/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.dm.muws.Metric;
import org.apache.muse.ws.dm.muws.Metrics;
import org.apache.muse.ws.dm.muws.MuwsConstants;
import org.apache.muse.ws.dm.muws.impl.AbstractManageabilityCapability;
import org.apache.muse.ws.dm.muws.impl.MetricDecorationProvider;
import org.apache.muse.ws.dm.muws.impl.MetricOnDemandListener;
import org.apache.muse.ws.dm.muws.impl.MetricUpdateListener;
import org.apache.muse.ws.dm.muws.impl.SimpleMetric;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.properties.ResourcePropertyCollection;
import org.w3c.dom.Element;

public class SimpleMetrics
extends AbstractManageabilityCapability
implements Metrics {
    private Map _countersByQName = new HashMap();
    private Map _metricsByQName = new HashMap();

    public Date getCurrentTime() {
        return new Date();
    }

    public Metric getMetric(QName propertyQName) {
        return (Metric)this._metricsByQName.get(propertyQName);
    }

    public QName[] getPropertyNames() {
        return Metrics.PROPERTIES;
    }

    public void initialize() throws SoapFault {
        super.initialize();
        WsResource resource = this.getWsResource();
        ResourcePropertyCollection props = resource.getPropertyCollection();
        MetadataDescriptor metadata = props.getMetadata();
        Iterator i = metadata.getPropertyNames().iterator();
        while (i.hasNext()) {
            QName qname = (QName)i.next();
            String capability = metadata.getExtendedMetadata(qname, MuwsConstants.CAPABILITY_QNAME);
            if (capability == null || !capability.equals("http://docs.oasis-open.org/wsdm/muws/capabilities/Metrics")) continue;
            SimpleMetric metric = new SimpleMetric(qname, resource);
            this._metricsByQName.put(qname, metric);
            if (metric.isOnDemand()) {
                props.addReadListener(new MetricOnDemandListener(metric));
            }
            props.addReadListener(new MetricDecorationProvider(metric));
            props.addChangeListener(new MetricUpdateListener(metric));
            if (!metric.isCounter() || !metric.isInterval()) continue;
            CounterThread counter = new CounterThread(props, metric);
            this._countersByQName.put(qname, counter);
            counter.start();
        }
    }

    public void shutdown() throws SoapFault {
        Iterator i = this._countersByQName.values().iterator();
        while (i.hasNext()) {
            Thread next = (Thread)i.next();
            next.destroy();
        }
        super.shutdown();
    }

    class CounterThread
    extends Thread {
        private Metric _metric = null;
        private ResourcePropertyCollection _properties = null;

        public CounterThread(ResourcePropertyCollection properties, Metric metric) {
            this._properties = properties;
            this._metric = metric;
        }

        private int getCurrentValue() {
            QName name = this._metric.getName();
            Element[] values = null;
            try {
                values = this._properties.getResourceProperty(name);
            }
            catch (SoapFault fault) {
                throw new RuntimeException(fault.getMessage(), fault);
            }
            return XmlUtils.getInteger(values[0]);
        }

        public void run() {
            QName name = this._metric.getName();
            long interval = this._metric.getInterval();
            int currentValue = this.getCurrentValue();
            while (true) {
                try {
                    Thread.currentThread();
                    Thread.sleep(interval);
                }
                catch (InterruptedException error) {
                    error.printStackTrace();
                }
                if (this._metric.hasBeenReset()) {
                    currentValue = this.getCurrentValue();
                }
                try {
                    Integer asObject = new Integer(++currentValue);
                    this._properties.updateResourceProperty(name, new Object[]{asObject});
                    continue;
                }
                catch (SoapFault fault) {
                    fault.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

