/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import java.text.ParseException;
import java.util.Date;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.ext.faults.InvalidMessageFormatFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SubscribeResponse
implements XmlSerializable {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$notification$impl$SubscribeResponse == null ? (class$org$apache$muse$ws$notification$impl$SubscribeResponse = SubscribeResponse.class$("org.apache.muse.ws.notification.impl.SubscribeResponse")) : class$org$apache$muse$ws$notification$impl$SubscribeResponse);
    private Date _currentTime = new Date();
    private EndpointReference _subscriptionEPR = null;
    private Date _terminationTime = null;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$SubscribeResponse;

    public SubscribeResponse(Element xml) throws InvalidMessageFormatFault {
        Element eprXML = XmlUtils.getElement(xml, WsnConstants.SUBSCRIPTION_EPR_QNAME);
        if (eprXML == null) {
            throw new InvalidMessageFormatFault(_MESSAGES.get("NoSubscriptionEPR"));
        }
        try {
            this._subscriptionEPR = new EndpointReference(eprXML);
        }
        catch (SoapFault error) {
            throw new InvalidMessageFormatFault(error);
        }
        String currentString = XmlUtils.getElementText(xml, WsnConstants.CURRENT_TIME_QNAME);
        String terminationString = XmlUtils.getElementText(xml, WsnConstants.TERMINATION_TIME_QNAME);
        try {
            if (currentString != null) {
                this._currentTime = XsdUtils.getLocalTime(currentString);
            }
            if (terminationString != null) {
                this._terminationTime = XsdUtils.getLocalTime(terminationString);
            }
        }
        catch (ParseException error) {
            throw new InvalidMessageFormatFault(error);
        }
    }

    public SubscribeResponse(WsResource subscription, Date terminationTime) {
        this._subscriptionEPR = subscription.getEndpointReference();
        this._terminationTime = terminationTime;
    }

    public Date getCurrentTime() {
        return this._currentTime;
    }

    public EndpointReference getSubscriptionReference() {
        return this._subscriptionEPR;
    }

    public Date getTerminationTime() {
        return this._terminationTime;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Element root = XmlUtils.createElement(doc, WsnConstants.SUBSCRIBE_RESPONSE_QNAME);
        Element eprXML = this.getSubscriptionReference().toXML();
        XmlUtils.setElement(root, WsnConstants.SUBSCRIPTION_EPR_QNAME, eprXML);
        Date currentTime = this.getCurrentTime();
        Date termTime = this.getTerminationTime();
        if (currentTime != null) {
            XmlUtils.setElement(root, WsnConstants.CURRENT_TIME_QNAME, currentTime);
        }
        if (termTime != null) {
            XmlUtils.setElement(root, WsnConstants.TERMINATION_TIME_QNAME, termTime);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

