/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.impl;

import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XPathUtils;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.WsnConstants;
import org.apache.muse.ws.notification.faults.InvalidTopicExpressionFault;
import org.apache.muse.ws.notification.faults.TopicExpressionDialectUnknownFault;
import org.apache.muse.ws.notification.topics.Topic;
import org.apache.muse.ws.notification.topics.impl.ConcretePathExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TopicFilter
implements Filter {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$notification$impl$TopicFilter == null ? (class$org$apache$muse$ws$notification$impl$TopicFilter = TopicFilter.class$("org.apache.muse.ws.notification.impl.TopicFilter")) : class$org$apache$muse$ws$notification$impl$TopicFilter);
    private QName _topicName = null;
    private Topic _topic = null;
    static /* synthetic */ Class class$org$apache$muse$ws$notification$impl$TopicFilter;

    public TopicFilter(QName topicName) throws TopicExpressionDialectUnknownFault, InvalidTopicExpressionFault {
        this(topicName, "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
    }

    public TopicFilter(QName topicName, String dialect) throws TopicExpressionDialectUnknownFault, InvalidTopicExpressionFault {
        if (!dialect.equals("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete")) {
            Object[] filler = new Object[]{dialect, "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete"};
            throw new TopicExpressionDialectUnknownFault(_MESSAGES.get("InvalidDialect", filler));
        }
        ConcretePathExpression.validateTopicPath(topicName);
        this._topicName = topicName;
    }

    public TopicFilter(Topic topic) throws TopicExpressionDialectUnknownFault, InvalidTopicExpressionFault {
        this(topic, "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
    }

    public TopicFilter(Topic topic, String dialect) throws TopicExpressionDialectUnknownFault, InvalidTopicExpressionFault {
        this(topic.getConcretePath(), dialect);
    }

    public boolean accepts(NotificationMessage message) {
        QName messageTopicName = message.getTopic();
        if (messageTopicName == null) {
            return false;
        }
        if (!messageTopicName.equals(this._topicName)) {
            return false;
        }
        if (this._topic == null) {
            return true;
        }
        String pattern = this._topic.getMessagePattern();
        if (pattern == null) {
            return true;
        }
        try {
            return XPathUtils.isMatch(message.toXML(), pattern);
        }
        catch (TransformerException error) {
            throw new RuntimeException(error.getMessage(), error);
        }
    }

    public QName getTopic() {
        return this._topicName;
    }

    public void setTopic(QName topicName) {
        this._topicName = topicName;
    }

    public void setTopic(Topic topic) {
        this._topic = topic;
    }

    public String toString() {
        return XmlUtils.toString(this.toXML(), false);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Element filter = XmlUtils.createElement(doc, WsnConstants.FILTER_QNAME);
        Element topic = XmlUtils.createElement(doc, WsnConstants.TOPIC_EXPRESSION_QNAME, this.getTopic());
        topic.setAttribute("Dialect", "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
        filter.appendChild(topic);
        return filter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

