/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.notification.remote;

import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.notification.Filter;
import org.apache.muse.ws.notification.NotificationMessage;
import org.apache.muse.ws.notification.impl.GetCurrentMessage;
import org.apache.muse.ws.notification.impl.GetCurrentMessageResponse;
import org.apache.muse.ws.notification.impl.Subscribe;
import org.apache.muse.ws.notification.impl.SubscribeResponse;
import org.apache.muse.ws.notification.remote.SubscriptionClient;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.w3c.dom.Element;

public class NotificationProducerClient
extends WsResourceClient {
    public NotificationProducerClient(EndpointReference destination) {
        super(destination);
    }

    public NotificationProducerClient(EndpointReference destination, EndpointReference source) {
        super(destination, source);
    }

    public NotificationProducerClient(EndpointReference destination, EndpointReference source, Environment environment) {
        super(destination, source, environment);
    }

    public NotificationProducerClient(EndpointReference destination, EndpointReference source, SoapClient soapClient) {
        super(destination, source, soapClient);
    }

    public NotificationMessage getCurrentMessage(QName topicPath) throws SoapFault {
        GetCurrentMessage get = new GetCurrentMessage(topicPath);
        Element responseXML = this.invoke("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer/GetCurrentMessageRequest", get.toXML());
        GetCurrentMessageResponse response = new GetCurrentMessageResponse(responseXML);
        return response.getMessage();
    }

    public SubscriptionClient subscribe(EndpointReference consumer, Filter filter, Date termination) throws SoapFault {
        Subscribe sub = new Subscribe(consumer, filter, termination);
        Element responseXML = this.invoke("http://docs.oasis-open.org/wsn/bw-2/NotificationProducer/SubscribeRequest", sub.toXML());
        SubscribeResponse response = new SubscribeResponse(responseXML);
        EndpointReference epr = response.getSubscriptionReference();
        return new SubscriptionClient(epr, this.getSource());
    }
}

