/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.basefaults;

import java.text.ParseException;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.basefaults.WsbfConstants;
import org.w3c.dom.Element;

public abstract class BaseFault
extends SoapFault {
    private static final long serialVersionUID = 7582724758621882686L;
    private Element _errorCode = null;
    private String _errorCodeDialect = null;
    private QName _name = null;
    private EndpointReference _origin = null;
    private Date _timestamp = new Date();

    public BaseFault(Element xml) {
        super(xml);
        Element detail = this.getDetail();
        this._name = XmlUtils.getElementQName(detail);
        String timeText = XmlUtils.getElementText(detail, WsbfConstants.TIMESTAMP_QNAME);
        try {
            if (timeText != null) {
                this._timestamp = XsdUtils.getLocalTime(timeText);
            }
        }
        catch (ParseException error) {
            // empty catch block
        }
        Element eprXML = XmlUtils.getElement(detail, WsbfConstants.ORIGINATOR_QNAME);
        try {
            if (eprXML != null) {
                this.setOriginReference(new EndpointReference(eprXML, false));
            }
        }
        catch (Throwable error) {
            // empty catch block
        }
        Element errorXML = XmlUtils.getElement(detail, WsbfConstants.ERROR_CODE_QNAME);
        if (errorXML != null) {
            Element error = XmlUtils.getFirstElement(errorXML);
            String dialect = errorXML.getAttribute("Dialect");
            this.setErrorCode(error, dialect);
        }
    }

    public BaseFault(QName name, String message) {
        super(message);
        this._name = name;
    }

    public BaseFault(QName name, String message, Throwable cause) {
        super(message, cause);
        this._name = name;
    }

    public BaseFault(QName name, Throwable cause) {
        super(cause);
        this._name = name;
    }

    public Element getDetail() {
        Element errorCode;
        Element baseFault = XmlUtils.createElement(this.getName());
        XmlUtils.setElement(baseFault, WsbfConstants.TIMESTAMP_QNAME, this.getTimestamp());
        EndpointReference originEPR = this.getOriginReference();
        if (originEPR != null) {
            Element originXML = originEPR.toXML();
            baseFault.appendChild(originXML);
        }
        if ((errorCode = this.getErrorCode()) != null) {
            Element errorXML = XmlUtils.createElement(WsbfConstants.ERROR_CODE_QNAME);
            errorXML.setAttribute("Dialect", this.getErrorCodeDialect());
            XmlUtils.setElement(errorXML, WsbfConstants.ERROR_CODE_QNAME, errorCode, false);
        }
        return baseFault;
    }

    public String getDescription() {
        return this.getMessage();
    }

    public Element getErrorCode() {
        return this._errorCode;
    }

    public String getErrorCodeDialect() {
        return this._errorCodeDialect;
    }

    public QName getName() {
        return this._name;
    }

    public EndpointReference getOriginReference() {
        return this._origin;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void setErrorCode(Element errorCode, String errorCodeDialect) {
        this._errorCode = errorCode;
        this._errorCodeDialect = errorCodeDialect;
    }

    public void setOriginReference(EndpointReference origin) {
        this._origin = new EndpointReference(origin, WsbfConstants.ORIGINATOR_QNAME);
    }
}

