/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.impl;

import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.core.SimpleResource;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.metadata.MetadataDescriptor;
import org.apache.muse.ws.resource.metadata.OpenMetadataDescriptor;
import org.apache.muse.ws.resource.metadata.WsrmdConstants;
import org.apache.muse.ws.resource.metadata.impl.SimpleMetadataDescriptor;
import org.apache.muse.ws.resource.metadata.impl.WsrmdUtils;
import org.apache.muse.ws.resource.properties.ResourcePropertyCollection;
import org.apache.muse.ws.resource.properties.impl.SimpleResourcePropertyCollection;
import org.apache.muse.ws.resource.properties.impl.WsrpUtils;
import org.apache.muse.ws.resource.properties.schema.OpenPropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.ResourcePropertiesSchema;
import org.apache.muse.ws.resource.properties.schema.impl.SimpleResourcePropertiesSchema;
import org.apache.muse.ws.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleWsResource
extends SimpleResource
implements WsResource {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$SimpleResource == null ? (class$org$apache$muse$core$SimpleResource = SimpleWsResource.class$("org.apache.muse.core.SimpleResource")) : class$org$apache$muse$core$SimpleResource);
    private static final String _VALIDATE_WSRP_PARAM = "validate-wsrp-schema";
    private ResourcePropertyCollection _properties = null;
    static /* synthetic */ Class class$org$apache$muse$core$SimpleResource;

    protected MetadataDescriptor createMetadataDescriptor(Document wsdl) {
        String path;
        Element portTypeXML = WsdlUtils.getPortType(wsdl, this.getWsdlPortType());
        String rmdName = XmlUtils.getAttribute(portTypeXML, WsrmdConstants.DESCRIPTOR_ATTR_QNAME);
        String rmdPath = XmlUtils.getAttribute(portTypeXML, WsrmdConstants.DESCRIPTOR_LOCATION_ATTR_QNAME);
        if (rmdName == null && rmdPath == null) {
            return OpenMetadataDescriptor.getInstance();
        }
        if ((rmdName == null || rmdPath == null) && rmdName != rmdPath) {
            throw new RuntimeException(_MESSAGES.get("IncompleteMetadataAttributes"));
        }
        Environment env = this.getEnvironment();
        Document rmdDoc = env.getDocument(path = env.createRelativePath(this.getWsdlPath(), rmdPath));
        Element descriptorXML = WsrmdUtils.getMetadataDescriptor(rmdDoc, rmdName);
        if (descriptorXML == null) {
            Object[] filler = new Object[]{rmdPath, rmdName};
            throw new RuntimeException(_MESSAGES.get("DescriptorNotFound", filler));
        }
        return new SimpleMetadataDescriptor(descriptorXML);
    }

    protected ResourcePropertiesSchema createPropertiesSchema(Document wsdl) {
        QName wsrpName = WsrpUtils.getPropertiesName(wsdl, this.getWsdlPortType());
        Element wsrpDoc = WsdlUtils.getElementDeclaration(wsdl, wsrpName);
        if (wsrpDoc == null) {
            Object[] filler = new Object[]{this.getContextPath(), this.getWsdlPath()};
            this.getLog().warning(_MESSAGES.get("NoWSRPDocument", filler));
            return OpenPropertiesSchema.getInstance();
        }
        return new SimpleResourcePropertiesSchema(wsrpName, wsrpDoc);
    }

    protected ResourcePropertyCollection createPropertyCollection() {
        return new SimpleResourcePropertyCollection();
    }

    public final ResourcePropertyCollection getPropertyCollection() {
        return this._properties;
    }

    public void initialize() throws SoapFault {
        this._properties = this.createPropertyCollection();
        Document wsdl = WsdlUtils.createWSDL(this.getEnvironment(), this.getWsdlPath(), true);
        ResourcePropertiesSchema schema = this.createPropertiesSchema(wsdl);
        this._properties.setSchema(schema);
        MetadataDescriptor metadata = this.createMetadataDescriptor(wsdl);
        this._properties.setMetadata(metadata);
        super.initialize();
        this._properties.applyMetadata();
        String validateParam = this.getInitializationParameter(_VALIDATE_WSRP_PARAM);
        if (validateParam == null || validateParam.equalsIgnoreCase("true")) {
            this._properties.validateSchema();
        }
        this._properties.validateMetadata();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

