/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.remote;

import java.text.ParseException;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.muse.core.AbstractResourceClient;
import org.apache.muse.core.Environment;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.lifetime.WsrlConstants;
import org.apache.muse.ws.resource.lifetime.impl.SetTerminationTime;
import org.apache.muse.ws.resource.lifetime.impl.SetTerminationTimeResponse;
import org.apache.muse.ws.resource.properties.WsrpConstants;
import org.apache.muse.ws.resource.properties.get.impl.GetMultipleRequest;
import org.apache.muse.ws.resource.properties.get.impl.GetRequest;
import org.apache.muse.ws.resource.properties.impl.WsrpUtils;
import org.apache.muse.ws.resource.properties.query.impl.QueryRequest;
import org.apache.muse.ws.resource.properties.set.SetOperationFactory;
import org.apache.muse.ws.resource.properties.set.SetRequest;
import org.apache.muse.ws.resource.properties.set.impl.SimpleSetOperationFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsResourceClient
extends AbstractResourceClient {
    private static final SetOperationFactory _SET_FACTORY = new SimpleSetOperationFactory();

    public WsResourceClient(EndpointReference destination) {
        super(destination);
    }

    public WsResourceClient(EndpointReference destination, EndpointReference source) {
        super(destination, source);
    }

    public WsResourceClient(EndpointReference destination, EndpointReference source, Environment environment) {
        super(destination, source, environment);
    }

    public WsResourceClient(EndpointReference destination, EndpointReference source, SoapClient soapClient) {
        super(destination, source, soapClient);
    }

    public void deleteResourceProperty(QName qname) throws SoapFault {
        SetRequest set = _SET_FACTORY.createDelete(qname);
        this.setResourceProperties(set);
    }

    public void destroy() throws SoapFault {
        Element body = XmlUtils.createElement(WsrlConstants.DESTROY_QNAME);
        this.invoke("http://docs.oasis-open.org/wsrf/rlw-2/ImmediateResourceTermination/DestroyRequest", body);
    }

    public Element[] getMultipleResourceProperties(QName[] qnames) throws SoapFault {
        GetMultipleRequest get = new GetMultipleRequest(qnames);
        Element response = this.invoke("http://docs.oasis-open.org/wsrf/rpw-2/GetMultipleResourceProperties/GetMultipleResourcePropertiesRequest", get.toXML());
        return XmlUtils.getAllElements(response);
    }

    public Object getPropertyAsObject(QName qname, Class type) throws SoapFault {
        Element[] properties = this.getResourceProperty(qname);
        return WsrpUtils.convertToObjects(properties, type);
    }

    public Element[] getResourceProperty(QName qname) throws SoapFault {
        GetRequest get = new GetRequest(qname);
        Element response = this.invoke("http://docs.oasis-open.org/wsrf/rpw-2/GetResourceProperty/GetResourcePropertyRequest", get.toXML());
        return XmlUtils.getAllElements(response);
    }

    public Element getResourcePropertyDocument() throws SoapFault {
        Element request = XmlUtils.createElement(WsrpConstants.GET_DOCUMENT_QNAME);
        Element response = this.invoke("http://docs.oasis-open.org/wsrf/rpw-2/GetResourcePropertyDocument/GetResourcePropertyDocumentRequest", request);
        return XmlUtils.getFirstElement(response);
    }

    public void insertResourceProperty(QName qname, Object[] values) throws SoapFault {
        SetRequest set = _SET_FACTORY.createInsert(qname, values);
        this.setResourceProperties(set);
    }

    public Element putResourcePropertyDocument(Element wsrpDoc) throws SoapFault {
        Element request = XmlUtils.createElement(XmlUtils.EMPTY_DOC, WsrpConstants.PUT_DOCUMENT_QNAME, wsrpDoc, false);
        Element response = this.invoke("http://docs.oasis-open.org/wsrf/rpw-2/PutResourcePropertyDocument/PutResourcePropertyDocumentRequest", request);
        return XmlUtils.getFirstElement(response);
    }

    public Node[] queryResourceProperties(String query, String dialect) throws SoapFault {
        QueryRequest request = new QueryRequest(query, dialect);
        Element response = this.invoke("http://docs.oasis-open.org/wsrf/rpw-2/QueryResourceProperties/QueryResourcePropertiesRequest", request.toXML());
        NodeList children = response.getChildNodes();
        return XmlUtils.convertToArray(children);
    }

    public void setResourceProperties(SetRequest request) throws SoapFault {
        this.invoke("http://docs.oasis-open.org/wsrf/rpw-2/SetResourceProperties/SetResourcePropertiesRequest", request.toXML());
    }

    public Date setTerminationTime(Date time) throws SoapFault {
        SetTerminationTime set = new SetTerminationTime(time);
        Element response = this.invoke("http://docs.oasis-open.org/wsrf/rlw-2/ScheduledResourceTermination/SetTerminationTimeRequest", set.toXML());
        try {
            SetTerminationTimeResponse setResponse = new SetTerminationTimeResponse(response);
            return setResponse.getTerminationTime();
        }
        catch (ParseException error) {
            throw new SoapFault(error.getMessage(), error);
        }
    }

    public void updateResourceProperty(QName qname, Object[] values) throws SoapFault {
        SetRequest set = _SET_FACTORY.createUpdate(qname, values);
        this.setResourceProperties(set);
    }
}

