/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.resource.sg.impl;

import javax.xml.namespace.QName;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.resource.WsResource;
import org.apache.muse.ws.resource.basefaults.BaseFault;
import org.apache.muse.ws.resource.impl.AbstractWsResourceCapability;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.apache.muse.ws.resource.sg.Entry;
import org.apache.muse.ws.resource.sg.ServiceGroup;
import org.apache.muse.ws.resource.sg.WssgConstants;
import org.apache.muse.ws.resource.sg.faults.ContentCreationFailedFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleEntry
extends AbstractWsResourceCapability
implements Entry {
    protected static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$resource$sg$impl$SimpleEntry == null ? (class$org$apache$muse$ws$resource$sg$impl$SimpleEntry = SimpleEntry.class$("org.apache.muse.ws.resource.sg.impl.SimpleEntry")) : class$org$apache$muse$ws$resource$sg$impl$SimpleEntry);
    private static final Element[] _EMPTY_CONTENT = new Element[0];
    private WsResourceClient _member = null;
    private WsResource _serviceGroup = null;
    static /* synthetic */ Class class$org$apache$muse$ws$resource$sg$impl$SimpleEntry;

    public Element getContent() throws BaseFault {
        Element[] content = _EMPTY_CONTENT;
        WsResourceClient client = this.getMemberClient();
        if (client == null) {
            return null;
        }
        ServiceGroup sg = (ServiceGroup)this.getServiceGroup().getCapability("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroup");
        QName[] contentNames = sg.getContentElements();
        try {
            if (contentNames.length != 0) {
                content = client.getMultipleResourceProperties(contentNames);
            }
        }
        catch (SoapFault fault) {
            throw new ContentCreationFailedFault(fault);
        }
        if (content.length == 0) {
            return null;
        }
        Document doc = content[0].getOwnerDocument();
        Element root = XmlUtils.createElement(doc, WssgConstants.CONTENT_QNAME);
        for (int n = 0; n < content.length; ++n) {
            root.appendChild(content[n]);
        }
        return root;
    }

    protected WsResourceClient getMemberClient() {
        return this._member;
    }

    public EndpointReference getMemberEPR() {
        WsResourceClient client = this.getMemberClient();
        return client == null ? null : client.getEndpointReference();
    }

    public QName[] getPropertyNames() {
        return Entry.PROPERTIES;
    }

    protected WsResource getServiceGroup() {
        return this._serviceGroup;
    }

    public EndpointReference getServiceGroupEPR() {
        WsResource sg = this.getServiceGroup();
        return sg == null ? null : sg.getEndpointReference();
    }

    public void setMemberEPR(EndpointReference memberEPR) {
        if (memberEPR == null) {
            throw new NullPointerException(_MESSAGES.get("NullResource"));
        }
        this._member = new WsResourceClient(memberEPR, this.getServiceGroupEPR(), this.getEnvironment());
    }

    public void setServiceGroup(WsResource serviceGroup) {
        if (serviceGroup == null) {
            throw new NullPointerException(_MESSAGES.get("NullServiceGroup"));
        }
        this._serviceGroup = serviceGroup;
    }

    public void shutdown() throws SoapFault {
        ServiceGroup sg = (ServiceGroup)this.getServiceGroup().getCapability("http://docs.oasis-open.org/wsrf/sgw-2/ServiceGroup");
        sg.removeEntry(this.getWsResource());
        super.shutdown();
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        if (doc == null) {
            throw new NullPointerException(_MESSAGES.get("NullDocument"));
        }
        Element root = XmlUtils.createElement(doc, WssgConstants.ENTRY_QNAME);
        EndpointReference myEPR = this.getResource().getEndpointReference();
        XmlUtils.setElement(root, WssgConstants.SG_ENTRY_EPR_QNAME, myEPR);
        EndpointReference member = this.getMemberEPR();
        XmlUtils.setElement(root, WssgConstants.MEMBER_SERVICE_EPR_QNAME, member);
        try {
            XmlUtils.setElement(root, WssgConstants.CONTENT_QNAME, this.getContent());
        }
        catch (SoapFault error) {
            Object[] filler = new Object[]{error.getMessage()};
            this.getLog().fine(_MESSAGES.get("ContentCreationFailed", filler));
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

