/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.ITemplateArea;
import org.eclipse.birt.report.engine.layout.area.ITextArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class PPTRender
implements IAreaVisitor {
    protected static Logger logger;
    public static final String REPORT_FILE = "Report.ppt";
    public static final float LAYOUT_TO_PPT_RATIO = 1000.0f;
    public static final int H_TEXT_SPACE = 70;
    public static final int V_TEXT_SPACE = 100;
    private OutputStream pptOutput = null;
    protected IReportContent report;
    protected int currentPageNum = 0;
    protected double pageWidth = 0.0;
    protected double pageHeight = 0.0;
    private int shapeCount = 0;
    protected IReportRunnable reportRunnable;
    protected ReportDesignHandle reportDesign;
    protected IReportContext context;
    protected IEmitterServices services;
    protected float scale;
    protected int hTextSpace = 70;
    protected int vTextSpace = 100;
    protected float lToP;
    private final Stack containerStack = new Stack();
    private Map imageNames = new HashMap();
    private Map imageExtensions = new HashMap();
    private Map fileNamesLists = new TreeMap();
    private List currentImageContents = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.ppt.PPTRender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.ppt.PPTRender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public String getOutputFormat() {
        return "ppt";
    }

    public void initialize(IEmitterServices services) {
        this.services = services;
        this.reportRunnable = services.getReportRunnable();
        if (this.reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)this.reportRunnable.getDesignHandle();
        }
        this.context = services.getReportContext();
        Object fd = services.getOption("outputFile");
        File file = null;
        try {
            if (fd != null) {
                file = new File(fd.toString());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                this.pptOutput = new FileOutputStream(file);
            }
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.WARNING, fnfe.getMessage(), fnfe);
        }
        if (this.pptOutput == null) {
            Object value = services.getOption("outputStream");
            if (value instanceof OutputStream) {
                this.pptOutput = (OutputStream)value;
            } else {
                try {
                    file = new File(REPORT_FILE);
                    this.pptOutput = new FileOutputStream(file);
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public void start(IReportContent rc) {
        this.report = rc;
        if (!this.imageNames.isEmpty()) {
            this.imageNames.clear();
        }
        if (!this.fileNamesLists.isEmpty()) {
            this.fileNamesLists.clear();
        }
        try {
            this.pptOutput.write("MIME-Version: 1.0\n".getBytes());
            this.pptOutput.write("Content-Type: multipart/related; boundary=\"___Actuate_Content_Boundary___\"\n".getBytes());
            this.pptOutput.write("\n".getBytes());
            this.pptOutput.write("--___Actuate_Content_Boundary___\n".getBytes());
            this.pptOutput.write("Content-Location: file:///C:/___Actuate___/slide-show\n".getBytes());
            this.pptOutput.write("Content-Transfer-Encoding: quoted-printable\n".getBytes());
            this.pptOutput.write("Content-Type: text/html; charset=\"utf-8\"\n".getBytes());
            this.pptOutput.write("\n".getBytes());
            this.pptOutput.write("<html\n".getBytes());
            this.pptOutput.write("xmlns=3D'http://www.w3.org/TR/REC-html40'\n".getBytes());
            this.pptOutput.write("xmlns:o=3D'urn:schemas-microsoft-com:office:office'\n".getBytes());
            this.pptOutput.write("xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'\n".getBytes());
            this.pptOutput.write("xmlns:v=3D'urn:schemas-microsoft-com:vml'\n".getBytes());
            this.pptOutput.write(">\n".getBytes());
            this.pptOutput.write("<head>\n".getBytes());
            this.pptOutput.write("<meta http-equiv=3D'Content-Type' content=3D'text/html; charset=3Dutf-8'>\n".getBytes());
            this.pptOutput.write("<meta name=3D'ProgId' content=3D'PowerPoint.Slide'>\n".getBytes());
            this.pptOutput.write("<meta name=3D'Generator' content=3D'Actuate View Server'>\n".getBytes());
            this.pptOutput.write("<title>Actuate Report</title>\n".getBytes());
            this.pptOutput.write("<xml><o:DocumentProperties>\n".getBytes());
            this.pptOutput.write("<o:Author>Actuate View Server</o:Author>\n".getBytes());
            this.pptOutput.write("</o:DocumentProperties></xml><link rel=3DFile-List href=3D'file-list'>\n".getBytes());
            this.pptOutput.write("<link rel=3DPresentation-XML href=3D'presentation'>\n".getBytes());
            this.pptOutput.write("</head><body/></html>\n".getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void end(IReportContent rc) {
        if (this.pptOutput != null) {
            try {
                this.pptOutput.write("--___Actuate_Content_Boundary___\n".getBytes());
                this.pptOutput.write("Content-Location: file:///C:/___Actuate___/presentation\n".getBytes());
                this.pptOutput.write("Content-Transfer-Encoding: quoted-printable\n".getBytes());
                this.pptOutput.write("Content-Type: text/xml; charset=\"utf-8\"\n".getBytes());
                this.pptOutput.write("\n".getBytes());
                this.pptOutput.write("<xml\n".getBytes());
                this.pptOutput.write(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'\n".getBytes());
                this.pptOutput.write(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'\n".getBytes());
                this.pptOutput.write(">\n".getBytes());
                this.pptOutput.write(("<p:presentation sizeof=3D'custom' slidesizex=3D'" + this.pageWidth * 8.0 + "' slidesizey=3D'" + this.pageHeight * 8.0 + "'>\n").getBytes());
                int i = 0;
                while (i < this.currentPageNum) {
                    this.pptOutput.write(("<p:slide id=3D'" + (i + 1) + "' href=3D's" + (i + 1) + "'/>\n").getBytes());
                    ++i;
                }
                this.pptOutput.write("</p:presentation></xml>\n".getBytes());
                this.pptOutput.write("\n".getBytes());
                this.pptOutput.write("--___Actuate_Content_Boundary___\n".getBytes());
                this.pptOutput.write("Content-Location: file:///C:/___Actuate___/file-list\n".getBytes());
                this.pptOutput.write("Content-Transfer-Encoding: quoted-printable\n".getBytes());
                this.pptOutput.write("Content-Type: text/xml; charset=\"utf-8\"\n".getBytes());
                this.pptOutput.write("<xml\n".getBytes());
                this.pptOutput.write(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'\n".getBytes());
                this.pptOutput.write(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'\n".getBytes());
                this.pptOutput.write(">\n".getBytes());
                this.pptOutput.write("<o:MainFile href=3D'slide-show'/>\n".getBytes());
                this.pptOutput.write("<o:File href=3D'presentation'/>\n".getBytes());
                this.pptOutput.write("<o:File href=3D'file-list'/>\n".getBytes());
                i = 0;
                while (i < this.currentPageNum) {
                    this.pptOutput.write(("<o:File href=3D's" + (i + 1) + "'/>\n").getBytes());
                    if (this.fileNamesLists.containsKey(new Integer(i + 1))) {
                        List filenames = (List)this.fileNamesLists.get(new Integer(i + 1));
                        Iterator ite = filenames.iterator();
                        while (ite.hasNext()) {
                            this.pptOutput.write(("<o:File href=3D\"" + (String)ite.next() + "\"/>\n").getBytes());
                        }
                    }
                    ++i;
                }
                this.pptOutput.write("</xml>\n".getBytes());
                this.pptOutput.write("\n".getBytes());
                this.pptOutput.write("--___Actuate_Content_Boundary___--\n".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.pptOutput = null;
    }

    protected void endPage() throws IOException {
        Iterator ite = this.currentImageContents.iterator();
        while (ite.hasNext()) {
            Object content = ite.next();
            if (content instanceof IImageContent) {
                IImageContent imageContent = (IImageContent)content;
                this.generateImageBytes(imageContent);
            } else if (content instanceof String) {
                String imageURI = (String)content;
                this.generateImageBytes(imageURI);
            }
            this.pptOutput.write("\n\n".getBytes());
        }
        this.pptOutput.write("</p:slide></body></html>\n".getBytes());
    }

    private void exportImageHeader(String imagekey) throws IOException {
        this.pptOutput.write("\n".getBytes());
        this.pptOutput.write("--___Actuate_Content_Boundary___\n".getBytes());
        this.pptOutput.write(("Content-Location: file:///C:/___Actuate___/" + (String)this.imageNames.get(imagekey) + "\n").getBytes());
        this.pptOutput.write("Content-Transfer-Encoding: base64\n".getBytes());
        this.pptOutput.write(("Content-Type: image/" + (String)this.imageExtensions.get(imagekey) + "\n\n").getBytes());
    }

    private void generateImageBytes(String imageURI) throws IOException {
        this.exportImageHeader(imageURI);
        Base64 base = new Base64();
        URL imageURL = null;
        if (this.reportDesign != null) {
            imageURL = this.reportDesign.findResource(imageURI, 1);
        }
        if (imageURL.toString().toLowerCase().endsWith(".svg")) {
            JPEGTranscoder transcoder = new JPEGTranscoder();
            transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
            TranscoderInput input = new TranscoderInput(imageURL.toString());
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
            try {
                transcoder.transcode(input, output);
            }
            catch (TranscoderException transcoderException) {}
            ostream.flush();
            this.pptOutput.write(base.encode(ostream.toByteArray()));
        } else {
            FileInputStream file = null;
            file = new FileInputStream(imageURI);
            byte[] data = null;
            if (file != null) {
                data = new byte[file.available()];
                file.read(data);
            }
            this.pptOutput.write(base.encode(data));
        }
    }

    private void generateImageBytes(IImageContent imageContent) throws IOException {
        block22: {
            if (imageContent.getURI() == null) {
                this.exportImageHeader(imageContent.getName());
            } else {
                this.exportImageHeader(imageContent.getURI());
            }
            boolean isSvg = false;
            TranscoderInput transInput = null;
            Base64 base = new Base64();
            byte[] imageData = null;
            try {
                if (imageContent.getURI() == null) {
                    imageData = imageContent.getData();
                    if (imageContent.getExtension() != null && imageContent.getExtension().equalsIgnoreCase("svg")) {
                        isSvg = true;
                    }
                } else {
                    switch (imageContent.getImageSource()) {
                        case 0: {
                            if (imageContent.getURI() == null) {
                                return;
                            }
                            URL url = this.reportDesign.findResource(imageContent.getURI(), 1);
                            InputStream imageInput = url.openStream();
                            if (imageContent.getURI().endsWith(".svg")) {
                                isSvg = true;
                                transInput = new TranscoderInput(imageInput);
                            }
                            imageData = new byte[imageInput.available()];
                            imageInput.read(imageData);
                            break;
                        }
                        case 3: {
                            if (imageContent.getURI() == null) {
                                return;
                            }
                            if (imageContent.getURI().endsWith(".svg")) {
                                isSvg = true;
                                transInput = new TranscoderInput(imageContent.getURI());
                            }
                            imageData = imageContent.getData();
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (imageContent.getData() == null || imageContent.getURI() == null) {
                                return;
                            }
                            if (imageContent.getURI().endsWith(".svg")) {
                                isSvg = true;
                                transInput = new TranscoderInput((InputStream)new ByteArrayInputStream(imageContent.getData()));
                            }
                            imageData = imageContent.getData();
                            break;
                        }
                        default: {
                            imageData = imageContent.getData();
                        }
                    }
                }
                if (!isSvg) {
                    this.pptOutput.write(base.encode(imageData));
                    break block22;
                }
                JPEGTranscoder transcoder = new JPEGTranscoder();
                transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                TranscoderOutput transOutput = new TranscoderOutput((OutputStream)ostream);
                try {
                    transcoder.transcode(transInput, transOutput);
                }
                catch (TranscoderException transcoderException) {}
                ostream.flush();
                this.pptOutput.write(base.encode(ostream.toByteArray()));
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, ioe.getMessage(), ioe);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, t.getMessage(), t);
            }
        }
    }

    public void setTotalPage(ITextArea totalPage) {
    }

    public void visitText(ITextArea textArea) {
        ContainerPosition curPos = !this.containerStack.isEmpty() ? (ContainerPosition)this.containerStack.peek() : new ContainerPosition(0, 0);
        int x = curPos.x + textArea.getX();
        int y = curPos.y + textArea.getY();
        this.drawTextAt(textArea, x, y);
    }

    public void visitImage(IImageArea imageArea) {
        this.drawImage(imageArea);
    }

    public void visitAutoText(ITemplateArea templateArea) {
    }

    public void visitContainer(IContainerArea container) {
        this.startContainer(container);
        Iterator iter = container.getChildren();
        while (iter.hasNext()) {
            IArea child = (IArea)iter.next();
            child.accept((IAreaVisitor)this);
        }
        this.endContainer(container);
    }

    public void startContainer(IContainerArea container) {
        if (container instanceof PageArea) {
            this.scale = container.getScale();
            this.lToP = 1000.0f / this.scale;
            this.hTextSpace = (int)(70.0f * this.scale);
            this.vTextSpace = (int)(100.0f * this.scale);
            this.newPage(container);
            this.containerStack.push(new ContainerPosition(0, 0));
        } else {
            this.drawContainer(container);
            if (!this.containerStack.isEmpty()) {
                ContainerPosition pos = (ContainerPosition)this.containerStack.peek();
                ContainerPosition current = new ContainerPosition(pos.x + container.getX(), pos.y + container.getY());
                this.containerStack.push(current);
            } else {
                this.containerStack.push(new ContainerPosition(container.getX(), container.getY()));
            }
        }
    }

    public void endContainer(IContainerArea container) {
        if (!this.containerStack.isEmpty()) {
            this.containerStack.pop();
        }
    }

    protected void newPage(IContainerArea page) {
        ++this.currentPageNum;
        this.currentImageContents.clear();
        if (this.pageWidth <= 0.0) {
            this.pageWidth = this.pptMeasure(page.getWidth());
        }
        if (this.pageHeight <= 0.0) {
            this.pageHeight = this.pptMeasure(page.getHeight());
        }
        try {
            this.pptOutput.write("--___Actuate_Content_Boundary___\n".getBytes());
            this.pptOutput.write(("Content-Location: file:///C:/___Actuate___/s" + this.currentPageNum + "\n").getBytes());
            this.pptOutput.write("Content-Transfer-Encoding: quoted-printable\n".getBytes());
            this.pptOutput.write("Content-Type: text/html; charset=\"utf-8\"\n".getBytes());
            this.pptOutput.write("\n".getBytes());
            this.pptOutput.write("<html\n".getBytes());
            this.pptOutput.write(" xmlns=3D'http://www.w3.org/TR/REC-html40'\n".getBytes());
            this.pptOutput.write(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'\n".getBytes());
            this.pptOutput.write(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'\n".getBytes());
            this.pptOutput.write(" xmlns:v=3D'urn:schemas-microsoft-com:vml'\n".getBytes());
            this.pptOutput.write(">\n".getBytes());
            this.pptOutput.write("<head/><body><p:slide>\n".getBytes());
            this.pptOutput.write("<meta http-equiv=3D'Content-Type' content=3D'text/html; charset=3Dutf-8'>\n".getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void drawBackgroundImage(IStyle containerStyle, double startX, double startY, double width, double height) {
        boolean yMode;
        double positionY;
        boolean xMode;
        double positionX;
        String bi = PropertyUtil.getBackgroundImage((CSSValue)containerStyle.getProperty(9));
        if (bi == null) {
            return;
        }
        FloatValue positionValX = (FloatValue)containerStyle.getProperty(45);
        FloatValue positionValY = (FloatValue)containerStyle.getProperty(35);
        if (positionValX == null || positionValY == null) {
            return;
        }
        if (positionValX.getPrimitiveType() == 2) {
            positionX = PropertyUtil.getPercentageValue((CSSValue)positionValX);
            xMode = true;
        } else {
            positionX = this.pptMeasure(PropertyUtil.getDimensionValue((CSSValue)positionValX));
            xMode = false;
        }
        if (positionValY.getPrimitiveType() == 2) {
            positionY = PropertyUtil.getPercentageValue((CSSValue)positionValY);
            yMode = true;
        } else {
            positionY = this.pptMeasure(PropertyUtil.getDimensionValue((CSSValue)positionValY));
            yMode = false;
        }
        this.drawBackgroundImage(bi, startX, startY, width, height, positionX, positionY, containerStyle.getBackgroundRepeat(), xMode, yMode);
    }

    protected void drawContainer(IContainerArea container) {
        IStyle style = container.getStyle();
        if (style == null) {
            return;
        }
        ContainerPosition curPos = !this.containerStack.isEmpty() ? (ContainerPosition)this.containerStack.peek() : new ContainerPosition(0, 0);
        if (container.getContent() != null) {
            int layoutX = curPos.x + container.getX();
            int layoutY = curPos.y + container.getY();
            double startX = this.layoutPointX2PPT(layoutX);
            double startY = this.layoutPointY2PPT(layoutY);
            double width = this.pptMeasure(container.getWidth());
            double height = this.pptMeasure(container.getHeight());
            Color bc = PropertyUtil.getColor((CSSValue)style.getProperty(20));
            if (bc != null) {
                this.drawBackgroundColor(bc, startX, startY, width, height);
            }
            this.drawBackgroundImage(style, startX, startY, width, height);
            int borderTopWidth = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(15));
            int borderLeftWidth = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(17));
            int borderBottomWidth = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(19));
            int borderRightWidth = PropertyUtil.getDimensionValue((CSSValue)style.getProperty(18));
            if (borderTopWidth > 0 || borderLeftWidth > 0 || borderBottomWidth > 0 || borderRightWidth > 0) {
                Color borderTopColor = PropertyUtil.getColor((CSSValue)style.getProperty(21));
                Color borderRightColor = PropertyUtil.getColor((CSSValue)style.getProperty(23));
                Color borderBottomColor = PropertyUtil.getColor((CSSValue)style.getProperty(24));
                Color borderLeftColor = PropertyUtil.getColor((CSSValue)style.getProperty(22));
                BorderInfo[] borders = new BorderInfo[]{new BorderInfo(layoutX, layoutY + borderTopWidth / 2, layoutX + container.getWidth(), layoutY + borderTopWidth / 2, borderTopWidth, borderTopColor, style.getProperty(10), 0), new BorderInfo(layoutX + container.getWidth() - borderRightWidth / 2, layoutY, layoutX + container.getWidth() - borderRightWidth / 2, layoutY + container.getHeight(), borderRightWidth, borderRightColor, style.getProperty(12), 1), new BorderInfo(layoutX, layoutY + container.getHeight() - borderBottomWidth / 2, layoutX + container.getWidth(), layoutY + container.getHeight() - borderBottomWidth / 2, borderBottomWidth, borderBottomColor, style.getProperty(13), 2), new BorderInfo(layoutX + borderLeftWidth / 2, layoutY, layoutX + borderLeftWidth / 2, layoutY + container.getHeight(), borderLeftWidth, borderLeftColor, style.getProperty(11), 3)};
                this.drawBorder(borders);
            }
        }
    }

    private void drawBorder(BorderInfo[] borders) {
        BorderInfo bi;
        ArrayList<BorderInfo> dbl = null;
        ArrayList<BorderInfo> solid = null;
        ArrayList<BorderInfo> dashed = null;
        ArrayList<BorderInfo> dotted = null;
        int i = 0;
        while (i < borders.length) {
            if (IStyle.DOUBLE_VALUE.equals(borders[i].borderStyle)) {
                if (dbl == null) {
                    dbl = new ArrayList<BorderInfo>();
                }
                dbl.add(borders[i]);
            } else if (IStyle.DASHED_VALUE.equals(borders[i].borderStyle)) {
                if (dashed == null) {
                    dashed = new ArrayList<BorderInfo>();
                }
                dashed.add(borders[i]);
            } else if (IStyle.DOTTED_VALUE.equals(borders[i].borderStyle)) {
                if (dotted == null) {
                    dotted = new ArrayList<BorderInfo>();
                }
                dotted.add(borders[i]);
            } else {
                if (solid == null) {
                    solid = new ArrayList<BorderInfo>();
                }
                solid.add(borders[i]);
            }
            ++i;
        }
        if (dotted != null) {
            Iterator it = dotted.iterator();
            while (it.hasNext()) {
                bi = (BorderInfo)it.next();
                this.drawLine(this.layoutPointX2PPT(bi.startX), this.layoutPointY2PPT(bi.startY), this.layoutPointX2PPT(bi.endX), this.layoutPointY2PPT(bi.endY), this.pptMeasure(bi.borderWidth), bi.borderColor, "dotted");
            }
        }
        if (dashed != null) {
            Iterator it = dashed.iterator();
            while (it.hasNext()) {
                bi = (BorderInfo)it.next();
                this.drawLine(this.layoutPointX2PPT(bi.startX), this.layoutPointY2PPT(bi.startY), this.layoutPointX2PPT(bi.endX), this.layoutPointY2PPT(bi.endY), this.pptMeasure(bi.borderWidth), bi.borderColor, "dashed");
            }
        }
        if (solid != null) {
            Iterator it = solid.iterator();
            while (it.hasNext()) {
                bi = (BorderInfo)it.next();
                this.drawLine(this.layoutPointX2PPT(bi.startX), this.layoutPointY2PPT(bi.startY), this.layoutPointX2PPT(bi.endX), this.layoutPointY2PPT(bi.endY), this.pptMeasure(bi.borderWidth), bi.borderColor, "solid");
            }
        }
        if (dbl != null) {
            Iterator it = dbl.iterator();
            while (it.hasNext()) {
                bi = (BorderInfo)it.next();
                int outerBorderWidth = bi.borderWidth / 4;
                int innerBorderWidth = bi.borderWidth / 4;
                switch (bi.borderType) {
                    case 0: {
                        this.drawLine(this.layoutPointX2PPT(bi.startX), this.layoutPointY2PPT(bi.startY - bi.borderWidth / 2 + outerBorderWidth / 2), this.layoutPointX2PPT(bi.endX), this.layoutPointY2PPT(bi.endY - bi.borderWidth / 2 + outerBorderWidth / 2), this.pptMeasure(outerBorderWidth), bi.borderColor, "solid");
                        this.drawLine(this.layoutPointX2PPT(bi.startX + 3 * borders[3].borderWidth / 4), this.layoutPointY2PPT(bi.startY + bi.borderWidth / 2 - innerBorderWidth / 2), this.layoutPointX2PPT(bi.endX - 3 * borders[1].borderWidth / 4), this.layoutPointY2PPT(bi.endY + bi.borderWidth / 2 - innerBorderWidth / 2), this.pptMeasure(innerBorderWidth), bi.borderColor, "solid");
                        break;
                    }
                    case 1: {
                        this.drawLine(this.layoutPointX2PPT(bi.startX + bi.borderWidth / 2 - outerBorderWidth / 2), this.layoutPointY2PPT(bi.startY), this.layoutPointX2PPT(bi.endX + bi.borderWidth / 2 - outerBorderWidth / 2), this.layoutPointY2PPT(bi.endY), this.pptMeasure(outerBorderWidth), bi.borderColor, "solid");
                        this.drawLine(this.layoutPointX2PPT(bi.startX - bi.borderWidth / 2 + innerBorderWidth / 2), this.layoutPointY2PPT(bi.startY + 3 * borders[0].borderWidth / 4), this.layoutPointX2PPT(bi.endX - bi.borderWidth / 2 + innerBorderWidth / 2), this.layoutPointY2PPT(bi.endY - 3 * borders[2].borderWidth / 4), this.pptMeasure(innerBorderWidth), bi.borderColor, "solid");
                        break;
                    }
                    case 2: {
                        this.drawLine(this.layoutPointX2PPT(bi.startX), this.layoutPointY2PPT(bi.startY + bi.borderWidth / 2 - outerBorderWidth / 2), this.layoutPointX2PPT(bi.endX), this.layoutPointY2PPT(bi.endY + bi.borderWidth / 2 - outerBorderWidth / 2), this.pptMeasure(outerBorderWidth), bi.borderColor, "solid");
                        this.drawLine(this.layoutPointX2PPT(bi.startX + 3 * borders[3].borderWidth / 4), this.layoutPointY2PPT(bi.startY - bi.borderWidth / 2 + innerBorderWidth / 2), this.layoutPointX2PPT(bi.endX - 3 * borders[1].borderWidth / 4), this.layoutPointY2PPT(bi.endY - bi.borderWidth / 2 + innerBorderWidth / 2), this.pptMeasure(innerBorderWidth), bi.borderColor, "solid");
                        break;
                    }
                    case 3: {
                        this.drawLine(this.layoutPointX2PPT(bi.startX - bi.borderWidth / 2 + outerBorderWidth / 2), this.layoutPointY2PPT(bi.startY), this.layoutPointX2PPT(bi.endX - bi.borderWidth / 2 + outerBorderWidth / 2), this.layoutPointY2PPT(bi.endY), this.pptMeasure(outerBorderWidth), bi.borderColor, "solid");
                        this.drawLine(this.layoutPointX2PPT(bi.startX + bi.borderWidth / 2 - innerBorderWidth / 2), this.layoutPointY2PPT(bi.startY + 3 * borders[0].borderWidth / 4), this.layoutPointX2PPT(bi.endX + bi.borderWidth / 2 - innerBorderWidth / 2), this.layoutPointY2PPT(bi.endY - 3 * borders[2].borderWidth / 4), this.pptMeasure(innerBorderWidth), bi.borderColor, "solid");
                    }
                }
            }
        }
    }

    protected void drawTextAt(ITextArea text, int textX, int textY) {
        if (text == null) {
            return;
        }
        IStyle style = text.getStyle();
        if (!$assertionsDisabled && style == null) {
            throw new AssertionError();
        }
        textX = (int)((float)textX + text.getFontInfo().getFontSize() * (float)this.hTextSpace);
        textY = (int)((float)textY + text.getFontInfo().getFontSize() * (float)this.vTextSpace);
        Color color = PropertyUtil.getColor((CSSValue)style.getProperty(14));
        FontInfo fi = text.getFontInfo();
        CSSValueList fontFamilies = (CSSValueList)style.getProperty(49);
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        red = red.length() == 1 ? "0" + red : red;
        green = green.length() == 1 ? "0" + green : green;
        blue = blue.length() == 1 ? "0" + blue : blue;
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer encodedText = charset.encode(text.getText());
        try {
            this.pptOutput.write(("<v:shape id=3D't" + ++this.shapeCount + "' type=3D'#r'\n").getBytes());
            this.pptOutput.write((" style=3D'position:absolute;left:" + (float)textX / 1000.0f + "pt;top:" + (float)textY / 1000.0f + "pt;width:" + (float)text.getWidth() / 1000.0f + "pt;height:" + (float)text.getHeight() / 1000.0f + "pt;v-text-anchor:top;mso-wrap-style:square;'\n").getBytes());
            this.pptOutput.write(" filled=3D'f' stroked=3D'f'>\n".getBytes());
            this.pptOutput.write("<v:textbox style=3D'mso-fit-shape-to-text:f;' inset=3D'0.00pt 0.00pt 0.00pt 0.00pt'/>\n".getBytes());
            this.pptOutput.write("</v:shape>\n".getBytes());
            this.pptOutput.write(("<div v:shape=3D't" + this.shapeCount + "'>\n").getBytes());
            this.pptOutput.write(("<div style=3D'mso-text-indent-alt:0;text-align:left;'><span style=3D'font-family:" + fontFamilies.getCssText() + ";font-size:" + fi.getFontSize() * this.scale + "pt;color:#" + red + green + blue + ";'>").getBytes());
            this.pptOutput.write(encodedText.array());
            this.pptOutput.write("</span></div>\n".getBytes());
            this.pptOutput.write("</div>\n".getBytes());
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
        }
        if (IStyle.LINE_THROUGH_VALUE.equals(style.getProperty(16))) {
            this.drawLine(this.layoutPointX2PPT(textX), this.layoutPointY2PPT(textY + text.getFontInfo().getLineThroughPosition()), this.layoutPointX2PPT(textX + text.getWidth()), this.layoutPointY2PPT(textY + text.getFontInfo().getLineThroughPosition()), text.getFontInfo().getLineWidth(), PropertyUtil.getColor((CSSValue)style.getProperty(14)), "solid");
        }
        if (IStyle.OVERLINE_VALUE.equals(style.getProperty(7))) {
            this.drawLine(this.layoutPointX2PPT(textX), this.layoutPointY2PPT(textY + text.getFontInfo().getOverlinePosition()), this.layoutPointX2PPT(textX + text.getWidth()), this.layoutPointY2PPT(textY + text.getFontInfo().getOverlinePosition()), text.getFontInfo().getLineWidth(), PropertyUtil.getColor((CSSValue)style.getProperty(14)), "solid");
        }
        if (IStyle.UNDERLINE_VALUE.equals(style.getProperty(8))) {
            this.drawLine(this.layoutPointX2PPT(textX), this.layoutPointY2PPT(textY + text.getFontInfo().getUnderlinePosition()), this.layoutPointX2PPT(textX + text.getWidth()), this.layoutPointY2PPT(textY + text.getFontInfo().getUnderlinePosition()), text.getFontInfo().getLineWidth(), PropertyUtil.getColor((CSSValue)style.getProperty(14)), "solid");
        }
    }

    protected void drawImage(IImageArea image) {
        String extension;
        String imageName;
        if (image == null) {
            return;
        }
        ++this.shapeCount;
        ContainerPosition curPos = !this.containerStack.isEmpty() ? (ContainerPosition)this.containerStack.peek() : new ContainerPosition(0, 0);
        int imageX = curPos.x + image.getX();
        int imageY = curPos.y + image.getY();
        IImageContent imageContent = (IImageContent)image.getContent();
        String imageTitle = "slide" + this.currentPageNum + "_image" + this.shapeCount;
        if (imageContent.getURI() != null) {
            if (this.imageNames.containsKey(imageContent.getURI())) {
                imageName = (String)this.imageNames.get(imageContent.getURI());
            } else {
                extension = this.getImageExtension(imageContent.getURI());
                imageName = String.valueOf(imageTitle) + "." + extension;
                this.imageNames.put(imageContent.getURI(), imageName);
                this.imageExtensions.put(imageContent.getURI(), extension);
                this.recordFileLists(imageName);
                this.currentImageContents.add(imageContent);
            }
        } else if (this.imageNames.containsKey(imageContent.getName())) {
            imageName = (String)this.imageNames.get(imageContent.getName());
        } else {
            extension = imageContent.getExtension();
            imageName = String.valueOf(imageTitle) + "." + extension;
            this.imageNames.put(imageContent.getName(), imageName);
            this.imageExtensions.put(imageContent.getName(), extension);
            this.recordFileLists(imageName);
            this.currentImageContents.add(imageContent);
        }
        double width = this.pptMeasure(image.getWidth());
        double height = this.pptMeasure(image.getHeight());
        double x = this.layoutAreaX2PPT(imageX);
        double y = this.layoutAreaY2PPT(imageY);
        try {
            this.pptOutput.write(("<v:shape id=3D'" + this.shapeCount + "' type=3D'#r'\n").getBytes());
            this.pptOutput.write((" style=3D'position:absolute;left:" + x + "pt;top:" + y + "pt;width:" + width + "pt;height:" + height + "pt'\n").getBytes());
            this.pptOutput.write(" filled=3D'f' stroked=3D'f'>\n".getBytes());
            this.pptOutput.write(("<v:imagedata src=3D\"" + imageName + "\" o:title=3D\"" + imageTitle + "\"/>\n").getBytes());
            this.pptOutput.write("<o:lock v:ext=3D'edit' aspectratio=3D't'/>\n".getBytes());
            this.pptOutput.write("</v:shape>\n".getBytes());
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
        }
    }

    private String getImageExtension(String imageURI) {
        String rectifiedImageURI = imageURI.replace('.', '&');
        String extension = imageURI.substring(rectifiedImageURI.lastIndexOf(38) + 1).toLowerCase();
        if (extension.equals("svg")) {
            extension = "jpg";
        }
        return extension;
    }

    private void recordFileLists(String filename) {
        Integer pageNum = new Integer(this.currentPageNum);
        if (this.fileNamesLists.containsKey(pageNum)) {
            ((List)this.fileNamesLists.get(pageNum)).add(filename);
        } else {
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add(filename);
            this.fileNamesLists.put(pageNum, fileNames);
        }
    }

    private void drawLine(double startX, double startY, double endX, double endY, double width, Color color, String lineStyle) {
        if (color == null || 0.0 == width || "none".equalsIgnoreCase(lineStyle)) {
            return;
        }
        if (lineStyle.equalsIgnoreCase("solid") || lineStyle.equalsIgnoreCase("dashed") || lineStyle.equalsIgnoreCase("dotted") || lineStyle.equalsIgnoreCase("double")) {
            this.drawRawLine(startX, startY, endX, endY, width, color, lineStyle);
        } else {
            this.drawRawLine(startX, startY, endX, endY, width, color, "solid");
        }
    }

    private void drawRawLine(double startX, double startY, double endX, double endY, double width, Color color, String lineStyle) {
        try {
            this.pptOutput.write(("<v:line id=3D\"" + ++this.shapeCount + "\"").getBytes());
            this.pptOutput.write((" style=3D'position:absolute' from=3D\"" + startX + "pt," + startY + "pt\"").getBytes());
            this.pptOutput.write((" to=3D\"" + endX + "pt," + endY + "pt\"").getBytes());
            this.pptOutput.write((" strokecolor=3D\"#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "\"").getBytes());
            this.pptOutput.write((" strokeweight=3D\"" + width + "pt\"").getBytes());
            if (lineStyle.equalsIgnoreCase("dashed")) {
                this.pptOutput.write("<v:stroke dashstyle=3D\"dash\"/>\n".getBytes());
            } else if (lineStyle.equalsIgnoreCase("dotted")) {
                this.pptOutput.write("<v:stroke dashstyle=3D\"1 1\"/>\n".getBytes());
            } else if (lineStyle.equalsIgnoreCase("double")) {
                this.pptOutput.write("<v:stroke linestyle=3D\"thinThin\"/>\n".getBytes());
            } else {
                this.pptOutput.write("/>\n".getBytes());
                return;
            }
            this.pptOutput.write(">\n".getBytes());
            this.pptOutput.write("</v:line>\n".getBytes());
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
        }
    }

    private void drawBackgroundColor(Color color, double x, double y, double width, double height) {
        try {
            this.pptOutput.write(("<v:rect id=3D\"" + ++this.shapeCount + "\"").getBytes());
            this.pptOutput.write((" style=3D'position:absolute;left:" + x + "pt;top:" + y + "pt;width:" + width + "pt;height:" + height + "pt'").getBytes());
            this.pptOutput.write((" fillcolor=3D\"#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "\"").getBytes());
            this.pptOutput.write(" stroked=3D\"f\"/>\n".getBytes());
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
        }
    }

    private void drawBackgroundImage(String imageURI, double x, double y, double width, double height, double positionX, double positionY, String repeat, boolean xMode, boolean yMode) {
        String imageName;
        if (imageURI == null || imageURI.length() == 0) {
            return;
        }
        String imageTitle = "slide" + this.currentPageNum + "_image" + ++this.shapeCount;
        if (this.imageNames.containsKey(imageURI)) {
            imageName = (String)this.imageNames.get(imageURI);
        } else {
            String extension = this.getImageExtension(imageURI);
            imageName = String.valueOf(imageTitle) + "." + extension;
            this.imageNames.put(imageURI, imageName);
            this.imageExtensions.put(imageURI, extension);
            this.recordFileLists(imageName);
            this.currentImageContents.add(imageURI);
        }
        try {
            this.pptOutput.write(("<v:shape id=3D'" + this.shapeCount + "' type=3D'#r'\n").getBytes());
            this.pptOutput.write((" style=3D'position:absolute;left:" + x + "pt;top:" + y + "pt;width:" + width + "pt;height:" + height + "pt'\n").getBytes());
            this.pptOutput.write(" filled=3D'f' stroked=3D'f'>\n".getBytes());
            this.pptOutput.write(("<v:imagedata src=3D\"" + imageName + "\" o:title=3D\"" + imageTitle + "\"/>\n").getBytes());
            this.pptOutput.write("<o:lock v:ext=3D'edit' aspectratio=3D't'/>\n".getBytes());
            this.pptOutput.write("</v:shape>\n".getBytes());
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
        }
    }

    private double pptMeasure(float layoutMeasure) {
        return layoutMeasure / this.lToP;
    }

    private double layoutPointX2PPT(int layoutX) {
        return this.pptMeasure(layoutX);
    }

    private double layoutPointY2PPT(float layoutY) {
        return this.pptMeasure(layoutY);
    }

    private double layoutAreaX2PPT(int layoutX) {
        return this.pptMeasure(layoutX);
    }

    private double layoutAreaY2PPT(int layoutY) {
        return this.pptMeasure(layoutY);
    }

    private class BorderInfo {
        public static final int TOP_BORDER = 0;
        public static final int RIGHT_BORDER = 1;
        public static final int BOTTOM_BORDER = 2;
        public static final int LEFT_BORDER = 3;
        public int startX;
        public int startY;
        public int endX;
        public int endY;
        public int borderWidth;
        public Color borderColor;
        public CSSValue borderStyle;
        public int borderType;

        public BorderInfo(int startX, int startY, int endX, int endY, int borderWidth, Color borderColor, CSSValue borderStyle, int borderType) {
            this.startX = startX;
            this.startY = startY;
            this.endX = endX;
            this.endY = endY;
            this.borderWidth = borderWidth;
            this.borderColor = borderColor;
            this.borderStyle = borderStyle;
            this.borderType = borderType;
        }
    }

    private class ContainerPosition {
        private int x;
        private int y;

        public ContainerPosition(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

