/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpOnlyCookie;
import org.mortbay.log.LogFactory;
import org.mortbay.util.DateCache;
import org.mortbay.util.LazyList;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;

public class HttpFields {
    private static Log log = LogFactory.getLog(HttpFields.class);
    public static final String __CacheControl = "Cache-Control";
    public static final String __Connection = "Connection";
    public static final String __Date = "Date";
    public static final String __Pragma = "Pragma";
    public static final String __ProxyConnection = "Proxy-Connection";
    public static final String __Trailer = "Trailer";
    public static final String __TransferEncoding = "Transfer-Encoding";
    public static final String __Upgrade = "Upgrade";
    public static final String __Via = "Via";
    public static final String __Warning = "Warning";
    public static final String __Allow = "Allow";
    public static final String __ContentEncoding = "Content-Encoding";
    public static final String __ContentLanguage = "Content-Language";
    public static final String __ContentLength = "Content-Length";
    public static final String __ContentLocation = "Content-Location";
    public static final String __ContentMD5 = "Content-MD5";
    public static final String __ContentRange = "Content-Range";
    public static final String __ContentType = "Content-Type";
    public static final String __Expires = "Expires";
    public static final String __LastModified = "Last-Modified";
    public static final String __Accept = "Accept";
    public static final String __AcceptCharset = "Accept-Charset";
    public static final String __AcceptEncoding = "Accept-Encoding";
    public static final String __AcceptLanguage = "Accept-Language";
    public static final String __Authorization = "Authorization";
    public static final String __Expect = "Expect";
    public static final String __Forwarded = "Forwarded";
    public static final String __From = "From";
    public static final String __Host = "Host";
    public static final String __IfMatch = "If-Match";
    public static final String __IfModifiedSince = "If-Modified-Since";
    public static final String __IfNoneMatch = "If-None-Match";
    public static final String __IfRange = "If-Range";
    public static final String __IfUnmodifiedSince = "If-Unmodified-Since";
    public static final String __KeepAlive = "keep-alive";
    public static final String __MaxForwards = "Max-Forwards";
    public static final String __ProxyAuthorization = "Proxy-Authorization";
    public static final String __Range = "Range";
    public static final String __RequestRange = "Request-Range";
    public static final String __Referer = "Referer";
    public static final String __TE = "TE";
    public static final String __UserAgent = "User-Agent";
    public static final String __XForwardedFor = "X-Forwarded-For";
    public static final String __AcceptRanges = "Accept-Ranges";
    public static final String __Age = "Age";
    public static final String __ETag = "ETag";
    public static final String __Location = "Location";
    public static final String __ProxyAuthenticate = "Proxy-Authenticate";
    public static final String __RetryAfter = "Retry-After";
    public static final String __Server = "Server";
    public static final String __ServletEngine = "Servlet-Engine";
    public static final String __Vary = "Vary";
    public static final String __WwwAuthenticate = "WWW-Authenticate";
    public static final String __Cookie = "Cookie";
    public static final String __SetCookie = "Set-Cookie";
    public static final String __SetCookie2 = "Set-Cookie2";
    public static final String __MimeVersion = "MIME-Version";
    public static final String __Identity = "identity";
    public static final String __SoapAction = "SOAPAction";
    private static final StringMap __info = new StringMap(true);
    private static final StringMap __values = new StringMap(true);
    private static final int __maxCacheSize = 128;
    public static final String __Chunked = "chunked";
    public static final String __Close = "close";
    public static final String __TextHtml = "text/html";
    public static final String __MessageHttp = "message/http";
    public static final String __WwwFormUrlEncode = "application/x-www-form-urlencoded";
    public static final String __ExpectContinue = "100-continue";
    public static final String __separators = ", \t";
    public static final char[] __CRLF;
    public static final char[] __COLON;
    private static String[] DAYS;
    private static String[] MONTHS;
    private static TimeZone __GMT;
    public static final DateCache __dateCache;
    private static final String[] __dateReceiveFmt;
    public static SimpleDateFormat[] __dateReceiveSource;
    public static final ThreadLocal __dateReceiveCache;
    public static final String __01Jan1970;
    private static Float __one;
    private static Float __zero;
    private static StringMap __qualities;
    private ArrayList _fields = new ArrayList(15);
    private int[] _index = new int[128];
    private int _version;
    private SimpleDateFormat[] _dateReceive;
    private StringBuffer _dateBuffer;
    private HttpCal _calendar;
    static /* synthetic */ Class class$org$mortbay$http$HttpFields$FieldInfo;

    private static FieldInfo getFieldInfo(String name) {
        FieldInfo info = (FieldInfo)__info.get(name);
        if (info == null) {
            info = new FieldInfo(name, false);
        }
        return info;
    }

    private static FieldInfo getFieldInfo(char[] name, int offset, int length) {
        Map.Entry entry = __info.getEntry(name, offset, length);
        if (entry == null) {
            return new FieldInfo(new String(name, offset, length), false);
        }
        return (FieldInfo)entry.getValue();
    }

    public static String formatDate(long date, boolean cookie) {
        StringBuffer buf = new StringBuffer(32);
        HttpCal gc = new HttpCal();
        gc.setTimeInMillis(date);
        HttpFields.formatDate(buf, gc, cookie);
        return buf.toString();
    }

    public static String formatDate(Calendar calendar, boolean cookie) {
        StringBuffer buf = new StringBuffer(32);
        HttpFields.formatDate(buf, calendar, cookie);
        return buf.toString();
    }

    public static String formatDate(StringBuffer buf, long date, boolean cookie) {
        HttpCal gc = new HttpCal();
        gc.setTimeInMillis(date);
        HttpFields.formatDate(buf, gc, cookie);
        return buf.toString();
    }

    public static void formatDate(StringBuffer buf, Calendar calendar, boolean cookie) {
        int day_of_week = calendar.get(7);
        int day_of_month = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int century = year / 100;
        year %= 100;
        long tm = calendar instanceof HttpCal ? ((HttpCal)calendar).getTimeInMillis() : calendar.getTime().getTime();
        int epoch = (int)(tm / 1000L % 86400L);
        int seconds = epoch % 60;
        int minutes = (epoch /= 60) % 60;
        int hours = epoch / 60;
        buf.append(DAYS[day_of_week]);
        buf.append(',');
        buf.append(' ');
        StringUtil.append2digits(buf, day_of_month);
        if (cookie) {
            buf.append('-');
            buf.append(MONTHS[month]);
            buf.append('-');
            StringUtil.append2digits(buf, year);
        } else {
            buf.append(' ');
            buf.append(MONTHS[month]);
            buf.append(' ');
            StringUtil.append2digits(buf, century);
            StringUtil.append2digits(buf, year);
        }
        buf.append(' ');
        StringUtil.append2digits(buf, hours);
        buf.append(':');
        StringUtil.append2digits(buf, minutes);
        buf.append(':');
        StringUtil.append2digits(buf, seconds);
        buf.append(" GMT");
    }

    public HttpFields() {
        Arrays.fill(this._index, -1);
    }

    public int size() {
        return this._fields.size();
    }

    public Enumeration getFieldNames() {
        return new Enumeration(){
            int i = 0;
            Field field = null;

            public boolean hasMoreElements() {
                if (this.field != null) {
                    return true;
                }
                while (this.i < HttpFields.this._fields.size()) {
                    Field f = (Field)HttpFields.this._fields.get(this.i++);
                    if (f == null || f._version != HttpFields.this._version || f._prev != null) continue;
                    this.field = f;
                    return true;
                }
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.field != null || this.hasMoreElements()) {
                    String n = this.field._info._name;
                    this.field = null;
                    return n;
                }
                throw new NoSuchElementException();
            }
        };
    }

    Field getField(String name) {
        FieldInfo info = HttpFields.getFieldInfo(name);
        return this.getField(info, true);
    }

    Field getField(FieldInfo info, boolean getValid) {
        int hi = info.hashCode();
        if (hi < this._index.length) {
            if (this._index[hi] >= 0) {
                Field field = (Field)this._fields.get(this._index[hi]);
                return field != null && (!getValid || field._version == this._version) ? field : null;
            }
        } else {
            for (int i = 0; i < this._fields.size(); ++i) {
                Field field = (Field)this._fields.get(i);
                if (!info.equals(field._info) || getValid && field._version != this._version) continue;
                return field;
            }
        }
        return null;
    }

    public boolean containsKey(String name) {
        FieldInfo info = HttpFields.getFieldInfo(name);
        return this.getField(info, true) != null;
    }

    public String get(String name) {
        FieldInfo info = HttpFields.getFieldInfo(name);
        Field field = this.getField(info, true);
        if (field != null) {
            return field._value;
        }
        return null;
    }

    public Enumeration getValues(String name) {
        FieldInfo info = HttpFields.getFieldInfo(name);
        final Field field = this.getField(info, true);
        if (field != null) {
            return new Enumeration(){
                Field f;
                {
                    this.f = field;
                }

                public boolean hasMoreElements() {
                    while (this.f != null && this.f._version != HttpFields.this._version) {
                        this.f = this.f._next;
                    }
                    return this.f != null;
                }

                public Object nextElement() throws NoSuchElementException {
                    if (this.f == null) {
                        throw new NoSuchElementException();
                    }
                    Field n = this.f;
                    do {
                        this.f = this.f._next;
                    } while (this.f != null && this.f._version != HttpFields.this._version);
                    return n._value;
                }
            };
        }
        return null;
    }

    public Enumeration getValues(String name, final String separators) {
        final Enumeration e = this.getValues(name);
        if (e == null) {
            return null;
        }
        return new Enumeration(){
            QuotedStringTokenizer tok = null;

            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (e.hasMoreElements()) {
                    String value = (String)e.nextElement();
                    this.tok = new QuotedStringTokenizer(value, separators, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String next = (String)this.tok.nextElement();
                if (next != null) {
                    next = next.trim();
                }
                return next;
            }
        };
    }

    public String put(String name, String value) {
        if (value == null) {
            return this.remove(name);
        }
        FieldInfo info = HttpFields.getFieldInfo(name);
        Field field = this.getField(info, false);
        if (field != null) {
            String old = field._version == this._version ? field._value : null;
            field.reset(value, this._version);
            field = field._next;
            while (field != null) {
                field.clear();
                field = field._next;
            }
            return old;
        }
        field = new Field(info, value, this._version);
        int hi = info.hashCode();
        if (hi < this._index.length) {
            this._index[hi] = this._fields.size();
        }
        this._fields.add(field);
        return null;
    }

    public void put(String name, List list) {
        if (list == null || list.size() == 0) {
            this.remove(name);
            return;
        }
        Object v = list.get(0);
        if (v != null) {
            this.put(name, v.toString());
        } else {
            this.remove(name);
        }
        if (list.size() > 1) {
            Iterator iter = list.iterator();
            iter.next();
            while (iter.hasNext()) {
                v = iter.next();
                if (v == null) continue;
                this.add(name, v.toString());
            }
        }
    }

    public void add(String name, String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        FieldInfo info = HttpFields.getFieldInfo(name);
        Field field = this.getField(info, false);
        Field last = null;
        if (field != null) {
            while (field != null && field._version == this._version) {
                last = field;
                field = field._next;
            }
        }
        if (field != null) {
            field.reset(value, this._version);
        } else {
            field = new Field(info, value, this._version);
            if (last != null) {
                field._prev = last;
                last._next = field;
            } else if (info.hashCode() < this._index.length) {
                this._index[info.hashCode()] = this._fields.size();
            }
            this._fields.add(field);
        }
    }

    public String remove(String name) {
        String old = null;
        FieldInfo info = HttpFields.getFieldInfo(name);
        Field field = this.getField(info, true);
        if (field != null) {
            old = field._value;
            while (field != null) {
                field.clear();
                field = field._next;
            }
        }
        return old;
    }

    public int getIntField(String name) throws NumberFormatException {
        String val = HttpFields.valueParameters(this.get(name), null);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return -1;
    }

    public long getDateField(String name) {
        int i;
        String val = HttpFields.valueParameters(this.get(name), null);
        if (val == null) {
            return -1L;
        }
        if (this._dateReceive == null) {
            this._dateReceive = (SimpleDateFormat[])__dateReceiveCache.get();
            if (this._dateReceive == null) {
                this._dateReceive = new SimpleDateFormat[__dateReceiveSource.length];
                __dateReceiveCache.set(this._dateReceive);
            }
        }
        for (i = 0; i < this._dateReceive.length; ++i) {
            if (this._dateReceive[i] == null) {
                this._dateReceive[i] = (SimpleDateFormat)__dateReceiveSource[i].clone();
            }
            try {
                Date date = (Date)this._dateReceive[i].parseObject(val);
                return date.getTime();
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
                continue;
            }
        }
        if (val.endsWith(" GMT")) {
            val = val.substring(0, val.length() - 4);
            for (i = 0; i < this._dateReceive.length; ++i) {
                try {
                    Date date = (Date)this._dateReceive[i].parseObject(val);
                    return date.getTime();
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                    continue;
                }
            }
        }
        throw new IllegalArgumentException(val);
    }

    public void putIntField(String name, int value) {
        this.put(name, Integer.toString(value));
    }

    public void putDateField(String name, Date date) {
        this.putDateField(name, date.getTime());
    }

    public void addDateField(String name, Date date) {
        this.addDateField(name, date.getTime());
    }

    public void addDateField(String name, long date) {
        if (this._dateBuffer == null) {
            this._dateBuffer = new StringBuffer(32);
            this._calendar = new HttpCal();
        }
        this._dateBuffer.setLength(0);
        this._calendar.setTimeInMillis(date);
        HttpFields.formatDate(this._dateBuffer, this._calendar, false);
        this.add(name, this._dateBuffer.toString());
    }

    public void putDateField(String name, long date) {
        if (this._dateBuffer == null) {
            this._dateBuffer = new StringBuffer(32);
            this._calendar = new HttpCal();
        }
        this._dateBuffer.setLength(0);
        this._calendar.setTimeInMillis(date);
        HttpFields.formatDate(this._dateBuffer, this._calendar, false);
        this.put(name, this._dateBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(LineInput in) throws IOException {
        Field last = null;
        char[] buf = null;
        int size = 0;
        LineInput lineInput = in;
        synchronized (lineInput) {
            LineInput.LineBuffer line_buffer;
            while ((line_buffer = in.readLineBuffer()) != null) {
                buf = line_buffer.buffer;
                size = line_buffer.size;
                if (size == 0) break;
                int i1 = -1;
                int i2 = -1;
                int name_l = 0;
                int i = 0;
                char c = buf[0];
                if (c != ' ' && c != '\t') {
                    i2 = 0;
                    for (i = 1; i < size; ++i) {
                        c = buf[i];
                        if (c == ':') {
                            name_l = i2 + 1;
                            break;
                        }
                        if (c == ' ' || c == '\t') continue;
                        i2 = i;
                    }
                }
                ++i;
                while (i < size) {
                    c = buf[i];
                    if (c != ' ' && c != '\t') {
                        i1 = i;
                        i2 = i - 1;
                        break;
                    }
                    ++i;
                }
                i = size;
                while (i-- > i1 && i >= 0) {
                    c = buf[i];
                    if (c == ' ' || c == '\t') continue;
                    i2 = i;
                    break;
                }
                if (name_l <= 0) {
                    if (i1 <= 0 || last == null) continue;
                    last._value = last._value + ' ' + new String(buf, i1, i2 - i1 + 1);
                    continue;
                }
                FieldInfo info = HttpFields.getFieldInfo(buf, 0, name_l);
                Field field = this.getField(info, false);
                last = null;
                if (field != null) {
                    while (field != null && field._version == this._version) {
                        last = field;
                        field = field._next;
                    }
                }
                if (field != null) {
                    if (i1 >= 0) {
                        field.reset(buf, i1, i2 - i1 + 1, this._version);
                    } else {
                        field.reset("", this._version);
                    }
                } else {
                    field = i1 >= 0 ? new Field(info, buf, i1, i2 - i1 + 1, this._version) : new Field(info, "", this._version);
                    if (last != null) {
                        field._prev = last;
                        last._next = field;
                    } else if (info.hashCode() < this._index.length) {
                        this._index[info.hashCode()] = this._fields.size();
                    }
                    this._fields.add(field);
                }
                last = field;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer) throws IOException {
        Writer writer2 = writer;
        synchronized (writer2) {
            for (int i = 0; i < this._fields.size(); ++i) {
                Field field = (Field)this._fields.get(i);
                if (field == null) continue;
                field.write(writer, this._version);
            }
            writer.write(__CRLF);
        }
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer);
            return writer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clear() {
        ++this._version;
        if (this._version > 1000) {
            this._version = 0;
            int i = this._fields.size();
            while (i-- > 0) {
                Field field = (Field)this._fields.get(i);
                if (field == null) continue;
                field.clear();
            }
        }
    }

    public void destroy() {
        int i = this._fields.size();
        while (i-- > 0) {
            Field field = (Field)this._fields.get(i);
            if (field == null) continue;
            field.destroy();
        }
        this._fields = null;
        this._index = null;
        this._dateBuffer = null;
        this._calendar = null;
        this._dateReceive = null;
    }

    public static String valueParameters(String value, Map parameters) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        if (parameters == null) {
            return value.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value.substring(i), ";", false, true);
        while (((StringTokenizer)tok1).hasMoreTokens()) {
            String token = ((StringTokenizer)tok1).nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!((StringTokenizer)tok2).hasMoreTokens()) continue;
            String paramName = ((StringTokenizer)tok2).nextToken();
            String paramVal = null;
            if (((StringTokenizer)tok2).hasMoreTokens()) {
                paramVal = ((StringTokenizer)tok2).nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value.substring(0, i).trim();
    }

    public static Float getQuality(String value) {
        Map.Entry entry;
        if (value == null) {
            return __zero;
        }
        int qe = value.indexOf(";");
        if (qe++ < 0 || qe == value.length()) {
            return __one;
        }
        if (value.charAt(qe++) == 'q' && (entry = __qualities.getEntry(value, ++qe, value.length() - qe)) != null) {
            return (Float)entry.getValue();
        }
        HashMap params = new HashMap(3);
        HttpFields.valueParameters(value, params);
        String qs = (String)params.get("q");
        Float q = (Float)__qualities.get(qs);
        if (q == null) {
            try {
                q = new Float(qs);
            }
            catch (Exception e) {
                q = __one;
            }
        }
        return q;
    }

    public static List qualityList(Enumeration enm) {
        if (enm == null || !enm.hasMoreElements()) {
            return Collections.EMPTY_LIST;
        }
        Object list = null;
        Object qual = null;
        while (enm.hasMoreElements()) {
            String v = enm.nextElement().toString();
            Float q = HttpFields.getQuality(v);
            if (!((double)q.floatValue() >= 0.001)) continue;
            list = LazyList.add(list, v);
            qual = LazyList.add(qual, q);
        }
        List vl = LazyList.getList(list, false);
        if (vl.size() < 2) {
            return vl;
        }
        List ql = LazyList.getList(qual, false);
        Float last = __zero;
        int i = vl.size();
        while (i-- > 0) {
            Float q = (Float)ql.get(i);
            if (last.compareTo(q) > 0) {
                Object tmp = vl.get(i);
                vl.set(i, vl.get(i + 1));
                vl.set(i + 1, tmp);
                ql.set(i, ql.get(i + 1));
                ql.set(i + 1, q);
                last = __zero;
                i = vl.size();
                continue;
            }
            last = q;
        }
        ql.clear();
        return vl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSetCookie(Cookie cookie) {
        String name = cookie.getName();
        String value = cookie.getValue();
        int version = cookie.getVersion();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuffer buf = new StringBuffer(128);
        String name_value_params = null;
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            long maxAge;
            String domain;
            String path;
            buf.append(name);
            buf.append('=');
            if (value != null && value.length() > 0) {
                if (version == 0) {
                    URI.encodeString(buf, value, "\";, ");
                } else {
                    buf.append(QuotedStringTokenizer.quote(value, "\";, "));
                }
            }
            if (version > 0) {
                buf.append(";Version=");
                buf.append(version);
                String comment = cookie.getComment();
                if (comment != null && comment.length() > 0) {
                    buf.append(";Comment=");
                    QuotedStringTokenizer.quote(buf, comment);
                }
            }
            if ((path = cookie.getPath()) != null && path.length() > 0) {
                buf.append(";Path=");
                buf.append(path);
            }
            if ((domain = cookie.getDomain()) != null && domain.length() > 0) {
                buf.append(";Domain=");
                buf.append(domain.toLowerCase());
            }
            if ((maxAge = (long)cookie.getMaxAge()) >= 0L) {
                if (version == 0) {
                    buf.append(";Expires=");
                    if (maxAge == 0L) {
                        buf.append(__01Jan1970);
                    } else {
                        HttpFields.formatDate(buf, System.currentTimeMillis() + 1000L * maxAge, true);
                    }
                } else {
                    buf.append(";Max-Age=");
                    buf.append(cookie.getMaxAge());
                }
            } else if (version > 0) {
                buf.append(";Discard");
            }
            if (cookie.getSecure()) {
                buf.append(";Secure");
            }
            if (cookie instanceof HttpOnlyCookie) {
                buf.append(";HttpOnly");
            }
            name_value_params = buf.toString();
        }
        this.put(__Expires, __01Jan1970);
        this.add(__SetCookie, name_value_params);
    }

    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration enm = fields.getFieldNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            Enumeration values = fields.getValues(name);
            while (values.hasMoreElements()) {
                this.add(name, (String)values.nextElement());
            }
        }
    }

    public Iterator iterator() {
        return new EntryIterator();
    }

    static {
        new FieldInfo(__Host, false);
        new FieldInfo(__KeepAlive, false);
        new FieldInfo(__Connection, false);
        new FieldInfo(__Cookie, false);
        new FieldInfo(__Accept, false);
        new FieldInfo(__AcceptLanguage, false);
        new FieldInfo(__AcceptEncoding, false);
        new FieldInfo(__AcceptCharset, false);
        new FieldInfo(__CacheControl, false);
        new FieldInfo(__SetCookie, false);
        new FieldInfo(__SetCookie2, false);
        new FieldInfo(__Date, false);
        new FieldInfo(__TransferEncoding, true);
        new FieldInfo(__ContentEncoding, true);
        new FieldInfo(__ContentLength, false);
        new FieldInfo(__Expires, false);
        new FieldInfo(__Expect, false);
        new FieldInfo(__Referer, false);
        new FieldInfo(__TE, false);
        new FieldInfo(__UserAgent, false);
        new FieldInfo(__IfModifiedSince, false);
        new FieldInfo(__IfRange, false);
        new FieldInfo(__IfUnmodifiedSince, false);
        new FieldInfo(__Location, false);
        new FieldInfo(__Server, false);
        new FieldInfo(__ServletEngine, false);
        new FieldInfo(__AcceptRanges, false);
        new FieldInfo(__Range, false);
        new FieldInfo(__RequestRange, false);
        new FieldInfo(__SoapAction, false);
        new FieldInfo(__ContentLocation, false);
        new FieldInfo(__ContentMD5, false);
        new FieldInfo(__ContentRange, false);
        new FieldInfo(__ContentType, false);
        new FieldInfo(__LastModified, false);
        new FieldInfo(__Authorization, false);
        new FieldInfo(__From, false);
        new FieldInfo(__MaxForwards, false);
        new FieldInfo(__ProxyAuthenticate, false);
        new FieldInfo(__Age, false);
        new FieldInfo(__ETag, false);
        new FieldInfo(__RetryAfter, false);
        __values.put(__KeepAlive, (Object)__KeepAlive);
        __values.put(__Chunked, (Object)__Chunked);
        __values.put(__Close, (Object)__Close);
        __values.put(__TextHtml, (Object)__TextHtml);
        __values.put(__MessageHttp, (Object)__MessageHttp);
        __values.put(__WwwFormUrlEncode, (Object)__WwwFormUrlEncode);
        __values.put(__ExpectContinue, (Object)__ExpectContinue);
        __values.put("max-age=0", (Object)"max-age=0");
        __values.put("no-cache", (Object)"no-cache");
        __values.put("300", (Object)"300");
        __values.put("ISO-8859-1, utf-8;q=0.66, *;q=0.66", (Object)"ISO-8859-1, utf-8;q=0.66, *;q=0.66");
        __CRLF = new char[]{'\r', '\n'};
        __COLON = new char[]{':', ' '};
        DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
        __GMT = TimeZone.getTimeZone("GMT");
        __dateCache = new DateCache("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        __dateReceiveFmt = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss", "dd-MMM-yy HH:mm:ss"};
        __dateReceiveCache = new ThreadLocal();
        __GMT.setID("GMT");
        __dateCache.setTimeZone(__GMT);
        __dateReceiveSource = new SimpleDateFormat[__dateReceiveFmt.length];
        for (int i = 0; i < __dateReceiveSource.length; ++i) {
            HttpFields.__dateReceiveSource[i] = new SimpleDateFormat(__dateReceiveFmt[i], Locale.US);
            __dateReceiveSource[i].setTimeZone(__GMT);
        }
        __01Jan1970 = HttpFields.formatDate(0L, false);
        __one = new Float("1.0");
        __zero = new Float("0.0");
        __qualities = new StringMap();
        __qualities.put(null, (Object)__one);
        __qualities.put("1.0", (Object)__one);
        __qualities.put("1", (Object)__one);
        __qualities.put("0.9", (Object)new Float("0.9"));
        __qualities.put("0.8", (Object)new Float("0.8"));
        __qualities.put("0.7", (Object)new Float("0.7"));
        __qualities.put("0.66", (Object)new Float("0.66"));
        __qualities.put("0.6", (Object)new Float("0.6"));
        __qualities.put("0.5", (Object)new Float("0.5"));
        __qualities.put("0.4", (Object)new Float("0.4"));
        __qualities.put("0.33", (Object)new Float("0.33"));
        __qualities.put("0.3", (Object)new Float("0.3"));
        __qualities.put("0.2", (Object)new Float("0.2"));
        __qualities.put("0.1", (Object)new Float("0.1"));
        __qualities.put("0", (Object)__zero);
        __qualities.put("0.0", (Object)__zero);
    }

    public class Entry {
        protected int _i;

        Entry(int i) {
            this._i = i;
        }

        public String getKey() {
            return ((Field)HttpFields.this._fields.get(this._i)).getDisplayName();
        }

        public String getValue() {
            return ((Field)((HttpFields)HttpFields.this)._fields.get((int)this._i))._value;
        }
    }

    private class EntryIterator
    implements Iterator {
        protected int _i = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this._i < HttpFields.this._fields.size();
        }

        public Object next() throws NoSuchElementException {
            return new Entry(this._i++);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class Field {
        FieldInfo _info;
        String _value;
        Field _next;
        Field _prev;
        int _version;

        Field(FieldInfo info, String value, int version) {
            this._info = info;
            this._value = value;
            this._next = null;
            this._prev = null;
            this._version = version;
        }

        Field(FieldInfo info, char[] buf, int offset, int length, int version) {
            Map.Entry valueEntry = __values.getEntry(buf, offset, length);
            String value = null;
            value = valueEntry != null ? (String)valueEntry.getKey() : new String(buf, offset, length);
            this._info = info;
            this._value = value;
            this._next = null;
            this._prev = null;
            this._version = version;
        }

        public boolean equals(Object o) {
            return o instanceof Field && o == this && this._version == ((Field)o)._version;
        }

        public int hashCode() {
            return this._info.hashCode() * this._version;
        }

        void clear() {
            this._version = -1;
        }

        void destroy() {
            this._info = null;
            this._value = null;
            this._next = null;
            this._prev = null;
            this._version = -1;
        }

        void reset(String value, int version) {
            this._value = value;
            this._version = version;
        }

        void reset(char[] buf, int offset, int length, int version) {
            this._version = version;
            if (!StringUtil.equals(this._value, buf, offset, length)) {
                Map.Entry valueEntry = __values.getEntry(buf, offset, length);
                String value = null;
                value = valueEntry != null ? (String)valueEntry.getKey() : new String(buf, offset, length);
                this._value = value;
            }
        }

        void write(Writer writer, int version) throws IOException {
            if (this._info == null || this._version != version) {
                return;
            }
            if (this._info._inlineValues) {
                if (this._prev != null) {
                    return;
                }
                writer.write(this._info._name);
                writer.write(__COLON);
                Field f = this;
                while (true) {
                    writer.write(QuotedStringTokenizer.quote(f._value, HttpFields.__separators));
                    f = f._next;
                    if (f == null) break;
                    writer.write(",");
                }
                writer.write(__CRLF);
            } else {
                writer.write(this._info._name);
                writer.write(__COLON);
                writer.write(this._value);
                writer.write(__CRLF);
            }
        }

        String getDisplayName() {
            return this._info._name;
        }

        public String toString() {
            return "[" + (this._prev == null ? "" : "<-") + this.getDisplayName() + "=" + this._value + (this._next == null ? "" : "->") + "]";
        }
    }

    private static final class FieldInfo {
        String _name;
        String _lname;
        boolean _inlineValues;
        int _hashCode;
        static int __hashCode;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldInfo(String name, boolean inline) {
            Class clazz = class$org$mortbay$http$HttpFields$FieldInfo == null ? (class$org$mortbay$http$HttpFields$FieldInfo = HttpFields.class$("org.mortbay.http.HttpFields$FieldInfo")) : class$org$mortbay$http$HttpFields$FieldInfo;
            synchronized (clazz) {
                this._name = name;
                this._lname = StringUtil.asciiToLowerCase(name);
                this._inlineValues = inline;
                this._hashCode = __hashCode++;
                if (__hashCode < 128) {
                    FieldInfo oldInfo = (FieldInfo)__info.get(name);
                    if (oldInfo == null) {
                        __info.put(name, (Object)this);
                        if (!name.equals(this._lname)) {
                            __info.put(this._lname, (Object)this);
                        }
                    } else {
                        this._hashCode = oldInfo._hashCode;
                    }
                }
            }
        }

        public String toString() {
            return "[" + this._name + "," + this._hashCode + "," + this._inlineValues + "]";
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof FieldInfo)) {
                return false;
            }
            FieldInfo fi = (FieldInfo)o;
            return fi == this || fi._hashCode == this._hashCode || fi._name.equals(this._name);
        }
    }

    private static class HttpCal
    extends GregorianCalendar {
        HttpCal() {
            super(__GMT);
        }

        public void setTimeInMillis(long arg0) {
            super.setTimeInMillis(arg0);
        }

        public long getTimeInMillis() {
            return super.getTimeInMillis();
        }
    }
}

