/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.group.GroupCalculatorFactory;
import org.eclipse.birt.report.data.adapter.group.ICalculator;
import org.eclipse.birt.report.data.adapter.i18n.AdapterResourceHandle;
import org.eclipse.birt.report.data.adapter.impl.DataRequestSessionImpl;
import org.eclipse.birt.report.data.adapter.internal.adapter.GroupAdapter;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DataSetIterator
implements IDatasetIterator {
    private boolean started = false;
    private IResultIterator it;
    private ResultMeta metadata;
    private static long nullTime;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.data.adapter.impl.DataSetIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(0, 0, 1, 0, 0, 0);
        nullTime = c.getTimeInMillis();
    }

    public DataSetIterator(DataRequestSessionImpl session, TabularHierarchyHandle hierHandle) throws AdapterException {
        QueryDefinition query = new QueryDefinition();
        query.setUsesDetails(false);
        query.setDataSetName(hierHandle.getDataSet().getQualifiedName());
        ArrayList metaList = new ArrayList();
        this.prepareLevels(query, hierHandle, metaList, null);
        this.popualteFilter(session, hierHandle.filtersIterator(), query);
        this.executeQuery(session, query);
        this.metadata = new ResultMeta(metaList);
    }

    private void executeQuery(DataRequestSessionImpl session, QueryDefinition query) throws AdapterException {
        try {
            Scriptable scope = session.getScope();
            TempDateTransformer tt = new TempDateTransformer();
            ScriptableObject.putProperty((Scriptable)scope, (String)tt.getClassName(), (Object)((Object)tt));
            this.it = session.prepare((IQueryDefinition)query).execute(scope).getResultIterator();
        }
        catch (BirtException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    public DataSetIterator(DataRequestSessionImpl session, TabularCubeHandle cubeHandle) throws BirtException {
        QueryDefinition query = new QueryDefinition();
        query.setUsesDetails(false);
        query.setDataSetName(cubeHandle.getDataSet().getQualifiedName());
        List dimensions = cubeHandle.getContents("dimensions");
        ArrayList<ColumnMeta> metaList = new ArrayList<ColumnMeta>();
        if (dimensions != null) {
            int i = 0;
            while (i < dimensions.size()) {
                TabularDimensionHandle dimension = (TabularDimensionHandle)dimensions.get(i);
                List hiers = dimension.getContents("hierarchies");
                if (!$assertionsDisabled && hiers.size() != 1) {
                    throw new AssertionError();
                }
                TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)hiers.get(0);
                if (hierHandle.getDataSet() == null || hierHandle.getDataSet().getQualifiedName().equals(cubeHandle.getDataSet().getQualifiedName())) {
                    this.prepareLevels(query, hierHandle, metaList, dimension.getName());
                } else {
                    Iterator it = cubeHandle.joinConditionsIterator();
                    while (it.hasNext()) {
                        DimensionConditionHandle dimCondHandle = (DimensionConditionHandle)it.next();
                        if (!dimCondHandle.getHierarchy().equals(hierHandle)) continue;
                        Iterator conditionIt = dimCondHandle.getJoinConditions().iterator();
                        while (conditionIt.hasNext()) {
                            DimensionJoinConditionHandle joinCondition = (DimensionJoinConditionHandle)conditionIt.next();
                            String cubeKey = joinCondition.getCubeKey();
                            String cubeKeyWithDimIdentifier = OlapExpressionUtil.getQualifiedLevelName((String)dimension.getName(), (String)cubeKey);
                            metaList.add(new ColumnMeta(cubeKeyWithDimIdentifier, null, 1));
                            query.addBinding((IBinding)new Binding(cubeKeyWithDimIdentifier, (IBaseExpression)new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)cubeKey))));
                            GroupDefinition gd = new GroupDefinition(String.valueOf(query.getGroups().size()));
                            gd.setKeyExpression(ExpressionUtil.createJSRowExpression((String)cubeKeyWithDimIdentifier));
                            query.addGroup(gd);
                        }
                    }
                }
                ++i;
            }
        }
        this.prepareMeasure(cubeHandle, query, metaList);
        this.popualteFilter(session, cubeHandle.filtersIterator(), query);
        this.executeQuery(session, query);
        this.metadata = new ResultMeta(metaList);
    }

    private void popualteFilter(DataRequestSession session, Iterator filterIterator, QueryDefinition query) {
        while (filterIterator.hasNext()) {
            FilterConditionHandle filter = (FilterConditionHandle)filterIterator.next();
            query.addFilter((IFilterDefinition)session.getModelAdaptor().adaptFilter(filter));
        }
    }

    private void prepareMeasure(TabularCubeHandle cubeHandle, QueryDefinition query, List metaList) throws AdapterException {
        try {
            List measureGroups = cubeHandle.getContents("measureGroups");
            int i = 0;
            while (i < measureGroups.size()) {
                MeasureGroupHandle mgh = (MeasureGroupHandle)measureGroups.get(i);
                List measures = mgh.getContents("measures");
                int j = 0;
                while (j < measures.size()) {
                    MeasureHandle measure = (MeasureHandle)measures.get(j);
                    String function = measure.getFunction();
                    if (query.getGroups().size() > 0) {
                        Binding binding = new Binding(measure.getName(), (IBaseExpression)new ScriptExpression(measure.getMeasureExpression()));
                        binding.setAggrFunction(DataAdapterUtil.adaptModelAggregationType(function));
                        IGroupDefinition group = (IGroupDefinition)query.getGroups().get(query.getGroups().size() - 1);
                        binding.addAggregateOn(group.getName());
                        query.addBinding((IBinding)binding);
                    } else {
                        query.addBinding((IBinding)new Binding(measure.getName(), (IBaseExpression)new ScriptExpression(measure.getMeasureExpression())));
                    }
                    ColumnMeta meta = new ColumnMeta(measure.getName(), null, 2);
                    meta.setDataType(DataAdapterUtil.adaptModelDataType(measure.getDataType()));
                    metaList.add(meta);
                    ++j;
                }
                ++i;
            }
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage());
        }
    }

    private int getDefaultStartValue(String timeType, String value) throws AdapterException {
        if (value != null && Double.valueOf(value) != 0.0) {
            return Integer.valueOf(value);
        }
        if ("day-of-month".equals(timeType)) {
            return 1;
        }
        if ("day-of-week".equals(timeType)) {
            return 1;
        }
        if ("day-of-year".equals(timeType)) {
            return 1;
        }
        if ("week-of-month".equals(timeType)) {
            return 1;
        }
        if ("week-of-year".equals(timeType)) {
            return 1;
        }
        if ("month".equals(timeType)) {
            return 1;
        }
        if ("quarter".equals(timeType)) {
            return 1;
        }
        if ("year".equals(timeType)) {
            return 1;
        }
        if ("hour".equals(timeType)) {
            return 0;
        }
        if ("minute".equals(timeType)) {
            return 0;
        }
        if ("second".equals(timeType)) {
            return 0;
        }
        throw new AdapterException("Error");
    }

    private void prepareLevels(QueryDefinition query, TabularHierarchyHandle hierHandle, List metaList, String dimName) throws AdapterException {
        try {
            List levels = hierHandle.getContents("levels");
            int j = 0;
            while (j < levels.size()) {
                TabularLevelHandle level = (TabularLevelHandle)levels.get(j);
                ColumnMeta temp = null;
                String exprString = ExpressionUtil.createJSDataSetRowExpression((String)level.getColumnName());
                int type = DataAdapterUtil.adaptModelDataType(level.getDataType());
                if (type == -1 || type == 0) {
                    type = 5;
                }
                if (level.getDateTimeLevelType() != null) {
                    temp = new ColumnMeta(this.createLevelName(dimName, level.getName()), new DataProcessorWrapper(GroupCalculatorFactory.getGroupCalculator(99, 2, String.valueOf(this.getDefaultStartValue(level.getDateTimeLevelType(), level.getIntervalBase())), level.getIntervalRange())), 1);
                    temp.setDataType(2);
                    exprString = this.createDateTransformerExpr(level.getDateTimeLevelType(), exprString);
                } else {
                    DataProcessorWrapper processor = null;
                    if ("dynamic".equals(level.getLevelType())) {
                        int interval = GroupAdapter.intervalFromModel(level.getInterval());
                        if (interval != 0) {
                            processor = new DataProcessorWrapper(GroupCalculatorFactory.getGroupCalculator(interval, type, level.getIntervalBase(), level.getIntervalRange()));
                        }
                    } else if ("mirrored".equals(level.getLevelType())) {
                        Iterator it = level.staticValuesIterator();
                        ArrayList<String> dispExpr = new ArrayList<String>();
                        ArrayList<String> filterExpr = new ArrayList<String>();
                        while (it.hasNext()) {
                            RuleHandle o = (RuleHandle)it.next();
                            dispExpr.add(o.getDisplayExpression());
                            filterExpr.add(o.getRuleExpression());
                        }
                        exprString = "";
                        int i = 0;
                        while (i < dispExpr.size()) {
                            String disp = "\"" + JavascriptEvalUtil.transformToJsConstants((String)String.valueOf(dispExpr.get(i))) + "\"";
                            String filter = String.valueOf(filterExpr.get(i));
                            exprString = String.valueOf(exprString) + "if(" + filter + ")" + disp + ";";
                            ++i;
                        }
                    }
                    temp = new ColumnMeta(this.createLevelName(dimName, level.getName()), processor, 1);
                    temp.setDataType(type);
                }
                metaList.add(temp);
                Iterator it = level.attributesIterator();
                while (it.hasNext()) {
                    LevelAttributeHandle levelAttr = (LevelAttributeHandle)it.next();
                    ColumnMeta meta = new ColumnMeta(this.createLevelName(dimName, OlapExpressionUtil.getAttributeColumnName((String)level.getName(), (String)levelAttr.getName())), null, 3);
                    meta.setDataType(DataAdapterUtil.adaptModelDataType(levelAttr.getDataType()));
                    metaList.add(meta);
                    query.addBinding((IBinding)new Binding(meta.getName(), (IBaseExpression)new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)levelAttr.getName()))));
                }
                if (level.getDisplayColumnName() != null) {
                    ColumnMeta meta = new ColumnMeta(this.createLevelName(dimName, OlapExpressionUtil.getDisplayColumnName((String)level.getName())), null, 3);
                    meta.setDataType(5);
                    metaList.add(meta);
                    query.addBinding((IBinding)new Binding(meta.getName(), (IBaseExpression)new ScriptExpression(level.getDisplayColumnName())));
                }
                String levelName = this.createLevelName(dimName, level.getName());
                query.addBinding((IBinding)new Binding(levelName, (IBaseExpression)new ScriptExpression(exprString)));
                GroupDefinition gd = new GroupDefinition(String.valueOf(query.getGroups().size()));
                gd.setKeyExpression(ExpressionUtil.createJSRowExpression((String)levelName));
                if (level.getLevelType() != null && level.getDateTimeLevelType() == null) {
                    gd.setIntervalRange(level.getIntervalRange());
                    gd.setIntervalStart((Object)level.getIntervalBase());
                    gd.setInterval(GroupAdapter.intervalFromModel(level.getInterval()));
                }
                if (level.getDateTimeLevelType() != null) {
                    gd.setIntervalRange(level.getIntervalRange() == 0.0 ? 1.0 : level.getIntervalRange());
                    gd.setIntervalStart((Object)String.valueOf(this.getDefaultStartValue(level.getDateTimeLevelType(), level.getIntervalBase())));
                    gd.setInterval(99);
                }
                query.addGroup(gd);
                ++j;
            }
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage());
        }
    }

    private String createLevelName(String dimName, String levelName) {
        if (dimName != null) {
            return String.valueOf(dimName) + "/" + levelName;
        }
        return levelName;
    }

    public void close() throws BirtException {
        this.it.close();
    }

    public int getFieldIndex(String name) throws BirtException {
        return this.metadata.getFieldIndex(name);
    }

    public int getFieldType(String name) throws BirtException {
        return this.metadata.getFieldType(name);
    }

    public Object getValue(int fieldIndex) throws BirtException {
        Object value = this.it.getValue(this.metadata.getFieldName(fieldIndex));
        if (value == null) {
            return this.metadata.getNullValueReplacer(fieldIndex);
        }
        return DataTypeUtil.convert((Object)this.metadata.getDataProcessor(fieldIndex).process(value), value.getClass());
    }

    public boolean next() throws BirtException {
        if (this.it.getQueryResults().getPreparedQuery().getReportQueryDefn().getGroups().size() == 0) {
            return this.it.next();
        }
        if (!this.started) {
            this.started = true;
            return this.it.next();
        }
        this.it.skipToEnd(this.it.getQueryResults().getPreparedQuery().getReportQueryDefn().getGroups().size());
        return this.it.next();
    }

    private String createDateTransformerExpr(String timeType, String value) {
        return "TempDateTransformer.transform(\"" + timeType + "\"," + value + ")";
    }

    private class ColumnMeta {
        static final int LEVEL_KEY_TYPE = 1;
        static final int MEASURE_TYPE = 2;
        static final int UNKNOWN_TYPE = 3;
        private String name;
        private int dataType;
        private int type;
        private int index;
        private IDataProcessor dataProcessor;

        ColumnMeta(String name, IDataProcessor processor, int type) {
            this.name = name;
            this.type = type;
            this.dataProcessor = processor == null ? new DummyDataProcessor() : processor;
        }

        public int getIndex() {
            return this.index;
        }

        public int getType() {
            return this.dataType;
        }

        public String getName() {
            return this.name;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setDataType(int type) {
            this.dataType = type;
        }

        public boolean isLevelKey() {
            return this.type == 1;
        }

        public boolean isMeasure() {
            return this.type == 2;
        }

        public IDataProcessor getDataProcessor() {
            return this.dataProcessor;
        }
    }

    private class DataProcessorWrapper
    implements IDataProcessor {
        private ICalculator calculator;

        DataProcessorWrapper(ICalculator calculator) {
            this.calculator = calculator;
        }

        public Object process(Object d) throws AdapterException {
            try {
                return this.calculator.calculate(d);
            }
            catch (BirtException e) {
                throw new AdapterException(e.getLocalizedMessage());
            }
        }
    }

    private class DummyDataProcessor
    implements IDataProcessor {
        private DummyDataProcessor() {
        }

        public Object process(Object d) {
            return d;
        }
    }

    private class Function_Transform
    extends Function_temp {
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.data.adapter.impl.DataSetIterator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        private Function_Transform() {
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (!$assertionsDisabled && args.length != 2) {
                throw new AssertionError();
            }
            String timeType = args[0].toString();
            Object d = args[1];
            if (args[1] == null) {
                return new Integer(0);
            }
            if ("day-of-month".equals(timeType)) {
                return new Integer(this.getCalendar(d).get(5));
            }
            if ("day-of-week".equals(timeType)) {
                return new Integer(this.getCalendar(d).get(7));
            }
            if ("day-of-year".equals(timeType)) {
                return new Integer(this.getCalendar(d).get(6));
            }
            if ("week-of-month".equals(timeType)) {
                return new Integer(this.getCalendar(d).get(4));
            }
            if ("week-of-year".equals(timeType)) {
                return new Integer(this.getCalendar(d).get(3));
            }
            if ("month".equals(timeType)) {
                return new Integer(this.getCalendar(d).get(2) + 1);
            }
            if ("quarter".equals(timeType)) {
                int month = this.getCalendar(d).get(2);
                int quarter = -1;
                switch (month) {
                    case 0: 
                    case 1: 
                    case 2: {
                        quarter = 1;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        quarter = 2;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        quarter = 3;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        quarter = 4;
                        break;
                    }
                    default: {
                        quarter = -1;
                    }
                }
                return new Integer(quarter);
            }
            if ("year".equals(timeType)) {
                return new Integer(this.getCalendar(d).get(1));
            }
            if ("hour".equals(timeType)) {
                return new Integer(this.getCalendar(d).get(11));
            }
            if ("minute".equals(timeType)) {
                return new Integer(this.getCalendar(d).get(12));
            }
            if ("second".equals(timeType)) {
                return new Integer(this.getCalendar(d).get(13));
            }
            throw new AdapterException("adapter.invalid.datetimetype", timeType);
        }

        private Calendar getCalendar(Object d) {
            if (!$assertionsDisabled && d == null) {
                throw new AssertionError();
            }
            try {
                java.util.Date date = DataTypeUtil.toDate((Object)d);
                Calendar c = Calendar.getInstance();
                c.setTime(date);
                return c;
            }
            catch (BirtException birtException) {
                throw new IllegalArgumentException(AdapterResourceHandle.getInstance().getMessage("invalid.datetime.value"));
            }
        }
    }

    abstract class Function_temp
    extends BaseFunction
    implements Function {
        Function_temp() {
        }

        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            args = this.convertToJavaObjects(args);
            try {
                return this.getValue(args);
            }
            catch (BirtException birtException) {
                throw new IllegalArgumentException("The type of arguement is incorrect.");
            }
        }

        protected abstract Object getValue(Object[] var1) throws BirtException;

        private Object[] convertToJavaObjects(Object[] args) {
            int i = 0;
            while (i < args.length) {
                args[i] = JavascriptEvalUtil.convertJavascriptValue((Object)args[i]);
                ++i;
            }
            return args;
        }
    }

    private static interface IDataProcessor {
        public Object process(Object var1) throws AdapterException;
    }

    private class ResultMeta {
        private HashMap columnMetaMap = new HashMap();
        private HashMap indexMap = new HashMap();
        private Object[] nullValueReplacer;

        ResultMeta(List columnMetas) {
            this.nullValueReplacer = new Object[columnMetas.size()];
            int i = 0;
            while (i < columnMetas.size()) {
                ColumnMeta columnMeta = (ColumnMeta)columnMetas.get(i);
                columnMeta.setIndex(i + 1);
                this.columnMetaMap.put(columnMeta.getName(), columnMeta);
                this.indexMap.put(new Integer(i + 1), columnMeta);
                if (columnMeta.isLevelKey() || columnMeta.isMeasure()) {
                    this.nullValueReplacer[i] = this.createNullValueReplacer(columnMeta.getType());
                }
                ++i;
            }
        }

        public int getFieldIndex(String fieldName) {
            return ((ColumnMeta)this.columnMetaMap.get(fieldName)).getIndex();
        }

        public int getFieldType(String fieldName) {
            return ((ColumnMeta)this.columnMetaMap.get(fieldName)).getType();
        }

        public String getFieldName(int index) {
            return ((ColumnMeta)this.indexMap.get(new Integer(index))).getName();
        }

        public Object getNullValueReplacer(int index) {
            return this.nullValueReplacer[index - 1];
        }

        public IDataProcessor getDataProcessor(int index) {
            return ((ColumnMeta)this.indexMap.get(new Integer(index))).getDataProcessor();
        }

        private Object createNullValueReplacer(int fieldType) {
            switch (fieldType) {
                case 6: {
                    return new java.util.Date(nullTime);
                }
                case 9: {
                    return new Date(nullTime);
                }
                case 10: {
                    return new Time(nullTime);
                }
                case 1: {
                    return new Boolean(false);
                }
                case 4: {
                    return new Double(0.0);
                }
                case 3: {
                    return new Double(0.0);
                }
                case 2: {
                    return new Integer(0);
                }
                case 5: {
                    return "";
                }
            }
            return "";
        }
    }

    private class TempDateTransformer
    extends ScriptableObject {
        public TempDateTransformer() {
            this.defineProperty("transform", (Object)new Function_Transform(), 0);
        }

        public String getClassName() {
            return "TempDateTransformer";
        }
    }
}

