/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.rm.validation.internal.SMLActivator;
import org.eclipse.cosmos.rm.validation.internal.actions.AbstractAction;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ResourceWrapper;
import org.eclipse.cosmos.rm.validation.internal.common.ReferenceExtractor;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.content.AbstractXMLContentDescriber;
import org.eclipse.cosmos.rm.validation.internal.core.SMLMainValidator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class ValidateResourceAction
extends AbstractAction {
    private SMLMainValidator validator;
    private Collection smlUnitsToValidate;
    private boolean inEclipse;

    public ValidateResourceAction() {
        this.validator = new SMLMainValidator();
        this.validator.getAttributes().put("attribute.environment", "value.environment.eclipse");
        this.inEclipse = true;
    }

    public ValidateResourceAction(SMLMainValidator validator) {
        this.validator = validator;
        this.inEclipse = false;
    }

    public void run(IAction action) {
        if (this.inEclipse && this.noValidSelection()) {
            return;
        }
        this.smlUnitsToValidate = new ArrayList();
        this.validator.getAttributes().put("validation.input.type", "value.sml.if");
        boolean errorFound = false;
        try {
            StringTokenizer st = null;
            Object[] selection = null;
            if (this.inEclipse) {
                selection = this.getSelection().toArray();
            } else {
                st = new StringTokenizer((String)this.validator.getAttributes().get("validation.instance"), ",");
            }
            int i = 0;
            while (!(this.inEclipse ? i >= selection.length : !st.hasMoreTokens())) {
                ResourceWrapper resource;
                ResourceWrapper resourceWrapper = resource = this.inEclipse ? new ResourceWrapper((IResource)selection[i]) : new ResourceWrapper(st.nextToken(), false);
                if (!this.validateWorkbenchSafe(resource)) {
                    errorFound = true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.failedValidationTitle, (String)e.getLocalizedMessage());
            return;
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.failedValidationTitle, (String)e.getLocalizedMessage());
            return;
        }
        if (!this.validateSmlUnits()) {
            errorFound = true;
        }
        if (!errorFound) {
            MessageDialog.openInformation((Shell)SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.confirmNoErrorTitle, (String)SMLMessages.confirmNoError);
        } else if (this.inEclipse) {
            try {
                SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView");
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.failedValidationTitle, (String)SMLMessages.failedValidation);
            }
        }
    }

    private boolean validateWorkbenchSafe(ResourceWrapper resource) throws CoreException, IOException {
        return this.validate(resource);
    }

    public boolean validate(ResourceWrapper resource) throws CoreException, IOException {
        boolean valid = true;
        if (resource.isDirectory()) {
            ResourceWrapper[] kids = resource.getChildren();
            int i = 0;
            while (i < kids.length) {
                if (!this.validate(kids[i])) {
                    valid = false;
                }
                ++i;
            }
            return valid;
        }
        Map attributes = this.validator.getAttributes();
        int type = SMLValidatorUtil.identifyDocumentType(resource);
        if (type == 3) {
            return true;
        }
        if (type == 0 || type == 1) {
            this.addSMLUnit(resource, type);
            return true;
        }
        attributes.put("validation.instance", resource.getAbsolutePath());
        return this.validator.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addDefinition(ResourceWrapper resource) {
        block17: {
            content = new StringBuffer();
            contentDescriber = new AbstractXMLContentDescriber(){

                public int determineType(String line) {
                    content.append(line);
                    if (line.indexOf(">") != -1) {
                        return 2;
                    }
                    return 10;
                }
            };
            inputStream = null;
            try {
                try {
                    inputStream = resource.getContents();
                    contentDescriber.describe(inputStream, null);
                }
                catch (IOException e) {
                    SMLActivator.logError(e);
                    var6_7 = null;
                    try {
                        if (inputStream == null) return;
                        inputStream.close();
                        return;
                    }
                    catch (IOException e) {
                        SMLActivator.logError(e);
                    }
                    return;
                }
            }
            catch (Throwable var7_14) {
                var6_8 = null;
                ** try [egrp 2[TRYBLOCK] [3 : 59->72)] { 
lbl25:
                // 1 sources

                if (inputStream == null) throw var7_14;
                inputStream.close();
                throw var7_14;
lbl28:
                // 1 sources

                catch (IOException e) {
                    SMLActivator.logError(e);
                }
                throw var7_14;
            }
            {
                var6_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 59->72)] { 
lbl33:
            // 1 sources

            if (inputStream != null) {
                inputStream.close();
            }
            break block17;
lbl36:
            // 1 sources

            catch (IOException e) {
                SMLActivator.logError(e);
            }
        }
        schemaLocationInx = 0;
        if (content.length() <= 0) return;
        schemaLocationInx = content.indexOf("schemaLocation");
        if (schemaLocationInx < 0) {
            return;
        }
        openingQuoteInx = content.indexOf("\"", schemaLocationInx);
        if (openingQuoteInx < 0) return;
        closingQuoteInx = content.indexOf("\"", openingQuoteInx + 1);
        if (closingQuoteInx <= 0) {
            return;
        }
        schemaLocationValue = content.substring(openingQuoteInx + 1, closingQuoteInx);
        st = new StringTokenizer(schemaLocationValue);
        if (st.countTokens() <= 0) return;
        if (st.countTokens() % 2 == 1) {
            return;
        }
        while (true) {
            if (!st.hasMoreTokens()) {
                return;
            }
            st.nextToken();
            schemaLocationValue = st.nextToken();
            try {
                schemaFile = new ResourceWrapper(this.resolvePath(resource, schemaLocationValue), this.inEclipse);
                if (!schemaFile.exists()) continue;
                this.addSMLUnit(schemaFile, 0);
                continue;
            }
            catch (MissingResourceException e) {
                SMLActivator.logError(e);
                continue;
            }
            break;
        }
    }

    private String resolvePath(ResourceWrapper resource, String resourcePath) {
        String parentPath;
        int lastSegmentInx;
        if (!resourcePath.startsWith("/") && !resourcePath.startsWith("\\") && (lastSegmentInx = Math.max((parentPath = resource.getFullPath()).lastIndexOf("/"), parentPath.lastIndexOf("\\"))) >= 0) {
            return String.valueOf(parentPath.substring(0, lastSegmentInx + 1)) + resourcePath;
        }
        return resourcePath;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addReferences(ResourceWrapper file) {
        block20: {
            referenceExtractor = new ReferenceExtractor();
            inputStream = null;
            try {
                try {
                    inputStream = file.getContents();
                    SMLValidatorUtil.saxParseDocument(inputStream, referenceExtractor);
                }
                catch (Exception e) {
                    SMLActivator.logError(e);
                    var5_6 = null;
                    try {
                        if (inputStream == null) return;
                        inputStream.close();
                        return;
                    }
                    catch (IOException e) {
                        SMLActivator.logError(e);
                    }
                    return;
                }
            }
            catch (Throwable var6_13) {
                var5_7 = null;
                ** try [egrp 2[TRYBLOCK] [3 : 44->55)] { 
lbl23:
                // 1 sources

                if (inputStream == null) throw var6_13;
                inputStream.close();
                throw var6_13;
lbl26:
                // 1 sources

                catch (IOException e) {
                    SMLActivator.logError(e);
                }
                throw var6_13;
            }
            {
                var5_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 44->55)] { 
lbl31:
            // 1 sources

            if (inputStream != null) {
                inputStream.close();
            }
            break block20;
lbl34:
            // 1 sources

            catch (IOException e) {
                SMLActivator.logError(e);
            }
        }
        references = (List)referenceExtractor.getDataStructure();
        i = 0;
        referenceCount = references.size();
        while (true) {
            block19: {
                if (i >= referenceCount) {
                    return;
                }
                uri = (String)references.get(i);
                finalUri = new StringBuffer();
                st = new StringTokenizer(uri, "\n,\r");
                while (true) {
                    if (!st.hasMoreTokens()) {
                        anchorInx = finalUri.indexOf("#");
                        if (anchorInx >= 0) {
                            uri = finalUri.substring(0, anchorInx);
                        }
                        ** try [egrp 4[TRYBLOCK] [4, 5 : 178->219)] { 
lbl52:
                        // 1 sources

                        break;
                    }
                    finalUri.append(st.nextToken().trim());
                }
                {
                    referencedFile = new ResourceWrapper(this.resolvePath(file, uri.trim()), this.inEclipse);
                    if (referencedFile.exists()) {
                        this.addSMLUnit(referencedFile, 1);
                    }
                    break block19;
                }
lbl60:
                // 1 sources

                catch (MissingResourceException mre) {
                    SMLActivator.logError(mre);
                    break block19;
                }
lbl63:
                // 1 sources

                catch (IllegalArgumentException v0) {}
            }
            ++i;
        }
    }

    public boolean validateSmlUnits() {
        if (this.smlUnitsToValidate.size() == 0) {
            return true;
        }
        StringBuffer filePaths = new StringBuffer();
        Iterator selectedElements = this.smlUnitsToValidate.iterator();
        while (selectedElements.hasNext()) {
            ResourceWrapper resource = (ResourceWrapper)selectedElements.next();
            if (filePaths.length() > 0) {
                filePaths.append(",");
            }
            filePaths.append(resource.getFullPath());
        }
        Map attributes = this.validator.getAttributes();
        attributes.put("validation.input.type", "value.sml.unit");
        attributes.put("validation.instance", filePaths.toString());
        return this.validator.start();
    }

    private void addSMLUnit(ResourceWrapper resource, int type) {
        if (this.smlUnitsToValidate.contains(resource)) {
            return;
        }
        this.smlUnitsToValidate.add(resource);
        if (type == 1) {
            this.addDefinition(resource);
            this.addReferences(resource);
        }
    }
}

