/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.common;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ResourceWrapper;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationMessage;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;

public abstract class AbstractValidationOutput
implements IValidationOutput {
    private ResourceWrapper associatedResource;
    private int errorCount = 0;
    private List previousMessages = new ArrayList();

    public void initialize(Map attributes) {
        String fileName = (String)attributes.get("validation.instance");
        if (fileName != null) {
            try {
                this.associatedResource = new ResourceWrapper(fileName, "value.environment.eclipse".equals(attributes.get("attribute.environment")));
            }
            catch (MissingResourceException missingResourceException) {
                this.associatedResource = null;
            }
        }
    }

    public void reportMessage(IValidationMessage validationMessage) {
        if (validationMessage == null) {
            return;
        }
        if (validationMessage.getAttribute("attribute.severity", -1) == 2) {
            ++this.errorCount;
        }
        if (this.associatedResource != null && validationMessage.getAttribute("attribute.resource", null) == null) {
            validationMessage.setAttribute("attribute.resource", this.associatedResource);
        }
        if (this.previousMessages.contains(validationMessage)) {
            return;
        }
        this.previousMessages.add(validationMessage);
        this.writeMessageToSource(validationMessage);
    }

    public abstract void writeMessageToSource(IValidationMessage var1);

    public void close() {
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public ResourceWrapper getAssociatedResource() {
        return this.associatedResource;
    }

    public void setAssociatedResource(ResourceWrapper resource) {
        this.associatedResource = resource;
    }

    public static class ValidationMessage
    implements IValidationMessage {
        public static final int SEVERITY_INFO = 0;
        public static final int SEVERITY_WARNING = 1;
        public static final int SEVERITY_ERROR = 2;
        public static final String ATTRIBUTE_MESSAGE = "attribute.message";
        public static final String ATTRIBUTE_SEVERITY = "attribute.severity";
        public static final String ATTRIBUTE_RESOURCE = "attribute.resource";
        public static final String ATTRIBUTE_LINE_NUMBER = "attribute.line.number";
        public static final int NO_LINE_NUMBER = -1;
        private Map attributes = new Hashtable();

        public void setAttribute(String key, String value) {
            this.setAttribute(key, (Object)value);
        }

        public void setAttribute(String key, int value) {
            this.setAttribute(key, new Integer(value));
        }

        public void setAttribute(String key, boolean value) {
            this.setAttribute(key, new Boolean(value));
        }

        public void setAttribute(String key, Object value) {
            if (key == null || value == null) {
                return;
            }
            this.attributes.put(key, value);
        }

        public int getAttribute(String key, int defaultValue) {
            Object value = this.attributes.get(key);
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return defaultValue;
        }

        public boolean getAttribute(String key, boolean defaultValue) {
            Object value = this.attributes.get(key);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return defaultValue;
        }

        public String getAttribute(String key, String defaultValue) {
            Object value = this.attributes.get(key);
            if (value instanceof String) {
                return (String)value;
            }
            return defaultValue;
        }

        public Object getAttribute(String key) {
            return this.attributes.get(key);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("MSG: " + this.getAttribute(ATTRIBUTE_MESSAGE, "<none>"));
            return buffer.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ValidationMessage)) {
                return false;
            }
            ValidationMessage other = (ValidationMessage)obj;
            return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
        }
    }

    public static class ValidationMessageFactory {
        public static IValidationMessage createErrorMessage(String filePath, int lineNumber, String message) {
            return ValidationMessageFactory.createMessage(2, filePath, lineNumber, message);
        }

        public static IValidationMessage createErrorMessage(int lineNumber, String message) {
            return ValidationMessageFactory.createMessage(2, null, lineNumber, message);
        }

        public static IValidationMessage createErrorMessage(String filePath, int lineNumber, int columnNumber, String localizedMessage) {
            return ValidationMessageFactory.createMessage(2, filePath, lineNumber, columnNumber, localizedMessage);
        }

        public static IValidationMessage createWarningMessage(String filePath, int lineNumber, String message) {
            return ValidationMessageFactory.createMessage(1, filePath, lineNumber, message);
        }

        public static IValidationMessage createWarningMessage(int lineNumber, String message) {
            return ValidationMessageFactory.createMessage(1, null, lineNumber, message);
        }

        public static IValidationMessage createInfoMessage(String filePath, int lineNumber, String message) {
            return ValidationMessageFactory.createMessage(0, filePath, lineNumber, message);
        }

        public static IValidationMessage createInfoMessage(int lineNumber, String message) {
            return ValidationMessageFactory.createMessage(0, null, lineNumber, message);
        }

        private static IValidationMessage createMessage(int severity, String filePath, int lineNumber, String message) {
            return ValidationMessageFactory.createMessage(severity, filePath, lineNumber, -1, message);
        }

        private static IValidationMessage createMessage(int severity, String filePath, int lineNumber, int columnNumber, String message) {
            if (message == null) {
                return null;
            }
            ValidationMessage validationMessage = new ValidationMessage();
            validationMessage.setAttribute("attribute.severity", severity);
            validationMessage.setAttribute("attribute.line.number", lineNumber);
            validationMessage.setAttribute("attribute.column.number", columnNumber);
            validationMessage.setAttribute("attribute.message", message);
            if (filePath != null) {
                validationMessage.setAttribute("attribute.resource", filePath);
            }
            return validationMessage;
        }
    }
}

