/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.content;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;

public abstract class AbstractXMLContentDescriber
implements IContentDescriber {
    public static final int CONTINUE = 10;

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(contents));
        String currentLine = null;
        boolean commentHit = false;
        int inx = -1;
        while ((currentLine = br.readLine()) != null) {
            int type;
            if ((currentLine = currentLine.trim()).length() <= 0 || currentLine.startsWith("<?")) continue;
            if (currentLine.startsWith("<!--")) {
                if (currentLine.endsWith("-->")) continue;
                commentHit = true;
                continue;
            }
            if (commentHit && (inx = currentLine.indexOf("-->")) >= 0) {
                commentHit = false;
                if (inx >= currentLine.length() - 4 || (type = this.determineType(currentLine = currentLine.substring(inx).trim())) == 10) continue;
                return type;
            }
            if (commentHit || (type = this.determineType(currentLine)) == 10) continue;
            return type;
        }
        return 0;
    }

    public abstract int determineType(String var1);

    public QualifiedName[] getSupportedOptions() {
        return null;
    }

    protected String retrieveElementName(String line) {
        if (line == null || line.length() <= 0 || line.charAt(0) != '<') {
            return null;
        }
        int inx = line.indexOf(32);
        line = inx < 0 ? line.substring(1) : line.substring(1, inx);
        inx = line.indexOf(58);
        return inx < 0 ? line : line.substring(inx + 1);
    }
}

