/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.validation.internal.actions.ValidateResourceAction;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.FileOutput;
import org.eclipse.cosmos.rm.validation.internal.common.MarkerOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SystemOutput;
import org.eclipse.cosmos.rm.validation.internal.core.DatastructureBuilderImpl;
import org.eclipse.cosmos.rm.validation.internal.core.IValidationListener;
import org.eclipse.cosmos.rm.validation.internal.core.IValidator;
import org.eclipse.cosmos.rm.validation.internal.core.ValidationEvent;
import org.eclipse.cosmos.rm.validation.internal.core.ValidationFactory;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;

public class SMLMainValidator
implements IValidationListener {
    private static final String OPTION_XML = "-xml";
    private static final String OPTION_SML = "-sml";
    private static final String OPTION_SCHEMATRON = "-schematron";
    private static final String OPTION_FILE = "-output";
    private static final String SML_IF_SCHEMA = "validation-resources/smlif.xsd";
    private Map attributes = new Hashtable();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public SMLMainValidator() {
        this.setDefaultAttributes();
    }

    protected void setDefaultAttributes() {
        this.attributes.put("attribute.environment", "value.environment.standalone");
        this.attributes.put("attribute.validation.xml", "default.validation.xml");
        ArrayList<String> smlValidators = new ArrayList<String>();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cosmos.rm.validation.internal.smlvalidators.AcyclicValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        smlValidators.add(clazz.getName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cosmos.rm.validation.internal.smlvalidators.IdentityConstraintValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        smlValidators.add(clazz2.getName());
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.cosmos.rm.validation.internal.smlvalidators.TargetValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        smlValidators.add(clazz3.getName());
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.cosmos.rm.validation.internal.smlvalidators.SchemaValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        smlValidators.add(clazz4.getName());
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.cosmos.rm.validation.internal.smlvalidators.SchematronValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        smlValidators.add(clazz5.getName());
        this.attributes.put("attribute.validation.sml", smlValidators);
        this.attributes.put("validation.schema.smlif", SML_IF_SCHEMA);
        this.attributes.put("validation.policy.fastfail", "false");
    }

    public void initialize(Map attributes) {
        Iterator keys = attributes.keySet().iterator();
        while (keys.hasNext()) {
            String currentKey = (String)keys.next();
            this.setAttribute(currentKey, (String)attributes.get(currentKey));
        }
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean start() {
        AbstractValidationOutput validationOutput;
        block18: {
            DataBuilderRegistry.instance().clear();
            validationOutput = this.createValidationOutput();
            this.attributes.put("validation.output", validationOutput);
            ReflectiveOperationException exception = null;
            try {
                block17: {
                    boolean bl;
                    block16: {
                        try {
                            DatastructureBuilderImpl datastructureBuilder = new DatastructureBuilderImpl();
                            Class<?> clazz = class$5;
                            if (clazz == null) {
                                try {
                                    clazz = class$5 = Class.forName("org.eclipse.cosmos.rm.validation.internal.core.ISMLValidator");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            IValidator[] smlValidations = ValidationFactory.createValidator(clazz, this.attributes.get("attribute.validation.sml"));
                            Class<?> clazz2 = class$6;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$6 = Class.forName("org.eclipse.cosmos.rm.validation.internal.core.ISchematronValidation");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            IValidator[] schematronValidation = ValidationFactory.createValidator(clazz2, this.attributes.get("attribute.validation.schematron"));
                            IValidator[] completeSet = new IValidator[1 + smlValidations.length + schematronValidation.length];
                            completeSet[0] = datastructureBuilder;
                            System.arraycopy(smlValidations, 0, completeSet, 1, smlValidations.length);
                            System.arraycopy(schematronValidation, 0, completeSet, 1 + smlValidations.length, schematronValidation.length);
                            this.initValidators(completeSet);
                            this.validate(completeSet);
                            bl = validationOutput.getErrorCount() == 0;
                            Object var7_11 = null;
                            if (exception == null) break block16;
                        }
                        catch (InstantiationException e) {
                            exception = e;
                            break block17;
                        }
                        catch (IllegalAccessException e) {
                            exception = e;
                            break block17;
                        }
                        catch (ClassNotFoundException e) {
                            exception = e;
                        }
                        String message = exception.getMessage();
                        validationOutput.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, String.valueOf(SMLMessages.errorValidatorInstantiation) + (message == null ? "" : message)));
                    }
                    validationOutput.close();
                    return bl;
                }
                Object var7_13 = null;
                if (exception == null) break block18;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                if (exception != null) {
                    String message = exception.getMessage();
                    validationOutput.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, String.valueOf(SMLMessages.errorValidatorInstantiation) + (message == null ? "" : message)));
                }
                validationOutput.close();
                throw throwable;
            }
            String message = exception.getMessage();
            validationOutput.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, String.valueOf(SMLMessages.errorValidatorInstantiation) + (message == null ? "" : message)));
        }
        validationOutput.close();
        return false;
    }

    private boolean validate(IValidator[] validators) {
        boolean allValid = true;
        int i = 0;
        while (i < validators.length) {
            if (validators[i] != null && !validators[i].validate()) {
                allValid = false;
                if (this.fastFailPolicy()) {
                    return false;
                }
            }
            ++i;
        }
        return allValid;
    }

    private boolean fastFailPolicy() {
        String fastFail = (String)this.attributes.get("validation.policy.fastfail");
        if (fastFail != null) {
            return Boolean.valueOf(fastFail);
        }
        return false;
    }

    private void initValidators(IValidator[] validators) {
        int i = 0;
        while (i < validators.length) {
            if (validators[i] != null) {
                validators[i].initialize(this.attributes);
                validators[i].addValidationListener(this);
            }
            ++i;
        }
    }

    protected AbstractValidationOutput createValidationOutput() {
        String environment = (String)this.attributes.get("attribute.environment");
        AbstractValidationOutput validationOutput = null;
        validationOutput = "value.environment.eclipse".equals(environment) ? new MarkerOutput() : ("value.environment.standalone".equals(environment) ? new FileOutput() : new SystemOutput());
        ((AbstractValidationOutput)validationOutput).initialize(this.attributes);
        return validationOutput;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            SMLMainValidator.printUsage();
            return;
        }
        int lastInx = -1;
        int currentInx = 0;
        SMLMainValidator mainValidator = new SMLMainValidator();
        try {
            while (lastInx != currentInx) {
                lastInx = currentInx;
                currentInx = SMLMainValidator.processOption(mainValidator, args, currentInx);
            }
            if (currentInx != args.length - 1) {
                SMLMainValidator.printUsage();
                return;
            }
            mainValidator.getAttributes().put("validation.instance", args[currentInx]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SMLMainValidator.printUsage();
        }
        new ValidateResourceAction(mainValidator).run(null);
    }

    private static int processOption(SMLMainValidator mainValidator, String[] args, int inx) throws IllegalArgumentException {
        if (inx < 0 || inx >= args.length) {
            return inx;
        }
        String currentOption = args[inx];
        boolean xml = false;
        xml = OPTION_XML.equals(currentOption);
        if (xml || OPTION_SCHEMATRON.equals(currentOption)) {
            ++inx;
            inx = SMLMainValidator.addAttribute(mainValidator, args, inx, xml ? "attribute.validation.xml" : "attribute.validation.schematron");
        } else if (OPTION_SML.equals(currentOption)) {
            ArrayList<String> smlValidators = new ArrayList<String>();
            while (++inx < args.length - 1 && !args[inx].startsWith("-")) {
                StringTokenizer st = new StringTokenizer(args[inx]);
                while (st.hasMoreTokens()) {
                    smlValidators.add(st.nextToken());
                }
            }
            if (smlValidators.isEmpty()) {
                throw new IllegalArgumentException();
            }
            mainValidator.getAttributes().put("attribute.validation.sml", smlValidators);
        } else if (OPTION_FILE.equals(currentOption)) {
            ++inx;
            inx = SMLMainValidator.addAttribute(mainValidator, args, inx, "attribute.file.output");
        }
        return inx;
    }

    private static int addAttribute(SMLMainValidator mainValidator, String[] args, int inx, String attribute) throws IllegalArgumentException {
        if (inx >= args.length || args[inx].startsWith("-")) {
            throw new IllegalArgumentException();
        }
        mainValidator.getAttributes().put(attribute, args[inx]);
        return inx + 1;
    }

    private static void printUsage() {
        System.err.println(SMLMessages.errorIllegalArguments);
    }

    public void validationErrorOccurred(ValidationEvent event) {
        event.continueOnError = !this.fastFailPolicy();
    }
}

