/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.core.ISchematronValidation;
import org.eclipse.cosmos.rm.validation.internal.core.IValidationListener;
import org.eclipse.cosmos.rm.validation.internal.util.FileHelper;

public class SchematronValidatorImpl
implements ISchematronValidation {
    protected String xsd;
    protected static final String SKELETON15 = "validation-resources\\skeleton1-5.xsl";
    protected AbstractValidationOutput validationLogger;
    protected Source xml;
    private Collection validationListeners;

    public void initialize(Map validationAttribute) {
        this.validationLogger = (AbstractValidationOutput)validationAttribute.get("validation.output");
        this.xsd = (String)validationAttribute.get("validation.schema.schematron");
        this.xml = new StreamSource((String)validationAttribute.get("validation.instance"));
    }

    public void setXML(Object xml) {
        if (xml instanceof String) {
            this.xml = new StreamSource((String)xml);
        }
    }

    public boolean validate() {
        block3: {
            try {
                if (this.xsd != null) break block3;
                return true;
            }
            catch (IOException e) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
                return false;
            }
        }
        StringWriter sw = new StringWriter();
        StreamResult schematron = new StreamResult(sw);
        this.transform(new StreamSource(this.xsd), new StreamSource(FileHelper.getResourceAsStream(SKELETON15)), schematron);
        schematron.getWriter().flush();
        StringReader sr = new StringReader(sw.getBuffer().toString());
        StreamSource schematronSource = new StreamSource(sr);
        StringWriter errorStream = new StringWriter();
        StreamResult errorStreamResult = new StreamResult(errorStream);
        this.transform(this.xml, schematronSource, errorStreamResult);
        this.parseMessageStream(errorStream.getBuffer().toString());
        return true;
    }

    protected void transform(Source source, Source xslt, Result result) {
        Transformer transformer = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            transformer = tFactory.newTransformer(xslt);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
        }
        catch (TransformerException e) {
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
        }
    }

    protected void parseMessageStream(String messageStream) {
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, messageStream));
    }

    public void addValidationListener(IValidationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList();
        }
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }
}

