/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationMessage;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractDataBuilder
extends DefaultHandler
implements IDataBuilder {
    protected Locator locator;
    private String targetNamespace;
    private String defaultNamespace;
    private Map prefixMap;
    private boolean validity;
    private IValidationMessage errorMessage;
    private byte currentPhase;
    private String filePath;

    public AbstractDataBuilder() {
        this.setStructureValidity(true);
        this.targetNamespace = "";
        this.prefixMap = new Hashtable();
    }

    public void endDefinitions() {
    }

    public void endInstances() {
    }

    public byte getPhase() {
        return 0;
    }

    public void startDefinitions() {
        this.currentPhase = 1;
    }

    public void startInstances() {
        this.currentPhase = (byte)16;
    }

    public byte getCurrentPhase() {
        return this.currentPhase;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "schema".equals(localName)) {
            this.targetNamespace = attributes.getValue("targetNamespace");
            int i = 0;
            int attributeCount = attributes.getLength();
            while (i < attributeCount) {
                String rawAttributeName;
                String attributeName = attributes.getQName(i);
                int prefixInx = attributeName.indexOf(58);
                String string = rawAttributeName = prefixInx >= 0 ? attributeName.substring(0, prefixInx).trim() : attributeName;
                if ("xmlns".equals(rawAttributeName)) {
                    if (prefixInx == -1) {
                        this.defaultNamespace = attributes.getValue(i);
                    } else if (attributeName.length() > prefixInx + 1) {
                        this.prefixMap.put(attributeName.substring(prefixInx + 1), attributes.getValue(i));
                    }
                }
                ++i;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "schema".equals(localName)) {
            this.targetNamespace = "";
            this.prefixMap.clear();
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public boolean isStructureValid() {
        return this.validity;
    }

    public void setStructureValidity(boolean validity) {
        this.validity = validity;
    }

    public IValidationMessage getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(IValidationMessage error) {
        this.errorMessage = error;
    }

    protected void appendToErrorMessage(String error) {
        String errMsg = this.errorMessage.getAttribute("attribute.message", null);
        if (errMsg == null) {
            errMsg = "";
        }
        if (errMsg.length() > 0) {
            errMsg = String.valueOf(errMsg) + IValidationConstants.LINE_SEPARATOR;
        }
        errMsg = String.valueOf(errMsg) + error;
    }

    public Map getPrefixMap() {
        return this.prefixMap;
    }

    public void setPrefixMap(Map prefix) {
        this.prefixMap = prefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    protected String[] tokenizeName(String qName) {
        if (qName == null) {
            return new String[2];
        }
        int inx = qName.indexOf(58);
        String prefix = inx >= 0 ? qName.substring(0, inx) : "";
        String localName = inx >= 0 && qName.length() > inx + 1 ? qName.substring(inx + 1) : qName;
        return new String[]{prefix, localName};
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void comment(char[] cs, int i, int j) {
    }
}

