/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementModel;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;

public class ElementSourceBuilder
extends AbstractDataBuilder {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ElementSourceHandler";
    private List schemas = new ArrayList();
    private boolean documentElementHit;
    private boolean dataElementHit;
    private boolean instanceElementHit = false;
    private boolean definitionElementHit = false;
    private ElementModel currentElementModel;
    private ElementLocation lastDataLocation;
    private List instances = new ArrayList();
    private String smlifFile;

    public ElementSourceBuilder(String smlifFile) {
        this.smlifFile = smlifFile;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.dataElementHit) {
            boolean importElement;
            if (!"http://purl.oclc.org/dsdl/schematron".equals(uri) && this.lastDataLocation != null) {
                this.currentElementModel = new ElementModel(qName, this.elementFilePath(), Math.max(this.lastDataLocation.getLineNumber(), 0), this.lastDataLocation.getColumnNumber());
                this.lastDataLocation = null;
            }
            boolean needSchemaLocation = (importElement = "import".equals(localName)) && this.currentElementModel != null;
            boolean smlNamespace = false;
            int i = 0;
            while (i < attributes.getLength()) {
                if (importElement && "schemaLocation".equals(attributes.getLocalName(i))) {
                    needSchemaLocation = false;
                }
                if (importElement && "namespace".equals(attributes.getLocalName(i)) && "http://schemas.serviceml.org/sml/2007/02".equals(attributes.getValue(i))) {
                    smlNamespace = true;
                }
                ++i;
            }
            if (smlNamespace && needSchemaLocation) {
                StringBuffer buffer = new StringBuffer(" schemaLocation");
                buffer.append("=").append("\"").append("http://schemas.serviceml.org/sml/2007/02").append("\"");
                this.currentElementModel.setAdditionalSchemaLocation(buffer.toString());
            }
        }
        if ("http://schemas.serviceml.org/smlif/2007/02".equals(uri)) {
            if ("instances".equals(localName)) {
                this.instanceElementHit = true;
            } else if ("definitions".equals(localName)) {
                this.definitionElementHit = true;
            } else if ("document".equals(localName)) {
                this.documentElementHit = true;
            } else if (this.documentElementHit && "data".equals(localName)) {
                this.dataElementHit = true;
                this.lastDataLocation = this.locator != null ? new ElementLocation(null, this.locator.getLineNumber() + 1, this.locator.getColumnNumber() + 1) : new ElementLocation(null, 0, 0);
            }
        }
    }

    private String elementFilePath() {
        return this.smlifFile == null ? this.getFilePath() : this.smlifFile;
    }

    public void endElement(String uri, String localName, String qName) {
        if ("http://schemas.serviceml.org/smlif/2007/02".equals(uri)) {
            if (this.instanceElementHit && "instances".equals(localName)) {
                this.instanceElementHit = false;
            } else if (this.definitionElementHit && "definitions".equals(localName)) {
                this.definitionElementHit = false;
            } else if (this.documentElementHit && "document".equals(localName)) {
                this.documentElementHit = false;
            } else if (this.dataElementHit && "data".equals(localName)) {
                this.dataElementHit = false;
                this.addModelToList(this.instances);
            }
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "schema".equals(localName)) {
            this.addModelToList(this.schemas);
        }
    }

    private void addModelToList(List list) {
        if (this.currentElementModel == null || list == null) {
            return;
        }
        if (this.locator != null) {
            this.currentElementModel.setEndingLine(this.locator.getLineNumber());
        }
        this.getElementSource(this.currentElementModel);
        list.add(this.currentElementModel);
        this.currentElementModel = null;
    }

    private void getElementSource(ElementModel elementModel) {
        LineNumberReader in = null;
        try {
            in = new LineNumberReader(new FileReader(SMLValidatorUtil.retrieveAbsolutePath(elementModel.getFilePath())));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            String currentLine = in.readLine();
            while (in.getLineNumber() < elementModel.getLineNumber()) {
                currentLine = in.readLine();
            }
            StringBuffer contents = new StringBuffer();
            if (this.smlifFile != null) {
                contents.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            }
            String firstLine = null;
            if (currentLine.indexOf(60) == -1) {
                currentLine = in.readLine();
                firstLine = String.valueOf(currentLine) + "\n";
            } else {
                int prevTagOnLine = currentLine.lastIndexOf(62, elementModel.getColumnNumber());
                firstLine = String.valueOf(currentLine.substring(prevTagOnLine + 1)) + "\n";
            }
            in.setLineNumber(elementModel.getLineNumber());
            contents.append(firstLine);
            boolean endFound = false;
            while (!endFound && currentLine != null) {
                int endTagIndex;
                currentLine = in.readLine();
                if (currentLine == null) break;
                if (elementModel.getAdditionalSchemaLocation() != null && currentLine.matches(".*[^/][\\s]*import.*")) {
                    endTagIndex = currentLine.indexOf(62, currentLine.indexOf("import"));
                    currentLine = endTagIndex == -1 ? String.valueOf(currentLine) + elementModel.getAdditionalSchemaLocation() : String.valueOf(currentLine.substring(0, endTagIndex)) + elementModel.getAdditionalSchemaLocation() + currentLine.substring(endTagIndex);
                }
                if (endFound = currentLine.matches(".*/[\\s]*" + elementModel.getElementName() + "[\\s]*>.*")) {
                    endTagIndex = currentLine.indexOf(elementModel.getElementName());
                    int rightBracket = currentLine.indexOf(62, endTagIndex);
                    elementModel.setEndingLine(in.getLineNumber());
                    elementModel.setEndingColumn(rightBracket);
                    contents.append(String.valueOf(currentLine.substring(0, rightBracket + 1)) + "\n");
                    continue;
                }
                contents.append(String.valueOf(currentLine) + "\n");
            }
            elementModel.setSource(contents.toString());
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List getSchemas() {
        return this.schemas;
    }

    public List getInstances() {
        return this.instances;
    }

    public byte getPhase() {
        return 3;
    }

    public Object getDataStructure() {
        return null;
    }
}

