/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.querydefn;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;

public class Binding
implements IBinding {
    private List aggregateOn;
    private List argument;
    private IBaseExpression expr;
    private IBaseExpression filter;
    private String aggrFunc;
    private String name;
    private int dataType;

    public Binding(String name) {
        this(name, null);
    }

    public Binding(String name, IBaseExpression expr) {
        this.name = name;
        this.expr = expr;
        this.aggregateOn = new ArrayList();
        this.argument = new ArrayList();
        this.dataType = expr != null ? expr.getDataType() : 0;
    }

    public void addAggregateOn(String levelName) throws DataException {
        if (this.aggregateOn.contains(levelName)) {
            throw new DataException("data.olap.tryToAddIdenticalAggrGroup", new Object[]{levelName, this.name});
        }
        this.aggregateOn.add(levelName);
    }

    public void addArgument(IBaseExpression expr) {
        this.argument.add(expr);
    }

    public String getAggrFunction() {
        return this.aggrFunc;
    }

    public List getAggregatOns() {
        return this.aggregateOn;
    }

    public List getArguments() {
        return this.argument;
    }

    public int getDataType() {
        return this.dataType;
    }

    public IBaseExpression getFilter() {
        return this.filter;
    }

    public void setAggrFunction(String functionName) {
        this.aggrFunc = functionName;
    }

    public void setDataType(int type) {
        this.dataType = type;
    }

    public void setExpression(IBaseExpression expr) {
        this.expr = expr;
    }

    public void setFilter(IBaseExpression expr) {
        this.filter = expr;
    }

    public String getBindingName() {
        return this.name;
    }

    public IBaseExpression getExpression() {
        return this.expr;
    }
}

