/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.fastxpath.compiler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledExpressionEvaluator;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledXPathExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerNotAvailableException;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerPostProcessor;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.FastXPathClassGenerator;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerHelper;

public class CompilerHelper
implements ICompilerHelper {
    protected Class objectClass = null;
    protected String outputFilePath = null;
    protected String className = null;
    protected static boolean keepJavaFile = false;
    protected static final String VERBOSE_COMPILATION = "FXP_VERBOSE_COMPILATION";
    public static boolean verboseOutput;
    protected FastXPathClassGenerator compiler;
    protected HashMap classesAsByteArrays = new HashMap();
    protected char[] javaSource;
    protected StringBuffer sb = new StringBuffer();
    protected CompilerPostProcessor compilerPostProcessor;
    protected String returnTypeAndMethodName = "Object eval";
    protected String compiledExpressionEvaluatorExtension;
    protected String classComment;
    protected static final String DEFAULT_FILEPATH;
    protected static final int RETRY_COUNT = 10;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        keepJavaFile = verboseOutput = System.getProperty(VERBOSE_COMPILATION) != null;
        DEFAULT_FILEPATH = "." + File.separator;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void batchCompile(List compiledExpressions, List xpathExpressions) throws CodeGenerationError, CompilerNotAvailableException {
        xpaths = new HashSet<String>();
        compiledXPathExpressions = new ArrayList<CompiledXPathExpression>();
        compiledClassMap = new HashMap<String, CompiledXPathExpression>();
        xpathExpression = null;
        compiledExpression = null;
        javaSource = null;
        new ArrayList<E>();
        i = 0;
        while (i < xpathExpressions.size()) {
            xpathExpression = (String)xpathExpressions.get(i);
            if (this.classesAsByteArrays.get(xpathExpression) == null) {
                compiledExpression = (String)compiledExpressions.get(i);
                cName = this.createClassName(xpathExpression);
                javaSource = this.createJavaSource(compiledExpression, xpathExpression, cName);
                if (!xpaths.contains(xpathExpression)) {
                    compiledXPathExpression = new CompiledXPathExpression();
                    compiledXPathExpression.setClassName(cName);
                    compiledXPathExpression.setXpathExpression(xpathExpression);
                    compiledXPathExpression.setCompiledExpression(compiledExpression);
                    compiledXPathExpression.setJavaSource(javaSource);
                    xpaths.add(xpathExpression);
                    compiledXPathExpressions.add(compiledXPathExpression);
                    compiledClassMap.put(cName, compiledXPathExpression);
                }
                xpathExpression = null;
                compiledExpression = null;
                javaSource = null;
            }
            ++i;
        }
        compiledExpressions = null;
        while (compiledXPathExpressions.size() > 0) {
            try {
                block13: {
                    try {
                        this.getCompiler().batchCompile(compiledXPathExpressions);
                        break block13;
                    }
                    catch (Throwable e) {
                        results = CompilerPostProcessor.getCompilerResults(e.getMessage());
                        if (results == null) break block13;
                        keys = results.keySet();
                        it = keys.iterator();
                        ** while (it.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        className = (String)it.next();
                        error = (String)results.get(className);
                        compiledXPathExpression = (CompiledXPathExpression)compiledClassMap.get(className);
                        compiledXPathExpression.setErrorMsg(error);
                        entryCount = compiledXPathExpression.getReEntryCount();
                        if (entryCount < 10) {
                            source = compiledXPathExpression.getJavaSource();
                            source = new CompilerPostProcessor(new String(source)).fixCompileError(new CodeGenerationError(error));
                            compiledXPathExpression.setJavaSource(source);
                            compiledXPathExpression.setReEntryCount(entryCount + 1);
                            continue;
                        }
                        compiledXPathExpressions.remove(compiledXPathExpression);
                        continue;
                    }
                }
                var18_19 = null;
                it = compiledXPathExpressions.iterator();
                if (true) ** GOTO lbl85
            }
            catch (Throwable var19_24) {
                var18_19 = null;
                it = compiledXPathExpressions.iterator();
                ** while (it.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                compiledXPathExpression = (CompiledXPathExpression)it.next();
                if (!compiledXPathExpression.isClassCompiled()) continue;
                bytes = compiledXPathExpression.getBytes();
                xpath = compiledXPathExpression.getXpathExpression();
                this.classesAsByteArrays.put(xpath, bytes);
                compiledXPathExpression = null;
                it.remove();
                continue;
            }
lbl76:
            // 1 sources

            throw var19_24;
            do {
                if (!(compiledXPathExpression = (CompiledXPathExpression)it.next()).isClassCompiled()) continue;
                bytes = compiledXPathExpression.getBytes();
                xpath = compiledXPathExpression.getXpathExpression();
                this.classesAsByteArrays.put(xpath, bytes);
                compiledXPathExpression = null;
                it.remove();
lbl85:
                // 3 sources

            } while (it.hasNext());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List batchGetJavaSource(List compiledExpressions, List xpathExpressions, CompilerPostProcessor compilerPostProcessor) throws CodeGenerationError, CompilerNotAvailableException {
        compiledXPathExpressions = new ArrayList<CompiledXPathExpression>();
        compiledClassMap = new HashMap<String, CompiledXPathExpression>();
        xpathExpression = null;
        compiledExpression = null;
        javaSource = null;
        i = 0;
        while (i < xpathExpressions.size()) {
            xpathExpression = (String)xpathExpressions.get(i);
            compiledExpression = (String)compiledExpressions.get(i);
            cName = this.createClassName(xpathExpression);
            javaSource = this.createJavaSource(compiledExpression, xpathExpression, cName);
            compiledXPathExpression = new CompiledXPathExpression();
            compiledXPathExpression.setClassName(cName);
            compiledXPathExpression.setXpathExpression(xpathExpression);
            compiledXPathExpression.setCompiledExpression(compiledExpression);
            compiledXPathExpression.setJavaSource(javaSource);
            compiledXPathExpressions.add(compiledXPathExpression);
            compiledClassMap.put(cName, compiledXPathExpression);
            ++i;
        }
        xpathExpression = null;
        compiledExpression = null;
        javaSource = null;
        compiledExpressions = null;
        res = new ArrayList<CompiledXPathExpression>();
        res.addAll(compiledXPathExpressions);
        while (compiledXPathExpressions.size() > 0) {
            try {
                block11: {
                    try {
                        this.getCompiler().batchCompile(compiledXPathExpressions);
                        break block11;
                    }
                    catch (Throwable e) {
                        results = CompilerPostProcessor.getCompilerResults(e.getMessage());
                        if (results == null) break block11;
                        keys = results.keySet();
                        it = keys.iterator();
                        ** while (it.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        className = (String)it.next();
                        error = (StringBuffer)results.get(className);
                        compiledXPathExpression = (CompiledXPathExpression)compiledClassMap.get(className);
                        compiledXPathExpression.setErrorMsg(error.toString());
                        entryCount = compiledXPathExpression.getReEntryCount();
                        if (entryCount < 10) {
                            source = compiledXPathExpression.getJavaSource();
                            compilerPostProcessor.setSb(new StringBuffer(new String(source)));
                            source = compilerPostProcessor.fixCompileError(new CodeGenerationError(error.toString()));
                            compiledXPathExpression.setJavaSource(source);
                            compiledXPathExpression.setReEntryCount(entryCount + 1);
                            continue;
                        }
                        compiledXPathExpressions.remove(compiledXPathExpression);
                        continue;
                    }
                }
                var19_21 = null;
                it = compiledXPathExpressions.iterator();
                if (true) ** GOTO lbl74
            }
            catch (Throwable var20_24) {
                var19_21 = null;
                it = compiledXPathExpressions.iterator();
                ** while (it.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                compiledXPathExpression = (CompiledXPathExpression)it.next();
                if (!compiledXPathExpression.isClassCompiled()) continue;
                it.remove();
                continue;
            }
lbl70:
            // 1 sources

            throw var20_24;
            do {
                if (!(compiledXPathExpression = (CompiledXPathExpression)it.next()).isClassCompiled()) continue;
                it.remove();
lbl74:
                // 3 sources

            } while (it.hasNext());
        }
        return res;
    }

    public CompilerHelper(Class clas) {
        StringBuffer stringBuffer = new StringBuffer(" extends ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledExpressionEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.compiledExpressionEvaluatorExtension = stringBuffer.append(clazz.getName()).toString();
        this.objectClass = clas;
    }

    protected void writeJavaCode(StringBuffer sb, String expr, String classname) {
        sb.append("\n");
        sb.append("public class " + classname + this.compiledExpressionEvaluatorExtension + " {\n");
        StringBuffer stringBuffer = new StringBuffer("\tpublic ").append(this.returnTypeAndMethodName).append("(");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append(" object, ");
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.tptp.platform.provisional.fastxpath.IFastXPathEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sb.append(stringBuffer2.append(clazz2.getName()).append(" ").append("fastXPathEngine").append(" ) {\n").toString());
        this.writeJavaBodyCode(sb, expr);
        sb.append("\t}\n");
        sb.append("}\n");
    }

    protected void writeJavaBodyCode(StringBuffer sb, String expr) {
        StringBuffer bodySB = new StringBuffer();
        bodySB.append("\t\t" + this.objectClass.getName() + " obj = (" + this.objectClass.getName() + ")object;" + "\n");
        bodySB.append("\t\t" + expr + "\n");
        sb.append(bodySB);
    }

    public char[] createJavaSource(String compiledExpression, String xpathExpression, String cName) {
        StringBuffer sb = new StringBuffer();
        if (this.classComment == null) {
            sb.append("// This class has been auto generated for the XPath: \n");
            sb.append("// " + xpathExpression + "\n");
        } else {
            sb.append(this.classComment);
        }
        this.writeJavaCode(sb, compiledExpression, cName);
        return sb.toString().toCharArray();
    }

    public CompiledExpressionEvaluator getCompiledExpressionEvaluator(String compiledExpression, String xpathExpression) throws CodeGenerationError, CompilerNotAvailableException {
        Class compilerOutput = this.buildCompiledExpression(compiledExpression, xpathExpression, true);
        if (keepJavaFile) {
            String cName = this.className == null ? this.createClassName(xpathExpression) : this.className;
            String fileName = this.outputFilePath == null ? String.valueOf(DEFAULT_FILEPATH) + cName : String.valueOf(this.outputFilePath) + cName;
            fileName = fileName.concat(".java");
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File(fileName)));
                bw.write(this.javaSource);
                bw.close();
            }
            catch (IOException e2) {
                System.err.println("Error writing java file. Compilation successful!!!");
                e2.printStackTrace();
            }
        }
        try {
            return (CompiledExpressionEvaluator)compilerOutput.newInstance();
        }
        catch (Exception e) {
            throw new CodeGenerationError("Compiled class not found", e);
        }
    }

    public Class buildCompiledExpression(String compiledExpression, String xpathExpression, boolean cacheByteCode) throws CodeGenerationError, CompilerNotAvailableException {
        String cName;
        String string = cName = this.className == null ? this.createClassName(xpathExpression) : this.className;
        if (this.compiler == null) {
            this.initCompiler();
        }
        Class compilerOutput = null;
        byte[] classBytes = (byte[])this.classesAsByteArrays.get(xpathExpression);
        if (classBytes != null) {
            try {
                compilerOutput = this.compiler.generateClass(classBytes);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            return compilerOutput;
        }
        this.javaSource = this.createJavaSource(compiledExpression, xpathExpression, cName);
        int retryCount = 10;
        while (retryCount-- > 0) {
            try {
                compilerOutput = this.compiler.generateClass(this.javaSource, cName);
                if (cacheByteCode) {
                    this.classesAsByteArrays.put(xpathExpression, this.compiler.getBytes());
                }
                return compilerOutput;
            }
            catch (CodeGenerationError error) {
                this.sb.setLength(0);
                this.sb.append(this.javaSource);
                this.compilerPostProcessor = this.compilerPostProcessor == null ? new CompilerPostProcessor("").setSb(this.sb) : this.compilerPostProcessor.setSb(this.sb);
                this.javaSource = new CompilerPostProcessor(new String(this.javaSource)).fixCompileError(error);
                if (this.javaSource != null) continue;
                throw error;
            }
            catch (Exception e) {
                throw new CodeGenerationError("Compiled class not found", e);
            }
        }
        throw new CodeGenerationError("Cannot compile code for expression: " + xpathExpression);
    }

    public void initCompiler() throws CompilerNotAvailableException {
        try {
            this.compiler = (FastXPathClassGenerator)Class.forName("org.eclipse.tptp.platform.provisional.fastxpath.compiler.JDTCompiler").newInstance();
        }
        catch (Exception e) {
            throw new CompilerNotAvailableException("Error initializing compiler", e);
        }
    }

    protected String createClassName(String xpathExpression) {
        return "Compiled" + String.valueOf(Math.abs(xpathExpression.hashCode()));
    }

    public String getOutputFilePath() {
        return this.outputFilePath;
    }

    public void setOutputFilePath(String outputPath) {
        this.outputFilePath = outputPath.endsWith(File.separator) ? outputPath : outputPath.concat(File.separator);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    public boolean isKeepJavaFile() {
        return keepJavaFile;
    }

    public void setKeepJavaFile(boolean keepFile) {
        keepJavaFile = keepFile;
    }

    public HashMap getClassesAsByteArrays() {
        return this.classesAsByteArrays;
    }

    public FastXPathClassGenerator getCompiler() throws CompilerNotAvailableException {
        if (this.compiler == null) {
            this.initCompiler();
        }
        return this.compiler;
    }

    public char[] getJavaSource() {
        return this.javaSource;
    }

    public String getReturnTypeAndMethodName() {
        return this.returnTypeAndMethodName;
    }

    public void setReturnTypeAndMethodName(String returnTypeAndMethodName) {
        this.returnTypeAndMethodName = returnTypeAndMethodName;
    }

    public String getCompiledExpressionEvaluatorExtension() {
        return this.compiledExpressionEvaluatorExtension;
    }

    public void setCompiledExpressionEvaluatorExtension(String compiledExpressionEvaluatorExtension) {
        this.compiledExpressionEvaluatorExtension = compiledExpressionEvaluatorExtension;
    }

    public String getClassComment() {
        return this.classComment;
    }

    public void setClassComment(String classComment) {
        this.classComment = classComment;
    }
}

