/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath.operations;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XBooleanStatic;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.operations.Operation;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FXPObject;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.EExpression;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.EExpressionFactory;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.objects.EXObject;

public class EOperation
extends EExpression {
    private Operation op;
    protected IExpression eLeft;
    protected IExpression eRight;

    public IExpression instance(Expression e) {
        return new EOperation((Operation)e);
    }

    public EOperation(Operation op) {
        this.op = op;
    }

    public Expression getExpression() {
        return this.op.getExpression();
    }

    public Expression getLeftOperand() {
        return this.op.getLeftOperand();
    }

    public Expression getRightOperand() {
        return this.op.getRightOperand();
    }

    public XObject operate(XObject left, XObject right) throws TransformerException {
        return this.op.operate(left, right);
    }

    public void setExpression(Expression exp) {
        this.op.setExpression(exp);
    }

    public void setLeftRight(Expression l, Expression r) {
        this.op.setLeftRight(l, r);
    }

    public XObject operate(EXObject left, EXObject right) throws TransformerException {
        return this.op.operate((XObject)left.getXo(), (XObject)right.getXo());
    }

    public Object[] execute(FastXPathContext context) throws TransformerException, ExpressionEvaluationException {
        Object[] objArrLeft = this.getELeft().execute(context);
        Object[] objArrRight = this.getERight().execute(context);
        if (objArrLeft.length == 0) {
            objArrLeft = new Object[]{XBooleanStatic.S_FALSE};
        }
        if (objArrRight.length == 0) {
            objArrRight = new Object[]{XBooleanStatic.S_FALSE};
        }
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        int i = 0;
        while (i < objArrRight.length) {
            int j = 0;
            while (j < objArrLeft.length) {
                Object rightObj = objArrRight[i];
                Object leftObj = objArrLeft[j];
                if (leftObj instanceof FXPObject) {
                    leftObj = ((FXPObject)leftObj).getVal();
                }
                if (rightObj instanceof FXPObject) {
                    rightObj = ((FXPObject)rightObj).getVal();
                }
                if (rightObj instanceof XBoolean) {
                    leftObj = this.turnToXBoolean(leftObj);
                }
                if (leftObj instanceof XBoolean) {
                    rightObj = this.turnToXBoolean(rightObj);
                }
                resultList.add(new Object[]{this.operate(new EXObject(leftObj.toString()), new EXObject(rightObj.toString()))});
                ++j;
            }
            ++i;
        }
        Iterator iter = resultList.iterator();
        while (iter.hasNext()) {
            Object[] result = (Object[])iter.next();
            if (result.length == 0 || !this.turnToXBoolean(result[0]).bool()) {
                iter.remove();
                continue;
            }
            return result;
        }
        return new Object[0];
    }

    public void compile(ICompilerContext compilationContext) throws CodeGenerationError {
        compilationContext.in(this);
        this.getELeft().compile(compilationContext);
        compilationContext.append(this.getOpAsString());
        compilationContext.append("( ");
        this.getERight().compile(compilationContext);
        compilationContext.append(")");
        compilationContext.out();
    }

    protected String getOpAsString() {
        return null;
    }

    private XBooleanStatic turnToXBoolean(Object obj) {
        XBooleanStatic boolResult;
        if (obj instanceof String) {
            boolResult = new XBooleanStatic(((String)obj).length() > 0);
        } else if (obj instanceof Boolean) {
            boolResult = new XBooleanStatic(((Boolean)obj).booleanValue());
        } else if (obj instanceof XNumber) {
            boolResult = new XBooleanStatic(((XNumber)obj).num() != 0.0);
        } else if (obj instanceof XObject) {
            try {
                boolResult = new XBooleanStatic(((XObject)obj).bool());
            }
            catch (TransformerException transformerException) {
                boolResult = new XBooleanStatic(obj != null);
            }
        } else {
            boolResult = new XBooleanStatic(obj != null);
        }
        return boolResult;
    }

    public void printGraph(int level) {
        IExpression right;
        super.printGraph(level);
        String indent = this.indent(level);
        IExpression left = this.getELeft();
        if (left != null) {
            System.out.println(String.valueOf(indent) + "LEFT:");
            left.printGraph(level + 1);
        }
        if ((right = this.getERight()) != null) {
            System.out.println(String.valueOf(indent) + "RIGHT:");
            right.printGraph(level + 1);
        }
    }

    public void linkParent(IExpression parent) {
        IExpression right;
        super.linkParent(parent);
        IExpression left = this.getELeft();
        if (left != null) {
            left.linkParent(parent);
        }
        if ((right = this.getERight()) != null) {
            right.linkParent(parent);
        }
    }

    public IExpression getELeft() {
        if (this.eLeft == null) {
            this.eLeft = EExpressionFactory.INSTANCE.createEExprNode(this.op.getLeftOperand());
        }
        return this.eLeft;
    }

    public IExpression getERight() {
        if (this.eRight == null) {
            this.eRight = EExpressionFactory.INSTANCE.createEExprNode(this.op.getRightOperand());
        }
        return this.eRight;
    }

    protected boolean leftSideSatisfies(Object[] leftSide) {
        Object o;
        return leftSide.length != 0 && ((o = leftSide[0]) instanceof XBoolean && ((XBoolean)o).bool() || !(o instanceof XBoolean));
    }
}

