/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.birt.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cosmos.dc.birt.helper.CBESeverityCount;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataQueryResult;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.spi.OutboundContext;
import org.eclipse.cosmos.dc.common.spi.RuntimeHost;
import org.eclipse.cosmos.dc.sample.components.sink.cbe.wrapper.CBECountBySeverity;
import org.eclipse.cosmos.dc.spec.capabilitiy.CBEQueryCapability;
import org.eclipse.cosmos.dc.spec.capabilitiy.StatisticalQueryCapability;
import org.eclipse.cosmos.dc.spec.types.StatisticalTuple;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalHelper {
    private static LocalHelper instance = new LocalHelper();
    private static RuntimeHost host;

    public static LocalHelper getLocalHelperInstance() {
        return instance;
    }

    public void setRuntimeHost(RuntimeHost host) {
        LocalHelper.host = host;
        host.getRegistry();
    }

    public String[] getDatasetsForSourceKeyset(String source, String keyset) throws Exception {
        ProviderRegistry reg = host.getRegistry();
        System.out.println("Database Home is " + System.getProperty("derby.system.home"));
        System.out.println("Getting dataset list");
        Collection ds = reg.getDataSetsForSource(source);
        ArrayList<String> list = new ArrayList<String>();
        if (ds != null) {
            for (DataSet set : ds) {
                if (!set.getDataFlow().getDimensionSet().getName().equals(keyset)) continue;
                try {
                    this.getStatDataForSource(set.getName(), keyset, 0, 1000);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                list.add(set.getName());
                System.out.println("Adding dataset:" + set.getName());
            }
        }
        System.out.println("Returning " + list.size() + " datasets");
        System.out.println("Database Home is " + System.getProperty("derby.system.home"));
        return list.toArray(new String[0]);
    }

    public String getLatestDatasetForSourceKeyset(String source, String keyset) throws Exception {
        ProviderRegistry reg = host.getRegistry();
        DataSet ds = reg.getLatestDataSetForSourceKeyset(source, keyset);
        if (ds != null) {
            return ds.getName();
        }
        return null;
    }

    public Collection<StatisticalTuple> getStatDataForSource(String dataset, String keyset, int start, int size) throws Exception {
        IDataCollectionContext context = host.loadContext("StatQuery.xml");
        context.materialize();
        OutboundContext outbound = (OutboundContext)context;
        IDataQueryService rootQuery = outbound.getRootQuery();
        DataSet set = host.getRegistry().getDataSet(dataset);
        if (rootQuery instanceof StatisticalQueryCapability) {
            StatisticalQueryCapability statQuery = (StatisticalQueryCapability)rootQuery;
            IDataQueryResult result = statQuery.keysetQuery("StatisticalTuple", dataset, keyset, set.getStart(), set.getStop());
            System.out.println("Statquery Returning:" + result.getRawResponseCollection().size());
            return result.getRawResponseCollection();
        }
        return null;
    }

    public Collection<CommonBaseEvent> getAllCBE(String dataset) throws Exception {
        IDataCollectionContext context = host.loadContext("CBEQuery.xml");
        context.materialize();
        OutboundContext outbound = (OutboundContext)context;
        IDataQueryService rootQuery = outbound.getRootQuery();
        if (rootQuery instanceof CBEQueryCapability) {
            CBEQueryCapability cbeQuery = (CBEQueryCapability)rootQuery;
            IDataQueryResult result = cbeQuery.getAllCBE(dataset);
            return result.getRawResponseCollection();
        }
        return null;
    }

    public Collection<CBESeverityCount> getCBECountBySeverity(String dataset) throws Exception {
        IDataCollectionContext context = host.loadContext("CBECount.xml");
        context.materialize();
        OutboundContext outbound = (OutboundContext)context;
        IDataQueryService rootQuery = outbound.getRootQuery();
        List rawResponse = null;
        HashMap<String, CBESeverityCount> componentMap = new HashMap<String, CBESeverityCount>();
        if (rootQuery instanceof CBEQueryCapability) {
            CBEQueryCapability cbeQuery = (CBEQueryCapability)rootQuery;
            IDataQueryResult result = cbeQuery.getCBECountBySeverity(dataset);
            rawResponse = (List)result.getRawResponseCollection();
        }
        if (rawResponse == null) {
            return null;
        }
        for (Object rowObj : rawResponse) {
            int count;
            CBECountBySeverity row = (CBECountBySeverity)rowObj;
            String compName = row.getComponent();
            CBESeverityCount sc = (CBESeverityCount)componentMap.get(compName);
            if (sc == null) {
                sc = new CBESeverityCount(compName);
                componentMap.put(compName, sc);
            }
            if (row.getSeverity() >= 50) {
                count = sc.getSevereCount() + row.getCount();
                sc.setSevereCount(count);
                continue;
            }
            if (row.getSeverity() >= 30) {
                count = sc.getWarningCount() + row.getCount();
                sc.setWarningCount(count);
                continue;
            }
            count = sc.getInfoCount() + row.getCount();
            sc.setInfoCount(count);
        }
        return componentMap.values();
    }
}

