/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.internal.logging.core.internationalization.InternationalizationUtilities;
import org.eclipse.hyades.logging.core.SerializationException;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.FormattingException;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.internal.util.EventHandler;
import org.eclipse.hyades.logging.events.cbe.internal.util.EventListenerImpl;
import org.eclipse.hyades.logging.events.cbe.util.EventListener;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class EventFormatter {
    private static EventHandler eventHandler = null;
    private static XMLReader xmlParser = null;
    private static boolean isValidationSupported = true;
    private static final String COMMON_BASE_EVENT_SCHEMA_NAME = "commonbaseevent1_0_1.xsd";
    private static final String COMMON_BASE_EVENT_SCHEMA_LOCATION_URL = EventFormatter.resolveCommonBaseEventSchemaLocation();
    private static final Object LOCK = new Object();
    static /* synthetic */ Class class$0;

    public static String toCanonicalXMLDocString(AssociationEngine associationEngine) {
        return EventFormatter.toCanonicalXMLDocString(associationEngine, true);
    }

    public static String toCanonicalXMLDocString(AssociationEngine[] associationEngines) {
        return EventFormatter.toCanonicalXMLDocString(associationEngines, true);
    }

    public static String toCanonicalXMLDocString(AssociationEngine associationEngine, boolean format) {
        return EventFormatter.toCanonicalXMLDocString(new AssociationEngine[]{associationEngine}, format);
    }

    public static String toCanonicalXMLDocString(AssociationEngine[] associationEngines, boolean format) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (format) {
            buffer.append(Constants.LINE_SEPARATOR);
        }
        buffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        if (format) {
            buffer.append(Constants.LINE_SEPARATOR);
        }
        if (associationEngines != null) {
            int index = 0;
            while (index < associationEngines.length) {
                if (format) {
                    buffer.append("\t");
                }
                buffer.append(EventFormatter.toCanonicalXMLString(associationEngines[index]));
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                }
                ++index;
            }
        }
        buffer.append("</CommonBaseEvents>");
        return buffer.toString();
    }

    public static String toCanonicalXMLString(AssociationEngine associationEngine) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("<AssociationEngine");
        String attributeValue = associationEngine.getId();
        if (attributeValue != null) {
            buffer.append(" id=\"");
            buffer.append(attributeValue);
            buffer.append("\"");
        }
        if ((attributeValue = associationEngine.getName()) != null) {
            buffer.append(" name=\"");
            buffer.append(attributeValue);
            buffer.append("\"");
        }
        if ((attributeValue = associationEngine.getType()) != null) {
            buffer.append(" type=\"");
            buffer.append(attributeValue);
            buffer.append("\"");
        }
        buffer.append("/>");
        return buffer.toString();
    }

    public static AssociationEngine[] associationEnginesFromCanonicalXMLDoc(String xmlDocumentString) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(xmlDocumentString, false);
    }

    public static void associationEnginesFromCanonicalXMLDoc(String xmlDocumentString, EventListener eventListener) throws FormattingException {
        EventFormatter.associationEnginesFromCanonicalXMLDoc(xmlDocumentString, false, eventListener);
    }

    public static AssociationEngine[] associationEnginesFromCanonicalXMLDoc(String xmlDocumentString, boolean validate) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(new StringReader(xmlDocumentString)), validate);
    }

    public static void associationEnginesFromCanonicalXMLDoc(String xmlDocumentString, boolean validate, EventListener eventListener) throws FormattingException {
        EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(new StringReader(xmlDocumentString)), validate, eventListener);
    }

    public static AssociationEngine[] associationEnginesFromCanonicalXMLDoc(InputSource inputSource) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(inputSource, false);
    }

    public static void associationEnginesFromCanonicalXMLDoc(InputSource inputSource, EventListener eventListener) throws FormattingException {
        EventFormatter.associationEnginesFromCanonicalXMLDoc(inputSource, false, eventListener);
    }

    public static AssociationEngine[] associationEnginesFromCanonicalXMLDoc(InputSource inputSource, boolean validate) throws FormattingException {
        EventListenerImpl eventListener = new EventListenerImpl();
        EventFormatter.associationEnginesFromCanonicalXMLDoc(inputSource, validate, (EventListener)eventListener);
        return eventListener.getAssociationEngines();
    }

    public static void associationEnginesFromCanonicalXMLDoc(InputSource inputSource, boolean validate, EventListener eventListener) throws FormattingException {
        EventFormatter.parse(inputSource, validate, eventListener);
    }

    public static AssociationEngine[] associationEnginesFromCanonicalXMLDoc(InputStream inputStream) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(inputStream, false);
    }

    public static void associationEnginesFromCanonicalXMLDoc(InputStream inputStream, EventListener eventListener) throws FormattingException {
        EventFormatter.associationEnginesFromCanonicalXMLDoc(inputStream, false, eventListener);
    }

    public static AssociationEngine[] associationEnginesFromCanonicalXMLDoc(InputStream inputStream, boolean validate) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(inputStream), validate);
    }

    public static void associationEnginesFromCanonicalXMLDoc(InputStream inputStream, boolean validate, EventListener eventListener) throws FormattingException {
        EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(inputStream), validate, eventListener);
    }

    public static AssociationEngine[] associationEnginesFromCanonicalXMLDoc(Document document) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(document, false);
    }

    public static void associationEnginesFromCanonicalXMLDoc(Document document, EventListener eventListener) throws FormattingException {
        EventFormatter.associationEnginesFromCanonicalXMLDoc(document, false, eventListener);
    }

    public static AssociationEngine[] associationEnginesFromCanonicalXMLDoc(Document document, boolean validate) throws FormattingException {
        try {
            return EventFormatter.associationEnginesFromCanonicalXMLDoc(XmlUtility.serialize((Document)document), validate);
        }
        catch (SerializationException s) {
            throw new FormattingException((Exception)((Object)s));
        }
    }

    public static void associationEnginesFromCanonicalXMLDoc(Document document, boolean validate, EventListener eventListener) throws FormattingException {
        try {
            EventFormatter.associationEnginesFromCanonicalXMLDoc(XmlUtility.serialize((Document)document), validate, eventListener);
        }
        catch (SerializationException s) {
            throw new FormattingException((Exception)((Object)s));
        }
    }

    public static AssociationEngine[] associationEnginesFromCanonicalXMLDoc(File file) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(file, false);
    }

    public static void associationEnginesFromCanonicalXMLDoc(File file, EventListener eventListener) throws FormattingException {
        EventFormatter.associationEnginesFromCanonicalXMLDoc(file, false, eventListener);
    }

    public static AssociationEngine[] associationEnginesFromCanonicalXMLDoc(File file, boolean validate) throws FormattingException {
        try {
            return EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(new FileInputStream(file)), validate);
        }
        catch (FileNotFoundException f) {
            throw new FormattingException(f);
        }
    }

    public static void associationEnginesFromCanonicalXMLDoc(File file, boolean validate, EventListener eventListener) throws FormattingException {
        try {
            EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(new FileInputStream(file)), validate, eventListener);
        }
        catch (FileNotFoundException f) {
            throw new FormattingException(f);
        }
    }

    public static AssociationEngine associationEngineFromCanonicalXML(String xmlFragmentString) throws FormattingException {
        return EventFormatter.associationEngineFromCanonicalXML(xmlFragmentString, false);
    }

    public static AssociationEngine associationEngineFromCanonicalXML(String xmlFragmentString, boolean validate) throws FormattingException {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        buffer.append(xmlFragmentString);
        buffer.append("</CommonBaseEvents>");
        AssociationEngine[] engines = EventFormatter.associationEnginesFromCanonicalXMLDoc(buffer.toString(), validate);
        if (engines != null) {
            return engines[0];
        }
        return null;
    }

    public static String toCanonicalXMLDocString(CommonBaseEvent commonBaseEvent) {
        return EventFormatter.toCanonicalXMLDocString(commonBaseEvent, true);
    }

    public static String toCanonicalXMLDocString(CommonBaseEvent[] commonBaseEvents) {
        return EventFormatter.toCanonicalXMLDocString(commonBaseEvents, true);
    }

    public static String toCanonicalXMLDocString(CommonBaseEvent commonBaseEvent, boolean format) {
        return EventFormatter.toCanonicalXMLDocString(new CommonBaseEvent[]{commonBaseEvent}, format);
    }

    public static String toCanonicalXMLDocString(CommonBaseEvent[] commonBaseEvents, boolean format) {
        StringBuffer xmlDocument = new StringBuffer(1024);
        xmlDocument.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (format) {
            xmlDocument.append(Constants.LINE_SEPARATOR);
            xmlDocument.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
            xmlDocument.append(Constants.LINE_SEPARATOR);
        } else {
            xmlDocument.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        }
        StringBuffer commonBaseEventsBuffer = new StringBuffer(1024);
        if (commonBaseEvents != null) {
            int index = 0;
            while (index < commonBaseEvents.length) {
                int counter;
                EList associatedEvents = commonBaseEvents[index].getAssociatedEvents();
                if (associatedEvents.size() > 0) {
                    AssociationEngine associationEngine = null;
                    counter = 0;
                    while (counter < associatedEvents.size()) {
                        associationEngine = ((AssociatedEvent)associatedEvents.get(counter)).getAssociationEngineInfo();
                        if (associationEngine != null) {
                            if (format) {
                                xmlDocument.append("\t");
                                xmlDocument.append(EventFormatter.toCanonicalXMLString(associationEngine));
                                xmlDocument.append(Constants.LINE_SEPARATOR);
                            } else {
                                xmlDocument.append(EventFormatter.toCanonicalXMLString(associationEngine));
                            }
                        }
                        ++counter;
                    }
                }
                if (format) {
                    String[] tokens = InternationalizationUtilities.tokenize((String)EventFormatter.toCanonicalXMLString(commonBaseEvents[index], format), (String)Constants.LINE_SEPARATOR);
                    counter = 0;
                    while (counter < tokens.length) {
                        commonBaseEventsBuffer.append("\t");
                        commonBaseEventsBuffer.append(tokens[counter]);
                        commonBaseEventsBuffer.append(Constants.LINE_SEPARATOR);
                        ++counter;
                    }
                } else {
                    commonBaseEventsBuffer.append(EventFormatter.toCanonicalXMLString(commonBaseEvents[index], format));
                }
                ++index;
            }
        }
        xmlDocument.append(commonBaseEventsBuffer);
        xmlDocument.append("</CommonBaseEvents>");
        return xmlDocument.toString();
    }

    public static String toCanonicalXMLString(CommonBaseEvent commonBaseEvent) {
        return EventFormatter.toCanonicalXMLString(commonBaseEvent, true);
    }

    public static String toCanonicalXMLString(CommonBaseEvent commonBaseEvent, boolean format) {
        Situation situation;
        MsgDataElement msgDataElement;
        String attributeValue;
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("<CommonBaseEvent");
        if (commonBaseEvent.isSetCreationTime()) {
            buffer.append(" creationTime=\"");
            buffer.append(commonBaseEvent.getCreationTime());
            buffer.append("\"");
        }
        if ((attributeValue = commonBaseEvent.getExtensionName()) != null) {
            buffer.append(" extensionName=\"");
            buffer.append(attributeValue);
            buffer.append("\"");
        }
        if ((attributeValue = commonBaseEvent.getGlobalInstanceId()) != null) {
            buffer.append(" globalInstanceId=\"");
            buffer.append(attributeValue);
            buffer.append("\"");
        }
        if ((attributeValue = commonBaseEvent.getLocalInstanceId()) != null) {
            buffer.append(" localInstanceId=\"");
            buffer.append(XmlUtility.normalize((String)attributeValue));
            buffer.append("\"");
        }
        if ((attributeValue = commonBaseEvent.getMsg()) != null) {
            buffer.append(" msg=\"");
            buffer.append(XmlUtility.normalize((String)attributeValue));
            buffer.append("\"");
        }
        if (commonBaseEvent.isSetElapsedTime()) {
            buffer.append(" elapsedTime=\"");
            buffer.append(commonBaseEvent.getElapsedTime());
            buffer.append("\"");
        }
        if (commonBaseEvent.isSetPriority()) {
            buffer.append(" priority=\"");
            buffer.append(commonBaseEvent.getPriority());
            buffer.append("\"");
        }
        if (commonBaseEvent.isSetRepeatCount()) {
            buffer.append(" repeatCount=\"");
            buffer.append(commonBaseEvent.getRepeatCount());
            buffer.append("\"");
        }
        if (commonBaseEvent.isSetSequenceNumber()) {
            buffer.append(" sequenceNumber=\"");
            buffer.append(commonBaseEvent.getSequenceNumber());
            buffer.append("\"");
        }
        if (commonBaseEvent.isSetSeverity()) {
            buffer.append(" severity=\"");
            buffer.append(commonBaseEvent.getSeverity());
            buffer.append("\"");
        }
        if ((attributeValue = commonBaseEvent.getVersion()) != null) {
            buffer.append(" version=\"");
            buffer.append(XmlUtility.normalize((String)attributeValue));
            buffer.append("\"");
        }
        buffer.append(">");
        EList contextDataElements = commonBaseEvent.getContextDataElements();
        ContextDataElement contextDataElement = null;
        int i = 0;
        while (i < contextDataElements.size()) {
            contextDataElement = (ContextDataElement)contextDataElements.get(i);
            if (contextDataElement != null) {
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t");
                }
                buffer.append("<contextDataElements");
                attributeValue = contextDataElement.getName();
                if (attributeValue != null) {
                    buffer.append(" name=\"");
                    buffer.append(attributeValue);
                    buffer.append("\"");
                }
                if ((attributeValue = contextDataElement.getType()) != null) {
                    buffer.append(" type=\"");
                    buffer.append(attributeValue);
                    buffer.append("\"");
                }
                buffer.append(">");
                attributeValue = contextDataElement.getContextId();
                if (attributeValue != null) {
                    if (format) {
                        buffer.append(Constants.LINE_SEPARATOR);
                        buffer.append("\t\t");
                    }
                    buffer.append("<contextId>");
                    buffer.append(attributeValue);
                    buffer.append("</contextId>");
                } else {
                    attributeValue = contextDataElement.getContextValue();
                    if (attributeValue != null) {
                        if (format) {
                            buffer.append(Constants.LINE_SEPARATOR);
                            buffer.append("\t\t");
                        }
                        buffer.append("<contextValue>");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("</contextValue>");
                    }
                }
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t");
                }
                buffer.append("</contextDataElements>");
            }
            ++i;
        }
        EList extendedDataElements = commonBaseEvent.getExtendedDataElements();
        int i2 = 0;
        while (i2 < extendedDataElements.size()) {
            buffer.append(EventFormatter.getExtendedDataElementXML((ExtendedDataElement)extendedDataElements.get(i2), "extendedDataElements", format, format ? 1 : 0));
            ++i2;
        }
        EList associatedEvents = commonBaseEvent.getAssociatedEvents();
        AssociatedEvent associatedEvent = null;
        int i3 = 0;
        while (i3 < associatedEvents.size()) {
            associatedEvent = (AssociatedEvent)associatedEvents.get(i3);
            if (associatedEvent != null) {
                AssociationEngine associationEngineInfo;
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t");
                }
                buffer.append("<associatedEvents");
                String resolvedEvents = associatedEvent.getResolvedEvents();
                if (resolvedEvents != null) {
                    buffer.append(" resolvedEvents=\"");
                    buffer.append(resolvedEvents);
                    buffer.append("\"");
                }
                buffer.append(">");
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t\t");
                }
                if ((associationEngineInfo = associatedEvent.getAssociationEngineInfo()) != null) {
                    buffer.append("<associationEngineInfo");
                    buffer.append(EventFormatter.toCanonicalXMLString(associationEngineInfo).substring(18));
                } else {
                    attributeValue = associatedEvent.getAssociationEngine();
                    if (attributeValue != null) {
                        buffer.append("<associationEngine>");
                        buffer.append(attributeValue);
                        buffer.append("</associationEngine>");
                    }
                }
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t");
                }
                buffer.append("</associatedEvents>");
            }
            ++i3;
        }
        ComponentIdentification componentId = commonBaseEvent.getReporterComponentId();
        if (componentId != null) {
            if (format) {
                buffer.append(Constants.LINE_SEPARATOR);
                buffer.append("\t");
            }
            buffer.append("<reporterComponentId");
            attributeValue = componentId.getApplication();
            if (attributeValue != null) {
                buffer.append(" application=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getComponent()) != null) {
                buffer.append(" component=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getComponentIdType()) != null) {
                buffer.append(" componentIdType=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getExecutionEnvironment()) != null) {
                buffer.append(" executionEnvironment=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getInstanceId()) != null) {
                buffer.append(" instanceId=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getLocation()) != null) {
                buffer.append(" location=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getLocationType()) != null) {
                buffer.append(" locationType=\"");
                buffer.append(attributeValue);
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getProcessId()) != null) {
                buffer.append(" processId=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getSubComponent()) != null) {
                buffer.append(" subComponent=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getThreadId()) != null) {
                buffer.append(" threadId=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getComponentType()) != null) {
                buffer.append(" componentType=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            buffer.append("/>");
        }
        if ((componentId = commonBaseEvent.getSourceComponentId()) != null) {
            if (format) {
                buffer.append(Constants.LINE_SEPARATOR);
                buffer.append("\t");
            }
            buffer.append("<sourceComponentId");
            attributeValue = componentId.getApplication();
            if (attributeValue != null) {
                buffer.append(" application=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getComponent()) != null) {
                buffer.append(" component=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getComponentIdType()) != null) {
                buffer.append(" componentIdType=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getExecutionEnvironment()) != null) {
                buffer.append(" executionEnvironment=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getInstanceId()) != null) {
                buffer.append(" instanceId=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getLocation()) != null) {
                buffer.append(" location=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getLocationType()) != null) {
                buffer.append(" locationType=\"");
                buffer.append(attributeValue);
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getProcessId()) != null) {
                buffer.append(" processId=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getSubComponent()) != null) {
                buffer.append(" subComponent=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getThreadId()) != null) {
                buffer.append(" threadId=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            if ((attributeValue = componentId.getComponentType()) != null) {
                buffer.append(" componentType=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            buffer.append("/>");
        }
        if ((msgDataElement = commonBaseEvent.getMsgDataElement()) != null) {
            if (format) {
                buffer.append(Constants.LINE_SEPARATOR);
                buffer.append("\t");
            }
            buffer.append("<msgDataElement");
            attributeValue = msgDataElement.getMsgLocale();
            if (attributeValue != null) {
                buffer.append(" msgLocale=\"");
                buffer.append(attributeValue);
                buffer.append("\"");
            }
            buffer.append(">");
            EList tokens = msgDataElement.getMsgCatalogTokens();
            MsgCatalogToken msgCatalogToken = null;
            int i4 = 0;
            while (i4 < tokens.size()) {
                msgCatalogToken = (MsgCatalogToken)tokens.get(i4);
                if (msgCatalogToken != null && msgCatalogToken.getValue() != null) {
                    if (format) {
                        buffer.append(Constants.LINE_SEPARATOR);
                        buffer.append("\t\t");
                    }
                    buffer.append("<msgCatalogTokens value=\"");
                    buffer.append(XmlUtility.normalize((String)msgCatalogToken.getValue()));
                    buffer.append("\"/>");
                }
                ++i4;
            }
            attributeValue = msgDataElement.getMsgId();
            if (attributeValue != null) {
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t\t");
                }
                buffer.append("<msgId>");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("</msgId>");
            }
            if ((attributeValue = msgDataElement.getMsgIdType()) != null) {
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t\t");
                }
                buffer.append("<msgIdType>");
                buffer.append(attributeValue);
                buffer.append("</msgIdType>");
            }
            if ((attributeValue = msgDataElement.getMsgCatalogId()) != null) {
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t\t");
                }
                buffer.append("<msgCatalogId>");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("</msgCatalogId>");
            }
            if ((attributeValue = msgDataElement.getMsgCatalogType()) != null) {
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t\t");
                }
                buffer.append("<msgCatalogType>");
                buffer.append(attributeValue);
                buffer.append("</msgCatalogType>");
            }
            if ((attributeValue = msgDataElement.getMsgCatalog()) != null) {
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t\t");
                }
                buffer.append("<msgCatalog>");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("</msgCatalog>");
            }
            if (format) {
                buffer.append(Constants.LINE_SEPARATOR);
                buffer.append("\t");
            }
            buffer.append("</msgDataElement>");
        }
        if ((situation = commonBaseEvent.getSituation()) != null) {
            if (format) {
                buffer.append(Constants.LINE_SEPARATOR);
                buffer.append("\t");
            }
            buffer.append("<situation");
            attributeValue = situation.getCategoryName();
            if (attributeValue != null) {
                buffer.append(" categoryName=\"");
                buffer.append(XmlUtility.normalize((String)attributeValue));
                buffer.append("\"");
            }
            buffer.append(">");
            SituationType situationType = situation.getSituationType();
            if (situationType != null) {
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t\t");
                }
                buffer.append("<situationType xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                attributeValue = situationType.getReasoningScope();
                if (situationType instanceof StartSituation) {
                    buffer.append(" xsi:type=\"StartSituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((StartSituation)situationType).getSuccessDisposition()) != null) {
                        buffer.append(" successDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((StartSituation)situationType).getSituationQualifier()) != null) {
                        buffer.append(" situationQualifier=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof StopSituation) {
                    buffer.append(" xsi:type=\"StopSituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((StopSituation)situationType).getSuccessDisposition()) != null) {
                        buffer.append(" successDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((StopSituation)situationType).getSituationQualifier()) != null) {
                        buffer.append(" situationQualifier=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof ConnectSituation) {
                    buffer.append(" xsi:type=\"ConnectSituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((ConnectSituation)situationType).getSuccessDisposition()) != null) {
                        buffer.append(" successDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((ConnectSituation)situationType).getSituationDisposition()) != null) {
                        buffer.append(" situationDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof ReportSituation) {
                    buffer.append(" xsi:type=\"ReportSituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((ReportSituation)situationType).getReportCategory()) != null) {
                        buffer.append(" reportCategory=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof FeatureSituation) {
                    buffer.append(" xsi:type=\"FeatureSituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((FeatureSituation)situationType).getFeatureDisposition()) != null) {
                        buffer.append(" featureDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof ConfigureSituation) {
                    buffer.append(" xsi:type=\"ConfigureSituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((ConfigureSituation)situationType).getSuccessDisposition()) != null) {
                        buffer.append(" successDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof DependencySituation) {
                    buffer.append(" xsi:type=\"DependencySituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((DependencySituation)situationType).getDependencyDisposition()) != null) {
                        buffer.append(" dependencyDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof CreateSituation) {
                    buffer.append(" xsi:type=\"CreateSituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((CreateSituation)situationType).getSuccessDisposition()) != null) {
                        buffer.append(" successDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof DestroySituation) {
                    buffer.append(" xsi:type=\"DestroySituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((DestroySituation)situationType).getSuccessDisposition()) != null) {
                        buffer.append(" successDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof AvailableSituation) {
                    buffer.append(" xsi:type=\"AvailableSituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((AvailableSituation)situationType).getOperationDisposition()) != null) {
                        buffer.append(" operationDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((AvailableSituation)situationType).getProcessingDisposition()) != null) {
                        buffer.append(" processingDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((AvailableSituation)situationType).getAvailabilityDisposition()) != null) {
                        buffer.append(" availabilityDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof RequestSituation) {
                    buffer.append(" xsi:type=\"RequestSituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((RequestSituation)situationType).getSuccessDisposition()) != null) {
                        buffer.append(" successDisposition=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    if ((attributeValue = ((RequestSituation)situationType).getSituationQualifier()) != null) {
                        buffer.append(" situationQualifier=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append("/>");
                } else if (situationType instanceof OtherSituation) {
                    buffer.append(" xsi:type=\"OtherSituation\"");
                    if (attributeValue != null) {
                        buffer.append(" reasoningScope=\"");
                        buffer.append(XmlUtility.normalize((String)attributeValue));
                        buffer.append("\"");
                    }
                    buffer.append(">");
                    String anyData = ((OtherSituation)situationType).getAny();
                    if (anyData != null) {
                        if (format) {
                            buffer.append(Constants.LINE_SEPARATOR);
                            buffer.append("\t\t\t");
                        }
                        buffer.append(anyData);
                    }
                    if (format) {
                        buffer.append(Constants.LINE_SEPARATOR);
                        buffer.append("\t\t");
                    }
                    buffer.append("</situationType>");
                } else {
                    buffer.append("/>");
                }
            }
            if (format) {
                buffer.append(Constants.LINE_SEPARATOR);
                buffer.append("\t");
            }
            buffer.append("</situation>");
        }
        EList anyElements = commonBaseEvent.getAny();
        String anyElement = null;
        int counter = 0;
        while (counter < anyElements.size()) {
            anyElement = (String)anyElements.get(counter);
            if (anyElement != null) {
                if (format) {
                    buffer.append(Constants.LINE_SEPARATOR);
                    buffer.append("\t");
                }
                buffer.append(anyElement);
            }
            ++counter;
        }
        if (format) {
            buffer.append(Constants.LINE_SEPARATOR);
        }
        buffer.append("</CommonBaseEvent>");
        return buffer.toString();
    }

    public static CommonBaseEvent[] eventsFromCanonicalXMLDoc(String xmlDocumentString) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(xmlDocumentString, false);
    }

    public static void eventsFromCanonicalXMLDoc(String xmlDocumentString, EventListener eventListener) throws FormattingException {
        EventFormatter.eventsFromCanonicalXMLDoc(xmlDocumentString, false, eventListener);
    }

    public static CommonBaseEvent[] eventsFromCanonicalXMLDoc(String xmlDocumentString, boolean validate) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(new StringReader(xmlDocumentString)), validate);
    }

    public static void eventsFromCanonicalXMLDoc(String xmlDocumentString, boolean validate, EventListener eventListener) throws FormattingException {
        EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(new StringReader(xmlDocumentString)), validate, eventListener);
    }

    public static CommonBaseEvent[] eventsFromCanonicalXMLDoc(InputSource inputSource) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(inputSource, false);
    }

    public static void eventsFromCanonicalXMLDoc(InputSource inputSource, EventListener eventListener) throws FormattingException {
        EventFormatter.eventsFromCanonicalXMLDoc(inputSource, false, eventListener);
    }

    public static CommonBaseEvent[] eventsFromCanonicalXMLDoc(InputSource inputSource, boolean validate) throws FormattingException {
        EventListenerImpl eventListener = new EventListenerImpl();
        EventFormatter.eventsFromCanonicalXMLDoc(inputSource, validate, (EventListener)eventListener);
        return eventListener.getCommonBaseEvents();
    }

    public static void eventsFromCanonicalXMLDoc(InputSource inputSource, boolean validate, EventListener eventListener) throws FormattingException {
        EventFormatter.parse(inputSource, validate, eventListener);
    }

    public static CommonBaseEvent[] eventsFromCanonicalXMLDoc(InputStream inputStream) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(inputStream, false);
    }

    public static void eventsFromCanonicalXMLDoc(InputStream inputStream, EventListener eventListener) throws FormattingException {
        EventFormatter.eventsFromCanonicalXMLDoc(inputStream, false, eventListener);
    }

    public static CommonBaseEvent[] eventsFromCanonicalXMLDoc(InputStream inputStream, boolean validate) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(inputStream), validate);
    }

    public static void eventsFromCanonicalXMLDoc(InputStream inputStream, boolean validate, EventListener eventListener) throws FormattingException {
        EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(inputStream), validate, eventListener);
    }

    public static CommonBaseEvent[] eventsFromCanonicalXMLDoc(Document document) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(document, false);
    }

    public static void eventsFromCanonicalXMLDoc(Document document, EventListener eventListener) throws FormattingException {
        EventFormatter.eventsFromCanonicalXMLDoc(document, false, eventListener);
    }

    public static CommonBaseEvent[] eventsFromCanonicalXMLDoc(Document document, boolean validate) throws FormattingException {
        try {
            return EventFormatter.eventsFromCanonicalXMLDoc(XmlUtility.serialize((Document)document), validate);
        }
        catch (SerializationException s) {
            throw new FormattingException((Exception)((Object)s));
        }
    }

    public static void eventsFromCanonicalXMLDoc(Document document, boolean validate, EventListener eventListener) throws FormattingException {
        try {
            EventFormatter.eventsFromCanonicalXMLDoc(XmlUtility.serialize((Document)document), validate, eventListener);
        }
        catch (SerializationException s) {
            throw new FormattingException((Exception)((Object)s));
        }
    }

    public static CommonBaseEvent[] eventsFromCanonicalXMLDoc(File file) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(file, false);
    }

    public static void eventsFromCanonicalXMLDoc(File file, EventListener eventListener) throws FormattingException {
        EventFormatter.eventsFromCanonicalXMLDoc(file, false, eventListener);
    }

    public static CommonBaseEvent[] eventsFromCanonicalXMLDoc(File file, boolean validate) throws FormattingException {
        try {
            return EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(new FileInputStream(file)), validate);
        }
        catch (FileNotFoundException f) {
            throw new FormattingException(f);
        }
    }

    public static void eventsFromCanonicalXMLDoc(File file, boolean validate, EventListener eventListener) throws FormattingException {
        try {
            EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(new FileInputStream(file)), validate, eventListener);
        }
        catch (FileNotFoundException f) {
            throw new FormattingException(f);
        }
    }

    public static CommonBaseEvent eventFromCanonicalXML(String xmlFragmentString) throws FormattingException {
        return EventFormatter.eventFromCanonicalXML(xmlFragmentString, false);
    }

    public static CommonBaseEvent eventFromCanonicalXML(String xmlFragmentString, boolean validate) throws FormattingException {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        buffer.append(xmlFragmentString);
        buffer.append("</CommonBaseEvents>");
        CommonBaseEvent[] events = EventFormatter.eventsFromCanonicalXMLDoc(buffer.toString(), validate);
        if (events != null) {
            return events[0];
        }
        return null;
    }

    private static String getExtendedDataElementXML(ExtendedDataElement extendedDataElement, String tagName, boolean format, int indent) {
        if (extendedDataElement != null) {
            StringBuffer buffer = new StringBuffer(512);
            if (format) {
                buffer.append(Constants.LINE_SEPARATOR);
                int counter = 0;
                while (counter < indent) {
                    buffer.append("\t");
                    ++counter;
                }
            }
            buffer.append("<");
            if (tagName != null) {
                buffer.append(tagName);
            } else {
                buffer.append("extendedDataElements");
            }
            String attributeValue = extendedDataElement.getName();
            if (attributeValue != null) {
                buffer.append(" name=\"");
                buffer.append(attributeValue);
                buffer.append("\"");
            }
            if ((attributeValue = extendedDataElement.getType()) != null) {
                buffer.append(" type=\"");
                buffer.append(attributeValue);
                buffer.append("\"");
            }
            buffer.append(">");
            if (extendedDataElement.getTypeAsInt() == 19) {
                String hexValues = extendedDataElement.getHexValue();
                if (hexValues != null) {
                    if (format) {
                        buffer.append(Constants.LINE_SEPARATOR);
                        int counter = 0;
                        while (counter < indent + 1) {
                            buffer.append("\t");
                            ++counter;
                        }
                    }
                    buffer.append("<hexValue>");
                    buffer.append(hexValues);
                    buffer.append("</hexValue>");
                }
            } else {
                EList values = extendedDataElement.getValues();
                String valuesString = null;
                int counter = 0;
                while (counter < values.size()) {
                    valuesString = (String)values.get(counter);
                    if (valuesString != null) {
                        if (format) {
                            buffer.append(Constants.LINE_SEPARATOR);
                            int index = 0;
                            while (index < indent + 1) {
                                buffer.append("\t");
                                ++index;
                            }
                        }
                        buffer.append("<values>");
                        buffer.append(XmlUtility.normalize((String)valuesString));
                        buffer.append("</values>");
                    }
                    ++counter;
                }
            }
            EList childDataElements = extendedDataElement.getChildren();
            int counter = 0;
            while (counter < childDataElements.size()) {
                buffer.append(EventFormatter.getExtendedDataElementXML((ExtendedDataElement)childDataElements.get(counter), "children", format, format ? indent + 1 : 0));
                ++counter;
            }
            if (format) {
                buffer.append(Constants.LINE_SEPARATOR);
                counter = 0;
                while (counter < indent) {
                    buffer.append("\t");
                    ++counter;
                }
            }
            buffer.append("</");
            if (tagName != null) {
                buffer.append(tagName);
            } else {
                buffer.append("extendedDataElements");
            }
            buffer.append(">");
            return buffer.toString();
        }
        return "";
    }

    private static String resolveCommonBaseEventSchemaLocation() {
        URL url = null;
        try {
            url = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.hyades.logging.events.cbe.util.EventFormatter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz.getClassLoader().getResource(EventFormatter.COMMON_BASE_EVENT_SCHEMA_NAME);
                }
            });
        }
        catch (Throwable throwable) {}
        if (url == null) {
            try {
                url = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ClassLoader.getSystemClassLoader().getResource(EventFormatter.COMMON_BASE_EVENT_SCHEMA_NAME);
                    }
                });
            }
            catch (Throwable throwable) {}
            if (url == null) {
                try {
                    url = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return Thread.currentThread().getContextClassLoader().getResource(EventFormatter.COMMON_BASE_EVENT_SCHEMA_NAME);
                        }
                    });
                }
                catch (Throwable throwable) {}
            }
        }
        if (url != null) {
            return url.toExternalForm();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parse(InputSource inputSource, boolean validate, EventListener eventListener) throws FormattingException {
        Object object = LOCK;
        synchronized (object) {
            try {
                if (xmlParser == null) {
                    try {
                        xmlParser = XMLReaderFactory.createXMLReader();
                    }
                    catch (SAXException sAXException) {
                        xmlParser = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                    }
                    eventHandler = new EventHandler();
                    xmlParser.setContentHandler(eventHandler);
                    xmlParser.setErrorHandler(eventHandler);
                    try {
                        xmlParser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://www.ibm.com/AC/commonbaseevent1_0_1 ".concat(COMMON_BASE_EVENT_SCHEMA_LOCATION_URL));
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        xmlParser.setFeature("http://xml.org/sax/features/validation", false);
                        xmlParser.setFeature("http://xml.org/sax/features/namespaces", false);
                        isValidationSupported = false;
                    }
                } else {
                    eventHandler.init();
                }
                eventHandler.addEventListener(eventListener);
                if (isValidationSupported) {
                    xmlParser.setFeature("http://xml.org/sax/features/validation", validate);
                    xmlParser.setFeature("http://xml.org/sax/features/namespaces", validate);
                    try {
                        xmlParser.setFeature("http://apache.org/xml/features/validation/schema", validate);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                        xmlParser.setFeature("http://xml.org/sax/features/validation", false);
                        xmlParser.setFeature("http://xml.org/sax/features/namespaces", false);
                        isValidationSupported = false;
                    }
                }
                xmlParser.parse(inputSource);
            }
            catch (Exception e) {
                throw new FormattingException(e);
            }
        }
    }
}

