/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.datafeed.GanttEntry;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.GanttDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.IAxesDecorator;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class Gantt
extends AxesRenderer
implements IAxesDecorator {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        Fill fLineFill;
        int iThisSeriesIndex;
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        if (cwa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.gantt.dimension", new Object[]{cwa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        this.isTransposed();
        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), new Integer(this.iSeriesIndex + 1), new Integer(this.iSeriesCount)}, this.getRunTimeContext().getULocale()));
        GanttSeries gs = (GanttSeries)this.getSeries();
        if (!gs.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.series.visibility", new Object[]{gs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (!gs.isVisible()) {
            return;
        }
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        ScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        DataPointHints[] dpha = srh.getDataPoints();
        LineAttributes lia = LineAttributesImpl.copyInstance((LineAttributes)gs.getConnectionLine());
        LineAttributes outlinelia = gs.getOutline();
        int iLineWidth = lia.getThickness();
        Marker mStart = gs.getStartMarker();
        Marker mEnd = gs.getEndMarker();
        boolean bTransposed = this.isTransposed();
        float[] faX = new float[dpha.length];
        float[][] faY = new float[dpha.length][2];
        Location loStart = null;
        Location loEnd = null;
        Location[] loaLine = null;
        SeriesDefinition sd = this.getSeriesDefinition();
        EList elPalette = sd.getSeriesPalette().getEntries();
        int iPaletteSize = elPalette.size();
        if (iPaletteSize == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{gs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && gs.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)gs.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(gs)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{gs, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            fPaletteEntry = (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
            this.updateTranslucency(fPaletteEntry, (Series)gs);
        }
        if (gs.isPaletteLineColor()) {
            fLineFill = fPaletteEntry;
            if (fPaletteEntry instanceof ColorDefinition) {
                lia.setColor((ColorDefinition)fPaletteEntry);
            }
        } else {
            Fill outlineFill = gs.getOutlineFill();
            Object object = fLineFill = lia.getColor() == null ? outlineFill : lia.getColor();
            if (outlineFill instanceof ColorDefinition) {
                lia.setColor((ColorDefinition)outlineFill);
            }
        }
        this.renderClipping(ipr, this.getPlotBounds());
        AutoScale scale = this.getInternalOrthogonalAxis().getScale();
        int i = 0;
        while (i < dpha.length) {
            GanttEntry ge = (GanttEntry)dpha[i].getOrthogonalValue();
            if (this.isValidGanttEntry(ge)) {
                PolygonRenderEvent pre;
                if (this.checkEntryInRange(this.se, scale.getMinimum(), scale.getMaximum()) > 0) {
                    dpha[i].markOutside();
                }
                CDateTime geStart = ge.getStart();
                CDateTime geEnd = ge.getEnd();
                double dX = 0.0;
                double dY = 0.0;
                double dStart = 0.0;
                double dEnd = 0.0;
                Location lo = dpha[i].getLocation();
                dX = (int)lo.getX();
                dY = (int)lo.getY();
                if (srh.isCategoryScale()) {
                    double fSize = dpha[i].getSize();
                    if (bTransposed) {
                        dY += fSize / 2.0;
                    } else {
                        dX += fSize / 2.0;
                    }
                }
                if (geStart != null) {
                    dStart = srh.getLocationOnOrthogonal((Object)geStart);
                }
                dEnd = geEnd != null ? srh.getLocationOnOrthogonal((Object)geEnd) : dStart;
                if (geStart == null) {
                    dStart = dEnd;
                }
                if (loStart == null) {
                    loStart = LocationImpl.create((double)0.0, (double)0.0);
                    loEnd = LocationImpl.create((double)0.0, (double)0.0);
                }
                if (cwa.isTransposed()) {
                    loStart.set(dStart, dY);
                    loEnd.set(dEnd, dY);
                    faX[i] = (float)dY;
                    faY[i][0] = (float)dStart;
                    faY[i][1] = (float)dEnd;
                    loaLine = new Location[]{LocationImpl.create((double)dStart, (double)(dY + (double)iLineWidth / 2.0)), LocationImpl.create((double)dStart, (double)(dY - (double)iLineWidth / 2.0)), LocationImpl.create((double)dEnd, (double)(dY - (double)iLineWidth / 2.0)), LocationImpl.create((double)dEnd, (double)(dY + (double)iLineWidth / 2.0))};
                } else {
                    loStart.set(dX, dStart);
                    loEnd.set(dX, dEnd);
                    faX[i] = (float)dX;
                    faY[i][0] = (float)dStart;
                    faY[i][1] = (float)dEnd;
                    loaLine = new Location[]{LocationImpl.create((double)(dX + (double)iLineWidth / 2.0), (double)dStart), LocationImpl.create((double)(dX - (double)iLineWidth / 2.0), (double)dStart), LocationImpl.create((double)(dX - (double)iLineWidth / 2.0), (double)dEnd), LocationImpl.create((double)(dX + (double)iLineWidth / 2.0), (double)dEnd)};
                }
                fPaletteEntry = bPaletteByCategory ? (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(i % iPaletteSize))) : (Fill)EcoreUtil.copy((EObject)((Fill)elPalette.get(iThisSeriesIndex % iPaletteSize)));
                this.updateTranslucency(fPaletteEntry, (Series)gs);
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                if (lia.isVisible() && geStart != null && geEnd != null) {
                    if (bPaletteByCategory && gs.isPaletteLineColor()) {
                        fLineFill = fPaletteEntry;
                        if (fPaletteEntry instanceof ColorDefinition) {
                            lia.setColor((ColorDefinition)fPaletteEntry);
                        }
                    }
                    if (iLineWidth == 1 || lia.getStyle() != LineStyle.SOLID_LITERAL) {
                        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                        StructureSource structureSource = StructureSource.createSeries((Series)gs);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        LineRenderEvent lre = (LineRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                        lre.setLineAttributes(lia);
                        lre.setStart(loStart);
                        lre.setEnd(loEnd);
                        ipr.drawLine(lre);
                    } else {
                        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                        StructureSource structureSource = StructureSource.createSeries((Series)gs);
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        pre = (PolygonRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                        pre.setPoints(loaLine);
                        pre.setBackground(fLineFill);
                        ipr.fillPolygon(pre);
                    }
                }
                if (outlinelia.isVisible() && geStart != null && geEnd != null) {
                    EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                    StructureSource structureSource = StructureSource.createSeries((Series)gs);
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    pre = (PolygonRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                    pre.setPoints(loaLine);
                    pre.setOutline(outlinelia);
                    ipr.drawPolygon(pre);
                }
                if (geStart != null && mStart.isVisible() || dpha[i].isOutside()) {
                    Location loStartMarker = LocationImpl.copyInstance((Location)loStart);
                    Position mStartPosition = this.transposePosition(gs.getStartMarkerPosition());
                    switch (mStartPosition.getValue()) {
                        case 0: {
                            if (!bTransposed) break;
                            loStartMarker.set(loStart.getX(), loStart.getY() - (double)mStart.getSize());
                            break;
                        }
                        case 1: {
                            if (!bTransposed) break;
                            loStartMarker.set(loStart.getX(), loStart.getY() + (double)mStart.getSize());
                        }
                    }
                    Fill startFill = fPaletteEntry;
                    if (fPaletteEntry instanceof MultipleFill && ((MultipleFill)fPaletteEntry).getFills().size() > 0) {
                        startFill = (Fill)((MultipleFill)fPaletteEntry).getFills().get(0);
                    }
                    this.renderMarker(gs, ipr, mStart, loStartMarker, outlinelia, startFill, dpha[i], null, true, false);
                }
                if (geEnd != null && mEnd.isVisible() || dpha[i].isOutside()) {
                    Location loEndMarker = LocationImpl.copyInstance((Location)loEnd);
                    Position mEndPosition = this.transposePosition(gs.getEndMarkerPosition());
                    switch (mEndPosition.getValue()) {
                        case 0: {
                            if (!bTransposed) break;
                            loEndMarker.set(loEnd.getX(), loEnd.getY() - (double)mEnd.getSize());
                            break;
                        }
                        case 1: {
                            if (!bTransposed) break;
                            loEndMarker.set(loEnd.getX(), loEnd.getY() + (double)mEnd.getSize());
                        }
                    }
                    Fill endFill = fPaletteEntry;
                    if (fPaletteEntry instanceof MultipleFill && ((MultipleFill)fPaletteEntry).getFills().size() > 1) {
                        endFill = (Fill)((MultipleFill)fPaletteEntry).getFills().get(1);
                    }
                    this.renderMarker(gs, ipr, mEnd, loEndMarker, outlinelia, endFill, dpha[i], null, true, false);
                }
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
            }
            ++i;
        }
        Label laDataPoint = srh.getLabelAttributes((Series)gs);
        if (laDataPoint.isVisible()) {
            Position pDataPoint = srh.getLabelPosition((Series)gs);
            Location loDataPoint = LocationImpl.create((double)0.0, (double)0.0);
            boolean useDecorationLabel = gs.isUseDecorationLabelValue();
            double dLabelGap = Math.max(Math.max(mStart.isVisible() ? mStart.getSize() : 0, mEnd.isVisible() ? mEnd.getSize() : 0), (lia.isVisible() ? iLineWidth / 2 : 0) + (outlinelia.isVisible() ? outlinelia.getThickness() : 0));
            int i2 = 0;
            while (i2 < dpha.length) {
                GanttEntry ge = (GanttEntry)dpha[i2].getOrthogonalValue();
                if (this.isValidGanttEntry(ge) && !dpha[i2].isOutside()) {
                    if (useDecorationLabel) {
                        laDataPoint.getCaption().setValue(ge.getLabel());
                    } else {
                        laDataPoint.getCaption().setValue(dpha[i2].getDisplayValue());
                    }
                    switch (pDataPoint.getValue()) {
                        case 0: {
                            if (!cwa.isTransposed()) {
                                loDataPoint.set((double)faX[i2], (double)(faY[i2][1] - (float)mEnd.getSize() - (float)p.getVerticalSpacing()));
                                break;
                            }
                            loDataPoint.set((double)((faY[i2][0] + faY[i2][1]) / 2.0f), (double)faX[i2] - dLabelGap - (double)p.getVerticalSpacing());
                            break;
                        }
                        case 1: {
                            if (!cwa.isTransposed()) {
                                loDataPoint.set((double)faX[i2], (double)(faY[i2][0] + (float)mStart.getSize() + (float)p.getVerticalSpacing()));
                                break;
                            }
                            loDataPoint.set((double)((faY[i2][0] + faY[i2][1]) / 2.0f), (double)faX[i2] + dLabelGap + (double)p.getVerticalSpacing());
                            break;
                        }
                        case 2: {
                            if (!cwa.isTransposed()) {
                                loDataPoint.set((double)faX[i2] - dLabelGap - (double)p.getHorizontalSpacing(), (double)((faY[i2][0] + faY[i2][1]) / 2.0f));
                                break;
                            }
                            loDataPoint.set((double)faY[i2][0] - dLabelGap - (double)p.getHorizontalSpacing(), (double)faX[i2]);
                            break;
                        }
                        case 3: {
                            if (!cwa.isTransposed()) {
                                loDataPoint.set((double)faX[i2] + dLabelGap + (double)p.getHorizontalSpacing(), (double)((faY[i2][0] + faY[i2][1]) / 2.0f));
                                break;
                            }
                            loDataPoint.set((double)faY[i2][1] + dLabelGap + (double)p.getHorizontalSpacing(), (double)faX[i2]);
                            break;
                        }
                        case 4: {
                            if (!cwa.isTransposed()) {
                                loDataPoint.set((double)faX[i2], (double)((faY[i2][0] + faY[i2][1]) / 2.0f));
                                break;
                            }
                            loDataPoint.set((double)((faY[i2][0] + faY[i2][1]) / 2.0f), (double)faX[i2]);
                            break;
                        }
                        default: {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.gantt", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                    }
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dpha[i2], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)laDataPoint);
                    if (laDataPoint.isVisible()) {
                        this.renderLabel(StructureSource.createSeries((Series)gs), 2, laDataPoint, pDataPoint, loDataPoint, null);
                    }
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dpha[i2], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)laDataPoint);
                }
                ++i2;
            }
        }
        this.restoreClipping(ipr);
    }

    public final void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        Marker mEnd;
        Marker mStart;
        double height;
        double width;
        int markerSize;
        LineAttributes outlinelia;
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        GanttSeries gs = (GanttSeries)this.getSeries();
        EventObjectCache eventObjectCache = (EventObjectCache)ipr;
        StructureSource structureSource = StructureSource.createLegend((Legend)lg);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.RectangleRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
        rre.setBackground(ca.getBackground());
        rre.setOutline(lia);
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        LineAttributes liaMarker = gs.getConnectionLine();
        if (liaMarker.isVisible()) {
            EventObjectCache eventObjectCache2 = (EventObjectCache)ipr;
            StructureSource structureSource2 = StructureSource.createLegend((Legend)lg);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LineRenderEvent lre = (LineRenderEvent)eventObjectCache2.getEventObject((Object)structureSource2, (Class)clazz2);
            if (fPaletteEntry instanceof ColorDefinition && gs.isSetPaletteLineColor() && gs.isPaletteLineColor()) {
                liaMarker = (LineAttributes)EcoreUtil.copy((EObject)liaMarker);
                liaMarker.setColor((ColorDefinition)EcoreUtil.copy((EObject)fPaletteEntry));
            }
            lre.setLineAttributes(liaMarker);
            lre.setStart(LocationImpl.create((double)(bo.getLeft() + 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            lre.setEnd(LocationImpl.create((double)(bo.getLeft() + bo.getWidth() - 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            ipr.drawLine(lre);
        }
        if ((outlinelia = gs.getOutline()).isVisible()) {
            EventObjectCache eventObjectCache3 = (EventObjectCache)ipr;
            StructureSource structureSource3 = StructureSource.createSeries((Series)gs);
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache3.getEventObject((Object)structureSource3, (Class)clazz3);
            Location[] points = new Location[]{LocationImpl.create((double)(bo.getLeft() + 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0 + (double)(liaMarker.getThickness() / 2))), LocationImpl.create((double)(bo.getLeft() + bo.getWidth() - 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0 + (double)(liaMarker.getThickness() / 2))), LocationImpl.create((double)(bo.getLeft() + bo.getWidth() - 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0 - (double)(liaMarker.getThickness() / 2))), LocationImpl.create((double)(bo.getLeft() + 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0 - (double)(liaMarker.getThickness() / 2)))};
            pre.setPoints(points);
            pre.setOutline(outlinelia);
            ipr.drawPolygon(pre);
        }
        if ((markerSize = (int)((((width = bo.getWidth() / this.getDeviceScale()) > (height = bo.getHeight() / this.getDeviceScale()) ? height : width) - 2.0) / 2.0)) <= 0) {
            markerSize = 1;
        }
        if ((mStart = gs.getStartMarker()) != null && mStart.isVisible()) {
            Location loStartMarker = LocationImpl.create((double)(bo.getLeft() + 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0));
            Position mStartPosition = this.transposePosition(gs.getStartMarkerPosition());
            switch (mStartPosition.getValue()) {
                case 0: {
                    if (!this.isTransposed()) break;
                    loStartMarker.set(loStartMarker.getX(), loStartMarker.getY() - (double)markerSize);
                    break;
                }
                case 1: {
                    if (!this.isTransposed()) break;
                    loStartMarker.set(loStartMarker.getX(), loStartMarker.getY() + (double)markerSize);
                }
            }
            Fill startFill = fPaletteEntry;
            if (fPaletteEntry instanceof MultipleFill && ((MultipleFill)fPaletteEntry).getFills().size() > 0) {
                startFill = (Fill)((MultipleFill)fPaletteEntry).getFills().get(0);
            }
            this.renderMarker(lg, ipr, mStart, loStartMarker, gs.getOutline(), startFill, null, new Integer(markerSize), false, false);
        }
        if ((mEnd = gs.getEndMarker()) != null && mEnd.isVisible()) {
            Location loEndMarker = LocationImpl.create((double)(bo.getLeft() + bo.getWidth() - 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0));
            Position mEndPosition = this.transposePosition(gs.getEndMarkerPosition());
            switch (mEndPosition.getValue()) {
                case 0: {
                    if (!this.isTransposed()) break;
                    loEndMarker.set(loEndMarker.getX(), loEndMarker.getY() - (double)mEnd.getSize());
                    break;
                }
                case 1: {
                    if (!this.isTransposed()) break;
                    loEndMarker.set(loEndMarker.getX(), loEndMarker.getY() + (double)mEnd.getSize());
                }
            }
            Fill endFill = fPaletteEntry;
            if (fPaletteEntry instanceof MultipleFill && ((MultipleFill)fPaletteEntry).getFills().size() > 1) {
                endFill = (Fill)((MultipleFill)fPaletteEntry).getFills().get(1);
            }
            this.renderMarker(lg, ipr, mEnd, loEndMarker, gs.getOutline(), endFill, null, new Integer(markerSize), false, false);
        }
    }

    private Position transposePosition(Position p) {
        if (this.isTransposed()) {
            switch (p.getValue()) {
                case 0: {
                    return Position.RIGHT_LITERAL;
                }
                case 1: {
                    return Position.LEFT_LITERAL;
                }
                case 3: {
                    return Position.ABOVE_LITERAL;
                }
                case 2: {
                    return Position.BELOW_LITERAL;
                }
            }
        }
        return p;
    }

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }

    public double[] computeDecorationThickness(IDisplayServer xs, OneAxis ax) throws ChartException {
        GanttSeries gs = (GanttSeries)this.getSeries();
        Label la = gs.getDecorationLabel();
        if (la != null && la.isVisible()) {
            int iOrientation = ax.getOrientation();
            if (iOrientation == 1) {
                double dMaxW = 0.0;
                GanttDataSet gds = (GanttDataSet)gs.getDataSet();
                DataSetIterator dsi = new DataSetIterator((DataSet)gds);
                la = LabelImpl.copyInstance((Label)la);
                int pos = this.transposePosition(gs.getDecorationLabelPosition()).getValue();
                dsi.reset();
                String sValue = null;
                while (dsi.hasNext()) {
                    Object o = dsi.next();
                    if (o != null) {
                        sValue = ((GanttEntry)o).getLabel();
                    }
                    if (sValue == null || sValue.length() <= 0) continue;
                    la.getCaption().setValue(sValue);
                    double dW = Methods.computeWidth((IDisplayServer)xs, (Label)la);
                    if (!(dW > dMaxW)) continue;
                    dMaxW = dW;
                }
                if (pos == 2) {
                    return new double[]{dMaxW, 0.0};
                }
                return new double[]{0.0, dMaxW};
            }
            if (iOrientation == 0) {
                double dMaxH = 0.0;
                GanttDataSet gds = (GanttDataSet)gs.getDataSet();
                DataSetIterator dsi = new DataSetIterator((DataSet)gds);
                la = LabelImpl.copyInstance((Label)la);
                int pos = this.transposePosition(gs.getDecorationLabelPosition()).getValue();
                dsi.reset();
                String sValue = null;
                while (dsi.hasNext()) {
                    Object o = dsi.next();
                    if (o != null) {
                        sValue = ((GanttEntry)o).getLabel();
                    }
                    if ((sValue = ((GanttEntry)o).getLabel()) == null || sValue.length() <= 0) continue;
                    la.getCaption().setValue(sValue);
                    double dH = Methods.computeHeight((IDisplayServer)xs, (Label)la);
                    if (!(dH > dMaxH)) continue;
                    dMaxH = dH;
                }
                if (pos == 1) {
                    return new double[]{0.0, dMaxH};
                }
                return new double[]{dMaxH, 0.0};
            }
        }
        return new double[]{0.0, 0.0};
    }

    public IAxesDecorator getAxesDecorator(OneAxis ax) {
        GanttSeries gs;
        Label la;
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        Axis baseAxis = cwa.getPrimaryBaseAxes()[0];
        if (ax.getModelAxis() == baseAxis && (la = (gs = (GanttSeries)this.getSeries()).getDecorationLabel()) != null && la.isVisible()) {
            return this;
        }
        return null;
    }

    public void decorateAxes(IPrimitiveRenderer ipr, ISeriesRenderingHints isrh, OneAxis ax) throws ChartException {
        GanttSeries gs = (GanttSeries)this.getSeries();
        Label la = gs.getDecorationLabel();
        if (la == null || !la.isVisible()) {
            return;
        }
        AutoScale as = ax.getScale();
        DataPointHints[] dpha = isrh.getDataPoints();
        AxisTickCoordinates tickCoords = as.getTickCordinates();
        String[] lba = new String[tickCoords.size() - 1];
        boolean bTransposed = this.isTransposed();
        int i = 0;
        while (i < dpha.length) {
            GanttEntry ge;
            Location loc = dpha[i].getLocation();
            double dv = bTransposed ? loc.getY() : loc.getX();
            int idx = this.getTickSlot(0, tickCoords, dv);
            if (idx >= 0 && idx < lba.length && lba[idx] == null && this.isValidGanttEntry(ge = (GanttEntry)dpha[i].getOrthogonalValue())) {
                lba[idx] = ge.getLabel();
            }
            ++i;
        }
        int pos = this.transposePosition(gs.getDecorationLabelPosition()).getValue();
        int iOrientation = ax.getOrientation();
        pos = iOrientation == 1 ? (pos == 2 ? 1 : 2) : (pos == 1 ? 4 : 3);
        la = LabelImpl.copyInstance((Label)la);
        Location loLabel = LocationImpl.create((double)0.0, (double)0.0);
        double axisCoord = ax.getAxisCoordinate();
        int iMajorTickStyle = ax.getGrid().getTickStyle(0);
        double dXTick1 = (iMajorTickStyle & 1) == 1 ? axisCoord - 5.0 - 1.0 : axisCoord - 1.0;
        double dXTick2 = (iMajorTickStyle & 2) == 2 ? axisCoord + 5.0 + 1.0 : axisCoord + 1.0;
        int i2 = 0;
        while (i2 < tickCoords.size() - 1) {
            if (lba[i2] != null) {
                la.getCaption().setValue(lba[i2]);
                if (iOrientation == 1) {
                    if (pos == 1) {
                        loLabel.setX(dXTick1);
                    } else {
                        loLabel.setX(dXTick2);
                    }
                    loLabel.setY(tickCoords.getCoordinate(i2) + tickCoords.getStep() / 2.0);
                } else {
                    loLabel.setX(tickCoords.getCoordinate(i2) + tickCoords.getStep() / 2.0);
                    if (pos == 3) {
                        loLabel.setY(dXTick1);
                    } else {
                        loLabel.setY(dXTick2);
                    }
                }
                EventObjectCache eventObjectCache = (EventObjectCache)ipr;
                StructureSource structureSource = StructureSource.createSeries((Series)gs);
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.birt.chart.event.TextRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                TextRenderEvent tre = (TextRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                tre.setTextPosition(pos);
                tre.setLocation(loLabel);
                tre.setLabel(la);
                tre.setAction(2);
                ipr.drawText(tre);
            }
            ++i2;
        }
    }

    private int getTickSlot(int startIndex, AxisTickCoordinates tickValues, double value) {
        int i = startIndex;
        while (i < tickValues.size() - 1) {
            if (ChartUtil.mathGE((double)value, (double)tickValues.getCoordinate(i)) && ChartUtil.mathLT((double)value, (double)tickValues.getCoordinate(i + 1)) || ChartUtil.mathLE((double)value, (double)tickValues.getCoordinate(i)) && ChartUtil.mathGT((double)value, (double)tickValues.getCoordinate(i + 1))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isValidGanttEntry(GanttEntry entry) {
        return entry != null && (entry.getStart() != null || entry.getEnd() != null);
    }

    protected int checkEntryInRange(Object entry, Object min, Object max) {
        if (entry instanceof GanttEntry) {
            GanttEntry ge = (GanttEntry)entry;
            if (ge.getStart().before((Object)Methods.asDateTime((Object)min))) {
                return 1;
            }
            if (ge.getEnd().after((Object)Methods.asDateTime((Object)max))) {
                return 2;
            }
            return 0;
        }
        return super.checkEntryInRange(entry, min, max);
    }
}

