/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.AreaRenderEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.GradientImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.render.Pie;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class PieRenderer {
    static final int UNKNOWN = 0;
    private static final int LOWER = 1;
    private static final int UPPER = 2;
    private static final double LEADER_TICK_MIN_SIZE = 10.0;
    private static final int LESS = -1;
    private static final int MORE = 1;
    private static final int EQUAL = 0;
    private static final double LENGTH_HINTS = 250.0;
    private final Position lpDataPoint;
    private final Position lpSeriesTitle;
    private transient double dLeaderLength;
    private final LeaderLineStyle lls;
    private transient double dThickness;
    private transient double dExplosion = 0.0;
    private transient String sExplosionExpression = null;
    private final Pie pie;
    private final PieSeries ps;
    private final ArrayList pieSliceList = new ArrayList();
    private final ArrayList alPlanes = new ArrayList();
    private final Palette pa;
    private Label laDataPoint;
    private final Label laSeriesTitle;
    private final LineAttributes liaLL;
    private final LineAttributes liaEdges;
    private transient IDisplayServer xs = null;
    private transient IDeviceRenderer idr = null;
    private transient Bounds boTitleContainer = null;
    private transient Insets insCA = null;
    private transient Bounds boSetDuringComputation = null;
    private final boolean bPaletteByCategory;
    private transient boolean bBoundsAdjustedForInsets = false;
    private transient boolean bMinSliceDefined = false;
    private transient double dMinSlice = 0.0;
    private transient double dAbsoluteMinSlice = 0.0;
    private transient boolean bPercentageMinSlice = false;
    private transient boolean bMinSliceApplied = false;
    private transient int orginalSliceCount = 0;
    private transient double ratio = 0.0;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    PieRenderer(ChartWithoutAxes cwoa, Pie pie, DataPointHints[] dpha, double[] da, Palette pa) throws ChartException {
        this.pa = pa;
        this.pie = pie;
        this.ps = (PieSeries)pie.getSeries();
        this.sExplosionExpression = this.ps.getExplosionExpression();
        this.dExplosion = (double)(this.ps.isSetExplosion() ? this.ps.getExplosion() : 0) * pie.getDeviceScale();
        this.dThickness = (cwoa.getDimension() == ChartDimension.TWO_DIMENSIONAL_LITERAL ? 0.0 : cwoa.getSeriesThickness()) * pie.getDeviceScale();
        this.ratio = this.ps.isSetRatio() ? this.ps.getRatio() : 1.0;
        this.liaLL = this.ps.getLeaderLineAttributes();
        this.dLeaderLength = this.ps.getLeaderLineAttributes().isVisible() ? this.ps.getLeaderLineLength() * pie.getDeviceScale() : 0.0;
        this.liaEdges = LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
        this.bPaletteByCategory = cwoa.getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL;
        this.lpDataPoint = this.ps.getLabelPosition();
        this.lpSeriesTitle = this.ps.getTitlePosition();
        this.laSeriesTitle = LabelImpl.copyInstance((Label)this.ps.getTitle());
        this.laSeriesTitle.getCaption().setValue(pie.getRunTimeContext().externalizedMessage(String.valueOf(this.ps.getSeriesIdentifier())));
        this.laSeriesTitle.getCaption().getFont().setAlignment(pie.switchTextAlignment(this.laSeriesTitle.getCaption().getFont().getAlignment()));
        this.laDataPoint = LabelImpl.copyInstance((Label)this.ps.getLabel());
        this.lls = this.ps.getLeaderLineStyle();
        this.bMinSliceDefined = cwoa.isSetMinSlice();
        this.dMinSlice = cwoa.getMinSlice();
        this.bPercentageMinSlice = cwoa.isMinSlicePercent();
        double dTotal = 0.0;
        this.orginalSliceCount = da.length;
        int i = 0;
        while (i < da.length) {
            if (da[i] < 0.0) {
                dTotal -= da[i];
            } else if (!Double.isNaN(da[i])) {
                dTotal += da[i];
            }
            ++i;
        }
        if (this.bMinSliceDefined) {
            this.dAbsoluteMinSlice = this.bPercentageMinSlice ? this.dMinSlice * dTotal / 100.0 : this.dMinSlice;
            double residualPos = 0.0;
            double residualNeg = 0.0;
            DataPointHints dphPos = null;
            DataPointHints dphNeg = null;
            int i2 = 0;
            while (i2 < da.length) {
                if (!Double.isNaN(da[i2])) {
                    if (Math.abs(da[i2]) >= Math.abs(this.dAbsoluteMinSlice)) {
                        this.pieSliceList.add(new PieSlice(da[i2], dpha[i2], i2));
                    } else if (da[i2] >= 0.0) {
                        residualPos += da[i2];
                        if (dphPos == null) {
                            dphPos = dpha[i2].getCopy();
                        } else {
                            dphPos.accumulate(dpha[i2].getBaseValue(), dpha[i2].getOrthogonalValue(), dpha[i2].getSeriesValue(), dpha[i2].getPercentileOrthogonalValue());
                        }
                    } else {
                        residualNeg += da[i2];
                        if (dphNeg == null) {
                            dphNeg = dpha[i2].getCopy();
                        } else {
                            dphNeg.accumulate(dpha[i2].getBaseValue(), dpha[i2].getOrthogonalValue(), dpha[i2].getSeriesValue(), dpha[i2].getPercentileOrthogonalValue());
                        }
                    }
                }
                ++i2;
            }
            if (dphPos != null) {
                dphPos.setBaseValue((Object)cwoa.getMinSliceLabel());
                dphPos.setIndex(this.orginalSliceCount);
                this.pieSliceList.add(new PieSlice(residualPos, dphPos, this.orginalSliceCount));
                this.bMinSliceApplied = true;
            }
            if (dphNeg != null) {
                dphNeg.setBaseValue((Object)cwoa.getMinSliceLabel());
                dphNeg.setIndex(this.orginalSliceCount);
                this.pieSliceList.add(new PieSlice(residualNeg, dphNeg, this.orginalSliceCount));
                this.bMinSliceApplied = true;
            }
        } else {
            i = 0;
            while (i < da.length) {
                if (!Double.isNaN(da[i])) {
                    this.pieSliceList.add(new PieSlice(da[i], dpha[i], i));
                }
                ++i;
            }
        }
        double startAngle = 0.0;
        if (dTotal == 0.0) {
            dTotal = 1.0;
        }
        PieSlice slice = null;
        Iterator iter = this.pieSliceList.iterator();
        while (iter.hasNext()) {
            slice = (PieSlice)iter.next();
            double length = Math.abs(slice.getPrimitiveValue()) / dTotal * 360.0;
            double percentage = slice.getPrimitiveValue() / dTotal * 100.0;
            slice.setStartAngle(startAngle);
            slice.setSliceLength(length);
            slice.setPercentage(percentage);
            startAngle += length;
        }
        if (startAngle > 0.0 && 360.0 - startAngle > 0.001) {
            slice.setSliceLength(360.0 - slice.getStartAngle());
        }
        this.initExploded();
    }

    private final void renderDataPoints(IDeviceRenderer idr) throws ChartException {
        if (!this.laDataPoint.isVisible()) {
            return;
        }
        ScriptHandler sh = this.pie.getRunTimeContext().getScriptHandler();
        if (this.lpDataPoint.getValue() == 5) {
            PieSlice slice;
            Iterator iter;
            if (this.laDataPoint.getShadowColor() != null) {
                iter = this.pieSliceList.iterator();
                while (iter.hasNext()) {
                    slice = (PieSlice)iter.next();
                    slice.renderLabel(idr, 1);
                }
            }
            iter = this.pieSliceList.iterator();
            while (iter.hasNext()) {
                slice = (PieSlice)iter.next();
                this.laDataPoint = LabelImpl.copyInstance((Label)this.ps.getLabel());
                this.laDataPoint.getCaption().setValue(slice.getDisplayValue());
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)slice.getDataPointHints(), (Object)this.laDataPoint, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)this.laDataPoint);
                if (this.laDataPoint.isVisible()) {
                    slice.renderLabel(idr, 2);
                }
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)slice.getDataPointHints(), (Object)this.laDataPoint, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)this.laDataPoint);
            }
        } else {
            Iterator iter = this.pieSliceList.iterator();
            while (iter.hasNext()) {
                PieSlice slice = (PieSlice)iter.next();
                this.laDataPoint = LabelImpl.copyInstance((Label)this.ps.getLabel());
                this.laDataPoint.getCaption().setValue(slice.getDisplayValue());
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)slice.getDataPointHints(), (Object)this.laDataPoint, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)this.laDataPoint);
                slice.renderLabel(idr, 3);
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)slice.getDataPointHints(), (Object)this.laDataPoint, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)this.laDataPoint);
            }
        }
    }

    private final void computeLabelBounds(Bounds bo, boolean isOutside) throws IllegalArgumentException {
        PieSlice slice;
        Iterator iter = this.pieSliceList.iterator();
        while (iter.hasNext()) {
            slice = (PieSlice)iter.next();
            slice.setBounds(bo);
            if (isOutside) {
                slice.computeLabelBoundOutside(this.lls, this.dLeaderLength);
                continue;
            }
            slice.computeLabelBoundInside();
        }
        if (isOutside) {
            iter = this.getOverlapSliceList().iterator();
            while (iter.hasNext()) {
                slice = (PieSlice)iter.next();
                this.resolveOverlap(slice, this.lls, this.dLeaderLength);
            }
        }
    }

    private int getOverlapCount(PieSlice pieSlice) {
        int count = 0;
        if (pieSlice.getLabelBounding() != null) {
            Iterator iter = this.pieSliceList.iterator();
            while (iter.hasNext()) {
                PieSlice slice = (PieSlice)iter.next();
                if (!pieSlice.isLabelOverlap(slice)) continue;
                ++count;
            }
        }
        return count;
    }

    private List getOverlapSliceList() {
        ArrayList<PieSlice> list = new ArrayList<PieSlice>();
        int i = 0;
        while (i < this.pieSliceList.size()) {
            PieSlice slice = (PieSlice)this.pieSliceList.get(i);
            int j = i + 1;
            while (j < this.pieSliceList.size()) {
                if (slice.isLabelOverlap((PieSlice)this.pieSliceList.get(j))) {
                    list.add(slice);
                }
                ++j;
            }
            ++i;
        }
        if (!list.isEmpty()) {
            Collections.sort(list, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    PieSlice slice0 = (PieSlice)arg0;
                    PieSlice slice1 = (PieSlice)arg1;
                    return (PieRenderer.this.getOverlapCount(slice0) - PieRenderer.this.getOverlapCount(slice1)) * 1000 + (int)(slice1.getdMidAngle() - slice0.getdMidAngle());
                }
            });
        }
        return list;
    }

    private boolean isOverlap(PieSlice pieSlice) {
        if (pieSlice.getLabelBounding() != null) {
            Iterator iter = this.pieSliceList.iterator();
            while (iter.hasNext()) {
                PieSlice slice = (PieSlice)iter.next();
                if (!pieSlice.isLabelOverlap(slice)) continue;
                return true;
            }
        }
        return false;
    }

    private void resolveOverlap(PieSlice slice, LeaderLineStyle lls, double dLeaderLength) {
        if (!this.isOverlap(slice)) {
            return;
        }
        PieSlice clonedSlice = (PieSlice)slice.clone();
        if (lls == LeaderLineStyle.STRETCH_TO_SIDE_LITERAL) {
            dLeaderLength = 100.0;
            slice.computeLabelBoundOutside(LeaderLineStyle.FIXED_LENGTH_LITERAL, dLeaderLength);
            if (!this.isOverlap(slice)) {
                return;
            }
        }
        double maxOffset = Math.min(dLeaderLength, 250.0 - dLeaderLength);
        double offset = 1.0;
        while (offset <= maxOffset) {
            int i = -1;
            while (i <= 1) {
                double dLength = dLeaderLength + (double)i * offset;
                slice.computeLabelBoundOutside(LeaderLineStyle.FIXED_LENGTH_LITERAL, dLength);
                if (!this.isOverlap(slice)) {
                    return;
                }
                i += 2;
            }
            offset += 1.0;
        }
        if (LeaderLineStyle.FIXED_LENGTH_LITERAL.equals(lls)) {
            slice.computeLabelBoundOutside(LeaderLineStyle.STRETCH_TO_SIDE_LITERAL, dLeaderLength);
            if (!this.isOverlap(slice)) {
                return;
            }
        }
        double dStart = 0.0;
        double dEnd = 250.0;
        if (dLeaderLength > 125.0) {
            dEnd = dLeaderLength - maxOffset;
        } else {
            dStart = dLeaderLength + maxOffset;
        }
        double l = dStart;
        while (l <= dEnd) {
            slice.computeLabelBoundOutside(LeaderLineStyle.FIXED_LENGTH_LITERAL, l);
            if (!this.isOverlap(slice)) {
                return;
            }
            l += 1.0;
        }
        clonedSlice.copyTo(slice);
    }

    private final Insets adjust(Bounds bo, Bounds boAdjusted, Insets ins) throws IllegalArgumentException {
        this.computeLabelBounds(boAdjusted, true);
        ins.set(0.0, 0.0, 0.0, 0.0);
        double dDelta = 0.0;
        Iterator iter = this.pieSliceList.iterator();
        while (iter.hasNext()) {
            PieSlice slice = (PieSlice)iter.next();
            BoundingBox bb = slice.getLabelBounding();
            if (bb.getLeft() < bo.getLeft()) {
                dDelta = bo.getLeft() - bb.getLeft();
                if (ins.getLeft() < dDelta) {
                    ins.setLeft(dDelta);
                }
            }
            if (bb.getTop() < bo.getTop()) {
                dDelta = bo.getTop() - bb.getTop();
                if (ins.getTop() < dDelta) {
                    ins.setTop(dDelta);
                }
            }
            if (bb.getLeft() + bb.getWidth() > bo.getLeft() + bo.getWidth()) {
                dDelta = bb.getLeft() + bb.getWidth() - bo.getLeft() - bo.getWidth();
                if (ins.getRight() < dDelta) {
                    ins.setRight(dDelta);
                }
            }
            if (!(bb.getTop() + bb.getHeight() > bo.getTop() + bo.getHeight())) continue;
            dDelta = bb.getTop() + bb.getHeight() - bo.getTop() - bo.getHeight();
            if (!(ins.getBottom() < dDelta)) continue;
            ins.setBottom(dDelta);
        }
        return ins;
    }

    final void computeInsets(Bounds bo) throws ChartException, IllegalArgumentException {
        this.boSetDuringComputation = BoundsImpl.copyInstance((Bounds)bo);
        this.xs = this.pie.getXServer();
        this.boTitleContainer = null;
        if (this.laSeriesTitle.isVisible()) {
            if (this.lpSeriesTitle == null) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 13, "exception.unspecified.visible.series.title", Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()));
            }
            BoundingBox bb = Methods.computeBox((IDisplayServer)this.xs, (int)4, (Label)this.laSeriesTitle, (double)0.0, (double)0.0);
            this.boTitleContainer = BoundsImpl.create((double)0.0, (double)0.0, (double)0.0, (double)0.0);
            switch (this.lpSeriesTitle.getValue()) {
                case 1: {
                    bo.setHeight(bo.getHeight() - bb.getHeight());
                    this.boTitleContainer.set(bo.getLeft(), bo.getTop() + bo.getHeight(), bo.getWidth(), bb.getHeight());
                    break;
                }
                case 0: {
                    this.boTitleContainer.set(bo.getLeft(), bo.getTop(), bo.getWidth(), bb.getHeight());
                    bo.setTop(bo.getTop() + bb.getHeight());
                    bo.setHeight(bo.getHeight() - bb.getHeight());
                    break;
                }
                case 2: {
                    bo.setWidth(bo.getWidth() - bb.getWidth());
                    this.boTitleContainer.set(bo.getLeft(), bo.getTop(), bb.getWidth(), bo.getHeight());
                    bo.setLeft(bo.getLeft() + bb.getWidth());
                    break;
                }
                case 3: {
                    bo.setWidth(bo.getWidth() - bb.getWidth());
                    this.boTitleContainer.set(bo.getLeft() + bo.getWidth(), bo.getTop(), bb.getWidth(), bo.getHeight());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()).getString("exception.illegal.pie.series.title.position"), this.lpSeriesTitle));
                }
            }
        }
        if (!this.laDataPoint.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 13, "exception.unspecified.datapoint.visibility.pie", new Object[]{this.ps}, Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()));
        }
        if (this.lpDataPoint == Position.OUTSIDE_LITERAL) {
            if (this.laDataPoint.isVisible()) {
                Bounds boAdjusted = BoundsImpl.copyInstance((Bounds)bo);
                Insets insTrim = InsetsImpl.create((double)0.0, (double)0.0, (double)0.0, (double)0.0);
                do {
                    this.adjust(bo, boAdjusted, insTrim);
                    boAdjusted.adjust(insTrim);
                } while (!insTrim.areLessThan(0.5) && boAdjusted.getWidth() > 0.0 && boAdjusted.getHeight() > 0.0);
                bo = boAdjusted;
            }
        } else if (this.lpDataPoint == Position.INSIDE_LITERAL) {
            if (this.laDataPoint.isVisible()) {
                this.computeLabelBounds(bo, false);
            }
        } else {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()).getString("exception.invalid.datapoint.position.pie"), this.lpDataPoint));
        }
        this.insCA = InsetsImpl.create((double)(bo.getTop() - this.boSetDuringComputation.getTop()), (double)(bo.getLeft() - this.boSetDuringComputation.getLeft()), (double)(this.boSetDuringComputation.getTop() + this.boSetDuringComputation.getHeight() - (bo.getTop() + bo.getHeight())), (double)(this.boSetDuringComputation.getLeft() + this.boSetDuringComputation.getWidth() - (bo.getLeft() + bo.getWidth())));
        this.bBoundsAdjustedForInsets = false;
    }

    final Insets getFittingInsets() {
        return this.insCA;
    }

    final void setFittingInsets(Insets insCA) throws IllegalArgumentException {
        this.insCA = insCA;
        if (!this.bBoundsAdjustedForInsets) {
            this.bBoundsAdjustedForInsets = true;
            this.boSetDuringComputation.adjust(insCA);
        }
        if (this.lpDataPoint == Position.OUTSIDE_LITERAL) {
            if (this.laDataPoint.isVisible()) {
                this.computeLabelBounds(this.boSetDuringComputation, true);
            }
        } else if (this.lpDataPoint == Position.INSIDE_LITERAL && this.laDataPoint.isVisible()) {
            this.computeLabelBounds(this.boSetDuringComputation, false);
        }
    }

    public final void render(IDeviceRenderer idr, Bounds bo) throws ChartException {
        bo.adjust(this.insCA);
        this.xs = idr.getDisplayServer();
        this.idr = idr;
        if (!this.laSeriesTitle.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.unspecified.pie.series.title.visibility", new Object[]{this.ps}, Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()));
        }
        ScriptHandler sh = this.pie.getRunTimeContext().getScriptHandler();
        double w = bo.getWidth() / 2.0 - this.dExplosion;
        double h = bo.getHeight() / 2.0 - this.dExplosion - this.dThickness / 2.0;
        double xc = bo.getLeft() + bo.getWidth() / 2.0;
        double yc = bo.getTop() + bo.getHeight() / 2.0;
        if (this.ratio > 0.0 && w > 0.0) {
            if (h / w > this.ratio) {
                h = w * this.ratio;
            } else if (h / w < this.ratio) {
                w = h / this.ratio;
            }
        }
        if (w > 0.0 && h > 0.0) {
            Fill fPaletteEntry;
            PieSlice slice;
            Iterator iter;
            if (this.dThickness > 0.0) {
                iter = this.pieSliceList.iterator();
                while (iter.hasNext()) {
                    slice = (PieSlice)iter.next();
                    fPaletteEntry = null;
                    fPaletteEntry = this.bPaletteByCategory ? (this.bMinSliceApplied && this.pieSliceList.indexOf(slice) == this.pieSliceList.size() - 1 ? this.getPaletteColor(this.orginalSliceCount) : this.getPaletteColor(slice.getCategoryIndex())) : this.getPaletteColor(this.pie.getSeriesDefinition().getRunTimeSeries().indexOf(this.ps));
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawElement", (Object)slice.getDataPointHints(), (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)slice.getDataPointHints(), (Object)fPaletteEntry, (Object)this.pie.getRunTimeContext().getScriptContext());
                    this.pie.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)slice.getDataPointHints());
                    this.pie.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)slice.getDataPointHints());
                    slice.render(LocationImpl.create((double)xc, (double)yc), LocationImpl.create((double)0.0, (double)this.dThickness), SizeImpl.create((double)w, (double)h), fPaletteEntry, 1);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawElement", (Object)slice.getDataPointHints(), (Object)fPaletteEntry);
                    ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)slice.getDataPointHints(), (Object)fPaletteEntry, (Object)this.pie.getRunTimeContext().getScriptContext());
                    this.pie.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)slice.getDataPointHints());
                    this.pie.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)slice.getDataPointHints());
                }
                this.sortAndRenderPlanes();
            }
            iter = this.pieSliceList.iterator();
            while (iter.hasNext()) {
                slice = (PieSlice)iter.next();
                fPaletteEntry = null;
                fPaletteEntry = this.bPaletteByCategory ? (this.bMinSliceApplied && this.pieSliceList.indexOf(slice) == this.pieSliceList.size() - 1 ? this.getPaletteColor(this.orginalSliceCount) : this.getPaletteColor(slice.getCategoryIndex())) : this.getPaletteColor(this.pie.getSeriesDefinition().getRunTimeSeries().indexOf(this.ps));
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)slice.getDataPointHints(), (Object)fPaletteEntry, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)slice.getDataPointHints());
                slice.render(LocationImpl.create((double)xc, (double)yc), LocationImpl.create((double)0.0, (double)this.dThickness), SizeImpl.create((double)w, (double)h), fPaletteEntry, 2);
                ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawDataPoint", (Object)slice.getDataPointHints(), (Object)fPaletteEntry, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)slice.getDataPointHints());
            }
        }
        ScriptHandler.callFunction((ScriptHandler)sh, (String)"beforeDrawSeriesTitle", (Object)this.ps, (Object)this.laSeriesTitle, (Object)this.pie.getRunTimeContext().getScriptContext());
        this.pie.getRunTimeContext().notifyStructureChange("beforeDrawSeriesTitle", (Object)this.laSeriesTitle);
        this.laDataPoint = LabelImpl.copyInstance((Label)this.ps.getLabel());
        if (this.laSeriesTitle.isVisible()) {
            EventObjectCache eventObjectCache = (EventObjectCache)idr;
            StructureSource structureSource = WrappedStructureSource.createSeriesTitle((Series)this.ps, (Label)this.laSeriesTitle);
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.birt.chart.event.TextRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TextRenderEvent tre = (TextRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
            tre.setLabel(this.laSeriesTitle);
            tre.setBlockBounds(this.boTitleContainer);
            tre.setBlockAlignment(null);
            tre.setAction(3);
            idr.drawText(tre);
        }
        ScriptHandler.callFunction((ScriptHandler)sh, (String)"afterDrawSeriesTitle", (Object)this.ps, (Object)this.laSeriesTitle, (Object)this.pie.getRunTimeContext().getScriptContext());
        this.pie.getRunTimeContext().notifyStructureChange("afterDrawSeriesTitle", (Object)this.laSeriesTitle);
        try {
            this.renderDataPoints(idr);
        }
        catch (ChartException rex) {
            logger.log((Exception)((Object)rex));
        }
    }

    private final void deferCurvedPlane(AreaRenderEvent areBentOrTwistedCurve, double dX1, double dX2) {
        this.alPlanes.add(new CurvedPlane(areBentOrTwistedCurve, dX1, dX2));
    }

    private final void deferFlatPlane(double[] daXPoints, double[] daYPoints, Fill cd, double dX1, double dX2, DataPointHints dph) {
        this.alPlanes.add(new FlatPlane(daXPoints, daYPoints, cd, dX1, dX2, dph));
    }

    private final void sortAndRenderPlanes() throws ChartException {
        int n = this.alPlanes.size();
        Collections.sort(this.alPlanes);
        int i = 0;
        while (i < n) {
            IDrawable id = (IDrawable)this.alPlanes.get(i);
            id.draw();
            ++i;
        }
        this.alPlanes.clear();
    }

    private final ColorDefinition getSliceOutline(Fill f) {
        if (this.ps.getSliceOutline() == null) {
            if (f instanceof ColorDefinition) {
                return ((ColorDefinition)f).darker();
            }
            return ColorDefinitionImpl.TRANSPARENT();
        }
        return ColorDefinitionImpl.copyInstance((ColorDefinition)this.ps.getSliceOutline());
    }

    private void initExploded() {
        if (this.sExplosionExpression == null || !this.pie.getRunTimeContext().isScriptingEnabled()) {
            return;
        }
        Iterator iter = this.pieSliceList.iterator();
        while (iter.hasNext()) {
            PieSlice slice = (PieSlice)iter.next();
            try {
                this.pie.getRunTimeContext().getScriptHandler().registerVariable("categoryData", slice.getDataPointHints().getBaseValue());
                this.pie.getRunTimeContext().getScriptHandler().registerVariable("valueData", slice.getDataPointHints().getOrthogonalValue());
                this.pie.getRunTimeContext().getScriptHandler().registerVariable("valueSeriesName", slice.getDataPointHints().getSeriesValue());
                Object obj = this.pie.getRunTimeContext().getScriptHandler().evaluate(this.sExplosionExpression);
                if (obj instanceof Boolean) {
                    slice.setExploded((Boolean)obj);
                }
                this.pie.getRunTimeContext().getScriptHandler().unregisterVariable("categoryData");
                this.pie.getRunTimeContext().getScriptHandler().unregisterVariable("valueData");
                this.pie.getRunTimeContext().getScriptHandler().unregisterVariable("valueSeriesName");
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
            }
        }
    }

    protected Gradient getDepthGradient(Fill cd) {
        if (cd instanceof Gradient) {
            return GradientImpl.create((ColorDefinition)((Gradient)cd).getStartColor().darker(), (ColorDefinition)((Gradient)cd).getEndColor().darker(), (double)((Gradient)cd).getDirection(), (boolean)((Gradient)cd).isCyclic());
        }
        return GradientImpl.create((ColorDefinition)(cd instanceof ColorDefinition ? ((ColorDefinition)cd).darker() : ColorDefinitionImpl.GREY()), (ColorDefinition)ColorDefinitionImpl.BLACK(), (double)0.0, (boolean)true);
    }

    private final void registerCurvedSurface(Bounds topBound, Bounds bottomBound, double dStartAngle, double dAngleExtent, LineRenderEvent lre1, LineRenderEvent lre2, Fill cd, DataPointHints dph) {
        if (dAngleExtent + dStartAngle > 180.0 && dStartAngle < 180.0) {
            LineRenderEvent lre3 = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            lre3.setEnd(LocationImpl.create((double)bottomBound.getLeft(), (double)(bottomBound.getTop() + bottomBound.getHeight() / 2.0)));
            lre3.setStart(LocationImpl.create((double)topBound.getLeft(), (double)(topBound.getTop() + topBound.getHeight() / 2.0)));
            ArcRenderEvent are1 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            ArcRenderEvent are2 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are1.setBounds(topBound);
            are1.setStartAngle(dStartAngle);
            are1.setAngleExtent(180.0 - dStartAngle);
            are1.setStyle(1);
            are2.setBounds(bottomBound);
            are2.setStartAngle(180.0);
            are2.setAngleExtent(dStartAngle - 180.0);
            are2.setStyle(1);
            AreaRenderEvent are = new AreaRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are.add((PrimitiveRenderEvent)lre1);
            are.add((PrimitiveRenderEvent)are1);
            are.add((PrimitiveRenderEvent)lre3);
            are.add((PrimitiveRenderEvent)are2);
            are.setOutline(LineAttributesImpl.create((ColorDefinition)this.getSliceOutline(cd), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            are.setBackground((Fill)this.getDepthGradient(cd));
            this.deferCurvedPlane(are, lre1.getStart().getX(), lre3.getStart().getX());
            are1 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are2 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are1.setBounds(topBound);
            are1.setStartAngle(180.0);
            are1.setAngleExtent(dStartAngle + dAngleExtent - 180.0);
            are1.setStyle(1);
            are2.setBounds(bottomBound);
            are2.setStartAngle(dStartAngle + dAngleExtent);
            are2.setAngleExtent(180.0 - (dStartAngle + dAngleExtent));
            are2.setStyle(1);
            LineRenderEvent lre4 = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            lre4.setStart(LocationImpl.copyInstance((Location)lre3.getEnd()));
            lre4.setEnd(LocationImpl.copyInstance((Location)lre3.getStart()));
            are = new AreaRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are.add((PrimitiveRenderEvent)lre4);
            are.add((PrimitiveRenderEvent)are1);
            are.add((PrimitiveRenderEvent)lre2);
            are.add((PrimitiveRenderEvent)are2);
            are.setOutline(LineAttributesImpl.create((ColorDefinition)this.getSliceOutline(cd), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            are.setBackground((Fill)this.getDepthGradient(cd));
            this.deferCurvedPlane(are, lre4.getStart().getX(), lre2.getStart().getX());
        } else {
            ArcRenderEvent are1 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            ArcRenderEvent are2 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are1.setBounds(topBound);
            are1.setStartAngle(dStartAngle);
            are1.setAngleExtent(dAngleExtent);
            are1.setStyle(1);
            are2.setBounds(bottomBound);
            are2.setStartAngle(dStartAngle + dAngleExtent);
            are2.setAngleExtent(-dAngleExtent);
            are2.setStyle(1);
            AreaRenderEvent are = new AreaRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            are.add((PrimitiveRenderEvent)lre1);
            are.add((PrimitiveRenderEvent)are1);
            are.add((PrimitiveRenderEvent)lre2);
            are.add((PrimitiveRenderEvent)are2);
            are.setOutline(LineAttributesImpl.create((ColorDefinition)this.getSliceOutline(cd), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
            are.setBackground((Fill)this.getDepthGradient(cd));
            this.deferCurvedPlane(are, lre1.getStart().getX(), lre2.getStart().getX());
        }
    }

    private final Fill getPaletteColor(int iIndex) {
        Fill fiClone = (Fill)EcoreUtil.copy((EObject)((Fill)this.pa.getEntries().get(iIndex % this.pa.getEntries().size())));
        this.pie.updateTranslucency(fiClone, (Series)this.ps);
        return fiClone;
    }

    private final class CurvedPlane
    implements Comparable,
    IDrawable {
        private final AreaRenderEvent _are;
        private final Bounds _bo;

        CurvedPlane(AreaRenderEvent are, double dX1, double dX2) {
            this._are = are;
            this._bo = are.getBounds();
        }

        public final Bounds getBounds() {
            return this._bo;
        }

        public final int compareTo(Object o) {
            CurvedPlane cp1 = this;
            if (o instanceof CurvedPlane) {
                double dMaxX2;
                double dMinX2;
                double dMaxY2;
                double dMinY2;
                CurvedPlane cp2 = (CurvedPlane)o;
                double dMinY1 = cp1.getMinY();
                double dDiff = dMinY1 - (dMinY2 = cp2.getMinY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : (dDiff > 0.0 ? 1 : 0);
                }
                double dMaxY1 = cp1.getMaxY();
                dDiff = dMaxY1 - (dMaxY2 = cp2.getMaxY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMinX1 = cp1.getMinX();
                dDiff = dMinX1 - (dMinX2 = cp2.getMinX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxX1 = cp1.getMaxX();
                dDiff = dMaxX1 - (dMaxX2 = cp2.getMaxX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                return 0;
            }
            if (o instanceof FlatPlane) {
                FlatPlane pi2 = (FlatPlane)o;
                return pi2.compareTo(cp1) * -1;
            }
            return 0;
        }

        public final void draw() throws ChartException {
            PieRenderer.this.idr.fillArea(this._are);
            PieRenderer.this.idr.drawArea(this._are);
        }

        private final double getMinY() {
            return this._bo.getTop();
        }

        private final double getMinX() {
            return this._bo.getLeft();
        }

        private final double getMaxX() {
            return this._bo.getLeft() + this._bo.getWidth();
        }

        private final double getMaxY() {
            return this._bo.getTop() + this._bo.getHeight();
        }
    }

    private final class FlatPlane
    implements Comparable,
    IDrawable {
        private final double[] _daXPoints;
        private final double[] _daYPoints;
        private Fill _cd;
        private final Bounds _bo;
        private DataPointHints _dph;

        FlatPlane(double[] daXPoints, double[] daYPoints, Fill cd, double dX1, double dX2, DataPointHints dph) {
            this._daXPoints = daXPoints;
            this._daYPoints = daYPoints;
            this._dph = dph;
            int n = this._daXPoints.length;
            double dMinX = 0.0;
            double dMinY = 0.0;
            double dMaxX = 0.0;
            double dMaxY = 0.0;
            int i = 0;
            while (i < n) {
                if (i == 0) {
                    dMinX = this._daXPoints[i];
                    dMinY = this._daYPoints[i];
                    dMaxX = dMinX;
                    dMaxY = dMinY;
                } else {
                    if (dMinX > this._daXPoints[i]) {
                        dMinX = this._daXPoints[i];
                    }
                    if (dMinY > this._daYPoints[i]) {
                        dMinY = this._daYPoints[i];
                    }
                    if (dMaxX < this._daXPoints[i]) {
                        dMaxX = this._daXPoints[i];
                    }
                    if (dMaxY < this._daYPoints[i]) {
                        dMaxY = this._daYPoints[i];
                    }
                }
                ++i;
            }
            this._bo = BoundsImpl.create((double)dMinX, (double)dMinY, (double)(dMaxX - dMinX), (double)(dMaxY - dMinY));
            this._cd = cd;
            int nPoints = this._daXPoints.length;
            int[] iaX = new int[nPoints];
            int[] iaY = new int[nPoints];
            int i2 = 0;
            while (i2 < nPoints) {
                iaX[i2] = (int)daXPoints[i2];
                iaY[i2] = (int)daYPoints[i2];
                ++i2;
            }
        }

        public Bounds getBounds() {
            return this._bo;
        }

        public final void draw() throws ChartException {
            EventObjectCache eventObjectCache = (EventObjectCache)PieRenderer.this.idr;
            StructureSource structureSource = WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this._dph);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
            pre.setPoints(this.toLocationArray());
            PieRenderer.this.liaEdges.setColor(PieRenderer.this.getSliceOutline(this._cd));
            pre.setOutline(PieRenderer.this.liaEdges);
            pre.setBackground((Fill)PieRenderer.this.getDepthGradient(this._cd));
            PieRenderer.this.idr.fillPolygon(pre);
            PieRenderer.this.idr.drawPolygon(pre);
        }

        public final int compareTo(Object o) {
            FlatPlane pi1 = this;
            if (o instanceof FlatPlane) {
                double dMaxX2;
                double dMinX2;
                double dMaxY2;
                double dMinY2;
                FlatPlane pi2 = (FlatPlane)o;
                double dMinY1 = pi1.getMinY();
                double dDiff = dMinY1 - (dMinY2 = pi2.getMinY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : (dDiff > 0.0 ? 1 : 0);
                }
                double dMaxY1 = pi1.getMaxY();
                dDiff = dMaxY1 - (dMaxY2 = pi2.getMaxY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMinX1 = pi1.getMinX();
                dDiff = dMinX1 - (dMinX2 = pi2.getMinX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxX1 = pi1.getMaxX();
                dDiff = dMaxX1 - (dMaxX2 = pi2.getMaxX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                return 0;
            }
            if (o instanceof CurvedPlane) {
                double dMaxX2;
                double dMinX2;
                double dMaxY2;
                double dMinY2;
                CurvedPlane pi2 = (CurvedPlane)o;
                double dMinY1 = pi1.getMinY();
                double dDiff = dMinY1 - (dMinY2 = pi2.getMinY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxY1 = pi1.getMaxY();
                dDiff = dMaxY1 - (dMaxY2 = pi2.getMaxY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMinX1 = pi1.getMinX();
                dDiff = dMinX1 - (dMinX2 = pi2.getMinX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxX1 = pi1.getMaxX();
                dDiff = dMaxX1 - (dMaxX2 = pi2.getMaxX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                return 0;
            }
            return 0;
        }

        private final double getMinY() {
            return this._bo.getTop();
        }

        private final double getMinX() {
            return this._bo.getLeft();
        }

        private final double getMaxX() {
            return this._bo.getLeft() + this._bo.getWidth();
        }

        private final double getMaxY() {
            return this._bo.getTop() + this._bo.getHeight();
        }

        private final Location[] toLocationArray() {
            int n = this._daXPoints.length;
            Location[] loa = new Location[n];
            int i = 0;
            while (i < n) {
                loa[i] = LocationImpl.create((double)this._daXPoints[i], (double)this._daYPoints[i]);
                ++i;
            }
            return loa;
        }
    }

    private static interface IDrawable {
        public void draw() throws ChartException;

        public Bounds getBounds();
    }

    public class PieSlice {
        private boolean isExploded = true;
        private double startAngle;
        private double sliceLength;
        private double slicePecentage;
        private int categoryIndex;
        private DataPointHints dataPointHints;
        private double primitiveValue;
        private int quadrant = -1;
        private Location loPie;
        private Location loStart;
        private Location loEnd;
        private BoundingBox labelBounding = null;
        private Bounds bounds = null;
        private double w;
        private double h;
        private double xc;
        private double yc;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.birt.chart.render.PieRenderer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        PieSlice(double primitiveValue, DataPointHints dataPointHints, int categroyIndex) {
            this.primitiveValue = primitiveValue;
            this.dataPointHints = dataPointHints;
            this.categoryIndex = categroyIndex;
        }

        private PieSlice() {
        }

        public Object clone() {
            PieSlice slice = new PieSlice();
            this.copyTo(slice);
            return slice;
        }

        public void copyTo(PieSlice slice) {
            slice.primitiveValue = this.primitiveValue;
            slice.dataPointHints = this.dataPointHints;
            slice.categoryIndex = this.categoryIndex;
            slice.setLabelLocation(this.loPie, this.loStart, this.loEnd);
            slice.setExploded(this.isExploded);
            slice.setStartAngle(this.startAngle);
            slice.setSliceLength(this.sliceLength);
            slice.setPercentage(this.slicePecentage);
            slice.setBounds(this.bounds);
            slice.labelBounding = this.labelBounding;
            slice.quadrant = this.quadrant;
        }

        public double getPrimitiveValue() {
            return this.primitiveValue;
        }

        public DataPointHints getDataPointHints() {
            return this.dataPointHints;
        }

        public String getDisplayValue() {
            return this.dataPointHints.getDisplayValue();
        }

        public double getStartAngle() {
            return this.startAngle;
        }

        public double getSliceLength() {
            return this.sliceLength;
        }

        public double getdMidAngle() {
            return this.startAngle + this.sliceLength / 2.0;
        }

        public double getSlicePercentage() {
            return this.slicePecentage;
        }

        public int getCategoryIndex() {
            return this.categoryIndex;
        }

        public int getQuadrant() {
            return this.quadrant;
        }

        public void setLabelLocation(double dX0, double dY0, double dX1, double dY1, double dX2, double dY2) {
            this.setLabelLocation(LocationImpl.create((double)dX0, (double)dY0), LocationImpl.create((double)dX1, (double)dY1), LocationImpl.create((double)dX2, (double)dY2));
        }

        public void setLabelLocation(Location loPie, Location loStart, Location loEnd) {
            this.loPie = loPie;
            this.loStart = loStart;
            this.loEnd = loEnd;
        }

        public void setExploded(boolean isExploded) {
            this.isExploded = isExploded;
        }

        public void setStartAngle(double startAngle) {
            this.startAngle = startAngle;
        }

        public void setSliceLength(double newLength) {
            this.sliceLength = newLength;
        }

        public void setPercentage(double newPercentage) {
            this.slicePecentage = newPercentage;
        }

        public final BoundingBox getLabelBounding() {
            return this.labelBounding;
        }

        private final void render(Location loC, Location loOffset, Size sz, Fill fi, int iPieceType) throws ChartException {
            loC.translate(loOffset.getX() / 2.0, loOffset.getY() / 2.0);
            if (this.isExploded && PieRenderer.this.dExplosion != 0.0) {
                double dMidAngleInRadians = Math.toRadians(this.getStartAngle() + this.getSliceLength() / 2.0);
                double dSineThetaMid = Math.sin(dMidAngleInRadians);
                double dCosThetaMid = Math.cos(dMidAngleInRadians);
                double xDelta = PieRenderer.this.dExplosion * dCosThetaMid;
                double yDelta = PieRenderer.this.dExplosion * dSineThetaMid;
                loC.translate(xDelta, -yDelta);
            }
            Location loCTop = LocationImpl.create((double)(loC.getX() - loOffset.getX()), (double)(loC.getY() - loOffset.getY()));
            double dAngleInRadians = Math.toRadians(this.getStartAngle());
            double dSineThetaStart = Math.sin(dAngleInRadians);
            double dCosThetaStart = Math.cos(dAngleInRadians);
            dAngleInRadians = Math.toRadians(this.getStartAngle() + this.getSliceLength());
            double dSineThetaEnd = Math.sin(dAngleInRadians);
            double dCosThetaEnd = Math.cos(dAngleInRadians);
            double xE = sz.getWidth() * dCosThetaEnd;
            double yE = sz.getHeight() * dSineThetaEnd;
            double xS = sz.getWidth() * dCosThetaStart;
            double yS = sz.getHeight() * dSineThetaStart;
            ArcRenderEvent are = null;
            if (iPieceType == 1) {
                are = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints));
            } else {
                EventObjectCache eventObjectCache = (EventObjectCache)PieRenderer.this.idr;
                StructureSource structureSource = WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.getDataPointHints());
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.birt.chart.event.ArcRenderEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                are = (ArcRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
            }
            are.setBackground(fi);
            PieRenderer.this.liaEdges.setColor(PieRenderer.this.getSliceOutline(fi));
            are.setOutline(PieRenderer.this.liaEdges);
            are.setTopLeft(LocationImpl.create((double)(loCTop.getX() - sz.getWidth()), (double)(loCTop.getY() - sz.getHeight() + (iPieceType == 1 ? PieRenderer.this.dThickness : 0.0))));
            are.setWidth(sz.getWidth() * 2.0);
            are.setHeight(sz.getHeight() * 2.0);
            are.setStartAngle(this.startAngle);
            are.setAngleExtent(this.sliceLength);
            are.setStyle(3);
            PieRenderer.this.idr.fillArc(are);
            if (iPieceType == 1) {
                double[] daXPoints = new double[]{loC.getX(), loCTop.getX(), loCTop.getX() + xE, loC.getX() + xE};
                double[] daYPoints = new double[]{loC.getY(), loCTop.getY(), loCTop.getY() - yE, loC.getY() - yE};
                PieRenderer.this.deferFlatPlane(daXPoints, daYPoints, fi, loC.getX(), loC.getX() + xE, this.dataPointHints);
                daXPoints = new double[]{loC.getX(), loC.getX() + xS, loCTop.getX() + xS, loCTop.getX()};
                daYPoints = new double[]{loC.getY(), loC.getY() - yS, loCTop.getY() - yS, loCTop.getY()};
                PieRenderer.this.deferFlatPlane(daXPoints, daYPoints, fi, loC.getX(), loC.getX() + xS, this.dataPointHints);
                daXPoints = new double[]{loC.getX() + xS, loCTop.getX() + xS, loCTop.getX() + xE, loC.getX() + xE};
                daYPoints = new double[]{loC.getY() - yS, loCTop.getY() - yS, loCTop.getY() - yE, loC.getY() - yE};
                LineRenderEvent lre1 = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints));
                lre1.setStart(LocationImpl.create((double)(loC.getX() + xS), (double)(loC.getY() - yS)));
                lre1.setEnd(LocationImpl.create((double)(loCTop.getX() + xS), (double)(loCTop.getY() - yS)));
                LineRenderEvent lre2 = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints));
                lre2.setStart(LocationImpl.create((double)(loCTop.getX() + xE), (double)(loCTop.getY() - yE)));
                lre2.setEnd(LocationImpl.create((double)(loC.getX() + xE), (double)(loC.getY() - yE)));
                Bounds r2dd1 = BoundsImpl.create((double)(loCTop.getX() - sz.getWidth()), (double)(loCTop.getY() - sz.getHeight()), (double)(sz.getWidth() * 2.0), (double)(sz.getHeight() * 2.0));
                Bounds r2dd2 = BoundsImpl.create((double)(loC.getX() - sz.getWidth()), (double)(loC.getY() - sz.getHeight()), (double)(sz.getWidth() * 2.0), (double)(sz.getHeight() * 2.0));
                PieRenderer.this.registerCurvedSurface(r2dd1, r2dd2, this.getStartAngle(), this.getSliceLength(), lre1, lre2, fi, this.dataPointHints);
            } else if (iPieceType == 2) {
                EList elTriggers;
                if (PieRenderer.this.ps.getSliceOutline() != null) {
                    PieRenderer.this.idr.drawArc(are);
                }
                if (PieRenderer.this.pie.isInteractivityEnabled() && !(elTriggers = PieRenderer.this.ps.getTriggers()).isEmpty()) {
                    StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints);
                    EventObjectCache eventObjectCache = (EventObjectCache)PieRenderer.this.idr;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.InteractionEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    InteractionEvent iev = (InteractionEvent)eventObjectCache.getEventObject((Object)iSource, (Class)clazz);
                    int t = 0;
                    while (t < elTriggers.size()) {
                        Trigger tg = TriggerImpl.copyInstance((Trigger)((Trigger)elTriggers.get(t)));
                        PieRenderer.this.pie.processTrigger(tg, iSource);
                        iev.addTrigger(tg);
                        ++t;
                    }
                    iev.setHotSpot((PrimitiveRenderEvent)are);
                    PieRenderer.this.idr.enableInteraction(iev);
                }
            }
        }

        private final void renderLabel(IDeviceRenderer idr, int iTextRenderType) throws ChartException {
            PieRenderer.this.laDataPoint.getCaption().setValue(this.getDisplayValue());
            if (this.quadrant != -1) {
                if (iTextRenderType == 2) {
                    EventObjectCache eventObjectCache = (EventObjectCache)idr;
                    StructureSource structureSource = WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints);
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    LineRenderEvent lre = (LineRenderEvent)eventObjectCache.getEventObject((Object)structureSource, (Class)clazz);
                    lre.setLineAttributes(PieRenderer.this.liaLL);
                    lre.setStart(this.loPie);
                    lre.setEnd(this.loStart);
                    idr.drawLine(lre);
                    EventObjectCache eventObjectCache2 = (EventObjectCache)idr;
                    StructureSource structureSource2 = WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints);
                    Class<?> clazz2 = class$3;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$3 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    lre = (LineRenderEvent)eventObjectCache2.getEventObject((Object)structureSource2, (Class)clazz2);
                    lre.setLineAttributes(PieRenderer.this.liaLL);
                    lre.setStart(this.loStart);
                    lre.setEnd(this.loEnd);
                    idr.drawLine(lre);
                }
                PieRenderer.this.pie.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints), 3, PieRenderer.this.laDataPoint, this.quadrant == 1 || this.quadrant == 4 ? Position.RIGHT_LITERAL : Position.LEFT_LITERAL, this.loEnd, BoundsImpl.create((double)this.labelBounding.getLeft(), (double)this.labelBounding.getTop(), (double)this.labelBounding.getWidth(), (double)this.labelBounding.getHeight()));
            } else {
                PieRenderer.this.pie.renderLabel(StructureSource.createSeries((Series)PieRenderer.this.ps), 3, PieRenderer.this.laDataPoint, null, null, BoundsImpl.create((double)this.labelBounding.getLeft(), (double)this.labelBounding.getTop(), (double)this.labelBounding.getWidth(), (double)this.labelBounding.getHeight()));
            }
        }

        public boolean isLabelOverlap(PieSlice sliceToCompare) {
            BoundingBox dLow;
            BoundingBox dHigh;
            if (sliceToCompare == null || sliceToCompare == this || sliceToCompare.labelBounding == null) {
                return false;
            }
            BoundingBox bb1 = this.labelBounding;
            BoundingBox bb2 = sliceToCompare.labelBounding;
            if (bb1.getTop() < bb2.getTop()) {
                dHigh = bb1;
                dLow = bb2;
            } else {
                dHigh = bb2;
                dLow = bb1;
            }
            if (dHigh.getLeft() < dLow.getLeft()) {
                double dXHigh = dHigh.getLeft() + dHigh.getWidth();
                double dYHigh = dHigh.getTop() + dHigh.getHeight();
                double dXLow = dLow.getLeft();
                double dYLow = dLow.getTop();
                if (dXHigh > dXLow && dYHigh > dYLow) {
                    return true;
                }
            } else {
                double dXHigh = dHigh.getLeft();
                double dYHigh = dHigh.getTop() + dHigh.getHeight();
                double dXLow = dLow.getLeft() + dLow.getWidth();
                double dYLow = dLow.getTop();
                if (dXHigh < dXLow && dYHigh > dYLow) {
                    return true;
                }
            }
            return false;
        }

        public void setBounds(Bounds bo) {
            this.bounds = bo;
            this.w = this.bounds.getWidth() / 2.0 - PieRenderer.this.dExplosion;
            this.h = this.bounds.getHeight() / 2.0 - PieRenderer.this.dExplosion - PieRenderer.this.dThickness / 2.0;
            this.xc = this.bounds.getLeft() + this.w + PieRenderer.this.dExplosion;
            this.yc = this.bounds.getTop() + this.h + PieRenderer.this.dExplosion + PieRenderer.this.dThickness / 2.0;
            if (PieRenderer.this.ratio > 0.0 && this.w > 0.0) {
                if (this.h / this.w > PieRenderer.this.ratio) {
                    this.h = this.w * PieRenderer.this.ratio;
                } else if (this.h / this.w < PieRenderer.this.ratio) {
                    this.w = this.h / PieRenderer.this.ratio;
                }
            }
            if (this.w <= 0.0 || this.h <= 0.0) {
                this.h = 1.0;
                this.w = 1.0;
            }
        }

        private void computeLabelBoundOutside(LeaderLineStyle lls, double dLeaderLength) {
            double yDelta2;
            double xDelta2;
            double yDelta1;
            double xDelta1;
            int iLL = 0;
            double dLeaderTick = Math.max(dLeaderLength / 4.0, 10.0 * PieRenderer.this.pie.getDeviceScale());
            double dLeaderW = 0.0;
            double dLeaderH = 0.0;
            double dBottomLeaderW = 0.0;
            double dBottomLeaderH = 0.0;
            double dTopLeaderW = 0.0;
            double dTopLeaderH = 0.0;
            Location center = LocationImpl.create((double)this.xc, (double)(this.yc - PieRenderer.this.dThickness / 2.0));
            Location depthCenter = LocationImpl.create((double)this.xc, (double)this.yc);
            double dX = 0.0;
            double dLeftSide = this.xc - PieRenderer.this.dExplosion - this.w;
            double dRightSide = this.xc + PieRenderer.this.dExplosion + this.w;
            if (this.w > this.h) {
                dTopLeaderW = dLeaderTick;
                dTopLeaderH = dLeaderTick * PieRenderer.this.ratio;
            } else {
                dTopLeaderH = dLeaderTick;
                dTopLeaderW = dLeaderTick / PieRenderer.this.ratio;
            }
            double dMidAngleInDegrees = this.getdMidAngle();
            double dMidAngleInRadians = Math.toRadians(-dMidAngleInDegrees);
            double dSineThetaMid = Math.sin(dMidAngleInRadians);
            double dCosThetaMid = Math.cos(dMidAngleInRadians);
            if (PieRenderer.this.dThickness > 0.0 && dMidAngleInDegrees > 180.0 && dMidAngleInDegrees < 360.0) {
                double dTmpLeaderTick = Math.max(PieRenderer.this.dThickness * dSineThetaMid + 8.0 * PieRenderer.this.pie.getDeviceScale(), dLeaderTick);
                if (this.w > this.h) {
                    dBottomLeaderW = dTmpLeaderTick;
                    dBottomLeaderH = dTmpLeaderTick * PieRenderer.this.ratio;
                } else {
                    dBottomLeaderH = dTmpLeaderTick;
                    dBottomLeaderW = dTmpLeaderTick / PieRenderer.this.ratio;
                }
                dLeaderW = dBottomLeaderW;
                dLeaderH = dBottomLeaderH;
            } else {
                dLeaderW = dTopLeaderW;
                dLeaderH = dTopLeaderH;
            }
            if (this.isExploded) {
                xDelta1 = (this.w + PieRenderer.this.dExplosion) * dCosThetaMid;
                yDelta1 = (this.h + PieRenderer.this.dExplosion) * dSineThetaMid;
                xDelta2 = (this.w + dLeaderW + PieRenderer.this.dExplosion) * dCosThetaMid;
                yDelta2 = (this.h + dLeaderH + PieRenderer.this.dExplosion) * dSineThetaMid;
            } else {
                xDelta1 = this.w * dCosThetaMid;
                yDelta1 = this.h * dSineThetaMid;
                xDelta2 = (this.w + dLeaderW) * dCosThetaMid;
                yDelta2 = (this.h + dLeaderH) * dSineThetaMid;
            }
            if (lls == LeaderLineStyle.STRETCH_TO_SIDE_LITERAL) {
                if (dMidAngleInDegrees >= 90.0 && dMidAngleInDegrees < 270.0) {
                    dX = dLeftSide - dLeaderW * 1.5;
                    iLL = 1;
                } else {
                    dX = dRightSide + dLeaderW * 1.5;
                    iLL = 2;
                }
            } else if (lls == LeaderLineStyle.FIXED_LENGTH_LITERAL) {
                if (dMidAngleInDegrees > 90.0 && dMidAngleInDegrees < 270.0) {
                    dX = center.getX() + xDelta2 - dLeaderLength;
                    if (dLeaderLength > 0.0) {
                        iLL = 1;
                    } else if (dMidAngleInDegrees < 135.0) {
                        iLL = 3;
                    } else if (dMidAngleInDegrees < 225.0) {
                        iLL = 1;
                    } else if (dMidAngleInDegrees < 270.0) {
                        iLL = 4;
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                } else {
                    dX = center.getX() + xDelta2 + dLeaderLength;
                    if (dLeaderLength > 0.0) {
                        iLL = 2;
                    } else if (dMidAngleInDegrees <= 45.0) {
                        iLL = 2;
                    } else if (dMidAngleInDegrees > 45.0 && dMidAngleInDegrees <= 90.0) {
                        iLL = 3;
                    } else if (dMidAngleInDegrees <= 315.0 && dMidAngleInDegrees >= 270.0) {
                        iLL = 4;
                    } else if (dMidAngleInDegrees > 315.0) {
                        iLL = 2;
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            }
            Location relativeCenter = dMidAngleInDegrees > 0.0 && dMidAngleInDegrees < 180.0 ? center : depthCenter;
            this.setLabelLocation(relativeCenter.getX() + xDelta1, relativeCenter.getY() + yDelta1, relativeCenter.getX() + xDelta2, relativeCenter.getY() + yDelta2, dX, relativeCenter.getY() + yDelta2);
            PieRenderer.this.laDataPoint.getCaption().setValue(this.getDisplayValue());
            this.labelBounding = Methods.computeBox((IDisplayServer)PieRenderer.this.xs, (int)iLL, (Label)PieRenderer.this.laDataPoint, (double)dX, (double)(relativeCenter.getY() + yDelta2));
            if (dMidAngleInDegrees >= 0.0 && dMidAngleInDegrees < 90.0) {
                this.quadrant = 1;
            }
            if (dMidAngleInDegrees >= 90.0 && dMidAngleInDegrees < 180.0) {
                this.quadrant = 2;
            }
            this.quadrant = dMidAngleInDegrees >= 180.0 && dMidAngleInDegrees < 270.0 ? 3 : 4;
        }

        private void computeLabelBoundInside() {
            double yDelta;
            double xDelta;
            double dMidAngleInRadians = Math.toRadians(-this.getdMidAngle());
            double dSineThetaMid = Math.sin(dMidAngleInRadians);
            double dCosThetaMid = Math.cos(dMidAngleInRadians);
            if (this.isExploded) {
                xDelta = (this.w / 1.5 + PieRenderer.this.dExplosion) * dCosThetaMid;
                yDelta = (this.h / 1.5 + PieRenderer.this.dExplosion) * dSineThetaMid;
            } else {
                xDelta = this.w / 1.5 * dCosThetaMid;
                yDelta = this.h / 1.5 * dSineThetaMid;
            }
            PieRenderer.this.laDataPoint.getCaption().setValue(this.getDisplayValue());
            this.labelBounding = Methods.computeBox((IDisplayServer)PieRenderer.this.xs, (int)1, (Label)PieRenderer.this.laDataPoint, (double)0.0, (double)0.0);
            this.labelBounding.setLeft(this.xc + xDelta - this.labelBounding.getWidth() / 2.0);
            this.labelBounding.setTop(this.yc - PieRenderer.this.dThickness / 2.0 + yDelta - this.labelBounding.getHeight() / 2.0);
        }
    }
}

