/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.util.SchemaHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDMBindingUtil {
    private static Annotation[] EMPTY_ANNOTATION_LIST = new Annotation[0];
    private static HashMap<String, SchemaHelper> schemaMap = new HashMap();

    public static void extractFields(Class clazz, HashMap<String, Field> map) {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field field = fieldArray[n];
            if (map.get(field.getName()) == null) {
                map.put(field.getName(), field);
            }
            ++n;
        }
    }

    public static void getAnnotationsFromHierarchy(Class clazz, HashMap<Class, Annotation> map) {
        Annotation[] annotations;
        if (clazz == null) {
            return;
        }
        Annotation[] annotationArray = annotations = clazz.getAnnotations();
        int n = 0;
        int n2 = annotationArray.length;
        while (n < n2) {
            Annotation annotation = annotationArray[n];
            if (map.get(annotation.annotationType()) == null) {
                map.put(annotation.annotationType(), annotation);
            }
            ++n;
        }
        WSDMBindingUtil.getAnnotationsFromHierarchy(clazz.getSuperclass(), map);
    }

    public static void getAnnotationsFromInterface(Class clazz, HashMap<Class, Annotation> map) {
        if (clazz == null) {
            return;
        }
        if (clazz.isInterface()) {
            WSDMBindingUtil.getAnnotationsFromHierarchy(clazz, map);
        } else {
            Class<?>[] interfazes;
            Class<?>[] classArray = interfazes = clazz.getInterfaces();
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                WSDMBindingUtil.getAnnotationsFromHierarchy(clazz, map);
                ++n;
            }
            WSDMBindingUtil.getAnnotationsFromInterface(clazz.getSuperclass(), map);
        }
    }

    public static Annotation[] getAnnotations(Class clazz) {
        HashMap<Class, Annotation> map = new HashMap<Class, Annotation>();
        WSDMBindingUtil.getAnnotationsFromHierarchy(clazz, map);
        WSDMBindingUtil.getAnnotationsFromInterface(clazz, map);
        if (map.isEmpty()) {
            return EMPTY_ANNOTATION_LIST;
        }
        return map.values().toArray(EMPTY_ANNOTATION_LIST);
    }

    public static Annotation[] getAnnotations(Method method) {
        Annotation[] annotations;
        HashMap<Class, Annotation> map = new HashMap<Class, Annotation>();
        Annotation[] annotationArray = annotations = method.getAnnotations();
        int n = 0;
        int n2 = annotationArray.length;
        while (n < n2) {
            Annotation annotation = annotationArray[n];
            if (map.get(annotation.annotationType()) == null) {
                map.put(annotation.annotationType(), annotation);
            }
            ++n;
        }
        WSDMBindingUtil.getMethodAnnotationsFromHierarchy(method, method.getDeclaringClass(), map);
        WSDMBindingUtil.getMethodAnnotationsFromInterface(method, method.getDeclaringClass(), map);
        if (map.isEmpty()) {
            return EMPTY_ANNOTATION_LIST;
        }
        return map.values().toArray(EMPTY_ANNOTATION_LIST);
    }

    public static void getMethodAnnotationsFromHierarchy(Method method, Class clazz, HashMap<Class, Annotation> map) {
        Method superMethod = WSDMBindingUtil.getMethodFromSuper(method, clazz);
        if (superMethod != null) {
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = superMethod.getAnnotations();
            int n = 0;
            int n2 = annotationArray.length;
            while (n < n2) {
                Annotation annotation = annotationArray[n];
                if (map.get(annotation.annotationType()) == null) {
                    map.put(annotation.annotationType(), annotation);
                }
                ++n;
            }
            WSDMBindingUtil.getMethodAnnotationsFromHierarchy(method, superMethod.getDeclaringClass().getSuperclass(), map);
        }
    }

    public static void getMethodAnnotationsFromInterface(Method method, Class clazz, HashMap<Class, Annotation> map) {
        Class<?>[] interfazes;
        int n;
        if (clazz == null) {
            return;
        }
        if (clazz.isInterface()) {
            try {
                Annotation annotation;
                Annotation[] annotations;
                Method iMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                Annotation[] annotationArray = annotations = iMethod.getAnnotations();
                n = 0;
                int n2 = annotationArray.length;
                while (n < n2) {
                    annotation = annotationArray[n];
                    if (map.get(annotation.annotationType()) == null) {
                        map.put(annotation.annotationType(), annotation);
                    }
                    ++n;
                }
                if (clazz.getAnnotation(ManagedResourceCapability.class) != null && map.get((annotation = clazz.getAnnotation(ManagedResourceCapability.class)).annotationType()) == null) {
                    map.put(annotation.annotationType(), annotation);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        Class<?>[] classArray = interfazes = clazz.getInterfaces();
        int n3 = 0;
        n = classArray.length;
        while (n3 < n) {
            Class<?> interfaze = classArray[n3];
            WSDMBindingUtil.getMethodAnnotationsFromInterface(method, interfaze, map);
            ++n3;
        }
    }

    public static Annotation[] getAnnotations(Field field) {
        new HashMap();
        return EMPTY_ANNOTATION_LIST;
    }

    public static Annotation getAnnotation(Class annotation, Class clazz) {
        Object ret = clazz.getAnnotation(annotation);
        if (ret != null) {
            return ret;
        }
        ret = WSDMBindingUtil.getAnnotationFromHierarchy(annotation, clazz);
        if (ret != null) {
            return ret;
        }
        return WSDMBindingUtil.getAnnotationFromInterface(annotation, clazz);
    }

    public static Annotation getAnnotationFromInterface(Class annotation, Class clazz) {
        Class<?>[] interfazes;
        if (clazz == null) {
            return null;
        }
        Object ret = clazz.getAnnotation(annotation);
        if (ret != null) {
            return ret;
        }
        Class<?>[] classArray = interfazes = clazz.getInterfaces();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class<?> interfaze = classArray[n];
            ret = WSDMBindingUtil.getAnnotationFromInterface(annotation, interfaze);
            if (ret != null) {
                return ret;
            }
            ++n;
        }
        return null;
    }

    public static Annotation getAnnotationFromHierarchy(Class annotation, Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.getAnnotation(annotation) != null) {
            return clazz.getAnnotation(annotation);
        }
        return WSDMBindingUtil.getAnnotationFromHierarchy(annotation, clazz.getSuperclass());
    }

    private static Method getMethodFromSuper(Method method, Class superClazz) {
        if (superClazz == null) {
            return null;
        }
        try {
            return superClazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return WSDMBindingUtil.getMethodFromSuper(method, superClazz.getSuperclass());
        }
        return null;
    }

    public static Annotation getMethodAnnotation(Class annotation, Method method) {
        Object ret = method.getAnnotation(annotation);
        if (ret != null) {
            return ret;
        }
        ret = WSDMBindingUtil.getMethodAnnotationFromHierarchy(method, annotation, method.getDeclaringClass().getSuperclass());
        if (ret != null) {
            return ret;
        }
        ret = WSDMBindingUtil.getMethodAnnotationFromInterface(method, annotation, method.getDeclaringClass());
        return ret;
    }

    public static Annotation getMethodAnnotationFromHierarchy(Method method, Class annotation, Class clazz) {
        Method superMethod = WSDMBindingUtil.getMethodFromSuper(method, clazz);
        Annotation ret = null;
        if (superMethod != null && (ret = (Annotation)superMethod.getAnnotation(annotation)) == null) {
            return WSDMBindingUtil.getMethodAnnotationFromHierarchy(method, annotation, superMethod.getDeclaringClass().getSuperclass());
        }
        return ret;
    }

    public static Annotation getMethodAnnotationFromInterface(Method method, Class annotation, Class clazz) {
        Class<?>[] interfazes;
        if (clazz == null) {
            return null;
        }
        Annotation ret = null;
        if (clazz.isInterface()) {
            try {
                Method iMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
                ret = annotation.equals(ManagedResourceCapability.class) ? (Annotation)clazz.getAnnotation(annotation) : (Annotation)iMethod.getAnnotation(annotation);
                if (ret != null) {
                    return ret;
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        Class<?>[] classArray = interfazes = clazz.getInterfaces();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class<?> interfaze = classArray[n];
            ret = WSDMBindingUtil.getMethodAnnotationFromInterface(method, annotation, interfaze);
            if (ret != null) {
                return ret;
            }
            ++n;
        }
        return null;
    }

    public static boolean equivalentMethod(Method iMethod, Method mMethod) {
        Class<?>[] mParms;
        Class<?>[] iParms;
        boolean ok = true;
        if (!iMethod.getName().equals(mMethod.getName())) {
            return false;
        }
        if (iMethod.getReturnType().equals(mMethod.getReturnType()) && (iParms = iMethod.getParameterTypes()).length == (mParms = mMethod.getParameterTypes()).length) {
            int i = 0;
            Class<?>[] classArray = iParms;
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class<?> pClass = classArray[n];
                if (!pClass.equals(mParms[i++])) {
                    ok = false;
                    break;
                }
                ++n;
            }
        }
        return ok;
    }

    public static void registerSchemaHelper(Class type, SchemaHelper helper) {
        schemaMap.put(type.getName(), helper);
    }

    public static SchemaHelper getSchemaHelper(Class type) {
        return schemaMap.get(type.getName());
    }

    public static SchemaHelper getSchemaHelper(String type) {
        return schemaMap.get(type);
    }
}

