/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.IAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

class CSSLengthValueHandler {
    static final String[] ABSOLUTE_FONT_SIZE_CONSTANTS;
    static DimensionValue defaultFontSizeValue;
    IAbsoluteFontSizeValueProvider provider;
    DimensionHandle dimensionHandle;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.CSSLengthValueHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        ABSOLUTE_FONT_SIZE_CONSTANTS = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"};
        defaultFontSizeValue = null;
    }

    CSSLengthValueHandler(DimensionHandle dimensionHandle) {
        this.dimensionHandle = dimensionHandle;
        DesignSession session = dimensionHandle.getElementHandle().getModule().getSession();
        this.provider = session.getPredefinedFontSizeProvider();
    }

    DimensionValue getDefaultFontSizeValue() {
        if (defaultFontSizeValue == null) {
            ElementDefn styleDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement("Style");
            ElementPropertyDefn fontSizePropDefn = (ElementPropertyDefn)styleDefn.getProperty("fontSize");
            Object defaultValue = fontSizePropDefn.getDefault();
            if (defaultValue instanceof DimensionValue) {
                defaultFontSizeValue = (DimensionValue)defaultValue;
            }
            defaultFontSizeValue = this.provider.getValueOf((String)defaultValue);
        }
        return defaultFontSizeValue;
    }

    DimensionValue computeRelativeValue(DimensionValue fontSizeValue, DimensionValue relativeValue) {
        if (!$assertionsDisabled && !CSSLengthValueHandler.isAbsoluteUnit(fontSizeValue.getUnits())) {
            throw new AssertionError();
        }
        if (!CSSLengthValueHandler.isAbsoluteUnit(fontSizeValue.getUnits())) {
            throw new IllegalArgumentException("The argument \"fontSizeValue\" should be absolute.");
        }
        if (CSSLengthValueHandler.isAbsoluteUnit(relativeValue.getUnits())) {
            return relativeValue;
        }
        if ("em".equals(relativeValue.getUnits())) {
            return new DimensionValue(fontSizeValue.getMeasure() * relativeValue.getMeasure(), fontSizeValue.getUnits());
        }
        if ("ex".equals(relativeValue.getUnits())) {
            return new DimensionValue(fontSizeValue.getMeasure() * relativeValue.getMeasure() / 2.0, fontSizeValue.getUnits());
        }
        if ("%".equals(relativeValue.getUnits())) {
            return new DimensionValue(fontSizeValue.getMeasure() * relativeValue.getMeasure() / 100.0, fontSizeValue.getUnits());
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    static boolean isAbsoluteUnit(String unit) {
        return DimensionUtil.isAbsoluteUnit(unit) || "px".equalsIgnoreCase(unit);
    }
}

