/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.command.AbstractPropertyCommand;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.ContentElementCommand;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.MemberRecord;
import org.eclipse.birt.report.model.command.NameCommand;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.StyleCommand;
import org.eclipse.birt.report.model.command.ThemeCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class PropertyCommand
extends AbstractPropertyCommand {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.command.PropertyCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PropertyCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void setProperty(String propName, Object value) throws SemanticException {
        this.checkAllowedOperation();
        propName = StringUtil.trimString(propName);
        ElementPropertyDefn prop = this.element.getPropertyDefn(propName);
        if (prop == null) {
            throw new PropertyNameException(this.element, propName);
        }
        this.setProperty(prop, value);
    }

    public void setProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        this.checkAllowedOperation();
        String propName = prop.getName();
        if (("toc".equals(propName) || "toc".equals(propName)) && value instanceof String) {
            Object oldValue = this.element.getLocalProperty(this.module, prop);
            if (oldValue != null) {
                CachedMemberRef ref = new CachedMemberRef(prop, "expressionValue");
                this.setMember(ref, value);
                return;
            }
            value = StructureFactory.createTOC((String)value);
        }
        if ("extensionName".equals(prop.getName())) {
            throw new PropertyValueException(this.element, "extensionName", value, "Error.PropertyValueException.EXTENSION_SETTING_FORBIDDEN");
        }
        String mask = this.element.getPropertyMask(this.module, prop.getName());
        if ("lock".equalsIgnoreCase(mask)) {
            throw new PropertyValueException(this.element, prop, value, "Error.PropertyValueException.VALUE_LOCKED");
        }
        if (this.element.isVirtualElement() && this.element instanceof Cell && ("colSpan".equalsIgnoreCase(propName = prop.getName()) || "rowSpan".equalsIgnoreCase(propName) || "drop".equalsIgnoreCase(propName) || "column".equalsIgnoreCase(propName))) {
            throw new PropertyValueException(this.element, prop, value, "Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN");
        }
        if (this.element instanceof MasterPage) {
            propName = prop.getName();
            if (!((MasterPage)this.element).isCustomType(this.module) && ("width".equals(propName) || "height".equals(propName))) {
                throw new SemanticError(this.element, "Error.SemanticError.CANNOT_SPECIFY_PAGE_SIZE");
            }
        }
        if ((value = this.validateValue(prop, value)) instanceof ElementRefValue && prop.getTypeCode() == 15) {
            this.checkRecursiveElementReference(prop, (ElementRefValue)value);
        }
        if (this.element instanceof GroupElement && "groupName".equals(prop.getName()) && !this.isGroupNameValidInContext((String)value)) {
            throw new NameException(this.element, (String)value, "Error.NameException.DUPLICATE");
        }
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(prop, value);
            return;
        }
        if ("refTemplateParameter".equals(prop.getName()) && value == null) {
            this.clearRefTemplateParameterProp(prop, value);
            return;
        }
        if (this.element instanceof ContentElement && !((ContentElement)this.element).isLocal()) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.element, ((ContentElement)this.element).getValueContainer());
            attrCmd.doSetProperty(prop, value);
            return;
        }
        this.doSetProperty(prop, value);
    }

    private void clearRefTemplateParameterProp(ElementPropertyDefn prop, Object value) throws SemanticException {
        this.checkAllowedOperation();
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !"refTemplateParameter".equals(prop.getName())) {
            throw new AssertionError();
        }
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans();
        try {
            ElementRefValue templateParam = (ElementRefValue)this.element.getProperty(this.module, prop);
            TemplateParameterDefinition definition = (TemplateParameterDefinition)templateParam.getElement();
            this.doSetProperty(prop, value);
            if (definition != null && !definition.hasReferences()) {
                ContentCommand cmd = new ContentCommand(definition.getRoot(), definition.getContainerInfo());
                cmd.remove(definition);
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void doSetProperty(ElementPropertyDefn prop, Object value) throws ExtendedElementException, PropertyValueException {
        ExtendedItem extendedItem;
        Object oldValue = this.element.getLocalProperty(this.module, prop);
        if (oldValue == null && value == null) {
            return;
        }
        if (oldValue != null && value != null && oldValue.equals(value)) {
            return;
        }
        if (this.element instanceof ExtendedItem && ((extendedItem = (ExtendedItem)this.element).isExtensionModelProperty(prop.getName()) || prop.isUseOwnModel())) {
            IReportItem extElement = extendedItem.getExtendedElement();
            if (extElement == null) {
                return;
            }
            extElement.checkProperty(prop.getName(), value);
            extElement.setProperty(prop.getName(), value);
            return;
        }
        PropertyRecord record = new PropertyRecord(this.element, prop, value);
        record.setEventTarget(this.getEventTarget(prop));
        this.getActivityStack().execute(record);
    }

    private Object validateValue(ElementPropertyDefn prop, Object value) throws SemanticException {
        if (value == null) {
            return null;
        }
        Object input = value;
        if (value instanceof DesignElementHandle) {
            DesignElementHandle elementHandle = (DesignElementHandle)value;
            Module root = elementHandle.getModule();
            input = ReferenceValueUtil.needTheNamespacePrefix(elementHandle.getElement(), root, this.module);
        }
        Object retValue = null;
        try {
            retValue = prop.validateValue(this.module, input);
        }
        catch (PropertyValueException ex) {
            ex.setElement(this.element);
            ex.setPropertyName(prop.getName());
            throw ex;
        }
        if (!(retValue instanceof ElementRefValue)) {
            return retValue;
        }
        ElementRefValue refValue = (ElementRefValue)retValue;
        if (refValue.isResolved() && value instanceof DesignElementHandle && refValue.getElement() != ((DesignElementHandle)value).getElement()) {
            throw new SemanticError(this.element, new String[]{prop.getName(), refValue.getName()}, "Error.SemanticError.INVALID_ELEMENT_REF");
        }
        return retValue;
    }

    private void setIntrinsicProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        this.checkAllowedOperation();
        String propName = prop.getName();
        if ("name".equals(propName)) {
            String name = (String)value;
            NameCommand cmd = new NameCommand(this.module, this.element);
            cmd.setName(name);
        } else if ("extends".equals(propName)) {
            ExtendsCommand cmd = new ExtendsCommand(this.module, this.element);
            cmd.setExtendsRefValue((ElementRefValue)value);
        } else if ("style".equals(propName)) {
            StyleCommand cmd = new StyleCommand(this.module, this.element);
            cmd.setStyleRefValue((ElementRefValue)value);
        } else if ("units".equals(propName)) {
            this.doSetProperty(prop, value);
        } else if ("extensionName".equals(propName)) {
            this.doSetProperty(prop, value);
        } else if ("theme".equals(propName)) {
            if (!$assertionsDisabled && this.module != this.element) {
                throw new AssertionError();
            }
            ThemeCommand cmd = new ThemeCommand((Module)this.element);
            cmd.setThemeRefValue((ElementRefValue)value);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private boolean isGroupNameValidInContext(String groupName) {
        if (!$assertionsDisabled && !(this.element instanceof GroupElement)) {
            throw new AssertionError();
        }
        if (groupName == null) {
            return true;
        }
        if (this.element.getContainer() != null) {
            DesignElement tmpContainer = this.element.getContainer();
            List errors = GroupNameValidator.getInstance().validateForRenamingGroup((ListingHandle)tmpContainer.getHandle(this.module), (GroupHandle)this.element.getHandle(this.module), groupName);
            if (!errors.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public void clearProperty(String propName) throws SemanticException {
        this.setProperty(propName, null);
    }

    public void setMember(MemberRef ref, Object value) throws SemanticException {
        Object oldValue;
        this.checkAllowedOperation();
        PropertyDefn memberDefn = ref.getMemberDefn();
        ElementPropertyDefn propDefn = ref.getPropDefn();
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.assertExtendedElement(this.module, this.element, propDefn);
        if (!$assertionsDisabled && memberDefn == null) {
            throw new AssertionError();
        }
        value = memberDefn.validateValue(this.module, value);
        if (memberDefn.getTypeCode() == 13 || memberDefn.getTypeCode() == 22) {
            this.checkItemName(ref, (String)value);
        }
        if (value instanceof ElementRefValue && memberDefn.getTypeCode() == 15) {
            this.checkRecursiveElementReference(memberDefn, (ElementRefValue)value);
        }
        if ((oldValue = ref.getLocalValue(this.module, this.element)) == null && value == null) {
            return;
        }
        if (oldValue != null && value != null && oldValue.equals(value)) {
            return;
        }
        ActivityStack stack = this.getActivityStack();
        String label = ModelMessages.getMessage("Message.ChangeItem");
        stack.startTrans(label);
        this.makeLocalCompositeValue(ref);
        MemberRecord record = new MemberRecord(this.module, this.element, ref, value);
        record.setEventTarget(this.getEventTarget(ref.getPropDefn()));
        stack.execute(record);
        Structure structure = ref.getStructure(this.module, this.element);
        List semanticList = structure.validate(this.module, this.element);
        if (semanticList.size() > 0) {
            stack.rollback();
            throw (SemanticException)((Object)semanticList.get(0));
        }
        stack.commit();
    }

    private void checkAllowedOperation() {
        if (this.element != null && this.element instanceof CssStyle) {
            throw new IllegalOperationException("Error.CssException.READONLY");
        }
    }
}

