/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.StyleReferenceValidator;
import org.eclipse.birt.report.model.api.validators.UnsupportedElementValidator;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.ObjectDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefnSet;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class ElementDefn
extends ObjectDefn
implements IElementDefn {
    protected static final String HIDDEN_IN_PROPERTY_SHEET = "hide";
    protected static final String READONLY_IN_PROPERTY_SHEET = "readonly";
    protected boolean abstractElement = false;
    protected String extendsFrom = null;
    protected ElementDefn parent = null;
    protected boolean hasStyle = false;
    protected boolean isBuilt = false;
    protected String selector = null;
    protected boolean supportsUserProperties = true;
    protected ArrayList stylePropertyNames = null;
    protected ArrayList slots = null;
    protected boolean allowExtend = true;
    protected String javaClass = null;
    private SemanticTriggerDefnSet triggerDefnSet = null;
    protected Map propVisibilites = null;
    protected String xmlName;
    protected Map cachedProperties = new LinkedHashMap();
    protected boolean isContainer = false;
    protected LinkedHashMap cachedContainerProperties = null;
    protected NameConfig nameConfig = new NameConfig();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.metadata.ElementDefn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    void setJavaClass(String theClass) {
        if (!$assertionsDisabled && this.isBuilt) {
            throw new AssertionError();
        }
        this.javaClass = theClass;
    }

    void setSelector(String value) {
        this.selector = value;
    }

    void setExtends(String base) {
        if (!$assertionsDisabled && this.isBuilt) {
            throw new AssertionError();
        }
        this.extendsFrom = base;
    }

    void setSupportsUserProperties(boolean flag) {
        if (!$assertionsDisabled && this.isBuilt) {
            throw new AssertionError();
        }
        this.supportsUserProperties = flag;
    }

    public String getExtends() {
        return this.extendsFrom;
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public boolean hasStyle() {
        return this.hasStyle;
    }

    void setHasStyle(boolean flag) {
        if (!$assertionsDisabled && this.isBuilt) {
            throw new AssertionError();
        }
        this.hasStyle = flag;
    }

    public List getLocalProperties() {
        return new ArrayList(this.properties.values());
    }

    public List getProperties() {
        return new ArrayList(this.cachedProperties.values());
    }

    public IElementPropertyDefn getProperty(String propName) {
        if (!$assertionsDisabled && propName == null) {
            throw new AssertionError();
        }
        return (ElementPropertyDefn)this.cachedProperties.get(propName);
    }

    public List getContents() {
        if (this.cachedContainerProperties == null) {
            this.cachedContainerProperties = new LinkedHashMap();
            Iterator iter = this.cachedProperties.values().iterator();
            while (iter.hasNext()) {
                PropertyDefn defn = (PropertyDefn)iter.next();
                if (defn.getTypeCode() != 23) continue;
                this.cachedContainerProperties.put(defn.getName(), defn);
            }
        }
        if (this.cachedContainerProperties.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        result.addAll(this.cachedContainerProperties.values());
        return result;
    }

    public List getMethods() {
        return this.getPropertyListWithType(this.getProperties(), 18);
    }

    public List getLocalMethods() {
        return this.getPropertyListWithType(this.getLocalProperties(), 18);
    }

    public List getExpressions() {
        return this.getPropertyListWithType(this.getProperties(), 7);
    }

    public List getLocalExpressions() {
        return this.getPropertyListWithType(this.getLocalProperties(), 7);
    }

    private List getPropertyListWithType(List propList, int type) {
        ArrayList<PropertyDefn> props = new ArrayList<PropertyDefn>();
        Iterator iter = propList.iterator();
        while (iter.hasNext()) {
            PropertyDefn propDefn = (PropertyDefn)iter.next();
            if (propDefn.getTypeCode() != type) continue;
            props.add(propDefn);
        }
        return props;
    }

    protected void build() throws MetaDataException {
        if (this.isBuilt) {
            return;
        }
        this.buildDefn();
        this.buildProperties();
        if (!this.isAbstract()) {
            this.checkJavaClass();
            this.checkXmlName();
        }
        this.checkPropertyVisibilities();
        this.buildSlots();
        this.buildTriggerDefnSet();
        this.isBuilt = true;
    }

    private void checkPropertyVisibilities() throws MetaDataException {
        if (this.propVisibilites == null) {
            return;
        }
        Iterator propNames = this.propVisibilites.keySet().iterator();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            if (this.getProperty(propName) != null) continue;
            throw new MetaDataException(new String[]{this.name, propName}, "VISIBILITY_PROPERTY_NOT_FOUND");
        }
    }

    protected final void buildDefn() throws MetaDataException {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        if (this.extendsFrom != null) {
            this.parent = (ElementDefn)dd.getElement(this.extendsFrom);
            if (this.parent == null) {
                throw new MetaDataException(new String[]{this.extendsFrom, this.name}, "ELEMENT_PARENT_NOT_FOUND");
            }
            this.parent.build();
            if (this.parent.hasStyle()) {
                this.hasStyle = true;
            }
        }
        if ((this.parent == null || !this.parent.hasStyle()) && this.hasStyle) {
            SystemPropertyDefn prop = new SystemPropertyDefn();
            prop.setName("style");
            prop.setType(dd.getPropertyType(15));
            prop.setDisplayNameID("Element.ReportElement.style");
            prop.setDetails("Style");
            prop.setIntrinsic(true);
            this.addProperty(prop);
        }
        if (this.parent != null && this.parent.allowsUserProperties()) {
            this.supportsUserProperties = true;
        }
        if (this.parent != null && this.parent.isContainer) {
            this.isContainer = true;
        }
        if (this.isAbstract() && this.parent != null && !this.parent.isAbstract()) {
            throw new MetaDataException(new String[]{this.name, this.parent.getName()}, "ILLEGAL_ABSTRACT_ELEMENT");
        }
        this.buildNameConfig();
        if (this.nameConfig.nameOption == 0 || this.isAbstract()) {
            this.allowExtend = false;
        }
    }

    private void buildNameConfig() throws MetaDataException {
        if (this.parent != null) {
            if (this.nameConfig.nameSpaceID == -1) {
                this.nameConfig.nameSpaceID = this.parent.getNameSpaceID();
                this.nameConfig.holder = this.parent.nameConfig.holder;
                this.nameConfig.holderName = this.parent.nameConfig.holderName;
            } else {
                if (!this.isExtended() && this.parent.getNameSpaceID() != -1) {
                    throw new MetaDataException(new String[]{this.name}, "INVALID_NAME_OPTION");
                }
                this.nameConfig.holder = this.nameConfig.holder = MetaDataDictionary.getInstance().getElement(this.nameConfig.holderName);
            }
        } else {
            this.nameConfig.holder = MetaDataDictionary.getInstance().getElement(this.nameConfig.holderName);
        }
        if (!this.isAbstract()) {
            if (this.nameConfig.nameSpaceID == -1) {
                this.nameConfig.nameOption = 0;
            }
            if (this.nameConfig.nameSpaceID != -1 && this.nameConfig.nameOption == 0) {
                throw new MetaDataException(new String[]{this.name}, "INVALID_NAME_OPTION");
            }
            if (this.nameConfig.nameSpaceID != -1 && this.nameConfig.holder == null) {
                throw new MetaDataException(new String[]{this.name}, "INVALID_NAME_OPTION");
            }
        }
    }

    private void buildStyleProperties() throws MetaDataException {
        this.addStyleProperties();
        if ("ExtendedItem".equalsIgnoreCase(this.getName())) {
            List styles = MetaDataDictionary.getInstance().getStyle().getLocalProperties();
            int i = 0;
            while (i < styles.size()) {
                String propName = ((SystemPropertyDefn)styles.get(i)).getName();
                this.properties.put(propName, styles.get(i));
                ++i;
            }
        } else if (!this.hasStyle && this.stylePropertyNames != null || this.hasStyle && this.isContainer() && this.stylePropertyNames != null) {
            throw new MetaDataException(new String[]{this.name}, "ILLEGAL_STYLE_PROPS");
        }
    }

    protected void buildTriggerDefnSet() {
        AbstractElementValidator validator = UnsupportedElementValidator.getInstance();
        SemanticTriggerDefn triggerDefn = new SemanticTriggerDefn(validator.getName());
        triggerDefn.setValidator(validator);
        this.getTriggerDefnSet().add(triggerDefn);
        if (this.hasStyle) {
            validator = StyleReferenceValidator.getInstance();
            triggerDefn = new SemanticTriggerDefn("StyleReferenceValidator");
            triggerDefn.setValidator(validator);
            this.getTriggerDefnSet().add(triggerDefn);
        }
        List propList = this.getProperties();
        Iterator iter = propList.iterator();
        while (iter.hasNext()) {
            PropertyDefn propDefn = (PropertyDefn)iter.next();
            this.mergeTriggerDefnSet(propDefn.getTriggerDefnSet());
        }
        int slotCount = this.getSlotCount();
        int i = 0;
        while (i < slotCount) {
            SlotDefn slotDefn = (SlotDefn)this.getSlot(i);
            this.mergeTriggerDefnSet(slotDefn.getTriggerDefnSet());
            ++i;
        }
    }

    private void mergeTriggerDefnSet(SemanticTriggerDefnSet toMerge) {
        List triggerDefns = toMerge.getTriggerList();
        if (triggerDefns == null || triggerDefns.isEmpty()) {
            return;
        }
        Iterator iter = triggerDefns.iterator();
        while (iter.hasNext()) {
            SemanticTriggerDefn triggerDefn = (SemanticTriggerDefn)iter.next();
            String targetName = triggerDefn.getTargetElement();
            if (StringUtil.isBlank(targetName)) {
                this.getTriggerDefnSet().add(triggerDefn);
                continue;
            }
            ElementDefn targetDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(targetName);
            if (!this.isKindOf(targetDefn)) continue;
            this.getTriggerDefnSet().add(triggerDefn);
        }
    }

    private void checkXmlName() throws MetaDataException {
        if (StringUtil.isBlank(this.xmlName)) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_XML_NAME");
        }
    }

    private void checkJavaClass() throws MetaDataException {
        if (StringUtil.isBlank(this.javaClass)) {
            throw new MetaDataException(new String[]{this.name}, "MISSING_JAVA_CLASS");
        }
        try {
            Class<?> clazz;
            Class<?> c;
            Class<?> clazz2 = c = Class.forName(this.javaClass);
            while (clazz2.getSuperclass() != null) {
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("org.eclipse.birt.report.model.core.DesignElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz2 == clazz3) break;
                clazz2 = clazz2.getSuperclass();
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.birt.report.model.core.DesignElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2 != clazz) {
                throw new MetaDataException(new String[]{this.javaClass}, "INVALID_ELEMENT_JAVA_CLASS");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MetaDataException(new String[]{this.name, this.javaClass}, "JAVA_CLASS_LOAD_ERROR");
        }
    }

    protected void buildProperties() throws MetaDataException {
        this.buildLocalProperties();
        this.buildStyleProperties();
        this.buildCachedPropertyDefns();
    }

    protected void buildLocalProperties() throws MetaDataException {
        boolean isStyle = "Style".equals(this.name);
        Iterator iter = this.properties.values().iterator();
        while (iter.hasNext()) {
            ElementPropertyDefn prop = (ElementPropertyDefn)iter.next();
            if (prop.isStyleProperty() && !isStyle) {
                throw new MetaDataException(new String[]{this.name, prop.getName()}, "INVALID_STYLE_PROP_OPTION");
            }
            prop.build();
        }
    }

    private void buildCachedPropertyDefns() {
        ElementDefn tmpDefn = this;
        while (tmpDefn != null) {
            this.cachedProperties.putAll(tmpDefn.properties);
            tmpDefn = tmpDefn.parent;
        }
    }

    private void addStyleProperties() throws MetaDataException {
        if (!this.hasStyle()) {
            return;
        }
        if (this.isContainer()) {
            List styleProperties = MetaDataDictionary.getInstance().getStyle().getLocalProperties();
            int i = 0;
            while (i < styleProperties.size()) {
                PropertyDefn prop = (PropertyDefn)styleProperties.get(i);
                this.properties.put(prop.getName(), prop);
                ++i;
            }
        } else {
            if (this.stylePropertyNames == null) {
                return;
            }
            ElementDefn style = (ElementDefn)MetaDataDictionary.getInstance().getStyle();
            int i = 0;
            while (i < this.stylePropertyNames.size()) {
                String propName = (String)this.stylePropertyNames.get(i);
                if (this.getProperty(propName) == null) {
                    SystemPropertyDefn prop = (SystemPropertyDefn)style.getProperty(propName);
                    if (prop == null) {
                        throw new MetaDataException(new String[]{propName, this.name}, "STYLE_PROP_NOT_FOUND");
                    }
                    if (!$assertionsDisabled && !prop.isStyleProperty()) {
                        throw new AssertionError();
                    }
                    this.properties.put(prop.getName(), prop);
                }
                ++i;
            }
        }
    }

    protected void buildSlots() throws MetaDataException {
        if (this.slots != null && this.slots.size() == 0) {
            this.slots = null;
        }
        if (this.slots == null) {
            return;
        }
        int i = 0;
        while (i < this.slots.size()) {
            SlotDefn slot = (SlotDefn)this.slots.get(i);
            slot.setSlotID(i);
            slot.build();
            ++i;
        }
    }

    public List getGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        Iterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            SystemPropertyDefn prop = (SystemPropertyDefn)iter.next();
            String groupName = prop.getGroupName();
            if (groupName == null || groupNames.contains(groupName)) continue;
            groupNames.add(groupName);
        }
        return groupNames;
    }

    public boolean allowsUserProperties() {
        return this.supportsUserProperties;
    }

    void setAllowsUserProperties(boolean flag) {
        if (!$assertionsDisabled && this.isBuilt) {
            throw new AssertionError();
        }
        this.supportsUserProperties = flag;
    }

    public boolean isAbstract() {
        return this.abstractElement;
    }

    public String getSelector() {
        return this.selector;
    }

    public IElementDefn getParent() {
        return this.parent;
    }

    void addStyleProperty(String propName) {
        if (!$assertionsDisabled && this.isBuilt) {
            throw new AssertionError();
        }
        if (this.stylePropertyNames == null) {
            this.stylePropertyNames = new ArrayList();
        }
        this.stylePropertyNames.add(propName);
    }

    public int getNameSpaceID() {
        return this.nameConfig.nameSpaceID;
    }

    public int getNameOption() {
        return this.nameConfig.nameOption;
    }

    public boolean isContainer() {
        return this.slots != null || this.isContainer;
    }

    public int getSlotCount() {
        if (this.slots == null) {
            return 0;
        }
        return this.slots.size();
    }

    public boolean hasSlot(int slotID) {
        if (this.slots == null) {
            return false;
        }
        return slotID >= 0 && slotID < this.slots.size();
    }

    public ISlotDefn getSlot(int slotID) {
        if (this.slots == null) {
            return null;
        }
        if (slotID < 0 || slotID >= this.slots.size()) {
            return null;
        }
        return (SlotDefn)this.slots.get(slotID);
    }

    public boolean canContain(int slot, IElementDefn type) {
        if (this.slots == null) {
            return false;
        }
        if (slot < 0 || slot > this.slots.size() - 1) {
            return false;
        }
        return ((SlotDefn)this.slots.get(slot)).canContain(type);
    }

    public boolean isKindOf(IElementDefn type) {
        if (type == this) {
            return true;
        }
        if (type == null) {
            return false;
        }
        ElementDefn obj = this.parent;
        while (obj != null) {
            if (obj == type) {
                return true;
            }
            obj = obj.parent;
        }
        return false;
    }

    void addSlot(SlotDefn slot) {
        if (slot == null) {
            return;
        }
        if (this.slots == null) {
            this.slots = new ArrayList();
        }
        this.slots.add(slot);
    }

    void setNameSpaceID(int ns) {
        if (!$assertionsDisabled && this.isBuilt) {
            throw new AssertionError();
        }
        this.nameConfig.nameSpaceID = ns;
        if (this.nameConfig.nameSpaceID == -1) {
            this.nameConfig.nameOption = 0;
        }
    }

    void setNameOption(int choice) {
        this.nameConfig.nameOption = choice;
    }

    void setCanExtend(boolean flag) {
        this.allowExtend = flag;
    }

    public boolean canExtend() {
        if (this.nameConfig.getNameSpaceID() == -1) {
            return this.allowExtend;
        }
        IElementDefn holderDefn = this.getNameConfig().getNameContainer();
        return this.allowExtend && holderDefn != null && holderDefn.isKindOf(MetaDataDictionary.getInstance().getElement("Module"));
    }

    void setAbstract(boolean flag) {
        this.abstractElement = flag;
    }

    public IPropertyDefn findProperty(String propName) {
        return this.getProperty(propName);
    }

    public void addProperty(PropertyDefn property) throws MetaDataException {
        if (property == null) {
            return;
        }
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        if (dd.getElement(this.extendsFrom) != null) {
            ElementDefn parentTemp = (ElementDefn)dd.getElement(this.extendsFrom);
            while (parentTemp != null) {
                if (parentTemp.properties.containsKey(property.getName())) {
                    throw new MetaDataException(new String[]{property.getName(), this.name}, "DUPLICATE_PROPERTY");
                }
                parentTemp = (ElementDefn)dd.getElement(parentTemp.getExtends());
            }
        }
        if (this.hasStyle()) {
            ElementDefn styleDefn = (ElementDefn)dd.getElement("Style");
            if (styleDefn == null) {
                throw new MetaDataException(new String[]{this.name}, "STYLE_NOT_DEFINED");
            }
            if (styleDefn.properties.containsKey(property.getName())) {
                throw new MetaDataException(new String[]{property.getName(), this.name}, "DUPLICATE_PROPERTY");
            }
        }
        super.addProperty(property);
        if (property.getType() != null && property.isElementType() && !this.isContainer) {
            this.isContainer = true;
        }
    }

    public SemanticTriggerDefnSet getTriggerDefnSet() {
        if (this.triggerDefnSet == null) {
            this.triggerDefnSet = new SemanticTriggerDefnSet();
        }
        return this.triggerDefnSet;
    }

    public void addPropertyVisibility(String propName, String propVisibility) {
        if (this.propVisibilites == null) {
            this.propVisibilites = new HashMap();
        }
        this.propVisibilites.put(propName, propVisibility);
    }

    public boolean isPropertyReadOnly(String propName) {
        IElementPropertyDefn propDefn = this.getProperty(propName);
        if (propDefn == null) {
            return true;
        }
        String visibility = this.getPropertyVisibility(propDefn.getName());
        return READONLY_IN_PROPERTY_SHEET.equals(visibility);
    }

    public boolean isPropertyVisible(String propName) {
        IElementPropertyDefn propDefn = this.getProperty(propName);
        if (propDefn == null) {
            return false;
        }
        if (propDefn.getTypeCode() == 16) {
            return false;
        }
        if (((PropertyDefn)((Object)propDefn)).isElementType()) {
            return false;
        }
        String visibility = this.getPropertyVisibility(propDefn.getName());
        return !HIDDEN_IN_PROPERTY_SHEET.equals(visibility);
    }

    private String getPropertyVisibility(String propName) {
        ElementDefn elementDefn = this;
        while (elementDefn != null) {
            String visibility;
            if (elementDefn.propVisibilites != null && (visibility = (String)elementDefn.propVisibilites.get(propName)) != null) {
                return visibility;
            }
            elementDefn = elementDefn.parent;
        }
        return null;
    }

    public void setXmlName(String value) {
        this.xmlName = value;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    private boolean isExtended() {
        return this.name.equalsIgnoreCase("ExtendedItem") || MetaDataDictionary.getInstance().getExtension(this.name) != null;
    }

    public NameConfig getNameConfig() {
        return this.nameConfig;
    }

    public class NameConfig {
        protected int nameSpaceID = -1;
        protected IElementDefn holder = null;
        protected String holderName = "Module";
        protected int nameOption = 1;

        NameConfig() {
        }

        public int getNameSpaceID() {
            return this.nameSpaceID;
        }

        public IElementDefn getNameContainer() {
            return this.holder;
        }
    }
}

