/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.scripts.IScriptableObjectClassInfo;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.OverridePropertyInfo;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public final class PeerExtensionElementDefn
extends ExtensionElementDefn {
    protected IReportItemFactory reportItemFactory = null;
    protected Map overridePropertyInfoMap = new HashMap();
    private IScriptableObjectClassInfo scriptableFactory = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PeerExtensionElementDefn(String name, IReportItemFactory reportItemFactory) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && reportItemFactory == null) {
            throw new AssertionError();
        }
        this.name = name;
        this.reportItemFactory = reportItemFactory;
    }

    public IReportItemFactory getReportItemFactory() {
        return this.reportItemFactory;
    }

    public String getDisplayName() {
        String displayName;
        IMessages messages;
        if (this.displayNameKey != null && this.reportItemFactory != null && (messages = this.reportItemFactory.getMessages()) != null && !StringUtil.isBlank(displayName = messages.getMessage(this.displayNameKey, ThreadResources.getLocale()))) {
            return displayName;
        }
        return this.getName();
    }

    protected void buildProperties() throws MetaDataException {
        super.buildProperties();
        if ("org.eclipse.birt.report.model.reportItemModel".equalsIgnoreCase(this.extensionPoint)) {
            ElementDefn extendedItem = (ElementDefn)MetaDataDictionary.getInstance().getElement("ExtendedItem");
            PropertyDefn extensionName = (PropertyDefn)((Object)extendedItem.getProperty("extensionName"));
            if (this.getProperty("extensionName") == null) {
                this.properties.put("extensionName", extensionName);
                this.cachedProperties.put("extensionName", extensionName);
                this.addPropertyVisibility("extensionName", "hide");
            }
        }
        this.overrideProperty();
    }

    private void overrideProperty() {
        Set set = this.overridePropertyInfoMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ElementPropertyDefn clonedDefn;
            ElementPropertyDefn defn;
            OverridePropertyInfo propInfo;
            String propName = (String)iterator.next();
            if (this.properties.get(propName) != null || (propInfo = (OverridePropertyInfo)this.overridePropertyInfoMap.get(propName)) == null) continue;
            String units = propInfo.getAllowedUnits();
            boolean isOwn = propInfo.isUseOwnModel();
            ChoiceSet choiceSet = this.buildChoiceSet(units);
            if (choiceSet == null && !isOwn || (defn = (ElementPropertyDefn)this.cachedProperties.get(propName)) == null || (clonedDefn = (ElementPropertyDefn)this.reflectClass(defn)) == null) continue;
            if (choiceSet != null) {
                clonedDefn.allowedChoices = choiceSet;
            }
            clonedDefn.useOwnModel = isOwn;
            this.cachedProperties.put(propName, clonedDefn);
        }
    }

    private ChoiceSet buildChoiceSet(String units) {
        ArrayList<IChoice> choiceList = new ArrayList<IChoice>();
        if (units != null && units.length() > 0) {
            String[] eachUnit = units.split(",");
            int i = 0;
            while (eachUnit != null && i < eachUnit.length) {
                IChoiceSet romSet;
                IChoice romChoice;
                String unit = eachUnit[i];
                if (unit != null && unit.length() > 0 && (romChoice = (romSet = MetaDataDictionary.getInstance().getChoiceSet("units")).findChoice(unit)) != null) {
                    choiceList.add(romChoice);
                }
                ++i;
            }
        }
        if (choiceList.size() == 0) {
            return null;
        }
        ChoiceSet choiceSet = new ChoiceSet();
        IChoice[] choices = new Choice[choiceList.size()];
        choiceList.toArray(choices);
        choiceSet.setChoices(choices);
        return choiceSet;
    }

    private PropertyDefn reflectClass(PropertyDefn defn) {
        String className = defn.getClass().getName();
        try {
            Class<?> clazz = Class.forName(className);
            PropertyDefn clonedDefn = (PropertyDefn)clazz.newInstance();
            Class<?> ownerClass = defn.getClass();
            Class<?> clonedClass = clonedDefn.getClass();
            this.shadowCopyProperties(defn, clonedDefn, ownerClass, clonedClass);
            return clonedDefn;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }

    private void shadowCopyProperties(PropertyDefn defn, PropertyDefn clonedDefn, Class ownerClass, Class clonedClass) {
        if (ownerClass == null || clonedClass == null) {
            return;
        }
        Field[] fields = ownerClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            try {
                Object property = field.get(defn);
                Field clonedField = ownerClass.getDeclaredField(field.getName());
                clonedField.set(clonedDefn, property);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            ++i;
        }
        this.shadowCopyProperties(defn, clonedDefn, ownerClass.getSuperclass(), clonedClass.getSuperclass());
    }

    protected void setOverridePropertyInfo(String prop, OverridePropertyInfo propInfo) {
        this.overridePropertyInfoMap.put(prop, propInfo);
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public IScriptableObjectClassInfo getScriptableFactory() {
        return this.scriptableFactory;
    }

    void setScriptableFactory(IScriptableObjectClassInfo scriptableFactory) {
        this.scriptableFactory = scriptableFactory;
    }
}

