/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.I3DRenderEvent;
import org.eclipse.birt.chart.event.IRenderInstruction;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.MarkerInstruction;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;

public final class DeferredCache {
    public static final int FLUSH_PLANE = 1;
    public static final int FLUSH_LINE = 2;
    public static final int FLUSH_MARKER = 4;
    public static final int FLUSH_LABLE = 8;
    public static final int FLUSH_3D = 16;
    public static final int FLUSH_PLANE_SHADOW = 32;
    public static final int FLUSH_ALL = 63;
    private final IDeviceRenderer idr;
    private final ArrayList alPlanes = new ArrayList(16);
    private final ArrayList alLines = new ArrayList(16);
    private final ArrayList alMarkers = new ArrayList(16);
    private final ArrayList alLabels = new ArrayList(16);
    private final ArrayList alPlaneShadows = new ArrayList(4);
    private List al3D = new ArrayList(16);
    private final boolean bTransposed;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/factory");

    public DeferredCache(IDeviceRenderer idr, Chart c) {
        this.idr = idr;
        this.bTransposed = c instanceof ChartWithAxes && ((ChartWithAxes)c).isTransposed();
    }

    public final void addPlane(PrimitiveRenderEvent pre, int iInstruction) {
        try {
            if (pre instanceof I3DRenderEvent) {
                this.al3D.add(new WrappedInstruction(this, pre.copy(), iInstruction));
            } else {
                this.alPlanes.add(new WrappedInstruction(this, pre.copy(), iInstruction));
            }
        }
        catch (ChartException ufex) {
            logger.log((Exception)((Object)ufex));
        }
    }

    public final void addPlaneShadow(PrimitiveRenderEvent pre, int iInstruction) {
        try {
            if (pre instanceof I3DRenderEvent) {
                this.al3D.add(new WrappedInstruction(this, pre.copy(), iInstruction));
            } else {
                this.alPlaneShadows.add(new WrappedInstruction(this, pre.copy(), iInstruction));
            }
        }
        catch (ChartException ufex) {
            logger.log((Exception)((Object)ufex));
        }
    }

    public final void addModel(WrappedInstruction wi) {
        this.alPlanes.add(wi);
    }

    public final void addLine(LineRenderEvent lre) {
        if (lre instanceof I3DRenderEvent) {
            if (lre.getLineAttributes() != null && lre.getLineAttributes().isSetVisible() && lre.getLineAttributes().isVisible()) {
                this.al3D.add(lre.copy());
            }
        } else {
            this.alLines.add(lre.copy());
        }
    }

    public final void addLabel(TextRenderEvent tre) {
        if (tre instanceof I3DRenderEvent) {
            this.al3D.add(tre.copy());
        } else {
            this.alLabels.add(tre.copy());
        }
    }

    public final void addMarker(PrimitiveRenderEvent pre, int iInstruction, double iMarkerSize) {
        try {
            if (pre instanceof I3DRenderEvent) {
                this.al3D.add(new MarkerInstruction(this, pre.copy(), iInstruction, iMarkerSize));
            } else {
                this.alMarkers.add(new MarkerInstruction(this, pre.copy(), iInstruction, iMarkerSize));
            }
        }
        catch (ChartException ufex) {
            logger.log((Exception)((Object)ufex));
        }
    }

    public final void flush() throws ChartException {
        this.flushOptions(63);
    }

    public final void flushOptions(int options) throws ChartException {
        PrimitiveRenderEvent pre;
        int j;
        List al;
        IRenderInstruction wi;
        int i;
        if ((options & 0x20) == 32) {
            Collections.sort(this.alPlaneShadows);
            i = 0;
            while (i < this.alPlaneShadows.size()) {
                wi = (IRenderInstruction)this.alPlaneShadows.get(i);
                if (wi.isModel()) {
                    al = wi.getModel();
                    j = 0;
                    while (j < al.size()) {
                        pre = (PrimitiveRenderEvent)al.get(j);
                        pre.fill(this.idr);
                        pre.draw(this.idr);
                        ++j;
                    }
                } else {
                    wi.getEvent().iObjIndex = i + 1;
                    switch (wi.getInstruction()) {
                        case 3: {
                            wi.getEvent().fill(this.idr);
                            wi.getEvent().draw(this.idr);
                            break;
                        }
                        case 2: {
                            wi.getEvent().fill(this.idr);
                            break;
                        }
                        case 1: {
                            wi.getEvent().draw(this.idr);
                        }
                    }
                }
                ++i;
            }
            this.alPlaneShadows.clear();
        }
        if ((options & 1) == 1) {
            Collections.sort(this.alPlanes);
            i = 0;
            while (i < this.alPlanes.size()) {
                wi = (IRenderInstruction)this.alPlanes.get(i);
                if (wi.isModel()) {
                    al = wi.getModel();
                    j = 0;
                    while (j < al.size()) {
                        pre = (PrimitiveRenderEvent)al.get(j);
                        pre.fill(this.idr);
                        pre.draw(this.idr);
                        ++j;
                    }
                } else {
                    wi.getEvent().iObjIndex = i + 1;
                    switch (wi.getInstruction()) {
                        case 3: {
                            wi.getEvent().fill(this.idr);
                            wi.getEvent().draw(this.idr);
                            break;
                        }
                        case 2: {
                            wi.getEvent().fill(this.idr);
                            break;
                        }
                        case 1: {
                            wi.getEvent().draw(this.idr);
                        }
                    }
                }
                ++i;
            }
            this.alPlanes.clear();
        }
        if ((options & 2) == 2) {
            i = 0;
            while (i < this.alLines.size()) {
                LineRenderEvent lre = (LineRenderEvent)this.alLines.get(i);
                lre.draw(this.idr);
                ++i;
            }
            this.alLines.clear();
        }
        if ((options & 4) == 4) {
            Collections.sort(this.alMarkers);
            i = 0;
            while (i < this.alMarkers.size()) {
                wi = (IRenderInstruction)this.alMarkers.get(i);
                switch (wi.getInstruction()) {
                    case 3: {
                        wi.getEvent().fill(this.idr);
                        wi.getEvent().draw(this.idr);
                        break;
                    }
                    case 2: {
                        wi.getEvent().fill(this.idr);
                        break;
                    }
                    case 1: {
                        wi.getEvent().draw(this.idr);
                    }
                }
                ++i;
            }
            this.alMarkers.clear();
        }
        if ((options & 8) == 8) {
            i = 0;
            while (i < this.alLabels.size()) {
                TextRenderEvent tre = (TextRenderEvent)this.alLabels.get(i);
                tre.draw(this.idr);
                ++i;
            }
            this.alLabels.clear();
        }
        if ((options & 0x10) == 16) {
            i = 0;
            while (i < this.al3D.size()) {
                Object obj = this.al3D.get(i);
                if (obj instanceof IRenderInstruction) {
                    wi = (WrappedInstruction)obj;
                    if (wi.isModel()) {
                        List al2 = wi.getModel();
                        int j2 = 0;
                        while (j2 < al2.size()) {
                            PrimitiveRenderEvent pre2 = (PrimitiveRenderEvent)al2.get(j2);
                            pre2.fill(this.idr);
                            pre2.draw(this.idr);
                            ++j2;
                        }
                    } else {
                        wi.getEvent().iObjIndex = i + 1;
                        switch (wi.getInstruction()) {
                            case 3: {
                                wi.getEvent().fill(this.idr);
                                wi.getEvent().draw(this.idr);
                                break;
                            }
                            case 2: {
                                wi.getEvent().fill(this.idr);
                                break;
                            }
                            case 1: {
                                wi.getEvent().draw(this.idr);
                            }
                        }
                    }
                } else if (obj instanceof LineRenderEvent) {
                    ((LineRenderEvent)obj).draw(this.idr);
                } else if (obj instanceof TextRenderEvent) {
                    ((TextRenderEvent)obj).draw(this.idr);
                }
                ++i;
            }
            this.al3D.clear();
        }
    }

    public void process3DEvent(Engine3D engine, double xOffset, double yOffset) {
        this.al3D = engine.processEvent(this.al3D, xOffset, yOffset);
    }

    public boolean isTransposed() {
        return this.bTransposed;
    }
}

