/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.logging.events.cbe.impl;

import org.eclipse.hyades.internal.logging.core.internationalization.InternationalizationUtilities;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;
import org.eclipse.tptp.logging.events.cbe.AssociatedEvent;
import org.eclipse.tptp.logging.events.cbe.AssociationEngine;
import org.eclipse.tptp.logging.events.cbe.EventFactory;
import org.eclipse.tptp.logging.events.cbe.MissingPropertyException;
import org.eclipse.tptp.logging.events.cbe.ValidationException;
import org.eclipse.tptp.logging.events.cbe.impl.AssociationEngineImpl;

public class AssociatedEventImpl
implements AssociatedEvent {
    private static final long serialVersionUID = -4327879421885580788L;
    private String associationEngine = null;
    private String resolvedEvents = null;
    private AssociationEngine associationEngineInfo = null;

    protected AssociatedEventImpl() {
    }

    public void setAssociationEngine(String associationEngine) {
        this.associationEngine = associationEngine;
    }

    public String getAssociationEngine() {
        return this.associationEngine;
    }

    public void setAssociationEngineInfo(AssociationEngine associationEngineInfo) {
        this.associationEngineInfo = associationEngineInfo;
    }

    public void setAssociationEngineInfo(String associationEngineName, String associationEngineType, String associationEngineId) {
        AssociationEngine associationEngine = EventFactory.eINSTANCE.createAssociationEngine();
        associationEngine.setName(associationEngineName);
        associationEngine.setType(associationEngineType);
        associationEngine.setId(associationEngineId);
        this.setAssociationEngineInfo(associationEngine);
    }

    public AssociationEngine getAssociationEngineInfo() {
        return this.associationEngineInfo;
    }

    public void setResolvedEvents(String resolvedEvents) {
        this.resolvedEvents = resolvedEvents;
    }

    public String getResolvedEvents() {
        return this.resolvedEvents;
    }

    public void setResolvedEventsAsArray(String[] resolvedEventsArray) throws IllegalArgumentException {
        StringBuffer buffer;
        if (resolvedEventsArray != null) {
            buffer = new StringBuffer();
            int counter = 0;
            while (counter < resolvedEventsArray.length) {
                if (resolvedEventsArray[counter].indexOf(" ") != -1) {
                    throw new IllegalArgumentException("Blanks are not permitted in the array element [" + resolvedEventsArray[counter] + "]");
                }
                buffer.append(" ");
                buffer.append(resolvedEventsArray[counter].trim());
                ++counter;
            }
        } else {
            throw new IllegalArgumentException("The input array cannot be null.");
        }
        this.setResolvedEvents(buffer.toString().trim());
    }

    public String[] getResolvedEventsAsArray() {
        String resolvedEvents = this.getResolvedEvents();
        if (resolvedEvents != null) {
            return InternationalizationUtilities.tokenize((String)resolvedEvents);
        }
        return new String[0];
    }

    public void addResolvedEvent(String globalInstanceId) throws IllegalArgumentException {
        if (globalInstanceId != null) {
            if (this.resolvedEvents == null) {
                this.setResolvedEvents(globalInstanceId);
            } else if (this.resolvedEvents.indexOf(globalInstanceId) == -1) {
                this.setResolvedEvents(this.resolvedEvents.trim().concat(" ").concat(globalInstanceId.trim()));
            }
        } else {
            throw new IllegalArgumentException("The input string cannot be null.");
        }
    }

    public void clearResolvedEvents() {
        this.resolvedEvents = null;
    }

    public void removeResolvedEvent(String globalInstanceId) {
        if (globalInstanceId != null) {
            if (this.resolvedEvents != null) {
                int index;
                while ((index = this.resolvedEvents.indexOf(globalInstanceId)) != -1) {
                    this.setResolvedEvents(this.resolvedEvents.substring(0, index).trim().concat(" ").concat(this.resolvedEvents.substring(index + globalInstanceId.length()).trim()));
                }
            }
        } else {
            throw new IllegalArgumentException("The input string cannot be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        AssociatedEventImpl associatedEventImpl = this;
        synchronized (associatedEventImpl) {
            block6: {
                block5: {
                    if (this != object) break block5;
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) break block6;
                Object thisObjectsProperty = this.getAssociationEngine();
                Object parameterObjectsProperty = ((AssociatedEventImpl)object).getAssociationEngine();
                if ((thisObjectsProperty == null || !thisObjectsProperty.equals(parameterObjectsProperty)) && (thisObjectsProperty != null || parameterObjectsProperty != null)) break block6;
                thisObjectsProperty = this.getAssociationEngineInfo();
                parameterObjectsProperty = ((AssociatedEventImpl)object).getAssociationEngineInfo();
                if ((thisObjectsProperty == null || !thisObjectsProperty.equals(parameterObjectsProperty)) && (thisObjectsProperty != null || parameterObjectsProperty != null)) break block6;
                thisObjectsProperty = this.getResolvedEvents();
                parameterObjectsProperty = ((AssociatedEventImpl)object).getResolvedEvents();
                if ((thisObjectsProperty == null || !thisObjectsProperty.equals(parameterObjectsProperty)) && (thisObjectsProperty != null || parameterObjectsProperty != null)) break block6;
                return true;
            }
            return false;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (associationEngine: ");
        result.append(this.associationEngine);
        result.append(", resolvedEvents: ");
        result.append(this.resolvedEvents);
        result.append(", associationEngineInfo: ");
        result.append(this.associationEngineInfo);
        result.append(')');
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws ValidationException {
        AssociatedEventImpl associatedEventImpl = this;
        synchronized (associatedEventImpl) {
            if (this.resolvedEvents == null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString((String)"LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_", (Object)"CommonBaseEvent.AssociatedEvent.ResolvedEvents"));
            }
            if (this.associationEngine == null && this.associationEngineInfo == null || this.associationEngine != null && this.associationEngineInfo != null) {
                throw new MissingPropertyException(LoggingCoreResourceBundle.getString((String)"LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_", (Object)"CommonBaseEvent.AssociatedEvent.AssociationEngine", (Object)"CommonBaseEvent.AssociatedEvent.AssociationEngineInfo"));
            }
            String[] resolvedEventsArray = this.getResolvedEventsAsArray();
            int counter = 0;
            while (counter < resolvedEventsArray.length) {
                if (resolvedEventsArray[counter].length() < 32 || resolvedEventsArray[counter].length() > 64) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_", (Object)"CommonBaseEvent.AssociatedEvent.ResolvedEvents[".concat(String.valueOf(counter + 1)).concat("]"), (Object)resolvedEventsArray[counter]));
                }
                if (!Character.isLetter(resolvedEventsArray[counter].charAt(0))) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_", (Object)"CommonBaseEvent.AssociatedEvent.ResolvedEvents[".concat(String.valueOf(counter + 1)).concat("]"), (Object)resolvedEventsArray[counter]));
                }
                ++counter;
            }
            if (this.associationEngineInfo != null) {
                this.associationEngineInfo.validate();
            } else {
                if (this.associationEngine.length() < 32 || this.associationEngine.length() > 64) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_GLOBAL_INSTANCE_ID_LENGTH_EXC_", (Object)"CommonBaseEvent.AssociatedEvent.AssociationEngine", (Object)this.associationEngine));
                }
                if (!Character.isLetter(this.associationEngine.charAt(0))) {
                    throw new ValidationException(LoggingCoreResourceBundle.getString((String)"LOG_INVALID_GLOBAL_INSTANCE_ID_EXC_", (Object)"CommonBaseEvent.AssociatedEvent.AssociationEngine", (Object)this.associationEngine));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        AssociatedEventImpl associatedEventImpl = this;
        synchronized (associatedEventImpl) {
            AssociatedEventImpl copy = (AssociatedEventImpl)super.clone();
            if (this.associationEngine != null) {
                copy.setAssociationEngine(new String(this.associationEngine));
            }
            if (this.associationEngineInfo != null) {
                try {
                    copy.setAssociationEngineInfo((AssociationEngine)((AssociationEngineImpl)this.associationEngineInfo).clone());
                }
                catch (ClassCastException classCastException) {}
            }
            if (this.resolvedEvents != null) {
                copy.setResolvedEvents(new String(this.resolvedEvents));
            }
            return copy;
        }
    }

    public void init() {
        this.setAssociationEngine(null);
        this.setAssociationEngineInfo(null);
        this.setResolvedEvents(null);
    }
}

