/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.util.HashMap;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.engine.aggregation.BuiltInAggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class AggregationFactory {
    private static final String ATTRIBUTE_AGGREGATION_CLASS = "aggregationClass";
    private static final String ATTRIBUTE_AGGREGATION_NAME = "name";
    private static final String EXTENSION_POINT = "org.eclipse.birt.data.aggregation";
    private static final String ELEMENT_AGGREGATIONS = "Aggregations";
    private static final String ELEMENT_AGGREGATION = "Aggregation";
    private static AggregationFactory instance = null;
    private static HashMap aggregations = null;
    private static final String TOTAL_RUNNING_COUNT_FUNC = "RUNNING-COUNT";
    private static final String TOTAL_WEIGHTED_AVE_FUNC = "WEIGHTED-AVG";
    private static final String TOTAL_MOVING_AVE_FUNC = "MOVING-AVE";
    private static final String TOTAL_RUNNING_SUM_FUNC = "RUNNING-SUM";
    private static final String TOTAL_RUNNING_NPV_FUNC = "RUNNING-NPV";
    private static final String TOTAL_COUNT_DISTINCT_FUNC = "COUNT-DISTINCT";
    private static final String TOTAL_COUNT_AVERAGE_FUNC = "AVERAGE";
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AggregationFactory getInstance() throws DataException {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.aggregation.AggregationFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new AggregationFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void destroyInstance() {
        instance = null;
        aggregations = null;
    }

    private AggregationFactory() throws DataException {
        this.populateAggregations();
    }

    private void populateAggregations() throws DataException {
        aggregations = new HashMap();
        this.populateBuiltInAggregations();
        this.populateExtendedAggregations();
    }

    private void populateBuiltInAggregations() {
        String[] builtInAggrNames = BuiltInAggregationFactory.getInstance().getAggregationNames();
        int i = 0;
        while (i < builtInAggrNames.length) {
            aggregations.put(builtInAggrNames[i], BuiltInAggregationFactory.getInstance().getAggregation(builtInAggrNames[i]));
            ++i;
        }
    }

    private void populateExtendedAggregations() throws DataException {
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(EXTENSION_POINT);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        if (exts == null) {
            return;
        }
        int e = 0;
        while (e < exts.length) {
            IConfigurationElement[] configElems = exts[e].getConfigurationElements();
            if (configElems != null) {
                int i = 0;
                while (i < configElems.length) {
                    if (configElems[i].getName().equals(ELEMENT_AGGREGATIONS)) {
                        IConfigurationElement[] subElems = configElems[i].getChildren(ELEMENT_AGGREGATION);
                        int j = 0;
                        while (j < subElems.length) {
                            String name = subElems[j].getAttribute(ATTRIBUTE_AGGREGATION_NAME);
                            try {
                                if (aggregations.put(name.toUpperCase().trim(), subElems[j].createExecutableExtension(ATTRIBUTE_AGGREGATION_CLASS)) != null) {
                                    throw new DataException("date.engine.DuplicateAggregationName", name);
                                }
                            }
                            catch (FrameworkException frameworkException) {
                                DataException ep = new DataException("data.engine.CannotInstantiateAggregationFactory", name);
                                throw ep;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++e;
        }
    }

    public IAggregation getAggregation(String name) {
        IAggregation aggr = (IAggregation)aggregations.get(name.toUpperCase());
        if (aggr == null) {
            aggr = this.getAdaptableAggregation(name.toUpperCase());
        }
        return aggr;
    }

    private IAggregation getAdaptableAggregation(String name) {
        IAggregation aggr = null;
        if (TOTAL_WEIGHTED_AVE_FUNC.equals(name)) {
            aggr = (IAggregation)aggregations.get("WEIGHTEDAVE");
        } else if (TOTAL_MOVING_AVE_FUNC.equals(name)) {
            aggr = (IAggregation)aggregations.get("MOVINGAVE");
        } else if (TOTAL_RUNNING_SUM_FUNC.equals(name)) {
            aggr = (IAggregation)aggregations.get("RUNNINGSUM");
        } else if (TOTAL_COUNT_DISTINCT_FUNC.equals(name)) {
            aggr = (IAggregation)aggregations.get("COUNTDISTINCT");
        } else if (TOTAL_RUNNING_COUNT_FUNC.equals(name)) {
            aggr = (IAggregation)aggregations.get("RUNNINGCOUNT");
        } else if (TOTAL_RUNNING_NPV_FUNC.equals(name)) {
            aggr = (IAggregation)aggregations.get("RUNNINGNPV");
        } else if (TOTAL_COUNT_AVERAGE_FUNC.equals(name)) {
            aggr = (IAggregation)aggregations.get("AVE");
        }
        return aggr;
    }
}

