/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.aggregation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.Aggregation;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.cache.BasicCachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.odi.IAggrDefnManager;
import org.eclipse.birt.data.engine.odi.IAggrInfo;
import org.eclipse.birt.data.engine.odi.IAggrValueHolder;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class AggregationHelper
implements IAggrValueHolder {
    private IAggrDefnManager manager;
    private ResultSetPopulator populator;
    private List[] currentRoundAggrValue;
    private Object[][] aggrArgs;
    private int currentAggrCount;
    private AccumulatorManager[] accumulatorManagers;
    private Set invalidAggrSet;
    private Map invalidAggrMsg;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.aggregation.AggregationHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public AggregationHelper(IAggrDefnManager manager, ResultSetPopulator populator) throws DataException {
        this.populator = populator;
        this.manager = manager;
        this.currentRoundAggrValue = new List[0];
        this.populateAggregations();
    }

    private void populateAggregations() throws DataException {
        this.currentAggrCount = this.manager.getAggrCount();
        if (this.currentAggrCount > 0) {
            this.currentRoundAggrValue = new List[this.currentAggrCount];
            this.aggrArgs = new Object[this.currentAggrCount][];
            int i = 0;
            while (i < this.currentAggrCount) {
                this.currentRoundAggrValue[i] = new BasicCachedList();
                IAggrInfo aggrInfo = this.manager.getAggrDefn(i);
                this.aggrArgs[i] = new Object[aggrInfo.getAggregation().getParameterDefn().length];
                ++i;
            }
            this.accumulatorManagers = new AccumulatorManager[this.currentAggrCount];
        }
        this.calculate();
    }

    private void calculate() throws DataException {
        ArrayList<Integer> validAggregations = new ArrayList<Integer>();
        boolean[] populateAggrValue = new boolean[this.currentAggrCount];
        int count = 1;
        int i = 0;
        while (i < this.currentAggrCount) {
            validAggregations.add(new Integer(i));
            populateAggrValue[i] = !(this.getAggrInfo(i).getAggregation() instanceof Aggregation) || ((Aggregation)this.getAggrInfo(i).getAggregation()).getNumberOfPasses() <= 1;
            this.accumulatorManagers[i] = new AccumulatorManager(this.getAggrInfo(i).getAggregation());
            ++i;
        }
        while (validAggregations.size() > 0) {
            int[] validAggregationArray = new int[validAggregations.size()];
            int i2 = 0;
            while (i2 < validAggregations.size()) {
                validAggregationArray[i2] = (Integer)validAggregations.get(i2);
                ++i2;
            }
            if (!$assertionsDisabled && this.getCurrentResultIndex() != 0) {
                throw new AssertionError();
            }
            if (this.getCurrentResult() == null) {
                return;
            }
            this.pass(populateAggrValue, validAggregationArray);
            this.first(0);
            this.prepareNextIteration(validAggregations, populateAggrValue, ++count);
        }
    }

    private void pass(boolean[] populateAggrValue, int[] validAggregationArray) throws DataException {
        do {
            int startingGroupLevel = this.getStartingGroupLevel();
            int endingGroupLevel = this.getEndingGroupLevel();
            int i = 0;
            while (i < validAggregationArray.length) {
                int index = validAggregationArray[i];
                if (this.invalidAggrSet != null && this.invalidAggrSet.contains(new Integer(index))) {
                    this.addInvalidAggrMsg(index, endingGroupLevel);
                } else if (!this.onRow(index, startingGroupLevel, endingGroupLevel, populateAggrValue[index])) {
                    this.addInvalidAggrMsg(index, endingGroupLevel);
                    if (this.invalidAggrSet == null) {
                        this.invalidAggrSet = new HashSet();
                    }
                    this.invalidAggrSet.add(new Integer(index));
                }
                ++i;
            }
        } while (this.populator.getResultIterator().next());
    }

    private void addInvalidAggrMsg(int index, int endingGroupLevel) throws DataException {
        if (!$assertionsDisabled && this.invalidAggrMsg == null) {
            throw new AssertionError();
        }
        if (this.getAggrInfo(index).getAggregation().getType() == 1 || endingGroupLevel <= this.getAggrInfo(index).getGroupLevel()) {
            this.currentRoundAggrValue[index].add(this.invalidAggrMsg.get(new Integer(index)));
        }
    }

    private boolean onRow(int aggrIndex, int startingGroupLevel, int endingGroupLevel, boolean populateValue) throws DataException {
        Object value;
        boolean isRunning;
        IAggrInfo aggrInfo = this.getAggrInfo(aggrIndex);
        Accumulator acc = null;
        boolean newGroup = false;
        boolean[] argDefs = aggrInfo.getAggregation().getParameterDefn();
        if (startingGroupLevel <= aggrInfo.getGroupLevel()) {
            acc = this.accumulatorManagers[aggrIndex].next();
            acc.start();
            newGroup = true;
        } else {
            acc = this.accumulatorManagers[aggrIndex].getCurrentAccumulator();
        }
        boolean accepted = true;
        if (aggrInfo.getFilter() != null) {
            try {
                Object filterResult = ExprEvaluateUtil.evaluateValue(aggrInfo.getFilter(), this.populator.getCache().getCurrentIndex(), this.populator.getCache().getCurrentResult(), this.populator.getQuery().getExprProcessor().getScope());
                accepted = filterResult == null ? true : DataTypeUtil.toBoolean((Object)filterResult);
            }
            catch (BirtException e) {
                if (this.invalidAggrMsg == null) {
                    this.invalidAggrMsg = new HashMap();
                }
                this.invalidAggrMsg.put(new Integer(aggrIndex), e);
                return false;
            }
        }
        if (aggrInfo.getCalcualteLevel() > 0 && startingGroupLevel > aggrInfo.getCalcualteLevel()) {
            accepted = false;
        }
        if (accepted) {
            if (!$assertionsDisabled && argDefs.length != this.aggrArgs[aggrIndex].length) {
                throw new AssertionError();
            }
            try {
                if (aggrInfo.getArgument().length > argDefs.length && !this.isFunctionCount(aggrInfo)) {
                    throw new DataException("Invalid aggregation definition");
                }
                int i = 0;
                while (i < argDefs.length) {
                    if (argDefs[i] || newGroup) {
                        IBaseExpression argExpr = aggrInfo.getArgument()[i];
                        try {
                            this.aggrArgs[aggrIndex][i] = ExprEvaluateUtil.evaluateValue(argExpr, this.populator.getCache().getCurrentIndex(), this.populator.getCache().getCurrentResult(), this.populator.getQuery().getExprProcessor().getScope());
                        }
                        catch (BirtException e) {
                            throw DataException.wrap(e);
                        }
                    }
                    ++i;
                }
                acc.onRow(this.aggrArgs[aggrIndex]);
                newGroup = false;
            }
            catch (DataException e) {
                if (this.invalidAggrMsg == null) {
                    this.invalidAggrMsg = new HashMap();
                }
                this.invalidAggrMsg.put(new Integer(aggrIndex), e);
                return false;
            }
        }
        boolean bl = isRunning = aggrInfo.getAggregation().getType() == 1;
        if (isRunning && populateValue) {
            value = acc.getValue();
            this.currentRoundAggrValue[aggrIndex].add(value);
        }
        if (endingGroupLevel <= aggrInfo.getGroupLevel()) {
            acc.finish();
            if (!isRunning && populateValue) {
                value = acc.getValue();
                this.currentRoundAggrValue[aggrIndex].add(value);
            }
        }
        return true;
    }

    private boolean isFunctionCount(IAggrInfo aggrInfo) {
        String funcName = aggrInfo.getAggregation().getName();
        return "COUNT".equals(funcName) || "RUNNINGCOUNT".equals(funcName);
    }

    private void prepareNextIteration(List validAggregations, boolean[] populateAggrValue, int count) throws DataException {
        validAggregations.clear();
        int i = 0;
        while (i < this.currentAggrCount) {
            int passesNumber;
            this.accumulatorManagers[i].restart();
            IAggregation temp = this.getAggrInfo(i).getAggregation();
            populateAggrValue[i] = false;
            if (temp instanceof Aggregation && count <= (passesNumber = ((Aggregation)temp).getNumberOfPasses())) {
                validAggregations.add(new Integer(i));
                if (count == passesNumber) {
                    populateAggrValue[i] = true;
                }
            }
            ++i;
        }
    }

    private IAggrInfo getAggrInfo(int i) throws DataException {
        return this.manager.getAggrDefn(i);
    }

    private int getStartingGroupLevel() throws DataException {
        return this.populator.getResultIterator().getStartingGroupLevel();
    }

    private int getEndingGroupLevel() throws DataException {
        return this.populator.getResultIterator().getEndingGroupLevel();
    }

    private int getCurrentGroupIndex(int groupLevel) throws DataException {
        return this.populator.getResultIterator().getCurrentGroupIndex(groupLevel);
    }

    private int getCurrentResultIndex() throws DataException {
        return this.populator.getResultIterator().getCurrentResultIndex();
    }

    private IResultObject getCurrentResult() throws DataException {
        return this.populator.getResultIterator().getCurrentResult();
    }

    private void first(int groupLevel) throws DataException {
        this.populator.getResultIterator().first(groupLevel);
    }

    public Object getAggrValue(String name) throws DataException {
        IAggrInfo aggrInfo = this.manager.getAggrDefn(name);
        if (this.populator.getCache().getCount() == 0) {
            if (aggrInfo.getAggregation().getName().equalsIgnoreCase("COUNT") || aggrInfo.getAggregation().getName().equalsIgnoreCase("COUNTDISTINCT")) {
                return new Integer(0);
            }
            return null;
        }
        int groupIndex = aggrInfo.getAggregation().getType() == 0 ? (aggrInfo.getGroupLevel() == 0 ? 0 : this.getCurrentGroupIndex(aggrInfo.getGroupLevel())) : this.getCurrentResultIndex();
        return this.currentRoundAggrValue[this.manager.getAggrDefnIndex(name)].get(groupIndex);
    }

    public boolean hasAggr(String name) throws DataException {
        return this.manager.getAggrDefnIndex(name) != -1;
    }

    private class AccumulatorManager {
        private IAggregation aggregation;
        private int cursor;
        private List cachedAcc;
        private Accumulator accumulator;

        AccumulatorManager(IAggregation aggregation) {
            this.aggregation = aggregation;
            this.cursor = -1;
            int passNum = 0;
            if (aggregation instanceof Aggregation) {
                passNum = ((Aggregation)aggregation).getNumberOfPasses();
            }
            if (passNum < 2) {
                this.accumulator = aggregation.newAccumulator();
            } else {
                this.cachedAcc = new ArrayList();
            }
        }

        Accumulator getCurrentAccumulator() {
            if (this.accumulator != null) {
                return this.accumulator;
            }
            if (this.cachedAcc.size() == 0) {
                this.cachedAcc.add(this.aggregation.newAccumulator());
            }
            return (Accumulator)this.cachedAcc.get(this.cursor);
        }

        Accumulator next() {
            if (this.accumulator != null) {
                return this.accumulator;
            }
            ++this.cursor;
            if (this.cachedAcc.size() > this.cursor) {
                return (Accumulator)this.cachedAcc.get(this.cursor);
            }
            this.cachedAcc.add(this.aggregation.newAccumulator());
            return (Accumulator)this.cachedAcc.get(this.cursor);
        }

        void restart() {
            this.cursor = -1;
        }
    }
}

