/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;

public class ExprManagerUtil {
    private ExprManager exprManager;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ExprManagerUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    private ExprManagerUtil(ExprManager em) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ExprManagerUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "ExprManagerUtil", em);
        this.exprManager = em;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ExprManagerUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "ExprManagerUtil");
    }

    public static void validateColumnBinding(ExprManager exprManager, IBaseQueryDefinition baseQueryDefn) throws DataException {
        ExprManagerUtil util = new ExprManagerUtil(exprManager);
        util.checkColumnBindingExpression(baseQueryDefn);
        util.checkDependencyCycle();
        util.checkGroupNameValidation();
    }

    private void checkGroupNameValidation() throws DataException {
        HashMap map = this.getGroupKeys();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Integer level = (Integer)it.next();
            this.exprManager.setEntryGroupLevel(level);
            if (ExpressionCompilerUtil.hasColumnRow(map.get(level).toString(), this.exprManager)) continue;
            this.exprManager.setEntryGroupLevel(0);
            if (!this.isColumnBindingExist(map.get(level).toString())) {
                throw new DataException("data.engine.ColumnBindingNotExist", map.get(level).toString());
            }
            throw new DataException("data.engine.InvalidGroupKeyName", new Object[]{map.get(level).toString(), level});
        }
        this.exprManager.setEntryGroupLevel(0);
    }

    private boolean isColumnBindingExist(String columnName) throws DataException {
        List bindings = this.exprManager.getBindingExprs();
        int i = 0;
        while (i < bindings.size()) {
            GroupBindingColumn gbc = (GroupBindingColumn)bindings.get(i);
            if (gbc.getExpression(columnName) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void checkDependencyCycle() throws DataException {
        ArrayList<Node> result = new ArrayList<Node>();
        Iterator it = this.getColumnNames().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            Node n = new Node(name);
            IBaseExpression expr = this.exprManager.getExpr(name);
            if (expr != null) {
                if (!(expr instanceof IScriptExpression) && !(expr instanceof IConditionalExpression)) {
                    throw new DataException("data.engine.BadDataExpression");
                }
                List l = null;
                try {
                    if (expr instanceof IScriptExpression) {
                        l = ExpressionCompilerUtil.extractColumnExpression((IScriptExpression)expr);
                    } else if (expr instanceof IConditionalExpression) {
                        l = ExpressionCompilerUtil.extractColumnExpression((IConditionalExpression)expr);
                    }
                }
                catch (DataException dataException) {}
                if (l != null) {
                    int j = 0;
                    while (j < l.size()) {
                        n.addChild(new Node(l.get(j) == null ? null : l.get(j).toString()));
                        ++j;
                    }
                }
            }
            result.add(n);
        }
        Node[] source = new Node[result.size()];
        int i = 0;
        while (i < source.length) {
            source[i] = (Node)result.get(i);
            ++i;
        }
        this.validateNodes(source);
    }

    private void checkColumnBindingExpression(IBaseQueryDefinition baseQueryDefn) throws DataException {
        List list = this.getColumnNames();
        int i = 0;
        while (i < list.size()) {
            block13: {
                String name = list.get(i).toString();
                IBaseExpression expr = this.exprManager.getExpr(name);
                if (expr != null) {
                    if (!(expr instanceof IScriptExpression) && !(expr instanceof IConditionalExpression)) {
                        throw new DataException("data.engine.BadDataExpression");
                    }
                    List l = null;
                    try {
                        if (expr instanceof IScriptExpression) {
                            l = ExpressionCompilerUtil.extractColumnExpression((IScriptExpression)expr);
                        } else if (expr instanceof IConditionalExpression) {
                            l = ExpressionCompilerUtil.extractColumnExpression((IConditionalExpression)expr);
                        }
                    }
                    catch (DataException dataException) {}
                    if (l != null) {
                        int j = 0;
                        while (j < l.size()) {
                            this.checkColumnBindingExist(l.get(j).toString(), list);
                            ++j;
                        }
                    }
                    List usedBindings = null;
                    if (expr instanceof IScriptExpression) {
                        try {
                            usedBindings = ExpressionUtil.extractColumnExpressions((String)((IScriptExpression)expr).getText(), (boolean)true);
                        }
                        catch (BirtException birtException) {
                            break block13;
                        }
                        this.validateReferredColumnBinding(name, usedBindings, baseQueryDefn);
                    }
                }
            }
            ++i;
        }
    }

    private void checkColumnBindingExist(String bindingName, List binding) throws DataException {
        if ("__rownum".equals(bindingName) || "_outer".equals(bindingName)) {
            return;
        }
        int i = 0;
        while (i < binding.size()) {
            if (bindingName.equals(binding.get(i).toString())) {
                return;
            }
            ++i;
        }
        throw new DataException("data.engine.ColumnBindingNotExist", bindingName);
    }

    private void validateReferredColumnBinding(String bindingName, List usedBindings, IBaseQueryDefinition baseQueryDefn) throws DataException {
        List nameList = this.getColumnNames();
        int i = 0;
        while (i < usedBindings.size()) {
            String name;
            IColumnBinding cb = (IColumnBinding)usedBindings.get(i);
            if (!this.useDefinedKeyWord(cb) && !nameList.contains(name = ((IColumnBinding)usedBindings.get(i)).getResultSetColumnName()) && baseQueryDefn != null) {
                String expr = this.findExpression(name, baseQueryDefn.getParentQuery());
                if (expr == null) {
                    throw new DataException("data.engine.ColumnBindingReferToInexistColumn");
                }
                if (ExpressionUtil.hasAggregation((String)expr)) {
                    throw new DataException("data.engine.ColumnBindingReferToAggregationColumnBindingInParentQuery", bindingName);
                }
            }
            ++i;
        }
    }

    private String findExpression(String columnBindingName, IBaseQueryDefinition queryDefn) {
        if (queryDefn == null) {
            return null;
        }
        if (queryDefn.getBindings().get(columnBindingName) == null) {
            return this.findExpression(columnBindingName, queryDefn.getParentQuery());
        }
        IBaseExpression expr = (IBaseExpression)((Object)((IBinding)queryDefn.getBindings().get(columnBindingName)));
        if (expr instanceof IScriptExpression) {
            return ((IScriptExpression)expr).getText();
        }
        return null;
    }

    private boolean useDefinedKeyWord(IColumnBinding cb) {
        return cb.getOuterLevel() > 0 || cb.getResultSetColumnName().equals("__rownum") || cb.getResultSetColumnName().equals("_rowPosition");
    }

    private void validateNodes(Node[] source) throws DataException {
        Node[] preparedNodes = this.populateNodeList(source);
        int i = 0;
        while (i < preparedNodes.length) {
            this.isValidNode(preparedNodes[i], preparedNodes[i]);
            ++i;
        }
    }

    private void isValidNode(Node startNode, Node candidateNode) throws DataException {
        Object[] nodes = startNode.getChildren().toArray();
        int i = 0;
        while (i < nodes.length) {
            if (candidateNode.equals(nodes[i]) || startNode.equals(nodes[i])) {
                throw new DataException("data.engine.ColumnBindingCycle", ((Node)nodes[i]).getValue());
            }
            this.isValidNode((Node)nodes[i], candidateNode);
            ++i;
        }
    }

    private Node[] populateNodeList(Node[] source) {
        Node[] result = new Node[source.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new Node(source[i].getValue());
            ++i;
        }
        i = 0;
        while (i < result.length) {
            List l = source[i].getChildren();
            int j = 0;
            while (j < l.size()) {
                Node n = this.getMatchedNode((Node)l.get(j), result);
                if (n != null) {
                    result[i].addChild(n);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private Node getMatchedNode(Node node, Node[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i].equals(node)) {
                return nodes[i];
            }
            ++i;
        }
        return null;
    }

    private List getColumnNames() {
        List bindingExprs = this.exprManager.getBindingExprs();
        Map autoBindingExprMap = this.exprManager.getAutoBindingExprMap();
        ArrayList l = new ArrayList();
        l.addAll(autoBindingExprMap.keySet());
        int i = 0;
        while (i < bindingExprs.size()) {
            l.addAll(((GroupBindingColumn)bindingExprs.get(i)).getColumnNames());
            ++i;
        }
        return l;
    }

    private HashMap getGroupKeys() {
        List bindingExprs = this.exprManager.getBindingExprs();
        HashMap<Integer, String> l = new HashMap<Integer, String>();
        int i = 0;
        while (i < bindingExprs.size()) {
            String key = ((GroupBindingColumn)bindingExprs.get(i)).getGroupKey();
            Integer groupLevel = new Integer(((GroupBindingColumn)bindingExprs.get(i)).getGroupLevel());
            if (key != null) {
                l.put(groupLevel, key);
            }
            ++i;
        }
        return l;
    }

    public static class Node {
        private List children;
        private String value;

        public Node(String value) {
            this.value = value;
            this.children = new ArrayList();
        }

        String getValue() {
            return this.value;
        }

        void addChild(Node n) {
            this.children.add(n);
        }

        List getChildren() {
            return this.children;
        }

        public boolean equals(Object o) {
            return o instanceof Node && ((Node)o).value.equals(this.value);
        }
    }
}

