/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IJoinCondition;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.JointDataSetQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache;
import org.eclipse.birt.data.engine.executor.dscache.DataSourceQuery;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetCacheUtil;
import org.eclipse.birt.data.engine.impl.JointDataSetParameterUtil;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.jointdataset.IJoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.JoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.JointDataSetPopulatorFactory;
import org.eclipse.birt.data.engine.impl.jointdataset.JointResultMetadata;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;

public class PreparedJointDataSourceQuery
extends PreparedDataSourceQuery {
    private static final String COLUMN_NAME_SPLITTER = "::";
    private static final String TEMP_COLUMN_STRING = ".*$TEMP_.*";
    private IJointDataSetDesign dataSet;
    private IDataSetPopulator populator;
    private IResultClass resultClass;
    private ResultIterator left;
    private ResultIterator right;
    private IJoinConditionMatcher matcher;
    private int joinType;
    private DataEngineImpl dataEngine;
    private IBaseDataSetDesign dataSetDesign;
    private Map appContext;
    private Collection parameterBindings;
    private IQueryResults leftQueryResults;
    private IQueryResults rightQueryResults;
    private IResultMetaData leftResultMetaData;
    private IResultMetaData rightResultMetaData;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.PreparedJointDataSourceQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    PreparedJointDataSourceQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        super(dataEngine, queryDefn, dataSetDesign, appContext);
        Object[] params = new Object[]{dataEngine, queryDefn, dataSetDesign, appContext};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.PreparedJointDataSourceQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "PreparedJointDataSourceQuery", params);
        this.dataEngine = dataEngine;
        this.dataSetDesign = dataSetDesign;
        this.appContext = appContext;
        this.parameterBindings = queryDefn.getInputParamBindings();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.PreparedJointDataSourceQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "PreparedJointDataSourceQuery");
    }

    private void initialize(DataEngineImpl dataEngine, Map appContext) throws DataException {
        int savedCacheOption = this.getDataSetCacheManager().suspendCache();
        try {
            ResultIterator left = (ResultIterator)this.leftQueryResults.getResultIterator();
            ResultIterator right = (ResultIterator)this.rightQueryResults.getResultIterator();
            this.getDataSetCacheManager().setCacheOption(savedCacheOption);
            this.getDataSetCacheManager().setCacheMode(DataSetCacheUtil.getCacheMode(appContext));
            this.left = left;
            this.right = right;
            this.joinType = this.dataSet.getJoinType();
            this.matcher = new JoinConditionMatcher(left.getOdiResult(), right.getOdiResult(), left.getScope(), right.getScope(), this.dataSet.getJoinConditions());
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private void initializeResultClass(DataEngineImpl dataEngine, Map appContext) throws DataException {
        try {
            IResultMetaData leftMetaData = this.leftResultMetaData;
            IResultMetaData rightMetaData = this.rightResultMetaData;
            JointResultMetadata meta = this.getJointResultMetadata(leftMetaData, rightMetaData);
            this.resultClass = meta.getResultClass();
        }
        catch (BirtException be) {
            throw DataException.wrap(be);
        }
    }

    private void setCurrentDataSet(IBaseDataSetDesign dataSetDesign) {
        this.dataSet = (IJointDataSetDesign)dataSetDesign;
    }

    private JointResultMetadata getJointResultMetadata(IResultMetaData left, IResultMetaData right) throws DataException {
        if (left == null || right == null) {
            throw new DataException("data.engine.UnexpectedError");
        }
        try {
            String leftPrefix = this.getDataSetName(this.dataSet.getLeftDataSetDesignName());
            String rightPrefix = this.getDataSetName(this.dataSet.getRightDataSetDesignName());
            if (leftPrefix.equals(rightPrefix)) {
                leftPrefix = String.valueOf(leftPrefix) + "1";
                rightPrefix = String.valueOf(rightPrefix) + "2";
            }
            leftPrefix = String.valueOf(leftPrefix) + COLUMN_NAME_SPLITTER;
            rightPrefix = String.valueOf(rightPrefix) + COLUMN_NAME_SPLITTER;
            JointResultMetadata meta = this.populatorJointResultMetadata(left, leftPrefix, right, rightPrefix);
            return meta;
        }
        catch (BirtException be) {
            throw DataException.wrap(be);
        }
    }

    private String getDataSetName(String qualifiedName) {
        return ExpressionUtil.getDataSetNameWithoutPrefix((String)qualifiedName);
    }

    private Class getTypeClass(int typeCode) {
        return DataType.getClass((int)typeCode);
    }

    private int getTempColumnSize(IResultMetaData metaData) throws BirtException {
        int size = 0;
        int i = 1;
        while (i <= metaData.getColumnCount()) {
            if (this.isTempColumn(metaData.getColumnName(i))) {
                ++size;
            } else if (!$assertionsDisabled && size != 0) {
                throw new AssertionError();
            }
            ++i;
        }
        return size;
    }

    private boolean isTempColumn(String columnName) {
        if (columnName.length() < 7) {
            return false;
        }
        return columnName.matches(TEMP_COLUMN_STRING);
    }

    private JointResultMetadata populatorJointResultMetadata(IResultMetaData left, String leftPrefix, IResultMetaData right, String rightPrefix) throws DataException {
        try {
            int leftTempColumnSize = this.getTempColumnSize(left);
            int rightTempColumnSize = this.getTempColumnSize(right);
            int length = left.getColumnCount() - leftTempColumnSize + (right.getColumnCount() - rightTempColumnSize) + (this.dataSet.getComputedColumns() == null ? 0 : this.dataSet.getComputedColumns().size());
            int[] index = new int[length];
            int[] columnSource = new int[length];
            ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
            int i = 1;
            while (i <= left.getColumnCount() - leftTempColumnSize) {
                index[i - 1] = i;
                columnSource[i - 1] = 1;
                projectedColumns.add(new ResultFieldMetadata(i, String.valueOf(leftPrefix) + left.getColumnName(i), String.valueOf(leftPrefix) + left.getColumnName(i), this.getTypeClass(left.getColumnType(i)), left.getColumnNativeTypeName(i), false));
                ++i;
            }
            i = left.getColumnCount() - leftTempColumnSize + 1;
            while (i <= left.getColumnCount() - leftTempColumnSize + (right.getColumnCount() - rightTempColumnSize)) {
                index[i - 1] = i - (left.getColumnCount() - leftTempColumnSize);
                columnSource[i - 1] = 2;
                projectedColumns.add(new ResultFieldMetadata(i, String.valueOf(rightPrefix) + right.getColumnName(i - (left.getColumnCount() - leftTempColumnSize)), String.valueOf(rightPrefix) + right.getColumnName(i - (left.getColumnCount() - leftTempColumnSize)), this.getTypeClass(right.getColumnType(i - (left.getColumnCount() - leftTempColumnSize))), right.getColumnNativeTypeName(i - (left.getColumnCount() - leftTempColumnSize)), false));
                ++i;
            }
            if (this.dataSet.getComputedColumns() != null) {
                i = 0;
                while (i < this.dataSet.getComputedColumns().size()) {
                    IComputedColumn cc = (IComputedColumn)this.dataSet.getComputedColumns().get(i);
                    index[i + (left.getColumnCount() - leftTempColumnSize) + (right.getColumnCount() - rightTempColumnSize)] = -1;
                    columnSource[i + (left.getColumnCount() - leftTempColumnSize) + (right.getColumnCount() - rightTempColumnSize)] = 0;
                    projectedColumns.add(new ResultFieldMetadata(i, cc.getName(), cc.getName(), DataType.getClass((int)cc.getDataType()), null, true));
                    ++i;
                }
            }
            if (this.dataSet.getResultSetHints() != null) {
                List hintList = this.dataSet.getResultSetHints();
                int i2 = 0;
                while (i2 < hintList.size()) {
                    IColumnDefinition columnDefinition = (IColumnDefinition)hintList.get(i2);
                    int j = 0;
                    while (j < projectedColumns.size()) {
                        ResultFieldMetadata resultFieldMetadata = (ResultFieldMetadata)projectedColumns.get(j);
                        if (columnDefinition.getColumnName().equals(resultFieldMetadata.getName())) {
                            resultFieldMetadata.setAlias(columnDefinition.getAlias());
                            break;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            ResultClass resultClass = new ResultClass(projectedColumns);
            return new JointResultMetadata(resultClass, columnSource, index);
        }
        catch (BirtException be) {
            throw DataException.wrap(be);
        }
    }

    private void setParameterBindings(DataEngineImpl dataEngine, String dataSetDesignName, boolean isLeftDataSet, QueryDefinition queryDefinition) throws DataException {
        IBaseDataSetDesign dataSetDesign = dataEngine.getDataSetDesign(dataSetDesignName);
        if (dataSetDesign == null) {
            throw new DataException("data.engine.UndefinedDataSet", dataSetDesignName);
        }
        Iterator it = dataSetDesign.getParameters().iterator();
        if (it.hasNext()) {
            Iterator bindingIt = this.parameterBindings.iterator();
            while (bindingIt.hasNext()) {
                InputParameterBinding iipb = (InputParameterBinding)bindingIt.next();
                if (!JointDataSetParameterUtil.isDatasetParameter(dataSetDesignName, isLeftDataSet, iipb.getName())) continue;
                queryDefinition.addInputParamBinding(new InputParameterBinding(JointDataSetParameterUtil.extractParameterName(iipb.getName()), iipb.getExpr()));
            }
        }
    }

    private void addSortToQuery(IJoinCondition condition, boolean isLeftDataSet, IQueryDefinition query) {
        IScriptExpression sortExpression = isLeftDataSet ? condition.getLeftExpression() : condition.getRightExpression();
        SortDefinition sort = new SortDefinition();
        sort.setExpression(sortExpression.getText());
        query.getSorts().add(sort);
    }

    protected QueryExecutor newExecutor() {
        return new JointDataSetQueryExecutor();
    }

    public Collection getParameterMetaData() throws BirtException {
        return null;
    }

    private void populatePreparedQuery() throws BirtException {
        this.leftQueryResults = this.populatePreparedQuery(true, this.dataSet.getLeftDataSetDesignName());
        this.leftResultMetaData = this.leftQueryResults.getResultMetaData();
        this.rightQueryResults = this.populatePreparedQuery(false, this.dataSet.getRightDataSetDesignName());
        this.rightResultMetaData = this.rightQueryResults.getResultMetaData();
    }

    private IQueryResults populatePreparedQuery(boolean isLeftDataSet, String dataSetName) throws DataException {
        List conditions = this.dataSet.getJoinConditions();
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setDataSetName(dataSetName);
        this.setParameterBindings(this.dataEngine, dataSetName, isLeftDataSet, queryDefinition);
        int i = 0;
        while (i < conditions.size()) {
            this.addSortToQuery((IJoinCondition)conditions.get(i), isLeftDataSet, queryDefinition);
            ++i;
        }
        IPreparedQuery preparedQuery = PreparedQueryUtil.newInstance(this.dataEngine, queryDefinition, this.appContext);
        try {
            return preparedQuery.execute(null);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private class JointDataSetQueryExecutor
    extends PreparedDataSourceQuery.DSQueryExecutor {
        private IPreparedDSQuery odiPreparedQuery;

        private JointDataSetQueryExecutor() {
        }

        public IPreparedDSQuery getPreparedOdiQuery() {
            return this.odiPreparedQuery;
        }

        protected IDataSource createOdiDataSource() throws DataException {
            return null;
        }

        protected IQuery createOdiQuery() throws DataException {
            PreparedJointDataSourceQuery.this.setCurrentDataSet(PreparedJointDataSourceQuery.this.dataSetDesign);
            try {
                PreparedJointDataSourceQuery.this.populatePreparedQuery();
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            PreparedJointDataSourceQuery.this.initializeResultClass(PreparedJointDataSourceQuery.this.dataEngine, PreparedJointDataSourceQuery.this.appContext);
            return new JointDataSetQuery(PreparedJointDataSourceQuery.this.resultClass);
        }

        protected IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            if (this.doesLoadFromCache()) {
                DataSourceQuery dsQuery = new DataSourceQuery(PreparedJointDataSourceQuery.this.dataEngine.getSession());
                JointDataSetQuery jointQuery = (JointDataSetQuery)this.odiQuery;
                dsQuery.setExprProcessor(jointQuery.getExprProcessor());
                List fetchEvents = jointQuery.getFetchEvents();
                if (fetchEvents != null) {
                    int i = 0;
                    while (i < fetchEvents.size()) {
                        dsQuery.addOnFetchEvent((IResultObjectEvent)fetchEvents.get(i));
                        ++i;
                    }
                }
                dsQuery.setMaxRows(jointQuery.getMaxRows());
                dsQuery.setOrdering(this.toList(jointQuery.getOrdering()));
                dsQuery.setGrouping(this.toList(jointQuery.getGrouping()));
                return dsQuery.execute(eventHandler);
            }
            PreparedJointDataSourceQuery.this.initialize(PreparedJointDataSourceQuery.this.dataEngine, PreparedJointDataSourceQuery.this.appContext);
            JointResultMetadata jrm = PreparedJointDataSourceQuery.this.getJointResultMetadata(PreparedJointDataSourceQuery.this.left.getResultMetaData(), PreparedJointDataSourceQuery.this.right.getResultMetaData());
            PreparedJointDataSourceQuery.this.resultClass = jrm.getResultClass();
            PreparedJointDataSourceQuery.this.populator = JointDataSetPopulatorFactory.getBinaryTreeDataSetPopulator(PreparedJointDataSourceQuery.this.left.getOdiResult(), PreparedJointDataSourceQuery.this.right.getOdiResult(), jrm, PreparedJointDataSourceQuery.this.matcher, PreparedJointDataSourceQuery.this.joinType, PreparedJointDataSourceQuery.this.dataEngine.getSession(), PreparedJointDataSourceQuery.this.dataSetDesign.getRowFetchLimit());
            if (!this.doesSaveToCache()) {
                return new CachedResultSet((BaseQuery)this.odiQuery, PreparedJointDataSourceQuery.this.resultClass, PreparedJointDataSourceQuery.this.populator, eventHandler, PreparedJointDataSourceQuery.this.dataEngine.getSession());
            }
            return new CachedResultSet((BaseQuery)this.odiQuery, PreparedJointDataSourceQuery.this.resultClass, new DataSetResultCache(PreparedJointDataSourceQuery.this.populator, PreparedJointDataSourceQuery.this.resultClass, PreparedJointDataSourceQuery.this.dataEngine.getSession()), eventHandler, PreparedJointDataSourceQuery.this.dataEngine.getSession());
        }

        private List toList(Object[] obs) {
            if (obs == null) {
                return null;
            }
            ArrayList<Object> obList = new ArrayList<Object>();
            int i = 0;
            while (i < obs.length) {
                obList.add(obs[i]);
                ++i;
            }
            return obList;
        }

        private boolean doesLoadFromCache() {
            PreparedJointDataSourceQuery self = PreparedJointDataSourceQuery.this;
            return PreparedJointDataSourceQuery.this.getDataSetCacheManager().doesLoadFromCache(null, PreparedJointDataSourceQuery.this.dataSetDesign, null, PreparedJointDataSourceQuery.this.appContext, DataSetCacheUtil.getCacheOption(self.dataEngine.getContext(), PreparedJointDataSourceQuery.this.appContext), DataSetCacheUtil.getCacheCount(self.dataEngine.getContext(), PreparedJointDataSourceQuery.this.appContext));
        }

        private boolean doesSaveToCache() {
            return PreparedJointDataSourceQuery.this.getDataSetCacheManager().doesSaveToCache();
        }
    }
}

