/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseTransform;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedSubquery;
import org.eclipse.birt.data.engine.impl.QueryDefinitionCopyUtil;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.ServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

final class PreparedQuery {
    private IBaseQueryDefinition baseQueryDefn;
    private DataEngineContext dataEngineContext;
    private DataEngineSession session;
    private ExpressionCompiler expressionCompiler;
    private IPreparedQueryService queryService;
    private AggregateTable aggrTable;
    private Map appContext;
    private HashMap subQueryMap;
    private HashMap subQueryDefnMap;
    private static Logger logger;
    private ExprManager exprManager;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.PreparedQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.DataEngineImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    PreparedQuery(DataEngineSession session, DataEngineContext deContext, IBaseQueryDefinition queryDefn, IPreparedQueryService queryService, Map appContext) throws DataException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.PreparedQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINE, clazz.getName(), "PreparedQuery", "PreparedQuery starts up.");
        if (!$assertionsDisabled && queryDefn == null) {
            throw new AssertionError();
        }
        this.expressionCompiler = new ExpressionCompiler();
        this.expressionCompiler.setDataSetMode(false);
        this.dataEngineContext = deContext;
        this.session = session;
        this.baseQueryDefn = QueryDefinitionCopyUtil.copy(queryDefn);
        this.queryService = queryService;
        this.appContext = appContext;
        this.exprManager = new ExprManager(this.baseQueryDefn);
        this.subQueryMap = new HashMap();
        this.subQueryDefnMap = new HashMap();
        this.aggrTable = new AggregateTable(this.session.getSharedScope(), this.baseQueryDefn.getGroups());
        logger.fine("Start to prepare a PreparedQuery.");
        this.prepare();
        logger.fine("Finished preparing the PreparedQuery.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepare() throws DataException {
        Context cx = Context.enter();
        try {
            if (this.baseQueryDefn.getBindings() != null && this.baseQueryDefn.getBindings().size() > 0) {
                this.expressionCompiler.setDataSetMode(false);
            }
            List groups = this.baseQueryDefn.getGroups();
            HashSet<String> groupNameSet = new HashSet<String>();
            int i = 0;
            while (i < groups.size()) {
                IGroupDefinition group = (IGroupDefinition)groups.get(i);
                if (group.getName() != null && group.getName().trim().length() != 0) {
                    int j = 0;
                    while (j < groups.size()) {
                        if (group.getName().equals(((IGroupDefinition)groups.get(j)).getName() == null ? "" : ((IGroupDefinition)groups.get(j)).getName()) && j != i) {
                            throw new DataException("data.engine.DuplicateGroupName");
                        }
                        ++j;
                    }
                    groupNameSet.add(group.getName());
                }
                ++i;
            }
            Map map = this.baseQueryDefn.getBindings();
            if (map != null) {
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    IBinding binding = (IBinding)map.get(key);
                    String groupName = null;
                    if (binding.getExpression() != null) {
                        groupName = binding.getExpression().getGroupName();
                    }
                    if (groupName == null) {
                        if (binding.getAggregatOns().size() == 0) continue;
                        groupName = binding.getAggregatOns().get(0).toString();
                    }
                    if (groupName.equals("Total.OVERALL") || groupNameSet.contains(groupName)) continue;
                    throw new DataException("data.engine.GroupNotExist", new Object[]{groupName, key});
                }
            }
            this.mappingParentColumnBinding();
            int i2 = 0;
            while (i2 <= groups.size()) {
                this.prepareGroup(this.baseQueryDefn, i2, cx);
                ++i2;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var10_16 = null;
        }
        Context.exit();
    }

    private void mappingParentColumnBinding() throws DataException {
        IBaseQueryDefinition queryDef = this.baseQueryDefn;
        while (queryDef instanceof ISubqueryDefinition) {
            queryDef = queryDef.getParentQuery();
            Map parentBindings = queryDef.getBindings();
            this.addParentBindings(parentBindings);
        }
    }

    private void addParentBindings(Map parentBindings) throws DataException {
        Iterator it = parentBindings.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            IBaseExpression expr = ((IBinding)parentBindings.get(o)).getExpression();
            if (!(expr instanceof IScriptExpression) || ExpressionUtil.hasAggregation((String)((IScriptExpression)expr).getText()) || this.baseQueryDefn.getBindings().get(o) != null) continue;
            Binding binding = new Binding(o.toString());
            binding.setExpression(this.copyScriptExpr(expr));
            this.baseQueryDefn.addBinding(binding);
        }
    }

    private ScriptExpression copyScriptExpr(IBaseExpression expr) {
        ScriptExpression se = new ScriptExpression(((IScriptExpression)expr).getText(), ((IScriptExpression)expr).getDataType());
        return se;
    }

    private void prepareGroup(IBaseQueryDefinition baseQuery, int groupLevel, Context cx) throws DataException {
        IBaseTransform trans = baseQuery;
        String groupName = "Total.OVERALL";
        if (groupLevel != 0) {
            IGroupDefinition igd = (IGroupDefinition)trans.getGroups().get(groupLevel - 1);
            trans = igd;
            groupName = igd.getName();
        }
        ArrayList<IBaseExpression> exprCol = new ArrayList<IBaseExpression>();
        HashMap resultSetExpressions = new HashMap();
        Map map = baseQuery.getBindings();
        if (map != null) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                IBinding icbe = (IBinding)map.get(key);
                if (icbe.getExpression() != null && icbe.getExpression().getGroupName().equals(groupName) && groupLevel != 0) {
                    exprCol.add(icbe.getExpression());
                    resultSetExpressions.put(key, icbe);
                    continue;
                }
                if (groupLevel == 0 && icbe.getAggregatOns().size() == 0) {
                    exprCol.add(icbe.getExpression());
                    resultSetExpressions.put(key, icbe);
                    continue;
                }
                if (groupLevel == 0 || !icbe.getAggregatOns().contains(groupName)) continue;
                exprCol.add(icbe.getExpression());
                resultSetExpressions.put(key, icbe);
            }
        }
        this.prepareExpressions(exprCol, groupLevel, false, true, cx);
        String key = null;
        if (trans instanceof IGroupDefinition) {
            IGroupDefinition gd = (IGroupDefinition)trans;
            key = gd.getKeyColumn() != null ? gd.getKeyColumn() : gd.getKeyExpression();
        }
        this.exprManager.addBindingExpr(key, resultSetExpressions, groupLevel);
        Collection subQueries = trans.getSubqueries();
        Iterator subIt = subQueries.iterator();
        while (subIt.hasNext()) {
            ISubqueryDefinition subquery = (ISubqueryDefinition)subIt.next();
            PreparedSubquery pq = new PreparedSubquery(this.session, this.dataEngineContext, subquery, this.queryService, groupLevel);
            this.subQueryMap.put(subquery.getName(), pq);
            this.subQueryDefnMap.put(subquery.getName(), new Object[]{subquery, new Integer(groupLevel)});
        }
    }

    private void prepareExpressions(Collection expressions, int groupLevel, boolean afterGroup, boolean isDetailedRow, Context cx) throws DataException {
        if (expressions == null) {
            return;
        }
        AggregateRegistry reg = this.aggrTable.getAggrRegistry(groupLevel, -1, isDetailedRow, cx);
        Iterator it = expressions.iterator();
        while (it.hasNext()) {
            this.prepareExpression((IBaseExpression)it.next(), groupLevel, cx, reg);
        }
    }

    private void prepareExpression(IBaseExpression expr, int groupLevel, Context cx, AggregateRegistry reg) {
        ExpressionCompiler compiler = this.expressionCompiler;
        if (expr instanceof IScriptExpression) {
            String exprText = ((IScriptExpression)expr).getText();
            CompiledExpression handle = compiler.compile(exprText, reg, cx);
            expr.setHandle(handle);
        } else if (expr instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)expr;
            ce = this.transformConditionalExpression(ce);
            this.prepareExpression(ce.getExpression(), groupLevel, cx, reg);
            if (ce.getOperand1() != null) {
                this.prepareExpression(ce.getOperand1(), groupLevel, cx, reg);
            }
            if (ce.getOperand2() != null) {
                this.prepareExpression(ce.getOperand2(), groupLevel, cx, reg);
            }
            expr.setHandle(ce);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private IConditionalExpression transformConditionalExpression(IConditionalExpression ce) {
        String prefix = null;
        switch (ce.getOperator()) {
            case 14: {
                prefix = "Total.isTopN";
                break;
            }
            case 16: {
                prefix = "Total.isTopNPercent";
                break;
            }
            case 15: {
                prefix = "Total.isBottomN";
                break;
            }
            case 17: {
                prefix = "Total.isBottomNPercent";
            }
        }
        if (prefix != null) {
            ce = new ConditionalExpression(String.valueOf(prefix) + "(" + ce.getExpression().getText() + "," + ce.getOperand1().getText() + ")", 11);
        }
        return ce;
    }

    QueryResults doPrepare(IQueryResults outerResults, Scriptable scope, QueryExecutor executor, PreparedDataSourceQuery dataSourceQuery) throws DataException {
        if (this.baseQueryDefn == null) {
            DataException e = new DataException("data.engine.PreparedQueryClosed");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.PreparedQuery");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.WARNING, clazz.getName(), "doPrepare", "PreparedQuery instance is closed.", (Throwable)((Object)e));
            throw e;
        }
        executor.setAppContext(this.appContext);
        logger.finer("Start to prepare the execution.");
        executor.prepareExecution(outerResults, scope);
        logger.finer("Finish preparing the execution.");
        QueryResults result = new QueryResults(new ServiceForQueryResults(this.dataEngineContext, executor.getQueryScope(), executor.getNestedLevel() + 1, dataSourceQuery, this.queryService, executor, this.baseQueryDefn, this.exprManager));
        if (this.baseQueryDefn.cacheQueryResults()) {
            result.setID(QueryResultIDUtil.nextID());
        }
        return result;
    }

    ISubqueryDefinition getSubQueryDefn(String subQueryName) {
        return (ISubqueryDefinition)((Object[])this.subQueryDefnMap.get(subQueryName))[0];
    }

    int getSubQueryLevel(String subQueryName) {
        return (Integer)((Object[])this.subQueryDefnMap.get(subQueryName))[1];
    }

    QueryResults execSubquery(IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
        if (!$assertionsDisabled && subQueryName == null) {
            throw new AssertionError();
        }
        PreparedSubquery subquery = (PreparedSubquery)this.subQueryMap.get(subQueryName);
        if (subquery == null) {
            DataException e = new DataException("data.engine.NoSubQueryName", subQueryName);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.PreparedQuery");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz.getName(), "execSubquery", "Subquery name not found", (Throwable)((Object)e));
            throw e;
        }
        return subquery.execute(iterator, subScope);
    }

    void close() {
        this.baseQueryDefn = null;
        this.aggrTable = null;
        this.subQueryMap = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.data.engine.impl.PreparedQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINER, clazz.getName(), "close", "Prepared query closed");
    }

    Scriptable getSharedScope() {
        return this.session.getSharedScope();
    }

    IBaseQueryDefinition getBaseQueryDefn() {
        return this.baseQueryDefn;
    }

    AggregateTable getAggrTable() {
        return this.aggrTable;
    }
}

