/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.stream;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;

public class VersionManager {
    public static final int VERSION_2_0 = 0;
    public static final int VERSION_2_1 = 1;
    public static final int VERSION_2_2 = 2;
    public static final int VERSION_2_2_0 = 10;
    public static final int VERSION_2_2_1 = 20;
    private DataEngineContext dataEngineContext;

    VersionManager(DataEngineContext context) {
        this.dataEngineContext = context;
    }

    int getVersion() {
        int version = this.getLatestVersion();
        if (!this.dataEngineContext.hasInStream(null, null, 11)) {
            version = 0;
            return version;
        }
        try {
            DataInputStream is = new DataInputStream((InputStream)this.dataEngineContext.getInputStream(null, null, 11));
            version = IOUtil.readInt((InputStream)is);
            is.close();
        }
        catch (DataException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return version;
    }

    void setVersion(int version) throws DataException {
        RAOutputStream versionOs = this.dataEngineContext.getOutputStream(null, null, 11);
        DataOutputStream versionDos = new DataOutputStream((OutputStream)versionOs);
        try {
            IOUtil.writeInt((OutputStream)versionDos, (int)version);
            versionDos.close();
            versionOs.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    int getLatestVersion() {
        return 20;
    }
}

