/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.DataTypeUtil;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ParameterMetaData {
    private int m_position = -1;
    private String m_name;
    private int m_dataType = 0;
    private String m_nativeTypeName;
    private String m_defaultValue;
    private Boolean m_isOptional;
    private Boolean m_isInput;
    private Boolean m_isOutput;
    private int m_scale = -1;
    private int m_precision = -1;
    private Boolean m_isNullable;
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.ParameterMetaData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.ParameterMetaData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz2.getName();
        sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }

    ParameterMetaData(ParameterHint paramHint, String odaDataSourceId, String dataSetType) {
        String methodName = "ParameterMetaData";
        sm_logger.entering(sm_className, methodName, paramHint);
        this.m_name = paramHint.getName();
        int position = paramHint.getPosition();
        this.m_position = position > 0 ? position : -1;
        this.m_dataType = paramHint.getEffectiveOdaType(odaDataSourceId, dataSetType);
        this.m_isOptional = paramHint.isInputOptional();
        this.m_isInput = paramHint.isInputMode();
        this.m_isOutput = paramHint.isOutputMode();
        this.m_defaultValue = paramHint.getDefaultInputValue();
        this.m_isNullable = paramHint.isNullable();
        sm_logger.exiting(sm_className, methodName, this);
    }

    ParameterMetaData(IParameterMetaData parameterMetaData, int index, String odaDataSourceId, String dataSetType) throws DataException {
        String methodName = "ParameterMetaData";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{parameterMetaData, new Integer(index), odaDataSourceId, dataSetType});
        }
        this.m_position = index;
        int nativeType = this.getRuntimeParameterType(parameterMetaData, index);
        if (nativeType != 0) {
            this.m_dataType = DataTypeUtil.toOdaType(nativeType, odaDataSourceId, dataSetType);
        }
        this.m_nativeTypeName = this.getRuntimeParamTypeName(parameterMetaData, index);
        int mode = this.getRuntimeParameterMode(parameterMetaData, index);
        if (mode == 1) {
            this.m_isInput = Boolean.TRUE;
            this.m_isOutput = Boolean.FALSE;
        } else if (mode == 3) {
            this.m_isInput = Boolean.FALSE;
            this.m_isOutput = Boolean.TRUE;
        } else if (mode == 2) {
            this.m_isInput = Boolean.TRUE;
            this.m_isOutput = Boolean.TRUE;
        }
        this.m_scale = this.getRuntimeParameterScale(parameterMetaData, index);
        this.m_precision = this.getRuntimeParameterPrecision(parameterMetaData, index);
        int isNullable = this.getRuntimeIsNullable(parameterMetaData, index);
        if (isNullable == 2) {
            this.m_isNullable = Boolean.TRUE;
        } else if (isNullable == 1) {
            this.m_isNullable = Boolean.FALSE;
            this.m_isOptional = Boolean.FALSE;
        }
        sm_logger.exiting(sm_className, methodName, this);
    }

    void updateWith(ParameterHint paramHint, String odaDataSourceId, String dataSetType) throws DataException {
        String methodName = "updateWith";
        sm_logger.entering(sm_className, methodName, paramHint);
        this.m_isInput = paramHint.isInputMode();
        this.m_isOutput = paramHint.isOutputMode();
        int position = paramHint.getPosition();
        if (!$assertionsDisabled && position > 0 && this.m_position > 0 && position != this.m_position) {
            throw new AssertionError();
        }
        if (this.m_position <= 0 && position > 0) {
            this.m_position = position;
        }
        String name = paramHint.getName();
        if (!($assertionsDisabled || name != null && name.length() > 0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_name != null && !this.m_name.equals(name)) {
            throw new AssertionError();
        }
        if (this.m_name == null) {
            this.m_name = name;
        }
        if (this.m_dataType == 0) {
            this.m_dataType = paramHint.getEffectiveOdaType(odaDataSourceId, dataSetType);
        }
        if (this.m_isOptional == null) {
            this.m_isOptional = paramHint.isInputOptional();
        }
        if (this.m_isNullable == null) {
            this.m_isNullable = paramHint.isNullable();
        }
        this.m_defaultValue = paramHint.getDefaultInputValue();
        sm_logger.exiting(sm_className, methodName, this);
    }

    private int getRuntimeParameterType(IParameterMetaData parameterMetaData, int index) throws DataException {
        String methodName = "getRuntimeParameterType";
        try {
            return parameterMetaData.getParameterType(index);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get parameter type.", ex);
            throw new DataException("odaconsumer.CannotGetParameterType", (Throwable)ex, new Object[]{new Integer(index)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get parameter type.", ex);
            throw new DataException("odaconsumer.CannotGetParameterType", (Throwable)ex, new Object[]{new Integer(index)});
        }
    }

    private String getRuntimeParamTypeName(IParameterMetaData parameterMetaData, int index) throws DataException {
        String methodName = "getRuntimeParamTypeName";
        try {
            return parameterMetaData.getParameterTypeName(index);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get parameter type name.", ex);
            throw new DataException("odaconsumer.CannotGetParameterTypeName", (Throwable)ex, new Object[]{new Integer(index)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.INFO, sm_className, methodName, "Cannot get parameter type name.", ex);
            return "";
        }
    }

    private int getRuntimeParameterMode(IParameterMetaData parameterMetaData, int index) throws DataException {
        String methodName = "getRuntimeParameterMode";
        try {
            return parameterMetaData.getParameterMode(index);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get parameter mode.", ex);
            throw new DataException("odaconsumer.CannotGetParameterMode", (Throwable)ex, new Object[]{new Integer(index)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, methodName, "Cannot get parameter mode.", ex);
            return 0;
        }
    }

    private int getRuntimeParameterScale(IParameterMetaData parameterMetaData, int index) throws DataException {
        String methodName = "getRuntimeParameterScale";
        try {
            return parameterMetaData.getScale(index);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get parameter scale.", ex);
            throw new DataException("odaconsumer.CannotGetParameterScale", (Throwable)ex, new Object[]{new Integer(index)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.INFO, sm_className, methodName, "Cannot get parameter scale.", ex);
            return -1;
        }
    }

    private int getRuntimeParameterPrecision(IParameterMetaData parameterMetaData, int index) throws DataException {
        String methodName = "getRuntimeParameterPrecision";
        try {
            return parameterMetaData.getPrecision(index);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get parameter precision.", ex);
            throw new DataException("odaconsumer.CannotGetParameterPrecision", (Throwable)ex, new Object[]{new Integer(index)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.INFO, sm_className, methodName, "Cannot get parameter precision.", ex);
            return -1;
        }
    }

    private int getRuntimeIsNullable(IParameterMetaData parameterMetaData, int index) throws DataException {
        String methodName = "getRuntimeIsNullable";
        try {
            return parameterMetaData.isNullable(index);
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get parameter nullability.", ex);
            throw new DataException("odaconsumer.CannotGetParameterIsNullable", (Throwable)ex, new Object[]{new Integer(index)});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.INFO, sm_className, methodName, "Cannot get parameter nullability.", ex);
            return 0;
        }
    }

    public int getPosition() {
        return this.m_position;
    }

    public String getName() {
        return this.m_name;
    }

    public int getDataType() {
        return this.m_dataType == 0 ? 1 : this.m_dataType;
    }

    public String getNativeTypeName() {
        return this.m_nativeTypeName;
    }

    public Boolean isOptional() {
        return this.m_isOptional;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public Boolean isInputMode() {
        return this.m_isInput;
    }

    public Boolean isOutputMode() {
        return this.m_isOutput;
    }

    public int getScale() {
        return this.m_scale;
    }

    public int getPrecision() {
        return this.m_precision;
    }

    public Boolean isNullable() {
        return this.m_isNullable;
    }
}

