/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.data.engine.olap.cursor.AbstractCursorSupport;
import org.eclipse.birt.data.engine.olap.cursor.AggregationAccessor;
import org.eclipse.birt.data.engine.olap.cursor.EdgeCursorImpl;
import org.eclipse.birt.data.engine.olap.driver.EdgeAxis;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;
import org.eclipse.birt.data.engine.olap.query.view.MeasureNameManager;

public class CubeCursorImpl
extends AbstractCursorSupport
implements CubeCursor {
    private List ordinateEdge = new ArrayList();
    private List pageEdge = new ArrayList();

    public CubeCursorImpl(BirtCubeView cubeView, IResultSet result, Map relationMap, MeasureNameManager manager) throws OLAPException {
        super(null, new AggregationAccessor(cubeView, result, relationMap, manager));
        if (result == null) {
            return;
        }
        EdgeAxis[] calculatedMemberAxis = result.getMeasureResult();
        BirtEdgeView[] calculatedMemberView = cubeView.getMeasureEdgeView();
        if (calculatedMemberAxis != null) {
            int i = 0;
            while (i < calculatedMemberAxis.length) {
                this.pageEdge.add(new EdgeCursorImpl(calculatedMemberView[i], true, calculatedMemberAxis[i], this));
                ++i;
            }
        }
        if (cubeView.getColumnEdgeView() != null) {
            this.ordinateEdge.add(new EdgeCursorImpl(cubeView.getColumnEdgeView(), false, result.getColumnEdgeResult(), this));
        }
        if (cubeView.getRowEdgeView() != null) {
            this.ordinateEdge.add(new EdgeCursorImpl(cubeView.getRowEdgeView(), false, result.getRowEdgeResult(), this));
        }
    }

    public List getOrdinateEdge() throws OLAPException {
        return this.ordinateEdge;
    }

    public Collection getPageEdge() throws OLAPException {
        return this.pageEdge;
    }

    public void synchronizePages() throws OLAPException {
    }
}

