/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.EdgeInfo;
import org.eclipse.birt.data.engine.olap.cursor.ResultSetFetcher;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;

public class EdgeInfoGenerator {
    private Vector[] edgeInfoArray;
    private IAggregationResultSet rs;
    private DimensionAxis[] dimAxis;
    private int[] dimensionCursorPosition;
    private int[] length;
    private int edgeCursor;
    private int edgeLength;
    private int mirrorStartPosition;
    private ResultSetFetcher fetcher;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.cursor.EdgeInfoGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public EdgeInfoGenerator(IAggregationResultSet resultSet, DimensionAxis[] axis, int mirrorStartPosition) {
        if (!$assertionsDisabled && resultSet == null) {
            throw new AssertionError();
        }
        if (axis.length == 0) {
            return;
        }
        this.rs = resultSet;
        this.dimAxis = axis;
        this.dimensionCursorPosition = new int[axis.length];
        this.mirrorStartPosition = mirrorStartPosition;
        this.fetcher = new ResultSetFetcher(resultSet);
        this.initDimensionPosition();
        this.edgeCursor = -1;
    }

    public void populateEdgeInfo(boolean isPage) throws IOException {
        int customDimSize = 0;
        customDimSize = this.mirrorStartPosition > 0 ? this.mirrorStartPosition : this.dimAxis.length;
        this.edgeInfoArray = new Vector[customDimSize];
        this.length = new int[this.dimAxis.length];
        int i = 0;
        while (i < customDimSize) {
            this.edgeInfoArray[i] = new Vector();
            ++i;
        }
        Object[] preValue = new Object[customDimSize];
        Object[] currValue = new Object[customDimSize];
        int rowId = 0;
        while (rowId < this.rs.length()) {
            this.rs.seek(rowId);
            if (!isPage) {
                int i2 = 0;
                while (i2 < customDimSize) {
                    currValue[i2] = this.fetcher.getLevelKeyValue(this.dimAxis[i2].getLevelIndex())[this.fetcher.getAggrResultSet().getLevelKeyColCount(this.dimAxis[i2].getLevelIndex()) - 1];
                    ++i2;
                }
            }
            int breakLevel = rowId == 0 || isPage ? 0 : this.getBreakLevel(currValue, preValue, rowId);
            int level = breakLevel;
            while (level < customDimSize) {
                EdgeInfo edge = new EdgeInfo();
                if (level != 0) {
                    edge.startPostion = this.edgeInfoArray[level - 1].size() - 1;
                }
                edge.endPosition = level == this.edgeInfoArray.length - 1 ? rowId : this.edgeInfoArray[level + 1].size();
                this.edgeInfoArray[level].add(edge);
                ++level;
            }
            int i3 = 0;
            while (i3 < customDimSize) {
                preValue[i3] = currValue[i3];
                ++i3;
            }
            ++rowId;
        }
        if (this.mirrorStartPosition > 0) {
            this.edgeLength = this.edgeInfoArray[this.mirrorStartPosition - 1].size();
            int i4 = this.mirrorStartPosition;
            while (i4 < this.dimAxis.length) {
                this.length[i4] = this.dimAxis[i4].getDisctinctValue().size();
                this.edgeLength *= this.length[i4];
                ++i4;
            }
        } else {
            this.edgeLength = this.rs.length();
        }
    }

    public boolean dim_next(int dimAxisIndex) throws OLAPException {
        if (this.hasNext(dimAxisIndex)) {
            int position = this.dimensionCursorPosition[dimAxisIndex];
            this.dimensionCursorPosition[dimAxisIndex] = ++position;
            return true;
        }
        return false;
    }

    private boolean hasNext(int dimAxisIndex) {
        if (!this.dimAxis[dimAxisIndex].isMirrored()) {
            EdgeInfo currentEdgeInfo = this.findEdgeInfo(dimAxisIndex);
            if (currentEdgeInfo == null && this.rs.length() > 0) {
                return true;
            }
            if (currentEdgeInfo == null && this.rs.length() == 0) {
                return false;
            }
            int index = this.edgeInfoArray[dimAxisIndex].indexOf(currentEdgeInfo);
            EdgeInfo nextEdgeInfo = null;
            if (this.edgeInfoArray[dimAxisIndex].size() > index + 1) {
                nextEdgeInfo = (EdgeInfo)this.edgeInfoArray[dimAxisIndex].get(index + 1);
            }
            if (nextEdgeInfo == null) {
                return false;
            }
            return currentEdgeInfo.startPostion == nextEdgeInfo.startPostion;
        }
        return this.dimensionCursorPosition[dimAxisIndex] < this.length[dimAxisIndex] - 1;
    }

    public boolean dim_previous(int dimAxisIndex) throws OLAPException {
        int position = this.dimensionCursorPosition[dimAxisIndex];
        if (--position >= 0) {
            this.dimensionCursorPosition[dimAxisIndex] = position;
            return true;
        }
        this.dimensionCursorPosition[dimAxisIndex] = -1;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean dim_relative(int offset, int dimAxisIndex) throws OLAPException {
        block3: {
            index = offset;
            if (offset <= 0) ** GOTO lbl11
            while (index != 0) {
                if (this.dim_next(dimAxisIndex)) {
                    --index;
                    continue;
                }
                break block3;
            }
            break block3;
            while (this.dim_previous(dimAxisIndex)) {
                ++index;
lbl11:
                // 2 sources

                if (index != 0) continue;
            }
        }
        return index == 0;
    }

    public boolean dim_first(int dimAxisIndex) {
        if (this.edgeLength > 0) {
            this.dimensionCursorPosition[dimAxisIndex] = 0;
            return true;
        }
        return false;
    }

    public boolean dim_last(int dimAxisIndex) {
        if (!this.dimAxis[dimAxisIndex].isMirrored()) {
            int range = this.findCurentDimensionRange(dimAxisIndex);
            if (this.edgeLength > 0) {
                this.dimensionCursorPosition[dimAxisIndex] = range;
                return true;
            }
            return false;
        }
        if (this.edgeLength > 0) {
            this.dimensionCursorPosition[dimAxisIndex] = this.length[dimAxisIndex] - 1;
            return true;
        }
        return false;
    }

    public boolean dim_isBeforeFirst(int dimAxisIndex) {
        return this.dimensionCursorPosition[dimAxisIndex] < 0;
    }

    public boolean dim_isAfterLast(int dimAxisIndex) {
        return this.dimensionCursorPosition[dimAxisIndex] == this.getLastDiemsionLength()[dimAxisIndex];
    }

    public boolean dim_isFirst(int dimAxisIndex) {
        return this.dimensionCursorPosition[dimAxisIndex] == 0;
    }

    public boolean dim_isLast(int dimAxisIndex) {
        return this.dimensionCursorPosition[dimAxisIndex] == this.getLastDiemsionLength()[dimAxisIndex] - 1;
    }

    public void dim_afterLast(int dimAxisIndex) {
        this.dimensionCursorPosition[dimAxisIndex] = this.getLastDiemsionLength()[dimAxisIndex];
    }

    public void dim_beforeFirst(int dimAxisIndex) {
        this.dimensionCursorPosition[dimAxisIndex] = -1;
    }

    public void dim_setPosition(int dimAxisIndex, long position) {
        this.dimensionCursorPosition[dimAxisIndex] = (int)position;
    }

    public long dim_getPosition(int dimAxisIndex) {
        return this.dimensionCursorPosition[dimAxisIndex];
    }

    public Object dim_getCurrentMember(int dimAxisIndex, int attr, int sortType) throws OLAPException {
        if (!this.dimAxis[dimAxisIndex].isMirrored()) {
            try {
                int position = this.getCurrentRowPosition(dimAxisIndex);
                if (position == -1) {
                    throw new OLAPException("data.engine.ResultSetNotStart");
                }
                this.rs.seek(position);
            }
            catch (IOException e) {
                throw new OLAPException(e.getLocalizedMessage());
            }
            return this.fetcher.getValue(this.dimAxis[dimAxisIndex].getLevelIndex(), attr);
        }
        return this.fetchValueFromMirror(dimAxisIndex, sortType);
    }

    public Object dim_getCurrentMember(int dimAxisIndex, String attrName, int sortType) throws OLAPException {
        if (!this.dimAxis[dimAxisIndex].isMirrored()) {
            try {
                int position = this.getCurrentRowPosition(dimAxisIndex);
                if (position == -1) {
                    throw new OLAPException("data.engine.ResultSetNotStart");
                }
                this.rs.seek(position);
            }
            catch (IOException e) {
                throw new OLAPException(e.getLocalizedMessage());
            }
            int attrIndex = this.fetcher.getAttributeIndex(this.dimAxis[dimAxisIndex].getLevelIndex(), attrName);
            if (attrIndex == -1) {
                throw new OLAPException("data.olap.invalidLevelAttr" + attrName);
            }
            return this.fetcher.getValue(this.dimAxis[dimAxisIndex].getLevelIndex(), attrIndex);
        }
        return this.fetchValueFromMirror(dimAxisIndex, sortType);
    }

    private Object fetchValueFromMirror(int dimAxisIndex, int sortType) throws OLAPException {
        if (this.dimensionCursorPosition[dimAxisIndex] < 0 || this.dimensionCursorPosition[dimAxisIndex] >= this.length[dimAxisIndex]) {
            throw new OLAPException("data.engine.ResultSetNotStart");
        }
        if (sortType == -1) {
            return this.dimAxis[dimAxisIndex].getDisctinctValue().get(this.dimensionCursorPosition[dimAxisIndex]);
        }
        Collection collection = null;
        try {
            collection = this.fetchValueCollectionInEdgeInfo(dimAxisIndex);
        }
        catch (IOException iOException) {}
        Vector v = this.dimAxis[dimAxisIndex].getDisctinctValue();
        v.removeAll(collection);
        if (sortType == 0) {
            int i = 0;
            int startSize = v.size();
            while (i < collection.size()) {
                v.insertElementAt(collection.iterator().next(), startSize);
                ++startSize;
                ++i;
            }
        } else {
            Iterator iter = collection.iterator();
            int index = 0;
            while (iter.hasNext()) {
                v.insertElementAt(iter.next(), index);
                ++index;
            }
        }
        return v.get(this.dimensionCursorPosition[dimAxisIndex]);
    }

    private Collection fetchValueCollectionInEdgeInfo(int dimAxisIndex) throws IOException {
        HashSet<Object> value = new HashSet<Object>();
        int edgeStart = this.getEdgeStart(this.mirrorStartPosition - 1);
        int edgeEnd = this.getEdgeEnd(this.mirrorStartPosition - 1);
        while (edgeStart <= edgeEnd) {
            this.rs.seek(edgeStart);
            value.add(this.rs.getLevelKeyValue(dimAxisIndex)[this.rs.getLevelKeyColCount(dimAxisIndex) - 1]);
            ++edgeStart;
        }
        return value;
    }

    private int getCurrentRowPosition(int dimAxisIndex) {
        EdgeInfo currentEdgeInfo = this.findEdgeInfo(dimAxisIndex);
        if (currentEdgeInfo == null) {
            return -1;
        }
        EdgeInfo outerMost = this.findOuterMostChildEdgeInfo(dimAxisIndex, currentEdgeInfo);
        return outerMost.endPosition;
    }

    private EdgeInfo findEdgeInfo(int dimensionAxis) {
        if (dimensionAxis < 0 || dimensionAxis > this.dimAxis.length) {
            return null;
        }
        EdgeInfo tempEdgeInfo = null;
        EdgeInfo edgeInfo = null;
        int endPostion = 0;
        int index = 0;
        while (index <= dimensionAxis) {
            if (dimensionAxis == index) {
                if (this.edgeInfoArray[index].size() > endPostion && this.dimensionCursorPosition[index] > -1 && this.dimensionCursorPosition[index] + endPostion < this.edgeInfoArray[index].size()) {
                    edgeInfo = (EdgeInfo)this.edgeInfoArray[index].get(this.dimensionCursorPosition[index] + endPostion);
                    break;
                }
                if (this.dimensionCursorPosition[index] != -1) break;
                return null;
            }
            if (this.dimensionCursorPosition[index] + endPostion >= this.edgeInfoArray[index].size() || this.dimensionCursorPosition[index] <= -1 || this.edgeInfoArray[index].size() <= endPostion) {
                return null;
            }
            tempEdgeInfo = (EdgeInfo)this.edgeInfoArray[index].get(this.dimensionCursorPosition[index] + endPostion);
            if (tempEdgeInfo != null) {
                endPostion = tempEdgeInfo.endPosition;
            }
            ++index;
        }
        return edgeInfo;
    }

    private int findCurentDimensionRange(int dimensionAxis) {
        int index;
        if (dimensionAxis < 0 || dimensionAxis > this.dimAxis.length) {
            return 0;
        }
        if (dimensionAxis == 0) {
            if (this.dimensionCursorPosition[0] < this.edgeInfoArray[0].size()) {
                return this.edgeInfoArray[0].size() - 1;
            }
            return 0;
        }
        int range = 0;
        EdgeInfo info = this.findEdgeInfo(dimensionAxis);
        if (info == null) {
            return range;
        }
        range = 0;
        EdgeInfo currentInfo = info;
        while (true) {
            index = this.edgeInfoArray[dimensionAxis].indexOf(currentInfo);
            EdgeInfo nextEdgeInfo = null;
            if (this.edgeInfoArray[dimensionAxis].size() <= index + 1 || (nextEdgeInfo = (EdgeInfo)this.edgeInfoArray[dimensionAxis].get(index + 1)) == null || currentInfo.startPostion != nextEdgeInfo.startPostion) break;
            ++range;
            currentInfo = nextEdgeInfo;
        }
        currentInfo = info;
        while (true) {
            index = this.edgeInfoArray[dimensionAxis].indexOf(currentInfo);
            EdgeInfo preEdgeInfo = null;
            if (index <= 0 || (preEdgeInfo = (EdgeInfo)this.edgeInfoArray[dimensionAxis].get(index - 1)) == null || currentInfo.startPostion != preEdgeInfo.startPostion) break;
            ++range;
            currentInfo = preEdgeInfo;
        }
        return range;
    }

    public void edge_afterLast() {
        this.edgeCursor = this.edgeLength;
        int[] lastDimLength = this.getLastDiemsionLength();
        int i = 0;
        while (i < this.dimAxis.length) {
            this.dim_setPosition(i, lastDimLength[i]);
            ++i;
        }
    }

    public void edge_beforeFirst() {
        this.edgeCursor = -1;
        this.initDimensionPosition();
    }

    public boolean edge_first() {
        if (this.edgeLength > 0) {
            this.edgeCursor = 0;
            int i = 0;
            while (i < this.dimAxis.length) {
                this.dimensionCursorPosition[i] = 0;
                ++i;
            }
            return true;
        }
        return false;
    }

    public long getEdgePostion() {
        return this.edgeCursor;
    }

    public boolean edge_isAfterLast() {
        return this.edgeCursor >= this.edgeLength;
    }

    public boolean edge_isBeforeFirst() {
        return this.edgeCursor < 0;
    }

    public boolean edge_isFirst() {
        return this.edgeCursor == 0;
    }

    public boolean edge_isLast() {
        return this.edgeCursor == this.edgeLength - 1;
    }

    public boolean edge_last() {
        if (this.edgeLength > 0) {
            this.edgeCursor = this.edgeLength - 1;
            int[] lastDimLength = this.getLastDiemsionLength();
            int i = 0;
            while (i < this.dimAxis.length) {
                this.dim_setPosition(i, lastDimLength[i] - 1);
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean edge_next() throws OLAPException {
        ++this.edgeCursor;
        if (this.edgeCursor < this.edgeLength) {
            if (this.isInitialStatus()) {
                int i = this.dimAxis.length - 1;
                while (i >= 0) {
                    this.dimensionCursorPosition[i] = 0;
                    --i;
                }
            } else {
                int i = this.dimAxis.length - 1;
                while (i >= 0) {
                    if (!this.dim_next(i)) {
                        this.dim_first(i);
                        --i;
                        continue;
                    }
                    break;
                }
            }
            return true;
        }
        this.edge_afterLast();
        return false;
    }

    private boolean isInitialStatus() {
        int i = 0;
        while (i < this.dimensionCursorPosition.length) {
            if (this.dimensionCursorPosition[i] >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean edge_previous() throws OLAPException {
        --this.edgeCursor;
        if (this.edgeCursor >= this.edgeLength - 1) {
            int i = 0;
            while (i < this.dimAxis.length) {
                this.dim_previous(i);
                ++i;
            }
            return true;
        }
        if (this.edgeCursor >= 0) {
            int i = this.dimAxis.length - 1;
            while (i >= 0) {
                if (this.dim_previous(i)) {
                    int k = i + 1;
                    while (k < this.dimAxis.length) {
                        this.dim_last(k);
                        ++k;
                    }
                    break;
                }
                this.dim_first(i);
                --i;
            }
            return true;
        }
        this.edgeCursor = -1;
        this.initDimensionPosition();
        return false;
    }

    public boolean edge_relative(int arg0) throws OLAPException {
        if (arg0 == 0) {
            return true;
        }
        int position = this.edgeCursor + arg0;
        if (position >= this.edgeLength) {
            this.edge_afterLast();
            return false;
        }
        if (position < 0) {
            this.initDimensionPosition();
            this.edgeCursor = -1;
            return false;
        }
        int i = 0;
        while (i < Math.abs(arg0)) {
            if (arg0 > 0) {
                this.edge_next();
            } else {
                this.edge_previous();
            }
            ++i;
        }
        return true;
    }

    public void edge_setPostion(long position) throws OLAPException {
        if (position < 0L) {
            this.initDimensionPosition();
            this.edgeCursor = -1;
            return;
        }
        int offSet = (int)position - this.edgeCursor;
        this.edge_relative(offSet);
    }

    public int getEdgeStart(int dimAxisIndex) {
        if (this.mirrorStartPosition == 0) {
            int segment = this.edgeInfoArray[this.dimAxis.length - 1].size();
            if (segment == 1) {
                return this.rs.length() - 1;
            }
            EdgeInfo edgeInfo = this.findEdgeInfo(dimAxisIndex);
            if (edgeInfo == null) {
                return -1;
            }
            int endPosition = edgeInfo.endPosition;
            EdgeInfo info = edgeInfo;
            int position = dimAxisIndex + 1;
            while (position < this.dimAxis.length) {
                if (this.dimAxis[position].isMirrored()) break;
                info = (EdgeInfo)this.edgeInfoArray[position].get(endPosition);
                endPosition = info.endPosition;
                ++position;
            }
            if (position == this.dimAxis.length) {
                return info.endPosition;
            }
            return this.edgeInfoArray[position - 1].indexOf(info) * this.length[position] + this.dimensionCursorPosition[position];
        }
        if (!this.dimAxis[dimAxisIndex].isMirrored()) {
            EdgeInfo edgeInfo = this.findEdgeInfo(dimAxisIndex);
            int start = this.findOuterMostChildEdgeInfoIndex(dimAxisIndex, edgeInfo);
            if (this.mirrorStartPosition > 0 && start >= 0) {
                int i = this.mirrorStartPosition;
                while (i < this.dimAxis.length) {
                    start *= this.length[i];
                    ++i;
                }
            }
            return start;
        }
        int start = this.caculateOffset(dimAxisIndex, true);
        if (start < 0) {
            return start;
        }
        if (dimAxisIndex == this.dimAxis.length - 1) {
            start += this.dimensionCursorPosition[dimAxisIndex];
        }
        return start;
    }

    public int getEdgeEnd(int dimAxisIndex) {
        if (this.mirrorStartPosition == 0) {
            int segment = this.edgeInfoArray[this.dimAxis.length - 1].size();
            if (segment == 1) {
                return this.rs.length() - 1;
            }
            EdgeInfo edgeInfo = this.findEdgeInfo(dimAxisIndex);
            if (edgeInfo == null) {
                return -1;
            }
            int endPosition = -1;
            int index = this.edgeInfoArray[dimAxisIndex].indexOf(edgeInfo);
            if (index < this.edgeInfoArray[dimAxisIndex].size() - 1) {
                EdgeInfo nextEdgeInfo = (EdgeInfo)this.edgeInfoArray[dimAxisIndex].get(index + 1);
                EdgeInfo nextOuterEdgeInfo = this.findOuterMostChildEdgeInfo(dimAxisIndex, nextEdgeInfo);
                endPosition = nextOuterEdgeInfo.endPosition - 1;
            } else {
                endPosition = this.rs.length() - 1;
            }
            return endPosition;
        }
        if (!this.dimAxis[dimAxisIndex].isMirrored()) {
            EdgeInfo edgeInfo = this.findEdgeInfo(dimAxisIndex);
            int index = this.edgeInfoArray[dimAxisIndex].indexOf(edgeInfo);
            if (index < this.edgeInfoArray[dimAxisIndex].size() - 1) {
                EdgeInfo nextEdgeInfo = (EdgeInfo)this.edgeInfoArray[dimAxisIndex].get(index + 1);
                int start = this.findOuterMostChildEdgeInfoIndex(dimAxisIndex, nextEdgeInfo);
                if (this.mirrorStartPosition > 0) {
                    int i = this.mirrorStartPosition;
                    while (i < this.dimAxis.length) {
                        start *= this.length[i];
                        ++i;
                    }
                }
                return start - 1;
            }
            return this.edgeLength - 1;
        }
        int start = this.caculateOffset(dimAxisIndex, false);
        if (start < 0) {
            return start;
        }
        if (dimAxisIndex == this.dimAxis.length - 1) {
            start += this.dimensionCursorPosition[dimAxisIndex] + 1;
        }
        return start - 1;
    }

    private int caculateOffset(int dimAxisIndex, boolean isStart) {
        EdgeInfo edgeInfo = this.findEdgeInfo(this.mirrorStartPosition - 1);
        int start = this.findOuterMostChildEdgeInfoIndex(this.mirrorStartPosition - 1, edgeInfo);
        if (start < 0) {
            return start;
        }
        int i = this.mirrorStartPosition;
        while (i < this.dimAxis.length) {
            start *= this.length[i];
            ++i;
        }
        int k = this.mirrorStartPosition;
        while (k <= dimAxisIndex) {
            int offset = 1;
            int i2 = k + 1;
            while (i2 < this.dimAxis.length) {
                offset = k == dimAxisIndex && !isStart ? offset * (this.dimensionCursorPosition[k] + 1) * this.length[i2] : offset * this.dimensionCursorPosition[k] * this.length[i2];
                ++i2;
            }
            if (k + 1 < this.dimAxis.length) {
                start += offset;
            }
            ++k;
        }
        return start;
    }

    private void initDimensionPosition() {
        int i = 0;
        while (i < this.dimAxis.length) {
            this.dimensionCursorPosition[i] = -1;
            ++i;
        }
    }

    private EdgeInfo findOuterMostChildEdgeInfo(int dimAxisIndex, EdgeInfo edgeInfo) {
        if (dimAxisIndex < 0 || dimAxisIndex >= this.dimAxis.length || edgeInfo == null) {
            return null;
        }
        int endPosition = edgeInfo.endPosition;
        EdgeInfo info = edgeInfo;
        int i = dimAxisIndex + 1;
        while (i < this.dimAxis.length) {
            if (this.dimAxis[i].isMirrored()) break;
            info = (EdgeInfo)this.edgeInfoArray[i].get(endPosition);
            endPosition = info.endPosition;
            ++i;
        }
        return info;
    }

    private int findOuterMostChildEdgeInfoIndex(int dimAxisIndex, EdgeInfo edgeInfo) {
        if (dimAxisIndex < 0 || dimAxisIndex >= this.dimAxis.length || edgeInfo == null) {
            return -1;
        }
        int endPosition = edgeInfo.endPosition;
        EdgeInfo info = edgeInfo;
        int index = dimAxisIndex + 1;
        while (index < this.dimAxis.length) {
            if (this.dimAxis[index].isMirrored()) break;
            info = (EdgeInfo)this.edgeInfoArray[index].get(endPosition);
            endPosition = info.endPosition;
            ++index;
        }
        if (index == this.mirrorStartPosition) {
            return this.edgeInfoArray[index - 1].indexOf(info);
        }
        return this.edgeInfoArray[index].indexOf(info);
    }

    private int[] getLastDiemsionLength() {
        int[] lastDimensionLength = new int[this.dimAxis.length];
        if (this.mirrorStartPosition == 0) {
            int i = 0;
            while (i < this.dimAxis.length) {
                lastDimensionLength[i] = this.getRangeInLastDimension(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.mirrorStartPosition) {
                lastDimensionLength[i] = this.getRangeInLastDimension(i);
                ++i;
            }
            i = this.mirrorStartPosition;
            while (i < this.dimAxis.length) {
                lastDimensionLength[i] = this.length[i];
                ++i;
            }
        }
        return lastDimensionLength;
    }

    private int getRangeInLastDimension(int dimIndex) {
        if (dimIndex == 0) {
            return this.edgeInfoArray[0].size();
        }
        int size = this.edgeInfoArray[dimIndex].size();
        if (size == 0) {
            return -1;
        }
        int count = 1;
        EdgeInfo edgeInfo = (EdgeInfo)this.edgeInfoArray[dimIndex].get(size - 1);
        int i = size - 2;
        while (i >= 0) {
            EdgeInfo previousInfo = (EdgeInfo)this.edgeInfoArray[dimIndex].get(i);
            if (previousInfo.startPostion == edgeInfo.startPostion) {
                ++count;
            }
            --i;
        }
        return count;
    }

    public Object dim_getCurrentAggregation(int aggregationIndex) throws IOException {
        return this.rs.getAggregationValue(aggregationIndex);
    }

    private int getBreakLevel(Object[] currValue, Object[] preValue, int rowId) {
        if (!($assertionsDisabled || preValue != null && currValue != null)) {
            throw new AssertionError();
        }
        int breakLevel = 0;
        while (breakLevel < currValue.length) {
            Vector list = this.edgeInfoArray[breakLevel];
            EdgeInfo edgeInfo = (EdgeInfo)list.get(list.size() - 1);
            int child = edgeInfo.endPosition;
            Object currObjectValue = currValue[breakLevel];
            Object prevObjectValue = preValue[breakLevel];
            int level = breakLevel + 1;
            while (level < this.edgeInfoArray.length) {
                list = this.edgeInfoArray[level];
                edgeInfo = (EdgeInfo)list.get(child);
                child = edgeInfo.endPosition;
                ++level;
            }
            if (!this.isEqualObject(currObjectValue, prevObjectValue)) break;
            ++breakLevel;
        }
        return breakLevel;
    }

    private boolean isEqualObject(Object preValue, Object currentValue) {
        if (preValue == currentValue) {
            return true;
        }
        if (preValue == null || currentValue == null) {
            return false;
        }
        return preValue.equals(currentValue);
    }
}

