/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.EdgeInfoGenerator;
import org.eclipse.birt.data.engine.olap.cursor.INavigator;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.EdgeAxis;

class EdgeNavigator
implements INavigator {
    private EdgeInfoGenerator edgeInfoGenerator;
    private IAggregationResultSet rs;

    EdgeNavigator(EdgeAxis axis) {
        this.edgeInfoGenerator = axis.getEdgeInfoUtil();
        this.rs = axis.getQueryResultSet();
    }

    public void afterLast() throws OLAPException {
        this.edgeInfoGenerator.edge_afterLast();
    }

    public void beforeFirst() throws OLAPException {
        this.edgeInfoGenerator.edge_beforeFirst();
    }

    public void close() throws OLAPException {
        try {
            this.rs.close();
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    public boolean first() throws OLAPException {
        return this.edgeInfoGenerator.edge_first();
    }

    public long getExtend() {
        return 0L;
    }

    public long getPosition() throws OLAPException {
        return this.edgeInfoGenerator.getEdgePostion();
    }

    public int getType() {
        return 0;
    }

    public boolean isAfterLast() throws OLAPException {
        return this.edgeInfoGenerator.edge_isAfterLast();
    }

    public boolean isBeforeFirst() {
        return this.edgeInfoGenerator.edge_isBeforeFirst();
    }

    public boolean isFirst() throws OLAPException {
        return this.edgeInfoGenerator.edge_isFirst();
    }

    public boolean isLast() throws OLAPException {
        return this.edgeInfoGenerator.edge_isLast();
    }

    public boolean last() throws OLAPException {
        return this.edgeInfoGenerator.edge_last();
    }

    public boolean next() throws OLAPException {
        return this.edgeInfoGenerator.edge_next();
    }

    public boolean previous() throws OLAPException {
        return this.edgeInfoGenerator.edge_previous();
    }

    public boolean relative(int arg0) throws OLAPException {
        return this.edgeInfoGenerator.edge_relative(arg0);
    }

    public void setPosition(long position) throws OLAPException {
        this.edgeInfoGenerator.edge_setPostion(position);
    }
}

