/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.IRandomDataAccessObject;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;

public class DocumentObject
implements IDocumentObject {
    IRandomDataAccessObject delegate = null;

    DocumentObject(IRandomDataAccessObject randomAccessObject) throws IOException {
        this.delegate = randomAccessObject;
    }

    public long getFilePointer() {
        try {
            return this.delegate.getFilePointer();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public long length() throws IOException {
        return this.delegate.length();
    }

    public boolean readBoolean() throws IOException {
        return this.delegate.readBoolean();
    }

    public BigDecimal readBigDecimal() throws IOException {
        if (this.delegate.readByte() == 0) {
            return null;
        }
        return this.delegate.readBigDecimal();
    }

    public int read(byte[] b, int pos, int len) throws IOException {
        return this.delegate.read(b, pos, len);
    }

    public Date readDate() throws IOException {
        if (this.delegate.readByte() == 0) {
            return null;
        }
        return this.delegate.readDate();
    }

    public double readDouble() throws IOException {
        return this.delegate.readDouble();
    }

    public int readInt() throws IOException {
        return this.delegate.readInt();
    }

    public int readShort() throws IOException {
        return this.delegate.readShort();
    }

    public String readString() throws IOException {
        if (this.delegate.readByte() == 0) {
            return null;
        }
        return this.delegate.readUTF();
    }

    public void seek(long pos) throws IOException {
        this.delegate.seek(pos);
    }

    public void setLength(long newLength) throws IOException {
        this.delegate.setLength(newLength);
    }

    public int skipBytes(int n) throws IOException {
        return this.delegate.skipBytes(n);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.delegate.writeBoolean(b);
    }

    public void writeBigDecimal(BigDecimal value) throws IOException {
        if (value == null) {
            this.delegate.writeByte(0);
            return;
        }
        this.delegate.writeByte(1);
        this.delegate.writeBigDecimal(value);
    }

    public void write(byte[] b, int pos, int len) throws IOException {
        this.delegate.write(b, pos, len);
    }

    public void writeDate(Date value) throws IOException {
        if (value == null) {
            this.delegate.writeByte(0);
            return;
        }
        this.delegate.writeByte(1);
        this.delegate.writeDate(value);
    }

    public void writeDouble(double value) throws IOException {
        this.delegate.writeDouble(value);
    }

    public void writeShort(int value) throws IOException {
        this.delegate.writeShort(value);
    }

    public void writeInt(int value) throws IOException {
        this.delegate.writeInt(value);
    }

    public void writeString(String value) throws IOException {
        if (value == null) {
            this.delegate.writeByte(0);
            return;
        }
        this.delegate.writeByte(1);
        this.delegate.writeUTF(value);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public byte readByte() throws IOException {
        return this.delegate.readByte();
    }

    public void writeByte(int b) throws IOException {
        this.delegate.writeByte(b);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public Bytes readBytes() throws IOException {
        if (this.delegate.readByte() == 0) {
            return null;
        }
        return this.delegate.readBytes();
    }

    public void writeBytes(Bytes b) throws IOException {
        if (b == null) {
            this.delegate.writeByte(0);
            return;
        }
        this.delegate.writeByte(1);
        this.delegate.writeBytes(b);
    }
}

