/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.StopSign;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationCalculator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.DiskSortedStackWrapper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4AggregationComparator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4AggregationPopulator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;

public class AggregationExecutor {
    private IDimensionResultIterator[] dimesionResultIterators = null;
    private AggregationCalculator[] aggregationCalculators = null;
    private IFactTableRowIterator facttableRowIterator = null;
    private DiskSortedStackWrapper[] sortedFactRows = null;
    private List allSortedFactRows = null;
    private int[][] levelIndex = null;
    private DimColumn[] paraColumns = null;
    private int[][] parameterColIndexs = null;
    protected static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public AggregationExecutor(IDimensionResultIterator[] dimesionResultIterators, IFactTableRowIterator facttableRowIterator, AggregationDefinition[] aggregations) throws DataException {
        Object[] params = new Object[]{dimesionResultIterators, facttableRowIterator, aggregations};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "AggregationExecutor", params);
        this.dimesionResultIterators = dimesionResultIterators;
        this.getParameterColIndex(aggregations);
        this.aggregationCalculators = new AggregationCalculator[aggregations.length];
        int i = 0;
        while (i < this.aggregationCalculators.length) {
            this.aggregationCalculators[i] = new AggregationCalculator(aggregations[i], this.paraColumns, facttableRowIterator);
            ++i;
        }
        this.sortedFactRows = new DiskSortedStackWrapper[aggregations.length];
        this.facttableRowIterator = facttableRowIterator;
        this.getAggregationLevelIndex();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "AggregationExecutor");
    }

    public IAggregationResultSet[] execute(StopSign stopSign) throws IOException, BirtException {
        this.populateSortedFactRows(stopSign);
        int i = 0;
        while (i < this.allSortedFactRows.size()) {
            DiskSortedStackWrapper diskSortedStackWrapper = (DiskSortedStackWrapper)this.allSortedFactRows.get(i);
            int[] calculatorIndexs = new int[this.sortedFactRows.length];
            int pos = 0;
            int j = 0;
            while (j < calculatorIndexs.length) {
                if (this.sortedFactRows[j] == diskSortedStackWrapper) {
                    calculatorIndexs[pos] = j;
                    ++pos;
                }
                ++j;
            }
            while (diskSortedStackWrapper.pop() != null && !stopSign.isStopped()) {
                Row4Aggregation row = (Row4Aggregation)diskSortedStackWrapper.getCurrentObject();
                int j2 = 0;
                while (j2 < pos) {
                    this.aggregationCalculators[calculatorIndexs[j2]].onRow(AggregationExecutor.cut(row, this.levelIndex[calculatorIndexs[j2]].length / 2));
                    ++j2;
                }
            }
            ++i;
        }
        IAggregationResultSet[] resultSets = new IAggregationResultSet[this.aggregationCalculators.length];
        int i2 = 0;
        while (i2 < this.aggregationCalculators.length) {
            resultSets[i2] = new AggregationResultSet(this.aggregationCalculators[i2].aggregation, this.aggregationCalculators[i2].getResult(), this.getKeyNames(i2), this.getAttributeNames(i2));
            ++i2;
        }
        return resultSets;
    }

    private static Row4Aggregation cut(Row4Aggregation row, int levelCount) {
        Row4Aggregation result = new Row4Aggregation();
        if (levelCount > 0) {
            result.setLevelMembers(new Member[levelCount]);
            System.arraycopy(row.getLevelMembers(), 0, result.getLevelMembers(), 0, levelCount);
        }
        result.setMeasures(row.getMeasures());
        result.setParameterValues(row.getParameterValues());
        return result;
    }

    private String[][] getKeyNames(int aggregationIndex) {
        String[][] result = new String[this.levelIndex[aggregationIndex].length / 2][];
        int[] tmpLevelIndex = this.levelIndex[aggregationIndex];
        int i = 0;
        while (i < this.levelIndex[aggregationIndex].length / 2) {
            result[i] = this.dimesionResultIterators[tmpLevelIndex[i * 2]].getDimesion().getHierarchy().getLevels()[tmpLevelIndex[i * 2 + 1]].getKeyNames();
            ++i;
        }
        return result;
    }

    private String[][] getAttributeNames(int aggregationIndex) {
        String[][] result = new String[this.levelIndex[aggregationIndex].length / 2][];
        int[] tmpLevelIndex = this.levelIndex[aggregationIndex];
        int i = 0;
        while (i < this.levelIndex[aggregationIndex].length / 2) {
            result[i] = this.dimesionResultIterators[tmpLevelIndex[i * 2]].getDimesion().getHierarchy().getLevels()[tmpLevelIndex[i * 2 + 1]].getAttributeNames();
            ++i;
        }
        return result;
    }

    private void populateSortedFactRows(StopSign stopSign) throws IOException, BirtException {
        Row4AggregationPopulator aggregationRowPopulator = new Row4AggregationPopulator(this.dimesionResultIterators, this.facttableRowIterator, this.parameterColIndexs);
        this.prepareSortedStacks();
        int measureCount = this.facttableRowIterator.getMeasureCount();
        while (this.facttableRowIterator.next() && !stopSign.isStopped()) {
            int i = 0;
            while (i < this.allSortedFactRows.size()) {
                DiskSortedStackWrapper diskSortedStackWrapper = (DiskSortedStackWrapper)this.allSortedFactRows.get(i);
                int[] levelIndex = diskSortedStackWrapper.levelIndex;
                Row4Aggregation aggregationRow = new Row4Aggregation();
                aggregationRow.setLevelMembers(aggregationRowPopulator.getLevelMembers(levelIndex));
                if (aggregationRow.getLevelMembers() != null) {
                    aggregationRow.setMeasures(new Object[measureCount]);
                    int j = 0;
                    while (j < measureCount) {
                        aggregationRow.getMeasures()[j] = this.facttableRowIterator.getMeasure(j);
                        ++j;
                    }
                    aggregationRow.setParameterValues(aggregationRowPopulator.getParameterValues());
                    diskSortedStackWrapper.diskSortedStack.push(aggregationRow);
                }
                ++i;
            }
        }
    }

    private void prepareSortedStacks() {
        this.allSortedFactRows = new ArrayList();
        block0: while (true) {
            int maxLevelCount = 0;
            int aggregationIndex = -1;
            int[] levelSortType = null;
            int i = 0;
            while (i < this.aggregationCalculators.length) {
                if (this.sortedFactRows[i] == null && (this.aggregationCalculators[i].aggregation.getLevels() != null && this.aggregationCalculators[i].aggregation.getLevels().length > maxLevelCount || this.aggregationCalculators[i].aggregation.getLevels() == null)) {
                    aggregationIndex = i;
                    maxLevelCount = this.levelIndex[i].length;
                    levelSortType = this.aggregationCalculators[i].aggregation.getSortTypes();
                }
                ++i;
            }
            if (aggregationIndex == -1) break;
            Row4AggregationComparator comparator = new Row4AggregationComparator(levelSortType);
            DiskSortedStack diskSortedStack = new DiskSortedStack(40000, false, comparator, Row4Aggregation.getCreator());
            DiskSortedStackWrapper diskSortedStackReader = new DiskSortedStackWrapper(diskSortedStack, this.levelIndex[aggregationIndex]);
            this.allSortedFactRows.add(diskSortedStackReader);
            int i2 = 0;
            while (true) {
                if (i2 >= this.aggregationCalculators.length) continue block0;
                if (this.sortedFactRows[i2] == null && AggregationExecutor.cover(this.levelIndex[aggregationIndex], this.levelIndex[i2])) {
                    this.sortedFactRows[i2] = diskSortedStackReader;
                }
                ++i2;
            }
            break;
        }
    }

    private static boolean cover(int[] dimensionIndex1, int[] dimensionIndex2) {
        if (dimensionIndex2 == null || dimensionIndex2.length == 0) {
            return true;
        }
        if (dimensionIndex1.length < dimensionIndex2.length) {
            return false;
        }
        int i = 0;
        while (i < dimensionIndex2.length) {
            if (dimensionIndex1[i] != dimensionIndex2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void getAggregationLevelIndex() {
        if (this.aggregationCalculators == null) {
            return;
        }
        this.levelIndex = new int[this.aggregationCalculators.length][];
        int i = 0;
        while (i < this.aggregationCalculators.length) {
            DimLevel[] levels = this.aggregationCalculators[i].aggregation.getLevels();
            if (levels == null || levels.length == 0) {
                this.levelIndex[i] = new int[0];
            } else {
                int[] tmpLevelIndex = new int[levels.length * 2];
                int j = 0;
                while (j < tmpLevelIndex.length / 2) {
                    tmpLevelIndex[j * 2] = this.findDimensionIterator(levels[j]);
                    tmpLevelIndex[j * 2 + 1] = this.dimesionResultIterators[tmpLevelIndex[j * 2]].getLevelIndex(levels[j].getLevelName());
                    ++j;
                }
                this.levelIndex[i] = tmpLevelIndex;
            }
            ++i;
        }
    }

    private void getParameterColIndex(AggregationDefinition[] aggregations) throws DataException {
        ArrayList<DimColumn> paraColList = new ArrayList<DimColumn>();
        int i = 0;
        while (i < aggregations.length) {
            AggregationFunctionDefinition[] functions = aggregations[i].getAggregationFunctions();
            if (functions != null) {
                int j = 0;
                while (j < functions.length) {
                    DimColumn paraCol = functions[j].getParaCol();
                    if (paraCol != null && !this.exist(paraColList, paraCol)) {
                        paraColList.add(paraCol);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (paraColList.size() == 0) {
            return;
        }
        this.paraColumns = new DimColumn[paraColList.size()];
        i = 0;
        while (i < paraColList.size()) {
            this.paraColumns[i] = (DimColumn)paraColList.get(i);
            ++i;
        }
        this.parameterColIndexs = new int[paraColList.size()][4];
        this.findColumnIndex();
    }

    private void findColumnIndex() throws DataException {
        if (this.paraColumns == null) {
            return;
        }
        int i = 0;
        while (i < this.paraColumns.length) {
            this.parameterColIndexs[i][0] = -1;
            int j = 0;
            while (j < this.dimesionResultIterators.length) {
                if (this.dimesionResultIterators[j].getDimesion().getName().equals(this.paraColumns[i].getDimensionName())) {
                    ILevel[] levels = this.dimesionResultIterators[j].getDimesion().getHierarchy().getLevels();
                    int k = 0;
                    while (k < levels.length) {
                        if (levels[k].getName().equals(this.paraColumns[i].getLevelName())) {
                            String[] columns = levels[k].getKeyNames();
                            int index = this.find(columns, this.paraColumns[i].getColumnName());
                            if (index >= 0) {
                                this.parameterColIndexs[i][0] = 0;
                                this.parameterColIndexs[i][1] = j;
                                this.parameterColIndexs[i][2] = k;
                                this.parameterColIndexs[i][3] = index;
                                break;
                            }
                            columns = levels[k].getAttributeNames();
                            index = this.find(columns, this.paraColumns[i].getColumnName());
                            if (index >= 0) {
                                this.parameterColIndexs[i][0] = 1;
                                this.parameterColIndexs[i][1] = j;
                                this.parameterColIndexs[i][2] = k;
                                this.parameterColIndexs[i][3] = index;
                                break;
                            }
                        }
                        ++k;
                    }
                    if (this.parameterColIndexs[i][0] != -1) break;
                }
                ++j;
            }
            if (this.parameterColIndexs[i][0] == -1) {
                throw new DataException("data.olap.ParameterColumnOfAggregationNotExist", this.paraColumns[i]);
            }
            ++i;
        }
    }

    private int find(String[] strArray, String str) {
        if (strArray == null) {
            return -1;
        }
        int i = 0;
        while (i < strArray.length) {
            if (strArray[i].equals(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean exist(List colList, DimColumn col) {
        int i = 0;
        while (i < colList.size()) {
            if (col.equals(colList.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int findDimensionIterator(DimLevel level) {
        int i = 0;
        while (i < this.dimesionResultIterators.length) {
            if (this.dimesionResultIterators[i].getDimesion().getName().equals(level.getDimensionName()) && this.dimesionResultIterators[i].getLevelIndex(level.getLevelName()) >= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

