/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Hierarchy;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.DiskIndex;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IndexKey;

public class Dimension
implements IDimension {
    private String name = null;
    private IDocumentManager documentManager = null;
    private IDocumentObject documentObj = null;
    private Hierarchy hierarchy = null;
    private int length = 0;
    private boolean isTime;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public Dimension(String name, IDocumentManager documentManager, Hierarchy hierarchy, boolean isTime) throws DataException, IOException {
        Object[] params = new Object[]{name, documentManager, hierarchy, new Boolean(isTime)};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "Dimension", params);
        this.name = name;
        this.documentManager = documentManager;
        this.isTime = isTime;
        this.documentObj = documentManager.createDocumentObject(NamingUtil.getDimensionDocName(name));
        this.documentObj.writeBoolean(isTime);
        this.documentObj.writeString(hierarchy.getName());
        this.hierarchy = hierarchy;
        this.length = hierarchy.size();
        this.documentObj.close();
        this.documentObj = null;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "Dimension");
    }

    Dimension(String name, IDocumentManager documentManager) throws IOException, DataException {
        Object[] params = new Object[]{name, documentManager};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "Dimension", params);
        this.name = name;
        this.documentManager = documentManager;
        this.loadFromDisk();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "Dimension");
    }

    private void loadFromDisk() throws IOException, DataException {
        this.documentObj = this.documentManager.openDocumentObject(NamingUtil.getDimensionDocName(this.name));
        if (this.documentObj == null) {
            throw new DataException("data.olap.DimensionNotExist", this.name);
        }
        this.isTime = this.documentObj.readBoolean();
        String hierarchyName = this.documentObj.readString();
        this.hierarchy = new Hierarchy(this.documentManager, this.name, hierarchyName);
        this.hierarchy.loadFromDisk();
        this.length = this.hierarchy.size();
        this.documentObj.close();
        this.documentObj = null;
    }

    public IDiskArray getAllRows() throws IOException {
        return this.hierarchy.readAllRows();
    }

    public DimensionRow getRowByPosition(int position) throws IOException {
        return this.hierarchy.readRowByPosition(position);
    }

    public IDiskArray getDimensionRowByPositions(IDiskArray positionArray) throws IOException {
        BufferedStructureArray resultArray = new BufferedStructureArray(DimensionRow.getCreator(), 4000);
        int i = 0;
        while (i < positionArray.size()) {
            int pos = (Integer)positionArray.get(i);
            resultArray.add(this.hierarchy.readRowByPosition(pos));
            ++i;
        }
        return resultArray;
    }

    public DimensionRow getDimensionRowByOffset(int offset) throws IOException {
        return this.hierarchy.readRowByOffset(offset);
    }

    public IDiskArray find(Level level, Object[] keyValue) throws IOException, DataException {
        DiskIndex index = level.getDiskIndex();
        if (index == null) {
            return null;
        }
        return index.find(keyValue);
    }

    public IndexKey findFirst(Level level, Object[] keyValue) throws IOException, DataException {
        DiskIndex index = level.getDiskIndex();
        if (index == null) {
            return null;
        }
        return index.findFirst(keyValue);
    }

    public IDiskArray find(Level[] levels, ISelection[][] filters) throws IOException, DataException {
        return DimensionFilterHelper.find(levels, filters);
    }

    public Level getDetailLevel() {
        return (Level)this.hierarchy.getLevels()[this.hierarchy.getLevels().length - 1];
    }

    public IDiskArray findAll() throws IOException {
        BufferedPrimitiveDiskArray result = new BufferedPrimitiveDiskArray(4000);
        int lastPos = this.length() - 1;
        int i = 0;
        while (i <= lastPos) {
            result.add(new Integer(i));
            ++i;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public boolean isTime() {
        return this.isTime;
    }

    public int length() {
        return this.length;
    }

    public void close() throws IOException {
        this.hierarchy.close();
    }
}

