/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.StopSign;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectCache;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectUtil;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionKey;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.CombinedPositionContructor;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivider;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivision;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionInfo;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionPositionSeeker;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FTSUDocumentObjectNamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FTSUNameSaveHelper;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRow;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class FactTableAccessor {
    private IDocumentManager documentManager = null;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public FactTableAccessor(IDocumentManager documentManager) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "FactTableAccessor", documentManager);
        this.documentManager = documentManager;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "FactTableAccessor");
    }

    public FactTable saveFactTable(String factTableName, String[][] factTableJointColumnNames, String[][] DimJointColumnNames, IDatasetIterator iterator, Dimension[] dimensions, String[] measureColumnName, StopSign stopSign) throws BirtException, IOException {
        DiskSortedStack sortedFactTableRows = FactTableAccessor.getSortedFactTableRows(iterator, factTableJointColumnNames, measureColumnName, stopSign);
        int segmentCount = FactTableAccessor.getSegmentCount(sortedFactTableRows.size());
        DimensionInfo[] dimensionInfo = FactTableAccessor.getDimensionInfo(dimensions);
        MeasureInfo[] measureInfo = FactTableAccessor.getMeasureInfo(iterator, measureColumnName);
        this.saveFactTableMetadata(factTableName, dimensionInfo, measureInfo, segmentCount);
        DimensionDivision[] subDimensions = FactTableAccessor.calculateDimensionDivision(FactTableAccessor.getDimensionMemberCount(dimensions), segmentCount);
        int[][][] columnIndex = this.getColumnIndex(DimJointColumnNames, dimensions);
        DimensionPositionSeeker[] dimensionSeekers = new DimensionPositionSeeker[dimensions.length];
        int i = 0;
        while (i < dimensionSeekers.length) {
            dimensionSeekers[i] = new DimensionPositionSeeker(FactTableAccessor.getDimCombinatedKey(columnIndex[i], dimensions[i].getAllRows()));
            ++i;
        }
        FactTableRow currentRow = null;
        FactTableRow lastRow = null;
        int[] dimensionPosition = new int[dimensions.length];
        DocumentObjectCache documentObjectManager = new DocumentObjectCache(this.documentManager);
        CombinedPositionContructor combinedPositionCalculator = new CombinedPositionContructor(subDimensions);
        FTSUNameSaveHelper helper = new FTSUNameSaveHelper(this.documentManager, factTableName);
        Object popObject = sortedFactTableRows.pop();
        while (popObject != null && !stopSign.isStopped()) {
            currentRow = (FactTableRow)popObject;
            if (lastRow != null && currentRow.equals(lastRow)) {
                throw new DataException("data.olap.FacttableRowNotDistinct", currentRow.toString());
            }
            int i2 = 0;
            while (i2 < dimensionPosition.length) {
                dimensionPosition[i2] = dimensionSeekers[i2].find(currentRow.getDimensionKeys()[i2]);
                if (dimensionPosition[i2] < 0) {
                    Object[] args = new String[]{currentRow.toString(), dimensions[i2].getName()};
                    throw new DataException("data.olap.InvalidDimensionPositionFacttableRow", args);
                }
                ++i2;
            }
            int[] subDimensionIndex = FactTableAccessor.getSubDimensionIndex(dimensionPosition, subDimensions);
            String FTSUDocName = FTSUDocumentObjectNamingUtil.getDocumentObjectName(NamingUtil.getFactTableName(factTableName), subDimensionIndex);
            helper.add(FTSUDocName);
            IDocumentObject documentObject = documentObjectManager.getIDocumentObject(FTSUDocName);
            documentObject.writeBytes(new Bytes(combinedPositionCalculator.calculateCombinedPosition(subDimensionIndex, dimensionPosition).toByteArray()));
            int i3 = 0;
            while (i3 < measureInfo.length) {
                DocumentObjectUtil.writeValue(documentObject, measureInfo[i3].dataType, currentRow.getMeasures()[i3]);
                ++i3;
            }
            popObject = sortedFactTableRows.pop();
            lastRow = currentRow;
        }
        helper.save();
        documentObjectManager.closeAll();
        this.documentManager.flush();
        return new FactTable(factTableName, this.documentManager, dimensionInfo, measureInfo, segmentCount, subDimensions);
    }

    private int[][][] getColumnIndex(String[][] keyColumnNames, Dimension[] dimensions) throws DataException {
        int[][][] columnIndex = new int[keyColumnNames.length][][];
        int i = 0;
        while (i < keyColumnNames.length) {
            columnIndex[i] = new int[keyColumnNames[i].length][];
            ILevel[] levels = dimensions[i].getHierarchy().getLevels();
            int j = 0;
            while (j < keyColumnNames[i].length) {
                columnIndex[i][j] = new int[3];
                columnIndex[i][j][0] = -1;
                int k = 0;
                while (k < levels.length) {
                    String[] columns = levels[k].getKeyNames();
                    int index = this.find(columns, keyColumnNames[i][j]);
                    if (index >= 0) {
                        columnIndex[i][j][0] = 0;
                        columnIndex[i][j][1] = k;
                        columnIndex[i][j][2] = index;
                        break;
                    }
                    columns = levels[k].getAttributeNames();
                    index = this.find(columns, keyColumnNames[i][j]);
                    if (index >= 0) {
                        columnIndex[i][j][0] = 1;
                        columnIndex[i][j][1] = k;
                        columnIndex[i][j][2] = index;
                        break;
                    }
                    ++k;
                }
                if (columnIndex[i][j][0] == -1) {
                    throw new DataException("data.olap.FacttableJointColumnNotExist", keyColumnNames[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return columnIndex;
    }

    private int find(String[] strArray, String str) {
        if (strArray == null) {
            return -1;
        }
        int i = 0;
        while (i < strArray.length) {
            if (strArray[i].equals(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static IDiskArray getDimCombinatedKey(int[][] columnIndex, IDiskArray dimRowArray) throws IOException {
        BufferedStructureArray resultArray = new BufferedStructureArray(DimensionKey.getCreator(), 4000);
        int i = 0;
        while (i < dimRowArray.size()) {
            DimensionRow dimRow = (DimensionRow)dimRowArray.get(i);
            DimensionKey key = new DimensionKey(columnIndex.length);
            Object[] values = new Object[columnIndex.length];
            int j = 0;
            while (j < columnIndex.length) {
                values[j] = columnIndex[j][0] == 0 ? dimRow.getMembers()[columnIndex[j][1]].getKeyValues()[columnIndex[j][2]] : dimRow.getMembers()[columnIndex[j][1]].getAttributes()[columnIndex[j][2]];
                ++j;
            }
            key.setKeyValues(values);
            key.setDimensionPos(i);
            resultArray.add(key);
            ++i;
        }
        return resultArray;
    }

    private static int getSegmentCount(int factTableRowCount) {
        int segmentCount = factTableRowCount / 2048;
        if (segmentCount * 2048 < factTableRowCount) {
            ++segmentCount;
        }
        return segmentCount;
    }

    private static DimensionInfo[] getDimensionInfo(Dimension[] dimension) {
        DimensionInfo[] dimensionInfo = new DimensionInfo[dimension.length];
        int i = 0;
        while (i < dimension.length) {
            dimensionInfo[i] = new DimensionInfo();
            dimensionInfo[i].dimensionName = dimension[i].getName();
            dimensionInfo[i].dimensionLength = dimension[i].length();
            ++i;
        }
        return dimensionInfo;
    }

    private static MeasureInfo[] getMeasureInfo(IDatasetIterator iterator, String[] measureColumnName) throws BirtException {
        MeasureInfo[] measureInfo = new MeasureInfo[measureColumnName.length];
        int i = 0;
        while (i < measureColumnName.length) {
            measureInfo[i] = new MeasureInfo();
            measureInfo[i].measureName = measureColumnName[i];
            measureInfo[i].dataType = iterator.getFieldType(measureColumnName[i]);
            ++i;
        }
        return measureInfo;
    }

    private void saveFactTableMetadata(String factTableName, DimensionInfo[] dimensionInfo, MeasureInfo[] measureInfo, int segmentNumber) throws IOException, BirtException {
        IDocumentObject documentObject = this.documentManager.createDocumentObject(NamingUtil.getFactTableName(factTableName));
        documentObject.writeInt(dimensionInfo.length);
        int i = 0;
        while (i < dimensionInfo.length) {
            documentObject.writeString(dimensionInfo[i].dimensionName);
            documentObject.writeInt(dimensionInfo[i].dimensionLength);
            ++i;
        }
        documentObject.writeInt(measureInfo.length);
        i = 0;
        while (i < measureInfo.length) {
            documentObject.writeString(measureInfo[i].measureName);
            documentObject.writeInt(measureInfo[i].dataType);
            ++i;
        }
        documentObject.writeInt(segmentNumber);
        documentObject.close();
    }

    private static DiskSortedStack getSortedFactTableRows(IDatasetIterator iterator, String[][] keyColumnNames, String[] measureColumnNames, StopSign stopSign) throws BirtException, IOException {
        DiskSortedStack result = new DiskSortedStack(40000, true, false, FactTableRow.getCreator());
        int[][] levelKeyColumnIndex = new int[keyColumnNames.length][];
        int[] measureColumnIndex = new int[measureColumnNames.length];
        int i = 0;
        while (i < keyColumnNames.length) {
            levelKeyColumnIndex[i] = new int[keyColumnNames[i].length];
            int j = 0;
            while (j < keyColumnNames[i].length) {
                levelKeyColumnIndex[i][j] = iterator.getFieldIndex(keyColumnNames[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < measureColumnIndex.length) {
            measureColumnIndex[i] = iterator.getFieldIndex(measureColumnNames[i]);
            ++i;
        }
        while (iterator.next() && !stopSign.isStopped()) {
            FactTableRow factTableRow = new FactTableRow();
            factTableRow.setDimensionKeys(new DimensionKey[levelKeyColumnIndex.length]);
            int i2 = 0;
            while (i2 < levelKeyColumnIndex.length) {
                factTableRow.getDimensionKeys()[i2] = new DimensionKey(levelKeyColumnIndex[i2].length);
                int j = 0;
                while (j < levelKeyColumnIndex[i2].length) {
                    if (levelKeyColumnIndex[i2][j] >= 0) {
                        factTableRow.getDimensionKeys()[i2].getKeyValues()[j] = iterator.getValue(levelKeyColumnIndex[i2][j]);
                    }
                    ++j;
                }
                ++i2;
            }
            factTableRow.setMeasures(new Object[measureColumnIndex.length]);
            i2 = 0;
            while (i2 < measureColumnIndex.length) {
                factTableRow.getMeasures()[i2] = iterator.getValue(measureColumnIndex[i2]);
                if (factTableRow.getMeasures()[i2] == null) {
                    throw new DataException("data.olap.FacttableNullMeasureValue", factTableRow.toString());
                }
                ++i2;
            }
            result.push(factTableRow);
        }
        return result;
    }

    private static int[] getDimensionMemberCount(Dimension[] dimension) {
        int[] dimensionMemberCount = new int[dimension.length];
        int i = 0;
        while (i < dimension.length) {
            dimensionMemberCount[i] = dimension[i].length();
            ++i;
        }
        return dimensionMemberCount;
    }

    static DimensionDivision[] calculateDimensionDivision(int[] dimensionMemberCount, int blockNumber) {
        int[] subDimensionCount = DimensionDivider.divideDimension(dimensionMemberCount, blockNumber);
        DimensionDivision[] result = new DimensionDivision[dimensionMemberCount.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new DimensionDivision(dimensionMemberCount[i], subDimensionCount[i]);
            ++i;
        }
        return result;
    }

    private static int[] getSubDimensionIndex(int[] dimensionPosition, DimensionDivision[] dimensionDivision) {
        if (!$assertionsDisabled && dimensionPosition.length != dimensionDivision.length) {
            throw new AssertionError();
        }
        int[] result = new int[dimensionPosition.length];
        int i = 0;
        while (i < result.length) {
            result[i] = dimensionDivision[i].getSubDimensionIndex(dimensionPosition[i]);
            ++i;
        }
        return result;
    }

    public FactTable load(String factTableName, StopSign stopSign) throws IOException {
        int segmentNumber = 0;
        IDocumentObject documentObject = this.documentManager.openDocumentObject(NamingUtil.getFactTableName(factTableName));
        DimensionInfo[] dimensionInfo = new DimensionInfo[documentObject.readInt()];
        int i = 0;
        while (i < dimensionInfo.length) {
            dimensionInfo[i] = new DimensionInfo();
            dimensionInfo[i].dimensionName = documentObject.readString();
            dimensionInfo[i].dimensionLength = documentObject.readInt();
            ++i;
        }
        MeasureInfo[] measureInfo = new MeasureInfo[documentObject.readInt()];
        int i2 = 0;
        while (i2 < measureInfo.length) {
            measureInfo[i2] = new MeasureInfo();
            measureInfo[i2].measureName = documentObject.readString();
            measureInfo[i2].dataType = documentObject.readInt();
            ++i2;
        }
        segmentNumber = documentObject.readInt();
        int[] dimensionMemberCount = new int[dimensionInfo.length];
        int i3 = 0;
        while (i3 < dimensionInfo.length) {
            dimensionMemberCount[i3] = dimensionInfo[i3].dimensionLength;
            ++i3;
        }
        DimensionDivision[] subDimensions = FactTableAccessor.calculateDimensionDivision(dimensionMemberCount, segmentNumber);
        return new FactTable(factTableName, this.documentManager, dimensionInfo, measureInfo, segmentNumber, subDimensions);
    }
}

