/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.impl.query.LevelDefiniton;
import org.eclipse.birt.data.engine.olap.impl.query.MeasureDefinition;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.RelationShip;
import org.eclipse.birt.data.engine.olap.util.ICubeAggrDefn;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

class CubeQueryDefinitionUtil {
    CubeQueryDefinitionUtil() {
    }

    static CalculatedMember[] getCalculatedMembers(ICubeQueryDefinition queryDefn) throws DataException {
        List measureList = queryDefn.getMeasures();
        ICubeAggrDefn[] cubeAggrs = OlapExpressionUtil.getAggrDefns(queryDefn.getBindings());
        ArrayList<ICubeAggrDefn> cubeAggrBindingList = new ArrayList<ICubeAggrDefn>();
        int i = 0;
        while (i < cubeAggrs.length) {
            if (cubeAggrs[i].getAggrName() != null) {
                cubeAggrBindingList.add(cubeAggrs[i]);
            }
            ++i;
        }
        if (measureList == null) {
            return new CalculatedMember[0];
        }
        CalculatedMember[] calculatedMember = new CalculatedMember[measureList.size() + cubeAggrBindingList.size()];
        int index = 0;
        ArrayList<CalculatedMember> calculatedMemberList = new ArrayList<CalculatedMember>();
        if (!measureList.isEmpty()) {
            List levelList = CubeQueryDefinitionUtil.populateMeasureAggrOns(queryDefn);
            Iterator measureIter = measureList.iterator();
            while (measureIter.hasNext()) {
                MeasureDefinition measureDefn = (MeasureDefinition)measureIter.next();
                calculatedMember[index] = new CalculatedMember(measureDefn.getName(), measureDefn.getName(), levelList, measureDefn.getAggrFunction() == null ? "SUM" : measureDefn.getAggrFunction(), 0);
                calculatedMemberList.add(calculatedMember[index]);
                ++index;
            }
        }
        if (!cubeAggrBindingList.isEmpty()) {
            int rsID = 1;
            int i2 = 0;
            while (i2 < cubeAggrBindingList.size()) {
                int id = CubeQueryDefinitionUtil.getResultSetIndex(calculatedMemberList, ((ICubeAggrDefn)cubeAggrBindingList.get(i2)).getAggrLevels());
                if (id == -1) {
                    calculatedMember[index] = new CalculatedMember((ICubeAggrDefn)cubeAggrBindingList.get(i2), rsID);
                    calculatedMemberList.add(calculatedMember[index]);
                    ++rsID;
                } else {
                    calculatedMember[index] = new CalculatedMember((ICubeAggrDefn)cubeAggrBindingList.get(i2), id);
                }
                ++index;
                ++i2;
            }
        }
        return calculatedMember;
    }

    public static List populateMeasureAggrOns(ICubeQueryDefinition queryDefn) {
        ArrayList<DimLevel> levelList = new ArrayList<DimLevel>();
        ILevelDefinition[] rowLevels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(1));
        ILevelDefinition[] columnLevels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(2));
        int i = 0;
        while (i < rowLevels.length) {
            levelList.add(new DimLevel(rowLevels[i]));
            ++i;
        }
        i = 0;
        while (i < columnLevels.length) {
            levelList.add(new DimLevel(columnLevels[i]));
            ++i;
        }
        return levelList;
    }

    private static int getResultSetIndex(List aggrList, List levelList) {
        int i = 0;
        while (i < aggrList.size()) {
            CalculatedMember member = (CalculatedMember)aggrList.get(i);
            if (member.getAggrOnList().equals(levelList)) {
                return member.getRsID();
            }
            ++i;
        }
        return -1;
    }

    static ILevelDefinition[] getLevelsOnEdge(IEdgeDefinition edgeDefn) {
        if (edgeDefn == null) {
            return new ILevelDefinition[0];
        }
        ArrayList levelList = new ArrayList();
        Iterator dimIter = edgeDefn.getDimensions().iterator();
        while (dimIter.hasNext()) {
            IDimensionDefinition dimDefn = (IDimensionDefinition)dimIter.next();
            Iterator hierarchyIter = dimDefn.getHierarchy().iterator();
            while (hierarchyIter.hasNext()) {
                IHierarchyDefinition hierarchyDefn = (IHierarchyDefinition)hierarchyIter.next();
                levelList.addAll(hierarchyDefn.getLevels());
            }
        }
        ILevelDefinition[] levelDefn = new LevelDefiniton[levelList.size()];
        int i = 0;
        while (i < levelList.size()) {
            levelDefn[i] = (ILevelDefinition)levelList.get(i);
            ++i;
        }
        return levelDefn;
    }

    public static Map getRelationWithMeasure(ICubeQueryDefinition queryDefn) throws DataException {
        ICubeAggrDefn[] cubeAggrs;
        int i;
        ILevelDefinition[] levels;
        HashMap<String, RelationShip> measureRelationMap = new HashMap<String, RelationShip>();
        ArrayList<DimLevel> rowLevelList = new ArrayList<DimLevel>();
        ArrayList<DimLevel> columnLevelList = new ArrayList<DimLevel>();
        if (queryDefn.getEdge(2) != null) {
            levels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(2));
            i = 0;
            while (i < levels.length) {
                columnLevelList.add(new DimLevel(levels[i]));
                ++i;
            }
        }
        if (queryDefn.getEdge(1) != null) {
            levels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(1));
            i = 0;
            while (i < levels.length) {
                rowLevelList.add(new DimLevel(levels[i]));
                ++i;
            }
        }
        if (queryDefn.getMeasures() != null && !queryDefn.getMeasures().isEmpty()) {
            Iterator measureIter = queryDefn.getMeasures().iterator();
            while (measureIter.hasNext()) {
                MeasureDefinition measure = (MeasureDefinition)measureIter.next();
                measureRelationMap.put(measure.getName(), new RelationShip(rowLevelList, columnLevelList));
            }
        }
        if ((cubeAggrs = OlapExpressionUtil.getAggrDefns(queryDefn.getBindings())) != null && cubeAggrs.length > 0) {
            int i2 = 0;
            while (i2 < cubeAggrs.length) {
                if (cubeAggrs[i2].getAggrName() != null) {
                    List aggrOns = cubeAggrs[i2].getAggrLevels();
                    ArrayList usedLevelOnRow = new ArrayList();
                    ArrayList usedLevelOnColumn = new ArrayList();
                    int j = 0;
                    while (j < aggrOns.size()) {
                        if (rowLevelList.contains(aggrOns.get(j))) {
                            usedLevelOnRow.add(aggrOns.get(j));
                        } else if (columnLevelList.contains(aggrOns.get(j))) {
                            usedLevelOnColumn.add(aggrOns.get(j));
                        }
                        ++j;
                    }
                    measureRelationMap.put(cubeAggrs[i2].getName(), new RelationShip(usedLevelOnRow, usedLevelOnColumn));
                }
                ++i2;
            }
        }
        return measureRelationMap;
    }
}

