/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.StopSign;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationResultSetSaveUtil;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.driver.CubeResultSet;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryValidator;
import org.eclipse.birt.data.engine.olap.query.view.MeasureNameManager;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

public class QueryExecutor {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.query.view.QueryExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public IResultSet execute(BirtCubeView view, CubeQueryExecutor executor, MeasureNameManager manager) throws IOException, BirtException {
        AggregationDefinition[] aggrDefns = this.prepareCube(executor.getCubeQueryDefinition(), manager.getCalculatedMembers());
        if (aggrDefns == null || aggrDefns.length == 0) {
            return null;
        }
        IDocumentManager documentManager = this.getDocumentManager(executor);
        ICube cube = this.loadCube(documentManager, executor);
        CubeQueryValidator.validateCubeQueryDefinition(view, cube, manager.getCalculatedMembers());
        CubeQueryExecutorHelper cubeQueryExcutorHelper = new CubeQueryExecutorHelper(cube);
        cubeQueryExcutorHelper.addJSFilter(executor.getDimensionFilterEvalHelpers());
        this.populateAggregationSort(executor, cubeQueryExcutorHelper, true);
        this.populateAggregationSort(executor, cubeQueryExcutorHelper, false);
        IAggregationResultSet[] rs = null;
        if (executor.getContext().getMode() == 1) {
            rs = this.populateRs(executor, aggrDefns, cubeQueryExcutorHelper, true);
        } else if (executor.getContext().getMode() == 3) {
            rs = this.populateRs(executor, aggrDefns, cubeQueryExcutorHelper, false);
        } else if (executor.getContext().getMode() == 2) {
            if (!$assertionsDisabled && executor.getCubeQueryDefinition().getQueryResultsID() == null) {
                throw new AssertionError();
            }
            rs = AggregationResultSetSaveUtil.load(executor.getCubeQueryDefinition().getQueryResultsID(), executor.getContext().getDocReader());
        } else {
            rs = cubeQueryExcutorHelper.execute(aggrDefns, new StopSign());
        }
        cube.close();
        documentManager.close();
        return new CubeResultSet(rs, view, manager, cubeQueryExcutorHelper);
    }

    private IAggregationResultSet[] populateRs(CubeQueryExecutor executor, AggregationDefinition[] aggrDefns, CubeQueryExecutorHelper cubeQueryExcutorHelper, boolean saveToRD) throws IOException, BirtException {
        IAggregationResultSet[] rs;
        String id = null;
        if (executor.getCubeQueryDefinition().getQueryResultsID() == null) {
            rs = cubeQueryExcutorHelper.execute(aggrDefns, new StopSign());
            if (executor.getCubeQueryDefinition().cacheQueryResults()) {
                id = QueryResultIDUtil.nextID();
                FileArchiveWriter writer = new FileArchiveWriter(String.valueOf(executor.getContext().getTmpdir()) + "Cache");
                AggregationResultSetSaveUtil.save(id, rs, (IDocArchiveWriter)writer);
                writer.finish();
            }
            if (saveToRD) {
                if (id != null) {
                    AggregationResultSetSaveUtil.save(id, rs, executor.getContext().getDocWriter());
                } else {
                    id = QueryResultIDUtil.nextID();
                    AggregationResultSetSaveUtil.save(id, rs, executor.getContext().getDocWriter());
                }
            }
        } else {
            id = executor.getCubeQueryDefinition().getQueryResultsID();
            rs = AggregationResultSetSaveUtil.load(id, (IDocArchiveReader)new FileArchiveReader(String.valueOf(executor.getContext().getTmpdir()) + "Cache"));
        }
        executor.setQueryResultsId(id);
        return rs;
    }

    private void populateAggregationSort(CubeQueryExecutor executor, CubeQueryExecutorHelper cubeQueryExcutorHelper, boolean isRow) throws DataException {
        List columnSort = isRow ? executor.getRowEdgeSort() : executor.getColumnEdgeSort();
        int i = 0;
        while (i < columnSort.size()) {
            block8: {
                DimLevel[] aggrOnLevels;
                String bindingName;
                ICubeSortDefinition cubeSort;
                block10: {
                    List aggrOns;
                    block9: {
                        String measureName;
                        cubeSort = (ICubeSortDefinition)columnSort.get(i);
                        bindingName = OlapExpressionUtil.getBindingName(cubeSort.getExpression().getText());
                        if (bindingName == null) break block8;
                        List bindings = executor.getCubeQueryDefinition().getBindings();
                        aggrOns = null;
                        IBinding binding = null;
                        int j = 0;
                        while (j < bindings.size()) {
                            binding = (IBinding)bindings.get(j);
                            if (binding.getBindingName().equals(bindingName)) {
                                aggrOns = binding.getAggregatOns();
                                break;
                            }
                            ++j;
                        }
                        aggrOnLevels = null;
                        if (aggrOns != null && aggrOns.size() != 0) break block9;
                        if (binding == null || (measureName = OlapExpressionCompiler.getReferencedScriptObject(binding.getExpression(), "measure")) == null) break block8;
                        List measureAggrOns = CubeQueryDefinitionUtil.populateMeasureAggrOns(executor.getCubeQueryDefinition());
                        aggrOnLevels = new DimLevel[measureAggrOns.size()];
                        int k = 0;
                        while (k < measureAggrOns.size()) {
                            aggrOnLevels[k] = (DimLevel)measureAggrOns.get(k);
                            ++k;
                        }
                        break block10;
                    }
                    aggrOnLevels = new DimLevel[aggrOns.size()];
                    int j = 0;
                    while (j < aggrOnLevels.length) {
                        aggrOnLevels[j] = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(j).toString());
                        ++j;
                    }
                }
                DimLevel[] axisLevels = new DimLevel[cubeSort.getAxisQualifierLevels().length];
                int k = 0;
                while (k < axisLevels.length) {
                    axisLevels[k] = new DimLevel(cubeSort.getAxisQualifierLevels()[k]);
                    ++k;
                }
                AggrSortDefinition sort = new AggrSortDefinition(aggrOnLevels, bindingName, axisLevels, cubeSort.getAxisQualifierValues(), new DimLevel(cubeSort.getTargetLevel()), cubeSort.getSortDirection() != 1);
                if (isRow) {
                    cubeQueryExcutorHelper.addRowSort(sort);
                } else {
                    cubeQueryExcutorHelper.addColumnSort(sort);
                }
            }
            ++i;
        }
    }

    private ICube loadCube(IDocumentManager documentManager, CubeQueryExecutor executor) throws DataException, IOException {
        ICube cube = null;
        cube = CubeQueryExecutorHelper.loadCube(executor.getCubeQueryDefinition().getName(), documentManager, new StopSign());
        return cube;
    }

    private IDocumentManager getDocumentManager(CubeQueryExecutor executor) throws DataException, IOException {
        if (executor.getContext().getMode() == 3 || executor.getContext().getMode() == 1) {
            return DocumentManagerFactory.loadFileDocumentManager(String.valueOf(executor.getContext().getTmpdir()) + executor.getSession().getEngine().hashCode(), executor.getCubeQueryDefinition().getName());
        }
        return DocumentManagerFactory.createRADocumentManager(executor.getContext().getDocReader());
    }

    private AggregationDefinition[] prepareCube(ICubeQueryDefinition query, CalculatedMember[] calculatedMember) throws DataException {
        int i;
        int[] sortType;
        DimLevel[] levelsForFilter;
        IEdgeDefinition columnEdgeDefn = query.getEdge(2);
        ILevelDefinition[] levelsOnColumn = CubeQueryDefinitionUtil.getLevelsOnEdge(columnEdgeDefn);
        IEdgeDefinition rowEdgeDefn = query.getEdge(1);
        ILevelDefinition[] levelsOnRow = CubeQueryDefinitionUtil.getLevelsOnEdge(rowEdgeDefn);
        int aggregationCount = this.getDistinctCalculatedMemberCount(calculatedMember);
        AggregationDefinition[] aggregations = columnEdgeDefn == null && rowEdgeDefn == null ? new AggregationDefinition[aggregationCount] : (columnEdgeDefn == null || rowEdgeDefn == null ? new AggregationDefinition[aggregationCount + 1] : new AggregationDefinition[aggregationCount + 2]);
        int aggrIndex = 0;
        if (columnEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnColumn.length];
            sortType = new int[levelsOnColumn.length];
            i = 0;
            while (i < levelsOnColumn.length) {
                levelsForFilter[i] = new DimLevel(levelsOnColumn[i]);
                sortType[i] = this.getSortDirection(levelsForFilter[i], query);
                ++i;
            }
            aggregations[aggrIndex] = new AggregationDefinition(levelsForFilter, sortType, null);
            ++aggrIndex;
        }
        if (rowEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnRow.length];
            sortType = new int[levelsOnRow.length];
            i = 0;
            while (i < levelsOnRow.length) {
                levelsForFilter[i] = new DimLevel(levelsOnRow[i]);
                sortType[i] = this.getSortDirection(levelsForFilter[i], query);
                ++i;
            }
            aggregations[aggrIndex] = new AggregationDefinition(levelsForFilter, sortType, null);
            ++aggrIndex;
        }
        if (calculatedMember != null && calculatedMember.length > 0) {
            HashSet<Integer> rsIDSet = new HashSet<Integer>();
            int i2 = 0;
            while (i2 < calculatedMember.length) {
                if (!rsIDSet.contains(new Integer(calculatedMember[i2].getRsID()))) {
                    List list = this.getCalculatedMemberWithSameRSId(calculatedMember, i2);
                    AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[list.size()];
                    int index = 0;
                    while (index < list.size()) {
                        String[] dimInfo = ((CalculatedMember)list.get(index)).getFirstArgumentInfo();
                        String dimName = null;
                        String levelName = null;
                        String attributeName = null;
                        DimLevel dimLevel = null;
                        if (dimInfo != null && dimInfo.length == 3) {
                            dimName = ((CalculatedMember)list.get(index)).getFirstArgumentInfo()[0];
                            levelName = ((CalculatedMember)list.get(index)).getFirstArgumentInfo()[1];
                            attributeName = ((CalculatedMember)list.get(index)).getFirstArgumentInfo()[2];
                            dimLevel = new DimLevel(dimName, levelName);
                        }
                        funcitons[index] = new AggregationFunctionDefinition(((CalculatedMember)list.get(index)).getName(), ((CalculatedMember)list.get(index)).getMeasureName(), dimLevel, attributeName, ((CalculatedMember)list.get(index)).getAggrFunction());
                        ++index;
                    }
                    DimLevel[] levels = new DimLevel[calculatedMember[i2].getAggrOnList().size()];
                    sortType = new int[calculatedMember[i2].getAggrOnList().size()];
                    int index2 = 0;
                    while (index2 < calculatedMember[i2].getAggrOnList().size()) {
                        Object obj = calculatedMember[i2].getAggrOnList().get(index2);
                        levels[index2] = (DimLevel)obj;
                        sortType[index2] = this.getSortDirection(levels[index2], query);
                        ++index2;
                    }
                    rsIDSet.add(new Integer(calculatedMember[i2].getRsID()));
                    aggregations[aggrIndex] = new AggregationDefinition(levels, sortType, funcitons);
                    ++aggrIndex;
                }
                ++i2;
            }
        }
        return aggregations;
    }

    private List getCalculatedMemberWithSameRSId(CalculatedMember[] calMember, int index) {
        CalculatedMember member = calMember[index];
        ArrayList<CalculatedMember> list = new ArrayList<CalculatedMember>();
        list.add(member);
        int i = index + 1;
        while (i < calMember.length) {
            if (calMember[i].getRsID() == member.getRsID()) {
                list.add(calMember[i]);
            }
            ++i;
        }
        return list;
    }

    private int getDistinctCalculatedMemberCount(CalculatedMember[] calMember) {
        HashSet<Integer> rsIDSet = new HashSet<Integer>();
        int i = 0;
        while (i < calMember.length) {
            if (!rsIDSet.contains(new Integer(calMember[i].getRsID()))) {
                rsIDSet.add(new Integer(calMember[i].getRsID()));
            }
            ++i;
        }
        return rsIDSet.size();
    }

    private int getSortDirection(DimLevel level, ICubeQueryDefinition query) throws DataException {
        if (query.getSorts() != null && !query.getSorts().isEmpty()) {
            int i = 0;
            while (i < query.getSorts().size()) {
                ISortDefinition sortDfn = (ISortDefinition)query.getSorts().get(i);
                String expr = sortDfn.getExpression().getText();
                DimLevel info = this.getDimLevel(expr, query.getBindings());
                if (level.equals(info)) {
                    return sortDfn.getSortDirection();
                }
                ++i;
            }
        }
        return -1;
    }

    private DimLevel getDimLevel(String expr, List bindings) throws DataException {
        String bindingName = OlapExpressionUtil.getBindingName(expr);
        if (bindingName != null) {
            int j = 0;
            while (j < bindings.size()) {
                IBinding binding = (IBinding)bindings.get(j);
                if (binding.getBindingName().equals(bindingName)) {
                    if (!(binding.getExpression() instanceof IScriptExpression)) {
                        return null;
                    }
                    return this.getDimLevel(((IScriptExpression)binding.getExpression()).getText(), bindings);
                }
                ++j;
            }
        }
        if (!OlapExpressionUtil.isReferenceToDimLevel(expr)) {
            return null;
        }
        return OlapExpressionUtil.getTargetDimLevel(expr);
    }
}

