/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.impl.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.script.OLAPExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.filter.DimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.eclipse.birt.data.engine.olap.util.filter.TopBottomDimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class BaseDimensionFilterEvalHelper
implements IJSFilterHelper {
    protected Scriptable scope;
    protected DummyJSLevels dimObj;
    protected DummyJSAggregationAccessor dataObj;
    protected IBaseExpression expr;
    protected String dimName;
    protected DimLevel[] aggrLevels;
    protected ICubeQueryDefinition queryDefn;
    protected ICubeFilterDefinition cubeFilter;
    protected ILevelDefinition[] axisLevels;
    protected Object[] axisValues;
    protected boolean isAxisFilter;
    static /* synthetic */ Class class$0;

    public static IJSFilterHelper createFilterHelper(Scriptable parentScope, ICubeQueryDefinition queryDefn, IFilterDefinition cubeFilter) throws DataException {
        IConditionalExpression expr;
        if (cubeFilter.getExpression() instanceof IConditionalExpression && ((expr = (IConditionalExpression)cubeFilter.getExpression()).getOperator() == 14 || expr.getOperator() == 15 || expr.getOperator() == 16 || expr.getOperator() == 17)) {
            return new TopBottomDimensionFilterEvalHelper(parentScope, queryDefn, cubeFilter);
        }
        return new DimensionFilterEvalHelper(parentScope, queryDefn, cubeFilter);
    }

    protected void initialize(Scriptable parentScope, ICubeQueryDefinition queryDefn, IFilterDefinition cubeFilter, Context cx) throws DataException {
        this.scope = cx.initStandardObjects();
        this.scope.setParentScope(parentScope);
        this.dataObj = new DummyJSAggregationAccessor();
        this.expr = cubeFilter.getExpression();
        this.dimName = OlapExpressionUtil.getReferencedDimensionName(this.expr, queryDefn.getBindings());
        this.dimObj = new DummyJSLevels(this.dimName);
        this.queryDefn = queryDefn;
        this.cubeFilter = cubeFilter instanceof ICubeFilterDefinition ? (ICubeFilterDefinition)cubeFilter : new CubeFilterDefinition(this.expr);
        this.aggrLevels = this.populateAggrLevels();
        this.axisLevels = this.cubeFilter.getAxisQualifierLevels();
        this.axisValues = this.cubeFilter.getAxisQualifierValues();
        if (this.axisLevels == null || this.axisValues == null || this.axisLevels.length != this.axisValues.length) {
            this.isAxisFilter = false;
        } else {
            int i = 0;
            while (i < this.axisLevels.length) {
                if (this.axisLevels[i] == null) {
                    throw new DataException("data.olap.axis.level.CantBeNull");
                }
                if (this.axisValues[i] == null) {
                    throw new DataException("data.olap.axis.value.CantBeNull", this.axisLevels[i].getName());
                }
                ++i;
            }
        }
        boolean bl = this.isAxisFilter = this.axisLevels != null && this.axisValues != null && this.axisLevels.length == this.axisValues.length;
        if (this.dimName != null) {
            DummyJSDimensionObject dimObj = new DummyJSDimensionObject(this.dimObj, this.getTargetDimensionLevelNames());
            this.scope.put("dimension", this.scope, (Object)new DummyJSDimensionAccessor(this.dimName, dimObj));
        }
        if (this.aggrLevels != null && this.aggrLevels.length > 0) {
            this.scope.put("data", this.scope, (Object)this.dataObj);
        } else {
            this.scope.put("data", this.scope, (Object)new DummyJSDataAccessor(queryDefn.getBindings(), this.scope));
        }
        OLAPExpressionCompiler.compile(cx, this.expr);
    }

    protected DimLevel[] populateAggrLevels() throws DataException {
        String bindingName = OlapExpressionCompiler.getReferencedScriptObject(this.expr, "data");
        if (bindingName == null) {
            return null;
        }
        Iterator it = this.queryDefn.getBindings().iterator();
        while (it.hasNext()) {
            IBinding binding = (IBinding)it.next();
            if (!binding.getBindingName().equals(bindingName)) continue;
            List aggrs = binding.getAggregatOns();
            if (aggrs.size() == 0) {
                if (OlapExpressionCompiler.getReferencedScriptObject(binding.getExpression(), "dimension") != null) {
                    return null;
                }
                ArrayList<DimLevel> levelList = new ArrayList<DimLevel>();
                IEdgeDefinition rowEdge = this.queryDefn.getEdge(1);
                List rowDims = rowEdge.getDimensions();
                Iterator i = rowDims.iterator();
                while (i.hasNext()) {
                    IDimensionDefinition dim = (IDimensionDefinition)i.next();
                    IHierarchyDefinition hirarchy = (IHierarchyDefinition)dim.getHierarchy().get(0);
                    Iterator j = hirarchy.getLevels().iterator();
                    while (j.hasNext()) {
                        ILevelDefinition level = (ILevelDefinition)j.next();
                        levelList.add(new DimLevel(dim.getName(), level.getName()));
                    }
                }
                IEdgeDefinition colEdge = this.queryDefn.getEdge(2);
                List colDims = colEdge.getDimensions();
                Iterator i2 = colDims.iterator();
                while (i2.hasNext()) {
                    IDimensionDefinition dim = (IDimensionDefinition)i2.next();
                    IHierarchyDefinition hirarchy = (IHierarchyDefinition)dim.getHierarchy().get(0);
                    Iterator j = hirarchy.getLevels().iterator();
                    while (j.hasNext()) {
                        ILevelDefinition level = (ILevelDefinition)j.next();
                        levelList.add(new DimLevel(dim.getName(), level.getName()));
                    }
                }
                DimLevel[] levels = new DimLevel[levelList.size()];
                levelList.toArray(levels);
                return levels;
            }
            DimLevel[] levels = new DimLevel[aggrs.size()];
            int i = 0;
            while (i < aggrs.size()) {
                levels[i] = OlapExpressionUtil.getTargetDimLevel(aggrs.get(i).toString());
                ++i;
            }
            return levels;
        }
        return null;
    }

    public DimLevel[] getAggrLevels() {
        return this.aggrLevels;
    }

    protected List getTargetDimensionLevelNames() throws DataException {
        IDimensionDefinition dimDefn = this.getTargetDimension();
        if (dimDefn == null) {
            throw new DataException("Referenced dimension definition:" + this.dimName + " does not exist.");
        }
        ArrayList<String> result = new ArrayList<String>();
        List levels = ((IHierarchyDefinition)dimDefn.getHierarchy().get(0)).getLevels();
        int j = 0;
        while (j < levels.size()) {
            ILevelDefinition level = (ILevelDefinition)levels.get(j);
            result.add(level.getName());
            ++j;
        }
        return result;
    }

    public String getDimensionName() {
        return this.dimName;
    }

    public ICubeFilterDefinition getCubeFilterDefinition() {
        return this.cubeFilter;
    }

    public boolean isAggregationFilter() {
        return this.dimName == null;
    }

    private IDimensionDefinition getTargetDimension() throws DataException {
        if (this.isAggregationFilter()) {
            ILevelDefinition targetLevel = this.cubeFilter.getTargetLevel();
            if (targetLevel == null) {
                throw new DataException("Referenced level:" + targetLevel.getName() + " does not exist.");
            }
            IDimensionDefinition dimDefn = targetLevel.getHierarchy().getDimension();
            if (dimDefn == null) {
                throw new DataException("Referenced dimension:" + this.dimName + " does not exist.");
            }
            return dimDefn;
        }
        IEdgeDefinition columnEdge = this.queryDefn.getEdge(2);
        IEdgeDefinition rowEdge = this.queryDefn.getEdge(1);
        ArrayList dims = new ArrayList();
        if (columnEdge != null) {
            dims.addAll(columnEdge.getDimensions());
        }
        if (rowEdge != null) {
            dims.addAll(rowEdge.getDimensions());
        }
        int i = 0;
        while (i < dims.size()) {
            IDimensionDefinition dimDefn = (IDimensionDefinition)dims.get(i);
            if (dimDefn.getName().equals(this.dimName)) {
                return dimDefn;
            }
            ++i;
        }
        return null;
    }

    public void close() {
        this.scope.delete("dimension");
        this.scope.delete("data");
        this.scope.setParentScope(null);
    }

    protected class DummyJSAggregationAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = 1L;
        private IResultRow resultRow;

        protected DummyJSAggregationAccessor() {
        }

        public Object get(String aggrName, Scriptable scope) {
            if (this.resultRow != null) {
                try {
                    return this.resultRow.getAggrValue(aggrName);
                }
                catch (DataException dataException) {
                    return null;
                }
            }
            return null;
        }

        public void setResultRow(IResultRow row) {
            this.resultRow = row;
        }

        public String getClassName() {
            return "DummyJSAggregationAccessor";
        }
    }

    protected class DummyJSDataAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = 6434908701820853543L;
        private Map bindingMap = new HashMap();
        private Scriptable scope;

        public DummyJSDataAccessor(List bindings, Scriptable scope) throws DataException {
            int i = 0;
            while (i < bindings.size()) {
                this.bindingMap.put(((IBinding)bindings.get(i)).getBindingName(), bindings.get(i));
                ++i;
            }
            this.scope = scope;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object get(String aggrName, Scriptable scope) {
            try {
                block5: {
                    Object object;
                    try {
                        Context cx = Context.enter();
                        if (!this.bindingMap.containsKey(aggrName)) {
                            break block5;
                        }
                        object = ScriptEvalUtil.evalExpr(((IBinding)this.bindingMap.get(aggrName)).getExpression(), cx, this.scope, null, 0);
                        Object var4_5 = null;
                    }
                    catch (DataException dataException) {}
                    Context.exit();
                    return object;
                }
                Object var4_4 = null;
                Context.exit();
                return null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                Context.exit();
                throw throwable;
            }
        }

        public String getClassName() {
            return null;
        }
    }

    protected class DummyJSDimensionAccessor
    extends ScriptableObject {
        private static final long serialVersionUID = 2973311240789516725L;
        private String dimensionName;
        private DummyJSDimensionObject dimObj;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.util.filter.BaseDimensionFilterEvalHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        DummyJSDimensionAccessor(String name, DummyJSDimensionObject dimObj) {
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && dimObj == null) {
                throw new AssertionError();
            }
            this.dimensionName = name;
            this.dimObj = dimObj;
        }

        public String getClassName() {
            return "DummyJSDimensionAccessor";
        }

        public Object get(String value, Scriptable scope) {
            if (!this.dimensionName.equals(value)) {
                throw new InMatchDimensionIndicator();
            }
            return this.dimObj;
        }
    }

    protected class DummyJSDimensionObject
    extends ScriptableObject {
        private static final long serialVersionUID = -5518881690927904342L;
        private DummyJSLevels levels;
        private List levelNames;

        DummyJSDimensionObject(DummyJSLevels levels, List levelNames) {
            this.levels = levels;
            this.levelNames = levelNames;
        }

        public String getClassName() {
            return "DummyJSDimensionObject";
        }

        public Object get(String value, Scriptable scope) {
            if (this.levelNames.contains(value)) {
                this.levels.setCurrentKey(value);
                return this.levels;
            }
            throw new RuntimeException("Invalid level Name:" + value);
        }
    }

    protected class DummyJSLevels
    extends ScriptableObject {
        private static final long serialVersionUID = -3448256508462449221L;
        private IResultRow resultRow;
        private String key;
        private String dimName;

        public DummyJSLevels(String dimName) {
            this.dimName = dimName;
        }

        public String getClassName() {
            return "DummyJSLevels";
        }

        public Object getDefaultValue(Class hint) {
            try {
                return this.resultRow.getFieldValue(CubeQueryExecutorHelper.getAttrReference(this.dimName, this.key, this.key));
            }
            catch (DataException dataException) {
                return null;
            }
        }

        public Object get(String value, Scriptable scope) {
            try {
                return this.resultRow.getFieldValue(CubeQueryExecutorHelper.getAttrReference(this.dimName, this.key, value));
            }
            catch (DataException dataException) {
                return null;
            }
        }

        public void setCurrentKey(String key) {
            this.key = key;
        }

        public void setResultRow(IResultRow result) {
            this.resultRow = result;
        }
    }

    protected class InMatchDimensionIndicator
    extends RuntimeException {
        private static final long serialVersionUID = 5546172382226378064L;

        protected InMatchDimensionIndicator() {
        }
    }
}

