/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import com.ibm.icu.util.StringTokenizer;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.MonitoringParser;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;
import org.eclipse.hyades.logging.parsers.util.FilterExitHelper;

public abstract class AbstractAccessLogParser
extends MonitoringParser {
    protected String clientIP = null;
    protected String method = null;
    protected String fileName = null;
    protected String returnCode = null;
    protected String fileSize = null;
    protected String userID = null;
    protected String userAgent = null;
    protected String referer = null;
    protected String message = null;
    protected StringBuffer currentTimeStamp = null;
    protected StringBuffer cgiDebuggingOutput = new StringBuffer();
    protected String productVersion = null;
    protected String sourceID = null;
    private long duplicateTimeStampCounter = 0L;
    private String previousTimeStamp = "";
    private SimpleDateFormat SDFformatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat SDFparser = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss", Locale.US);
    protected FilterExitHelper sensorFilterExitHelper = new FilterExitHelper();

    public void setConfiguration(Hashtable table) throws LogParserException {
        super.setConfiguration(table);
        this.sensorFilterExitHelper.init(table, this.filterExitClassInstance);
    }

    public void preParse() throws LogParserException {
        super.preParse();
    }

    public void postParse() throws LogParserException {
        super.postParse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommonBaseEvent[] parseNext() throws LogParserException {
        CommonBaseEvent[] temp = null;
        this.curLine = this.readALine();
        this.arrayIndex = 0;
        try {
            block35: {
                while (true) {
                    if (this.curLine == null) {
                        if (this.cgiDebuggingOutput.length() > 0) {
                            if (this.recordCount != 0) break;
                            throw new LogParserException(ParserUtilities.getResourceString("INVALID_ACCESS_LOG_ERROR_", this.file_path));
                        }
                        break block35;
                    }
                    this.curLine = this.curLine.trim();
                    if (this.curLine.length() > 0) {
                        if (this.filterExitClassInstance != null) {
                            try {
                                boolean pass = this.filterExitClassInstance.filter(this.curLine);
                                if (!pass) {
                                    this.curLine = this.readALine();
                                    continue;
                                }
                            }
                            catch (AdapterException adapterException) {
                                throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_FILTERING_ERROR_", this.curLine));
                            }
                        }
                        if (this.parseLogRecord()) {
                            if (this.cgiDebuggingOutput.length() > 0) {
                                this.createCGIDebuggingOutputCBE();
                                ++this.arrayIndex;
                                if (this.arrayIndex == this.MessageArraySize) {
                                    this.increaseMsgArraySize();
                                }
                                ++this.recordCount;
                            }
                            this.reinitializeCBE();
                            if (this.previousTimeStamp.equals(this.currentTimeStamp.toString())) {
                                this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
                            } else {
                                this.previousTimeStamp = this.currentTimeStamp.toString();
                                this.duplicateTimeStampCounter = 0L;
                                this.messages[this.arrayIndex].setSequenceNumber(this.duplicateTimeStampCounter);
                            }
                            this.messages[this.arrayIndex].setCreationTime(this.currentTimeStamp.toString());
                            if (this.message.length() > 1024) {
                                this.messages[this.arrayIndex].setMsg(this.message.substring(0, 1024));
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractAccessLogParser.createStringEDE("message", this.message));
                            } else {
                                this.messages[this.arrayIndex].setMsg(this.message);
                            }
                            if (this.sensorFilterExitHelper.isSeverityFilterSet()) {
                                this.messages[this.arrayIndex].setSeverity(this.sensorFilterExitHelper.getCurrentEventSeverity());
                            } else {
                                this.determineSeverity(this.messages[this.arrayIndex]);
                            }
                            if (this.method != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractAccessLogParser.createStringEDE("method", this.method));
                            }
                            if (this.clientIP != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractAccessLogParser.createStringEDE("client", this.clientIP));
                            }
                            if (this.fileName != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractAccessLogParser.createStringEDE("file", this.fileName));
                            }
                            if (this.returnCode != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractAccessLogParser.createStringEDE("return_code", this.returnCode));
                            }
                            if (this.fileSize != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractAccessLogParser.createStringEDE("file_size", this.fileSize));
                            }
                            if (this.userID != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractAccessLogParser.createStringEDE("userid", this.userID));
                            }
                            if (this.referer != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractAccessLogParser.createStringEDE("referer", this.referer));
                            }
                            if (this.userAgent != null) {
                                this.messages[this.arrayIndex].addExtendedDataElement(AbstractAccessLogParser.createStringEDE("userAgent", this.userAgent));
                            }
                            ++this.arrayIndex;
                            if (this.arrayIndex == this.MessageArraySize) {
                                this.arrayIndex = 0;
                                ++this.recordCount;
                                this.reset();
                                return this.messages;
                            }
                            ++this.recordCount;
                            this.reset();
                        } else {
                            this.cgiDebuggingOutput.append(this.curLine);
                            this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
                        }
                    }
                    this.curLine = this.readALine();
                }
                this.createCGIDebuggingOutputCBE();
                ++this.arrayIndex;
                if (this.arrayIndex == this.MessageArraySize) {
                    this.arrayIndex = 0;
                    ++this.recordCount;
                    this.reset();
                    return this.messages;
                }
                this.cgiDebuggingOutput = new StringBuffer();
                ++this.recordCount;
            }
            if (this.arrayIndex == 0) {
                temp = null;
                this.setEndOfFile();
            } else {
                int i = this.arrayIndex;
                while (true) {
                    if (i >= this.MessageArraySize) {
                        temp = this.messages;
                        break;
                    }
                    this.messages[i] = null;
                    ++i;
                }
            }
            if (this.recordCount != 0) return temp;
            throw new LogParserException(ParserUtilities.getResourceString("NO_ACCESS_LOG_RECORDS_ERROR_", this.file_path));
        }
        catch (LogParserException l) {
            throw l;
        }
        catch (Throwable t) {
            ParserUtilities.exceptionHandler(t, this.curLineNumber, this.curLine, ParserUtilities.getResourceString("ACCESS_LOG_PARSER_ERROR_"));
        }
        return temp;
    }

    private void reinitializeCBE() {
        if (this.messages[this.arrayIndex] == null) {
            this.messages[this.arrayIndex] = eventFactory.createCommonBaseEvent();
        }
        this.messages[this.arrayIndex].init();
        this.messages[this.arrayIndex].setGlobalInstanceId(Guid.generate());
        ComponentIdentification sourceComponentID = eventFactory.createComponentIdentification();
        sourceComponentID.setLocation(this.localHostId);
        sourceComponentID.setLocationType(this.localHostIdFormat);
        sourceComponentID.setComponent(this.sourceID);
        sourceComponentID.setSubComponent("Unknown");
        sourceComponentID.setComponentType("HTTPServer");
        sourceComponentID.setComponentIdType("ProductName");
        this.messages[this.arrayIndex].setSourceComponentId(sourceComponentID);
        this.messages[this.arrayIndex].setSituation(this.createSituation());
    }

    private Situation createSituation() {
        Situation cbeSituation = eventFactory.createSituation();
        boolean defaultSituation = true;
        if (this.returnCode != null && this.returnCode.trim().length() > 0) {
            char firstChr = this.returnCode.charAt(0);
            if (this.returnCode.equals("202") || firstChr == '3' || firstChr == '1') {
                RequestSituation cbeRequestSituation = eventFactory.createRequestSituation();
                cbeRequestSituation.setReasoningScope("EXTERNAL");
                cbeRequestSituation.setSuccessDisposition("SUCCESSFUL");
                cbeRequestSituation.setSituationQualifier("REQUEST INITIATED");
                cbeSituation.setCategoryName("RequestSituation");
                cbeSituation.setSituationType((SituationType)cbeRequestSituation);
                defaultSituation = false;
            } else if (firstChr == '2') {
                RequestSituation cbeRequestSituation = eventFactory.createRequestSituation();
                cbeRequestSituation.setReasoningScope("EXTERNAL");
                cbeRequestSituation.setSuccessDisposition("SUCCESSFUL");
                cbeRequestSituation.setSituationQualifier("REQUEST COMPLETED");
                cbeSituation.setCategoryName("RequestSituation");
                cbeSituation.setSituationType((SituationType)cbeRequestSituation);
                defaultSituation = false;
            } else if (firstChr == '4' || firstChr == '5') {
                RequestSituation cbeRequestSituation = eventFactory.createRequestSituation();
                cbeRequestSituation.setReasoningScope("EXTERNAL");
                cbeRequestSituation.setSuccessDisposition("UNSUCCESSFUL");
                cbeRequestSituation.setSituationQualifier("REQUEST INITIATED");
                cbeSituation.setCategoryName("RequestSituation");
                cbeSituation.setSituationType((SituationType)cbeRequestSituation);
                defaultSituation = false;
            }
        }
        if (defaultSituation) {
            ReportSituation cbeReportSituation = eventFactory.createReportSituation();
            cbeReportSituation.setReasoningScope("INTERNAL");
            cbeReportSituation.setReportCategory("LOG");
            cbeSituation.setCategoryName("ReportSituation");
            cbeSituation.setSituationType((SituationType)cbeReportSituation);
        }
        return cbeSituation;
    }

    protected void determineSeverity(CommonBaseEvent message) {
        if (this.returnCode != null && this.returnCode.trim().length() > 0) {
            char firstChr = this.returnCode.charAt(0);
            switch (firstChr) {
                case '4': {
                    message.setSeverity((short)40);
                    break;
                }
                case '5': {
                    message.setSeverity((short)60);
                    break;
                }
                default: {
                    message.setSeverity((short)10);
                    break;
                }
            }
        } else {
            message.setSeverity((short)10);
        }
    }

    protected boolean parseDate(int startIndex, int endIndex) {
        if (this.curLine.charAt(startIndex) == '[' && this.curLine.charAt(endIndex) == ']') {
            int timeZoneIndex = this.curLine.indexOf(45, startIndex);
            if (!(timeZoneIndex != -1 && timeZoneIndex <= endIndex || (timeZoneIndex = this.curLine.indexOf(43, startIndex)) != -1 && timeZoneIndex <= endIndex)) {
                return false;
            }
            Date creationDate = this.SDFparser.parse(this.curLine.substring(startIndex + 1, timeZoneIndex).trim(), new ParsePosition(0));
            if (creationDate != null) {
                this.currentTimeStamp = new StringBuffer(this.SDFformatter.format(creationDate).trim());
                this.currentTimeStamp.replace(10, 11, "T");
                this.currentTimeStamp.append(".000000");
                this.currentTimeStamp.append(this.curLine.charAt(timeZoneIndex));
                this.currentTimeStamp.append(this.curLine.substring(timeZoneIndex + 1, timeZoneIndex + 3));
                this.currentTimeStamp.append(":");
                this.currentTimeStamp.append(this.curLine.substring(timeZoneIndex + 3, timeZoneIndex + 5));
                return true;
            }
        }
        return false;
    }

    protected boolean parseLogRecord() {
        int currentIndex;
        StringTokenizer st = new StringTokenizer(this.curLine, " ");
        int count = st.countTokens();
        if (count-- >= 1) {
            this.clientIP = st.nextToken();
        }
        if (!ParserUtilities.isValidIPAddress(this.clientIP)) {
            return false;
        }
        if (count-- >= 1) {
            st.nextToken();
        }
        if (count-- >= 1) {
            this.userID = st.nextToken();
            if (this.userID.equals("-")) {
                this.userID = null;
            }
        }
        if ((currentIndex = this.curLine.indexOf("[")) == -1) {
            return false;
        }
        int previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("]", previousIndex)) == -1) {
            return false;
        }
        if (this.sensorFilterExitHelper.isCreationTimeFilterSet()) {
            this.currentTimeStamp = new StringBuffer(this.sensorFilterExitHelper.getCurrentEventCreationTime());
        } else if (!this.parseDate(previousIndex, currentIndex)) {
            return false;
        }
        if (count-- >= 1) {
            st.nextToken();
        }
        if (count-- >= 1) {
            st.nextToken();
        }
        if (count-- >= 1) {
            this.method = st.nextToken();
        }
        if (this.method != null && this.method.charAt(0) == '\"') {
            this.method = this.method.substring(1);
            if (this.method.length() == 2 && this.method.charAt(0) == '-') {
                this.method = null;
                this.message = this.curLine.substring(currentIndex + 1).trim();
                if (count-- >= 1) {
                    this.returnCode = st.nextToken();
                }
                if (this.returnCode.equals("-")) {
                    this.returnCode = null;
                }
                if (count-- >= 1) {
                    this.fileSize = st.nextToken();
                    if (this.fileSize.equals("-")) {
                        this.fileSize = null;
                    }
                }
                if (count-- >= 1) {
                    int userAgentLength;
                    this.userAgent = st.nextToken();
                    if (this.userAgent.charAt(0) == '\"') {
                        this.userAgent = this.userAgent.substring(1);
                    }
                    if (this.userAgent.charAt((userAgentLength = this.userAgent.length()) - 1) == '\"') {
                        this.userAgent = this.userAgent.substring(0, userAgentLength - 1);
                    }
                    if (this.userAgent.equals("-")) {
                        this.userAgent = null;
                    }
                }
                if (count-- >= 1) {
                    int refererLength;
                    this.referer = st.nextToken();
                    if (this.referer.charAt(0) == '\"') {
                        this.referer = this.referer.substring(1);
                    }
                    if (this.referer.charAt((refererLength = this.referer.length()) - 1) == '\"') {
                        this.referer = this.referer.substring(0, refererLength - 1);
                    }
                    if (this.referer.equals("-")) {
                        this.referer = null;
                    }
                }
                return true;
            }
        }
        this.message = this.curLine.substring(currentIndex + 1).trim();
        int fileNameStartIndex = this.message.indexOf(32);
        int fileNameEndIndex = this.message.indexOf("\" ");
        if (fileNameStartIndex >= 0 && fileNameEndIndex >= 0 && fileNameStartIndex < fileNameEndIndex) {
            String misc;
            String tmpFileName = this.message.substring(fileNameStartIndex, fileNameEndIndex).trim();
            this.fileName = (fileNameEndIndex = tmpFileName.lastIndexOf(32)) == -1 ? tmpFileName : ((misc = tmpFileName.substring(fileNameEndIndex)).indexOf("HTTP") > -1 || misc.indexOf(62) > -1 ? tmpFileName.substring(0, fileNameEndIndex) : tmpFileName);
        }
        if (this.fileName != null) {
            String temp = null;
            if (count-- >= 1) {
                temp = st.nextToken();
            }
            while (!temp.endsWith("\"") && temp.indexOf(34) <= -1 || temp.indexOf("\\\"") > -1) {
                if (count-- < 1) break;
                temp = st.nextToken();
            }
        }
        if (count-- >= 1) {
            this.returnCode = st.nextToken();
            if (this.returnCode.startsWith("HTTP") && count-- >= 1) {
                this.returnCode = st.nextToken();
            }
        }
        if (this.returnCode.equals("-")) {
            this.returnCode = null;
        }
        if (count-- >= 1) {
            this.fileSize = st.nextToken();
            if (this.fileSize.equals("-")) {
                this.fileSize = null;
            }
        }
        if (count-- >= 1) {
            int userAgentLength;
            this.userAgent = st.nextToken();
            if (this.userAgent.charAt(0) == '\"') {
                this.userAgent = this.userAgent.substring(1);
            }
            if (this.userAgent.charAt((userAgentLength = this.userAgent.length()) - 1) == '\"') {
                this.userAgent = this.userAgent.substring(0, userAgentLength - 1);
            }
            if (this.userAgent.equals("-")) {
                this.userAgent = null;
            }
        }
        if (count-- >= 1) {
            int refererLength;
            this.referer = st.nextToken();
            if (this.referer.charAt(0) == '\"') {
                this.referer = this.referer.substring(1);
            }
            if (this.referer.charAt((refererLength = this.referer.length()) - 1) == '\"') {
                this.referer = this.referer.substring(0, refererLength - 1);
            }
            if (this.referer.equals("-")) {
                this.referer = null;
            }
        }
        return true;
    }

    private void createCGIDebuggingOutputCBE() {
        this.reinitializeCBE();
        this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
        this.messages[this.arrayIndex].setCreationTime(this.previousTimeStamp);
        this.messages[this.arrayIndex].setMsg(this.cgiDebuggingOutput.toString().trim());
        this.messages[this.arrayIndex].setSeverity((short)10);
        this.messages[this.arrayIndex].addExtendedDataElement(AbstractAccessLogParser.createStringEDE("CGI_debugging_output", this.cgiDebuggingOutput.toString().trim()));
    }

    protected void reset() {
        this.userID = null;
        this.method = null;
        this.returnCode = null;
        this.clientIP = null;
        this.fileName = null;
        this.fileSize = null;
        this.referer = null;
        this.userAgent = null;
        this.message = null;
        this.currentTimeStamp = null;
        this.cgiDebuggingOutput = new StringBuffer();
    }
}

